/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.utils;

import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseUtil.class);
    public static final String EMPTY_CONTENT = "";

    public static String getContent(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return EMPTY_CONTENT;
        }
        try {
            return EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return EMPTY_CONTENT;
        }
    }

    public static int getStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    public static Map<String, String> getHeaders(HttpResponse httpResponse) {
        Header[] headers;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Header header : headers = httpResponse.getAllHeaders()) {
            headerMap.put(header.getName(), header.getValue());
        }
        return headerMap;
    }

    public static boolean isResponse200(HttpResponse httpResponse) {
        return 200 == HttpResponseUtil.getStatusCode(httpResponse);
    }

    public static boolean isRequestTimeout(Exception e) {
        return HttpResponseUtil.isConnTimeout(e) || HttpResponseUtil.isSoTimeout(e);
    }

    public static boolean isConnTimeout(Exception e) {
        return e instanceof ConnectTimeoutException;
    }

    public static boolean isSoTimeout(Exception e) {
        return e instanceof SocketTimeoutException;
    }
}

