/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.tpdata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.global.CustomObjectMapper;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.SyncResponseHandler;
import com.tplink.nbu.common.httpclient.response.sync.impl.SimpleSyncResponseHandlerImpl;
import com.tplink.nbu.common.tpdata.entity.ConsumerGroupResponseBase;
import com.tplink.nbu.common.tpdata.entity.ConsumerGroupResponsePayload;
import java.io.IOException;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupCommon {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupCommon.class);
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String EMAIL = "email";
    private static final String TOKEN = "token";
    private static final ObjectMapper objectMapper = new CustomObjectMapper();
    private final HttpClientMgmt httpClientMgmt;
    private RequestConfig.Builder requestConfigBuilder;

    public ConsumerGroupCommon(HttpClientMgmt httpClientMgmt) {
        this.httpClientMgmt = httpClientMgmt;
    }

    private static <T> T analyzeResponse(String req, SimpleSyncResponseHandlerImpl handler, Class<T> cl) throws IOException, CloudException {
        int statusCode = handler.getStatusCode();
        String response = handler.getContent();
        ConsumerGroupCommon.checkHttpStatus(statusCode, req, response);
        log.debug("get response : {}", (Object)response);
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ConsumerGroupResponsePayload.class, new Class[]{cl});
        ConsumerGroupResponsePayload value = (ConsumerGroupResponsePayload)objectMapper.readValue(response, javaType);
        Integer errorCode = value.getErrorCode();
        if (errorCode != 0) {
            throw new CloudException(200, req, errorCode, value.getMsg());
        }
        return value.getResult();
    }

    public static void checkHttpStatus(int statusCode, String req, String response) throws CloudException {
        if (statusCode != 200) {
            try {
                ConsumerGroupResponseBase value = (ConsumerGroupResponseBase)objectMapper.readValue(response, ConsumerGroupResponseBase.class);
                int errorCode = value.getErrorCode();
                throw new CloudException(statusCode, req, errorCode, value.getMsg());
            }
            catch (IOException e) {
                throw new CloudException(statusCode, req);
            }
        }
    }

    public <T> T sendRequest(HttpEntityEnclosingRequestBase request, String email, String token, String payload, Class<T> cl) throws IOException, CloudException {
        request.setEntity((HttpEntity)new StringEntity(payload, Charsets.UTF_8));
        SimpleSyncResponseHandlerImpl simpleSyncResponseHandler = new SimpleSyncResponseHandlerImpl();
        this.request((HttpRequestBase)request, email, token, simpleSyncResponseHandler);
        return ConsumerGroupCommon.analyzeResponse(payload, simpleSyncResponseHandler, cl);
    }

    public <T> T sendRequest(HttpRequestBase request, String email, String token, Class<T> cl) throws IOException, CloudException {
        SimpleSyncResponseHandlerImpl simpleSyncResponseHandler = new SimpleSyncResponseHandlerImpl();
        this.request(request, email, token, simpleSyncResponseHandler);
        return ConsumerGroupCommon.analyzeResponse(null, simpleSyncResponseHandler, cl);
    }

    public void request(HttpRequestBase request, String email, String token, SyncResponseHandler handler) throws IOException {
        this.logRequest(request);
        log.info("token: {}", (Object)token);
        request.setHeader("Content-Type", CONTENT_TYPE);
        request.addHeader(EMAIL, email);
        request.addHeader(TOKEN, token);
        this.setRequestConfig(request);
        SyncHttpClient sync = this.httpClientMgmt.sync();
        sync.execute((HttpUriRequest)request, handler);
    }

    public void setTimeout(int connectTimeoutMs, int poolTimeoutMs, int httpTimeoutMs) {
        this.requestConfigBuilder = RequestConfig.custom();
        if (httpTimeoutMs > 0) {
            this.requestConfigBuilder.setSocketTimeout(httpTimeoutMs);
        }
        if (connectTimeoutMs > 0) {
            this.requestConfigBuilder.setConnectTimeout(connectTimeoutMs);
        }
        if (poolTimeoutMs > 0) {
            this.requestConfigBuilder.setConnectionRequestTimeout(poolTimeoutMs);
        }
    }

    private void setRequestConfig(HttpRequestBase request) {
        if (this.requestConfigBuilder != null) {
            request.setConfig(this.requestConfigBuilder.build());
        }
    }

    private void logRequest(HttpRequestBase request) {
        log.debug("platform cloud request : path({})", (Object)request.getURI().toString());
    }
}

