/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.tpdata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.global.CustomObjectMapper;
import com.tplink.nbu.common.httpclient.response.sync.impl.SimpleSyncResponseHandlerImpl;
import com.tplink.nbu.common.tpdata.ConsumerGroupApi;
import com.tplink.nbu.common.tpdata.ConsumerGroupCommon;
import com.tplink.nbu.common.tpdata.entity.CommitInfoReq;
import com.tplink.nbu.common.tpdata.entity.ListInfoResp;
import com.tplink.nbu.common.tpdata.entity.ListInfoRespV3;
import com.tplink.nbu.common.tpdata.entity.LoginReq;
import com.tplink.nbu.common.tpdata.entity.LoginResp;
import com.tplink.nbu.common.utils.JacksonUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupApiImpl
implements ConsumerGroupApi {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupApiImpl.class);
    public static final String LABEL_PARAMETER = "with_label";
    public static final String LABEL = "1";
    public static final String DEVICE_PLATFORM = "device_platform";
    public static final String DEVICE_CATEGORY = "device_category";
    public static final String DEVICE_MODEL = "device_model";
    private static final String APP_TYPE = "app_type";
    private static final String TASK_ID = "task_id";
    private static final String APP_PLATFORM = "app_platform";
    private final ObjectMapper objectMapper = new CustomObjectMapper();
    private final ConsumerGroupCommon consumerGroupCommon;

    public ConsumerGroupApiImpl(ConsumerGroupCommon consumerGroupCommon) {
        this.consumerGroupCommon = consumerGroupCommon;
    }

    @Override
    public LoginResp login(String url, String email, String password) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath("/v2/auth/login/").build();
            HttpPost httpRequest = new HttpPost(uri);
            String loginPayload = JacksonUtil.parseToStr((Object)new LoginReq(email, password));
            return this.consumerGroupCommon.sendRequest((HttpEntityEnclosingRequestBase)httpRequest, null, null, loginPayload, LoginResp.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public ListInfoRespV3 getMICList(String url, String email, String token, String devicePlatform) throws IOException, CloudException {
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.setPath("/v3/tp-data/device_categories/");
            if (StringUtils.isNotEmpty((CharSequence)devicePlatform)) {
                builder.addParameter(DEVICE_PLATFORM, devicePlatform);
            }
            HttpGet httpRequest = new HttpGet(builder.build());
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoRespV3.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public ListInfoRespV3 getDeviceModelList(String url, String email, String devicePlatform, String deviceCategory, String token) throws IOException, CloudException {
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.setPath("/v3/tp-data/device_models/");
            if (StringUtils.isNotEmpty((CharSequence)devicePlatform)) {
                builder.addParameter(DEVICE_PLATFORM, devicePlatform);
            }
            builder.addParameter(DEVICE_CATEGORY, deviceCategory);
            HttpGet httpRequest = new HttpGet(builder.build());
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoRespV3.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public ListInfoRespV3 getDeviceFirmwares(String url, String email, String devicePlatform, String deviceCategory, String deviceModel, String token) throws IOException, CloudException {
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.setPath("/v3/tp-data/device_firmwares/");
            if (StringUtils.isNotEmpty((CharSequence)devicePlatform)) {
                builder.addParameter(DEVICE_PLATFORM, devicePlatform);
            }
            builder.addParameter(DEVICE_CATEGORY, deviceCategory);
            builder.addParameter(DEVICE_MODEL, deviceModel);
            HttpGet httpRequest = new HttpGet(builder.build());
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoRespV3.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public ListInfoResp getAppTypes(String url, String email, String token) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath("/v2/tp-data/app_types/").addParameter(LABEL_PARAMETER, LABEL).build();
            HttpGet httpRequest = new HttpGet(uri);
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoResp.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public ListInfoResp getAppVersions(String url, String email, String appType, String token) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath("/v2/tp-data/app_versions").addParameter(LABEL_PARAMETER, LABEL).addParameter(APP_TYPE, appType).build();
            HttpGet httpRequest = new HttpGet(uri);
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoResp.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public List<String> getEmailTopic(String url, String email, String token, String topic) throws IOException, CloudException {
        Map<String, List<String>> resultMap = this.getEmailTopics(url, email, token, Collections.singleton(topic));
        return resultMap.get(topic);
    }

    @Override
    public Map<String, List<String>> getEmailTopics(String url, String email, String token, Set<String> topics) throws IOException, CloudException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            URI uri = new URIBuilder(url).setPath("/v2/tp-data/email_topics/").build();
            HttpGet httpRequest = new HttpGet(uri);
            JsonNode response = this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, JsonNode.class);
            Map responseMap = (Map)this.objectMapper.readValue(response.traverse(), (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            for (String topic : topics) {
                result.put(topic, (List<String>)responseMap.get(topic));
            }
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
        }
        return result;
    }

    @Override
    public ListInfoRespV3 getKASAServicePaymentStatus(String url, String email, String token) throws IOException, CloudException {
        return this.sendAcquireServiceStatusRequest(url, "/v3/tp-data/kasa_care_status/", email, token);
    }

    @Override
    public ListInfoRespV3 getTAPOCareServicePaymentStatus(String url, String email, String token) throws IOException, CloudException {
        return this.sendAcquireServiceStatusRequest(url, "/v3/tp-data/tapo_care_status/", email, token);
    }

    @Override
    public ListInfoRespV3 getHomeShieldServicePaymentStatus(String url, String email, String token) throws IOException, CloudException {
        return this.sendAcquireServiceStatusRequest(url, "/v3/tp-data/home_shield_status/", email, token);
    }

    private ListInfoRespV3 sendAcquireServiceStatusRequest(String url, String path, String email, String token) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath(path).build();
            HttpGet httpRequest = new HttpGet(uri);
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoRespV3.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public Integer commitUserFilterInfoWithDevice(String url, String email, CommitInfoReq info, String token) throws IOException, CloudException {
        return this.commitInfo(url, email, info, token, "/v2/tp-data/task/device_accounts/");
    }

    @Override
    public Integer commitUserFilterInfo(String url, String email, CommitInfoReq info, String token) throws IOException, CloudException {
        return this.commitInfo(url, email, info, token, "/v3/tp-data/task/accounts/");
    }

    private Integer commitInfo(String url, String email, CommitInfoReq info, String token, String path) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath(path).build();
            HttpPost httpRequest = new HttpPost(uri);
            ObjectNode result = this.consumerGroupCommon.sendRequest((HttpEntityEnclosingRequestBase)httpRequest, email, token, JacksonUtil.parseToStr((Object)info), ObjectNode.class);
            return result.get(TASK_ID).traverse().getIntValue();
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public String getFile(String url, String email, int taskId, String token) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath("/v2/tp-data/task/result_file/").addParameter(TASK_ID, String.valueOf(taskId)).build();
            HttpGet httpRequest = new HttpGet(uri);
            SimpleSyncResponseHandlerImpl simpleSyncResponseHandler = new SimpleSyncResponseHandlerImpl();
            this.consumerGroupCommon.request((HttpRequestBase)httpRequest, email, token, simpleSyncResponseHandler);
            String response = simpleSyncResponseHandler.getContent();
            ConsumerGroupCommon.checkHttpStatus(simpleSyncResponseHandler.getStatusCode(), null, response);
            return response;
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    @Override
    public void setTimeout(int connectTimeoutMs, int poolTimeoutMs, int httpTimeoutMs) {
        this.consumerGroupCommon.setTimeout(connectTimeoutMs, poolTimeoutMs, httpTimeoutMs);
    }

    @Override
    public ListInfoRespV3 getAppPlatform(String url, String email, String token) throws IOException, CloudException {
        return this.sendAcquireServiceStatusRequest(url, "/v3/tp-data/app_platforms/", email, token);
    }

    @Override
    public ListInfoRespV3 getAppOsAndAppVersion(String url, String email, String token, String appPlatform) throws IOException, CloudException {
        try {
            URI uri = new URIBuilder(url).setPath("/v3/tp-data/app_os_and_app_version_list/").addParameter(APP_PLATFORM, appPlatform).build();
            HttpGet httpRequest = new HttpGet(uri);
            return this.consumerGroupCommon.sendRequest((HttpRequestBase)httpRequest, email, token, ListInfoRespV3.class);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    private void errorInUri(URISyntaxException e) {
        log.error("error in construct uri", (Throwable)e);
        throw new IllegalArgumentException("error in construct uri");
    }
}

