/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.httpclient.request.sync;

import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.SyncResponseHandler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpClientImpl
extends SyncHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SyncHttpClientImpl.class);
    private static final int DEFAULT_POOL_SIZE = 200;
    private static final int DEFAULT_MAX_PER_ROUTE = 50;
    private static final int DEFAULT_THREAD_SLEEP_INTERVAL_MS = 5000;
    private static final int DEFAULT_CONN_IDLE_TIME_MS = 15000;
    private final int poolSize;
    private final int maxPerRoute;
    private final int threadSleepIntervalMS;
    private final int connIdleTimeoutMS;
    private final RequestConfig requestConfig;
    private final HttpRequestRetryHandler retryHandler;
    private PoolingHttpClientConnectionManager connectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private CloseableHttpClient httpClient;

    @Deprecated
    public SyncHttpClientImpl() {
        this(200, 50, 5000, 15000);
    }

    @Deprecated
    public SyncHttpClientImpl(int poolSize, int maxPerRoute) {
        this(poolSize, maxPerRoute, 5000, 15000);
    }

    @Deprecated
    public SyncHttpClientImpl(int poolSize, int maxPerRoute, int threadSleepIntervalMS, int connIdleTimeoutMS) {
        this(poolSize, maxPerRoute, threadSleepIntervalMS, connIdleTimeoutMS, null, null);
    }

    private SyncHttpClientImpl(int poolSize, int maxPerRoute, int threadSleepIntervalMS, int connIdleTimeoutMS, RequestConfig requestConfig, HttpRequestRetryHandler retryHandler) {
        this.poolSize = poolSize;
        this.maxPerRoute = maxPerRoute;
        this.threadSleepIntervalMS = threadSleepIntervalMS;
        this.connIdleTimeoutMS = connIdleTimeoutMS;
        this.requestConfig = requestConfig;
        this.retryHandler = retryHandler;
    }

    public static SyncHttpClientBuilder custom() {
        return new SyncHttpClientBuilder();
    }

    public static SyncHttpClientImpl createDefault() {
        return SyncHttpClientImpl.custom().build();
    }

    private synchronized void initHttpClient() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        this.connectionManager = new PoolingHttpClientConnectionManager(registry);
        this.connectionManager.setMaxTotal(this.poolSize);
        this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.connectionManager, this.threadSleepIntervalMS, this.connIdleTimeoutMS);
        this.idleConnectionMonitorThread.start();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(this.requestConfig).setRetryHandler(this.retryHandler).build();
    }

    @Override
    public void execute(HttpUriRequest request, SyncResponseHandler callback) throws IOException {
        if (null == this.httpClient) {
            this.initHttpClient();
        }
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            callback.handleResponse((HttpResponse)response);
        }
    }

    @Override
    public void destroy() {
        log.warn("Destroy the SyncHttpClient!!");
        try {
            if (null != this.httpClient) {
                this.httpClient.close();
            }
            if (null != this.connectionManager) {
                this.connectionManager.close();
            }
            if (null != this.idleConnectionMonitorThread) {
                this.idleConnectionMonitorThread.shutdown();
            }
        }
        catch (IOException ex) {
            log.error(ex.toString(), (Throwable)ex);
        }
        catch (Exception e) {
            log.warn(e.toString(), (Throwable)e);
        }
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private final int threadSleepIntervalMS;
        private final int connIdleTimeoutMS;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, int threadSleepIntervalMS, int connIdleTimeoutMS) {
            this.connMgr = connMgr;
            this.threadSleepIntervalMS = threadSleepIntervalMS;
            this.connIdleTimeoutMS = connIdleTimeoutMS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(this.threadSleepIntervalMS);
                        log.trace("Close expired or idle connections periodically");
                        this.connMgr.closeIdleConnections((long)this.connIdleTimeoutMS, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (InterruptedException ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
            log.warn("Idle Connection Monitor Thread shutdown!!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    public static class SyncHttpClientBuilder {
        private int poolSize = 200;
        private int maxPerRoute = 50;
        private int threadSleepIntervalMS = 5000;
        private int connIdleTimeoutMS = 15000;
        private RequestConfig requestConfig;
        private HttpRequestRetryHandler retryHandler;

        SyncHttpClientBuilder() {
        }

        public SyncHttpClientBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public SyncHttpClientBuilder maxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
            return this;
        }

        public SyncHttpClientBuilder threadSleepIntervalMS(int threadSleepIntervalMS) {
            this.threadSleepIntervalMS = threadSleepIntervalMS;
            return this;
        }

        public SyncHttpClientBuilder connIdleTimeoutMS(int connIdleTimeoutMS) {
            this.connIdleTimeoutMS = connIdleTimeoutMS;
            return this;
        }

        public SyncHttpClientBuilder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        public SyncHttpClientBuilder retryHandler(HttpRequestRetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public SyncHttpClientImpl build() {
            return new SyncHttpClientImpl(this.poolSize, this.maxPerRoute, this.threadSleepIntervalMS, this.connIdleTimeoutMS, this.requestConfig, this.retryHandler);
        }
    }
}

