/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.httpclient.request.async;

import com.tplink.nbu.common.httpclient.request.async.AsyncHttpClient;
import java.util.function.Consumer;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClientImpl
extends AsyncHttpClient {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpClientImpl.class);
    private static final int DEFAULT_POOL_SIZE = 200;
    private static final int DEFAULT_MAX_PER_ROUTE = 50;
    private final int poolSize;
    private final int maxPerRoute;
    private final RequestConfig defaultRequestConfig;
    private CloseableHttpAsyncClient httpClient;
    private Consumer<HttpAsyncClientBuilder> builderConsumer;

    @Deprecated
    public AsyncHttpClientImpl() {
        this(200, 50);
    }

    @Deprecated
    public AsyncHttpClientImpl(int poolSize, int maxPerRoute) {
        this(poolSize, maxPerRoute, null);
    }

    private AsyncHttpClientImpl(int poolSize, int maxPerRoute, RequestConfig requestConfig) {
        this.poolSize = poolSize;
        this.maxPerRoute = maxPerRoute;
        this.defaultRequestConfig = requestConfig;
        this.httpClient = null;
    }

    private AsyncHttpClientImpl(int poolSize, int maxPerRoute, RequestConfig requestConfig, Consumer<HttpAsyncClientBuilder> builderConsumer) {
        this(poolSize, maxPerRoute, requestConfig);
        this.builderConsumer = builderConsumer;
    }

    public static AsyncHttpClientBuilder custom() {
        return new AsyncHttpClientBuilder();
    }

    public static AsyncHttpClientImpl createDefault() {
        return AsyncHttpClientImpl.custom().build();
    }

    private synchronized void initHttpClient() throws IOReactorException {
        if (null != this.httpClient) {
            return;
        }
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setSoKeepAlive(true).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        connManager.setMaxTotal(this.poolSize);
        connManager.setDefaultMaxPerRoute(this.maxPerRoute);
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setDefaultRequestConfig(this.defaultRequestConfig).setConnectionManager((NHttpClientConnectionManager)connManager);
        if (this.builderConsumer != null) {
            this.builderConsumer.accept(builder);
        }
        this.httpClient = builder.build();
        this.httpClient.start();
    }

    @Override
    public void execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) throws IOReactorException {
        if (null == this.httpClient) {
            this.initHttpClient();
        }
        this.httpClient.execute(request, callback);
    }

    @Override
    public void destroy() {
        log.debug("Destroy the AsyncHttpClient!!");
        try {
            if (null != this.httpClient) {
                this.httpClient.close();
            }
        }
        catch (Exception e) {
            log.warn(e.toString(), (Throwable)e);
        }
    }

    public static class AsyncHttpClientBuilder {
        private int poolSize = 200;
        private int maxPerRoute = 50;
        private RequestConfig requestConfig;
        private Consumer<HttpAsyncClientBuilder> lowerBuilderConsumer;

        AsyncHttpClientBuilder() {
        }

        public AsyncHttpClientBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public AsyncHttpClientBuilder maxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
            return this;
        }

        public AsyncHttpClientBuilder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        public AsyncHttpClientBuilder lowerBuilderConsumer(Consumer<HttpAsyncClientBuilder> consumer) {
            this.lowerBuilderConsumer = consumer;
            return this;
        }

        public AsyncHttpClientImpl build() {
            return new AsyncHttpClientImpl(this.poolSize, this.maxPerRoute, this.requestConfig, this.lowerBuilderConsumer);
        }

        public String toString() {
            return "AsyncHttpClientImpl.AsyncHttpClientBuilder(poolSize=" + this.poolSize + ", maxPerRoute=" + this.maxPerRoute + ", requestConfig=" + this.requestConfig + ", lowerBuilderConsumer=" + this.lowerBuilderConsumer + ")";
        }
    }
}

