/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.httpclient.request;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

public class HttpRequestBuilder {
    public static final int DEFAULT_CONN_TIMEOUT_MS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 5000;
    private String url;
    private String method;
    private JSONObject requestParamsJson;
    private Map<String, String> headerParams;
    private Map<String, String> requestParams;
    private int connectTimeoutMs;
    private int socketTimeoutMs;

    private HttpRequestBuilder(String url) {
        this.url = url;
        this.method = "GET";
        this.headerParams = null;
        this.requestParamsJson = null;
        this.requestParams = new HashMap<String, String>();
        this.connectTimeoutMs = 1000;
        this.socketTimeoutMs = 5000;
    }

    public static HttpRequestBuilder create(String url) {
        return new HttpRequestBuilder(url);
    }

    public HttpRequestBuilder post() {
        this.method = "POST";
        return this;
    }

    public HttpRequestBuilder get() {
        this.method = "GET";
        return this;
    }

    public HttpRequestBuilder head() {
        this.method = "HEAD";
        return this;
    }

    public HttpRequestBuilder delete() {
        this.method = "DELETE";
        return this;
    }

    public HttpRequestBuilder put() {
        this.method = "PUT";
        return this;
    }

    public HttpRequestBuilder patch() {
        this.method = "PATCH";
        return this;
    }

    public HttpRequestBuilder setRequestParamsJson(JSONObject requestParamsJson) {
        this.requestParamsJson = requestParamsJson;
        return this;
    }

    public HttpRequestBuilder addQueryParam(String name, String value) {
        try {
            this.url = new URIBuilder(this.url).addParameter(name, value).build().toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    public HttpRequestBuilder addRequestParam(String key, String value) {
        if (null == this.requestParams) {
            this.requestParams = new HashMap<String, String>();
        }
        this.requestParams.put(key, value);
        return this;
    }

    public HttpRequestBuilder addHeaderParam(String key, String value) {
        if (null == this.headerParams) {
            this.headerParams = new HashMap<String, String>();
        }
        this.headerParams.put(key, value);
        return this;
    }

    public HttpRequestBuilder connectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    public HttpRequestBuilder socketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
        return this;
    }

    public HttpUriRequest build() {
        RequestBuilder requestBuilder = RequestBuilder.create((String)this.method);
        if (null != this.headerParams) {
            for (String key : this.headerParams.keySet()) {
                requestBuilder.addHeader(key, this.headerParams.get(key));
            }
        }
        if (null != this.requestParams) {
            for (String key : this.requestParams.keySet()) {
                requestBuilder.addParameter(key, this.requestParams.get(key));
            }
        }
        if (null != this.requestParamsJson) {
            StringEntity entity = new StringEntity(this.requestParamsJson.toString(), Consts.UTF_8);
            entity.setContentType(ContentType.APPLICATION_JSON.toString());
            requestBuilder.setEntity((HttpEntity)entity);
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeoutMs).setConnectTimeout(this.connectTimeoutMs).build();
        return requestBuilder.setUri(this.url).setConfig(requestConfig).build();
    }
}

