/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.httpclient.mgmt;

import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmtBase;
import com.tplink.nbu.common.httpclient.request.async.AsyncHttpClient;
import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.SyncResponseHandler;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientMgmtProxy
extends HttpClientMgmtBase {
    private static final Logger log = LoggerFactory.getLogger(HttpClientMgmtProxy.class);

    private HttpClientMgmtProxy(SyncHttpClient syncHttpClientProxy, AsyncHttpClient asyncHttpClientProxy) {
        super(syncHttpClientProxy, asyncHttpClientProxy);
    }

    public static HttpClientMgmtProxy create(final HttpClientMgmt httpClientMgmt, final RequestConfig syncRequestConfig, final RequestConfig asyncRequestConfig) {
        SyncHttpClient syncHttpClientProxy = new SyncHttpClient(){
            private final SyncHttpClient syncHttpClient;
            {
                this.syncHttpClient = httpClientMgmt.sync();
            }

            @Override
            public void execute(HttpUriRequest request, SyncResponseHandler callback) throws IOException {
                if (syncRequestConfig != null) {
                    HttpClientMgmtProxy.setRequestConfig(request, syncRequestConfig);
                }
                this.syncHttpClient.execute(request, callback);
            }

            @Override
            public void destroy() {
                this.syncHttpClient.destroy();
            }
        };
        AsyncHttpClient asyncHttpClientProxy = new AsyncHttpClient(){
            private final AsyncHttpClient asyncHttpClient;
            {
                this.asyncHttpClient = httpClientMgmt.async();
            }

            @Override
            public void execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) throws IOReactorException {
                if (asyncRequestConfig != null) {
                    HttpClientMgmtProxy.setRequestConfig(request, asyncRequestConfig);
                }
                this.asyncHttpClient.execute(request, callback);
            }

            @Override
            public void destroy() {
                this.asyncHttpClient.destroy();
            }
        };
        return new HttpClientMgmtProxy(syncHttpClientProxy, asyncHttpClientProxy);
    }

    private static void setRequestConfig(HttpUriRequest request, RequestConfig requestConfig) {
        if (request instanceof HttpRequestBase) {
            ((HttpRequestBase)request).setConfig(requestConfig);
        } else {
            log.warn("Cannot set config to request {}", request.getClass());
        }
    }
}

