/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.global;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public enum DeviceRoleType {
    MASTER("master", 1),
    SLAVE("slave", 0),
    OTHER("other", -1);

    private String value;
    private int code;

    private DeviceRoleType(String value, int code) {
        this.code = code;
        this.value = value;
    }

    public static DeviceRoleType value(String value) {
        for (DeviceRoleType deviceStatus : DeviceRoleType.values()) {
            if (!deviceStatus.value.equals(value)) continue;
            return deviceStatus;
        }
        return OTHER;
    }

    public int getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public static class DecoRoleJsonDeserializer
    extends JsonDeserializer<Integer> {
        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return DeviceRoleType.value(jsonParser.getText()).getCode();
        }
    }
}

