/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.security;

import com.tplink.nbu.common.cloudv2.security.ApiCredential;
import com.tplink.nbu.common.cloudv2.security.AuthenticateManage;
import com.tplink.nbu.common.cloudv2.security.AuthenticatedRequest;
import com.tplink.nbu.common.cloudv2.security.PlatformCloudKeyConfig;
import com.tplink.nbu.common.utils.CipherUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticateManageImpl
implements AuthenticateManage {
    private static final Logger log = LoggerFactory.getLogger(AuthenticateManageImpl.class);
    private PlatformCloudKeyConfig keyConfig;

    public AuthenticateManageImpl(PlatformCloudKeyConfig keyConfig) {
        this.keyConfig = keyConfig;
    }

    @Override
    public ApiCredential getCredential(AuthenticatedRequest request) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = UUID.randomUUID().toString();
        String contentMd5 = CipherUtil.httpContentMd5((String)request.getPayload());
        String signature = this.getSignature(contentMd5, timestamp, nonce, request.getPath());
        return ApiCredential.builder().accessKey(this.keyConfig.getAccessKey()).nonce(nonce).contentMd5(contentMd5).timestamp(timestamp).signature(signature).build();
    }

    @Override
    public void configRequest(HttpRequest request, ApiCredential credential) {
        Map<String, String> headers = this.getHeaders(credential);
        headers.forEach((arg_0, arg_1) -> ((HttpRequest)request).setHeader(arg_0, arg_1));
    }

    @Override
    public void configRequest(HttpRequest httpRequest, AuthenticatedRequest basicRequestInfo) {
        this.configRequest(httpRequest, this.getCredential(basicRequestInfo));
    }

    public String getSignature(String contentMd5, long timestamp, String nonce, String path) {
        List<String> params = Arrays.asList(contentMd5, String.valueOf(timestamp), nonce, path);
        String strToSign = params.stream().collect(Collectors.joining("\n"));
        return CipherUtil.hamcsha1((String)strToSign, (String)this.keyConfig.getSecret());
    }

    public Map<String, String> getHeaders(ApiCredential credential) {
        HashMap<String, String> headers = new HashMap<String, String>();
        List<String> params = Arrays.asList("Timestamp=".concat(String.valueOf(credential.getTimestamp())), "Nonce=".concat(credential.getNonce()), "AccessKey=".concat(credential.getAccessKey()), "Signature=".concat(credential.getSignature()));
        headers.put("X-Authorization", params.stream().collect(Collectors.joining(", ")));
        headers.put("Content-MD5", credential.getContentMd5());
        log.debug("generate headers: {}", headers);
        return headers;
    }
}

