/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.security;

public class ApiCredential {
    private Long timestamp;
    private String nonce;
    private String accessKey;
    private String signature;
    private String contentMd5;

    ApiCredential(Long timestamp, String nonce, String accessKey, String signature, String contentMd5) {
        this.timestamp = timestamp;
        this.nonce = nonce;
        this.accessKey = accessKey;
        this.signature = signature;
        this.contentMd5 = contentMd5;
    }

    public static ApiCredentialBuilder builder() {
        return new ApiCredentialBuilder();
    }

    public String toString() {
        return "ApiCredential(timestamp=" + this.getTimestamp() + ", nonce=" + this.getNonce() + ", accessKey=" + this.getAccessKey() + ", signature=" + this.getSignature() + ", contentMd5=" + this.getContentMd5() + ")";
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public static class ApiCredentialBuilder {
        private Long timestamp;
        private String nonce;
        private String accessKey;
        private String signature;
        private String contentMd5;

        ApiCredentialBuilder() {
        }

        public ApiCredentialBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ApiCredentialBuilder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public ApiCredentialBuilder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public ApiCredentialBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public ApiCredentialBuilder contentMd5(String contentMd5) {
            this.contentMd5 = contentMd5;
            return this;
        }

        public ApiCredential build() {
            return new ApiCredential(this.timestamp, this.nonce, this.accessKey, this.signature, this.contentMd5);
        }

        public String toString() {
            return "ApiCredential.ApiCredentialBuilder(timestamp=" + this.timestamp + ", nonce=" + this.nonce + ", accessKey=" + this.accessKey + ", signature=" + this.signature + ", contentMd5=" + this.contentMd5 + ")";
        }
    }
}

