/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.cloud.entity.AccountInfoV2;
import com.tplink.nbu.common.cloud.entity.BatchGetServiceUrlReq;
import com.tplink.nbu.common.cloud.entity.BatchGetServiceUrlResp;
import com.tplink.nbu.common.cloud.entity.DecoFeatureInfo;
import com.tplink.nbu.common.cloud.entity.ServiceUrlInfo;
import com.tplink.nbu.common.cloudv2.AppServerInternalV2Api;
import com.tplink.nbu.common.cloudv2.DeserializeCallback;
import com.tplink.nbu.common.cloudv2.EAPIntlFwQuery;
import com.tplink.nbu.common.cloudv2.PlatformCloudV2Api;
import com.tplink.nbu.common.cloudv2.PlatformCloudV2ApiUtil;
import com.tplink.nbu.common.cloudv2.constant.Brand;
import com.tplink.nbu.common.cloudv2.entity.DeviceFwInfo;
import com.tplink.nbu.common.cloudv2.entity.DeviceOwnerInfo;
import com.tplink.nbu.common.cloudv2.entity.EAPDeviceInfo;
import com.tplink.nbu.common.cloudv2.entity.EAPFwInfo;
import com.tplink.nbu.common.cloudv2.entity.GetAllRegionCodeInfoResp;
import com.tplink.nbu.common.cloudv2.entity.GetDeviceInfoBySnReq;
import com.tplink.nbu.common.cloudv2.entity.GetDeviceInfoBySnResp;
import com.tplink.nbu.common.cloudv2.entity.LoginInfoV2;
import com.tplink.nbu.common.cloudv2.entity.PlatformCloudRequestPayload;
import com.tplink.nbu.common.cloudv2.entity.ServiceInfo;
import com.tplink.nbu.common.cloudv2.entity.ServiceRegionInfo;
import com.tplink.nbu.common.cloudv2.entity.WrapPlatformCloudRequestPayload;
import com.tplink.nbu.common.cloudv2.entity.request.AbandonDeviceUserRoleReq;
import com.tplink.nbu.common.cloudv2.entity.request.AddMfaTypeReq;
import com.tplink.nbu.common.cloudv2.entity.request.AuthTokenReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetAccountRegionCodeByCloudUserNameReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetAccountRegionCodeByIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetAccountStorageRegionByCloudUserNameReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetAccountStorageRegionByIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetDeviceInfoByMacReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetDeviceInfoByQRCodeReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetDeviceRegionCodeReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetDeviceStorageRegionInfoByMacReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetDeviceStorageRegionInfoReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetIntlFwListReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetSecureFwListReq;
import com.tplink.nbu.common.cloudv2.entity.request.BatchGetServiceRegion2ServiceUrlReq;
import com.tplink.nbu.common.cloudv2.entity.request.BindDeviceForBindCodeReq;
import com.tplink.nbu.common.cloudv2.entity.request.BindDeviceReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckDeviceTokenReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckDeviceTokenWithIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckFwUpdateStatusReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckMFACodeLoginReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckPasswordReq;
import com.tplink.nbu.common.cloudv2.entity.request.CheckShareBlacklistReq;
import com.tplink.nbu.common.cloudv2.entity.request.CreateSubscriptionsReq;
import com.tplink.nbu.common.cloudv2.entity.request.DelMfaTypeReq;
import com.tplink.nbu.common.cloudv2.entity.request.DeleteSubscriptionsReq;
import com.tplink.nbu.common.cloudv2.entity.request.DisableMFAReq;
import com.tplink.nbu.common.cloudv2.entity.request.EnableMFAReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetAccountInfoByIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetAccountInfoByTokenWithCacheReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetAccountInfoByUsernameReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceBasicInfoReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceFeatureInfoReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceInfoForBizCloudReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceListByPageReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceProxySecretByDeviceIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceServiceUrlReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceShareInfoByPageReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetDeviceShareInfoByShareIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetEAPDeviceInfoReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetEAPIntlFwListReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetIpLocationReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetMFAFeatureStatusReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetMsgReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetOwnerInfoByDeviceTokenReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetServiceRegionReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetSubscriptionsReq;
import com.tplink.nbu.common.cloudv2.entity.request.GetTOTPUrlReq;
import com.tplink.nbu.common.cloudv2.entity.request.LoginReq;
import com.tplink.nbu.common.cloudv2.entity.request.MergeThirdAuthAccountWithoutNotifyDeviceReq;
import com.tplink.nbu.common.cloudv2.entity.request.PassthroughForBizCloudPayload;
import com.tplink.nbu.common.cloudv2.entity.request.PurgeThirdAuthAccountReq;
import com.tplink.nbu.common.cloudv2.entity.request.PushDeviceMsgReq;
import com.tplink.nbu.common.cloudv2.entity.request.PushForAppsByTerminalIdReq;
import com.tplink.nbu.common.cloudv2.entity.request.PushForAppsWithLocaleReq;
import com.tplink.nbu.common.cloudv2.entity.request.RegisterRetailDeviceListReq;
import com.tplink.nbu.common.cloudv2.entity.request.RegisterThirdAuthAccountReq;
import com.tplink.nbu.common.cloudv2.entity.request.RequestUrlReq;
import com.tplink.nbu.common.cloudv2.entity.request.SendDisableMFAEmailReq;
import com.tplink.nbu.common.cloudv2.entity.request.SendEmailReq;
import com.tplink.nbu.common.cloudv2.entity.request.SubscribeDeviceEventsReq;
import com.tplink.nbu.common.cloudv2.entity.request.SubscribeMsgForBizCloudReq;
import com.tplink.nbu.common.cloudv2.entity.request.SubscribeMsgReq;
import com.tplink.nbu.common.cloudv2.entity.request.UnbindDeviceReq;
import com.tplink.nbu.common.cloudv2.entity.request.UnregisterRetailDeviceListReq;
import com.tplink.nbu.common.cloudv2.entity.request.UnsubscribeDevicesForBizCloudReq;
import com.tplink.nbu.common.cloudv2.entity.request.UnsubscribeMsgReq;
import com.tplink.nbu.common.cloudv2.entity.request.UpdateAccountInfoReq;
import com.tplink.nbu.common.cloudv2.entity.request.UpdateEmailSettingReq;
import com.tplink.nbu.common.cloudv2.entity.request.UpdateTopicSubscriptionReq;
import com.tplink.nbu.common.cloudv2.entity.request.ValidateDeviceByQRCodeReq;
import com.tplink.nbu.common.cloudv2.entity.request.VerifyBindCodeReq;
import com.tplink.nbu.common.cloudv2.entity.response.AuthTokenResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetAccountRegionCodeByCloudUserNameResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetAccountRegionCodeByIdResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetAccountStorageRegionByCloudUserNameResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetAccountStorageRegionByIdResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetDeviceInfoByMacResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetDeviceInfoByQRCodeResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetDeviceRegionCodeResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetDeviceStorageRegionInfoByMacRsp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetDeviceStorageRegionInfoRsp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetSecureFwListResp;
import com.tplink.nbu.common.cloudv2.entity.response.BatchGetServiceRegion2ServiceUrlResp;
import com.tplink.nbu.common.cloudv2.entity.response.BindDeviceForBindCodeResp;
import com.tplink.nbu.common.cloudv2.entity.response.BindDeviceResp;
import com.tplink.nbu.common.cloudv2.entity.response.CheckDeviceTokenResp;
import com.tplink.nbu.common.cloudv2.entity.response.CheckDeviceTokenWithIdResp;
import com.tplink.nbu.common.cloudv2.entity.response.CheckFwUpdateStatusResp;
import com.tplink.nbu.common.cloudv2.entity.response.CheckPasswordResp;
import com.tplink.nbu.common.cloudv2.entity.response.CheckShareBlacklistResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceBasicInfoResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceInfoForBizCloudResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceListByPageResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceProxySecretByDeviceIdResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceShareInfoByPageResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetDeviceShareInfoByShareIdResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetEAPIntlFwListResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetIpLocationResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetIpRegionCodeResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetMFAFeatureStatusResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetMsgResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetSubscriptionsResp;
import com.tplink.nbu.common.cloudv2.entity.response.GetTOTPUrlResp;
import com.tplink.nbu.common.cloudv2.entity.response.MergeThirdAuthAccountWithoutNotifyDeviceResp;
import com.tplink.nbu.common.cloudv2.entity.response.RegisterRetailDeviceListResp;
import com.tplink.nbu.common.cloudv2.entity.response.RegisterThirdAuthAccountResp;
import com.tplink.nbu.common.cloudv2.entity.response.RequestUrlResp;
import com.tplink.nbu.common.cloudv2.entity.response.SendEmailResp;
import com.tplink.nbu.common.cloudv2.entity.response.SubscribeDeviceEventsResp;
import com.tplink.nbu.common.cloudv2.entity.response.UnregisterRetailDeviceListResp;
import com.tplink.nbu.common.cloudv2.entity.response.ValidateDeviceByQRCodeResp;
import com.tplink.nbu.common.cloudv2.entity.response.VerifyBindCodeResp;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.global.CustomObjectMapper;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.nbu.common.utils.HttpRequestUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;

public class AppServerInternalV2ApiImpl
implements AppServerInternalV2Api {
    public static final String V2_INTERNAL_API_PREFIX = "/api/v2/internal/";
    public static final String V2_TOOL_API_PREFIX = "/api/v2/tool/";
    public static final String V2_INTERNAL_EMAIL_NOTIFICATION = "/v2/internal/email-notification/";
    private final PlatformCloudV2Api platformCloudV2Api;
    private final ObjectMapper objectMapper = new CustomObjectMapper();
    private final Cache<String, ServiceInfo> serviceInfoMap = CacheBuilder.newBuilder().maximumSize(100L).build();

    public AppServerInternalV2ApiImpl(PlatformCloudV2Api platformCloudV2Api) {
        this.platformCloudV2Api = platformCloudV2Api;
    }

    @Override
    public void setBeforeRequest(HttpRequestHandler requestHandler) {
        this.platformCloudV2Api.setBeforeRequest(requestHandler);
    }

    @Override
    public void passthroughForBizCloudAsync(String url, String deviceId, JsonNode requestData, String deviceType, FutureCallback<JsonNode> callback) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        PlatformCloudRequestPayload payload = this.preparePassthroughForBizCloudPayload(deviceId, requestData, deviceType);
        this.platformCloudV2Api.requestAsync((HttpEntityEnclosingRequestBase)request, payload, new DeserializeCallback<JsonNode>(callback){});
    }

    @Override
    public JsonNode passthroughForBizCloud(String url, String deviceId, JsonNode requestData, String deviceType) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        PlatformCloudRequestPayload payload = this.preparePassthroughForBizCloudPayload(deviceId, requestData, deviceType);
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, payload, JsonNode.class);
    }

    private PlatformCloudRequestPayload preparePassthroughForBizCloudPayload(String deviceId, JsonNode requestData, String deviceType) {
        return new WrapPlatformCloudRequestPayload("passthroughForBizCloud", new PassthroughForBizCloudPayload(deviceId, requestData, deviceType));
    }

    @Override
    public DeviceOwnerInfo getOwnerInfoByDeviceToken(String url, String deviceId, String deviceToken, String serviceId) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload payload = new WrapPlatformCloudRequestPayload("getOwnerInfoByDeviceToken", new GetOwnerInfoByDeviceTokenReq(deviceId, deviceToken, serviceId));
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, payload, DeviceOwnerInfo.class);
    }

    @Override
    public void pushForAppsWithLocale(String url, List<String> accountIds, String msgType, JsonNode data, List<String> appTypes, long timeToLive, int retryLimit, JsonNode payload) throws URISyntaxException, IOException, CloudException {
        if (null == accountIds) {
            accountIds = Collections.emptyList();
        }
        if (null == appTypes) {
            appTypes = Collections.emptyList();
        }
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        PushForAppsWithLocaleReq req = PushForAppsWithLocaleReq.builder().accountIds(accountIds).msgType(msgType).data(data).appTypes(appTypes).timeToLive(timeToLive).retryLimit(retryLimit).payload(payload).build();
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("pushForAppsWithLocale", req);
        this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, JsonNode.class);
    }

    @Override
    public List<DeviceFwInfo> batchGetIntlFwList(String url, Set<String> deviceIdList) throws URISyntaxException, IOException, CloudException {
        if (null == deviceIdList) {
            deviceIdList = Collections.emptySet();
        }
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("batchGetIntlFwList", new BatchGetIntlFwListReq(deviceIdList));
        JsonNode result = this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, JsonNode.class);
        return (List)this.objectMapper.readValue(result.path("deviceList").traverse(), (TypeReference)new TypeReference<List<DeviceFwInfo>>(){});
    }

    @Override
    public GetAllRegionCodeInfoResp getAllRegionCodeInfo(String url) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getAllRegionCodeInfo", this.objectMapper.createObjectNode());
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, GetAllRegionCodeInfoResp.class);
    }

    @Override
    public AccountInfoV2 getAccountInfoById(String url, String accountId) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getAccountInfoById", new GetAccountInfoByIdReq(accountId));
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, AccountInfoV2.class);
    }

    @Override
    public AccountInfoV2 getAccountInfoByTokenWithCache(String url, String token) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getAccountInfoByTokenWithCache", new GetAccountInfoByTokenWithCacheReq(token), AccountInfoV2.class);
    }

    @Override
    public ServiceRegionInfo getServiceRegion(String url, String serviceId, String regionCode) throws CloudException, IOException, URISyntaxException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getServiceRegion", new GetServiceRegionReq(serviceId, regionCode));
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, ServiceRegionInfo.class);
    }

    @Override
    public ServiceUrlInfo getDeviceServiceUrl(String url, String deviceToken, String deviceId, List<String> serviceIds) throws CloudException, IOException, URISyntaxException {
        if (null == serviceIds) {
            serviceIds = Collections.emptyList();
        }
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getDeviceServiceUrl", new GetDeviceServiceUrlReq(deviceToken, deviceId, serviceIds));
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, ServiceUrlInfo.class);
    }

    @Override
    public BatchGetServiceUrlResp getServiceUrl(String url, String regionCode, List<String> serviceIds) throws URISyntaxException, IOException, CloudException {
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        BatchGetServiceUrlReq requestDTO = BatchGetServiceUrlReq.builder().regionCode(regionCode).serviceIds(serviceIds).build();
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getServiceUrl", requestDTO);
        return this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, BatchGetServiceUrlResp.class);
    }

    @Override
    public String getServiceUrl(String url, String regionCode, String serviceId) throws CloudException, IOException, URISyntaxException {
        List<String> serviceIds = Collections.singletonList(serviceId);
        BatchGetServiceUrlResp respDTO = this.getServiceUrl(url, regionCode, serviceIds);
        if (!respDTO.getServiceUrls().isEmpty()) {
            return respDTO.getServiceUrls().get(serviceId);
        }
        return null;
    }

    @Override
    public GetDeviceInfoBySnResp getDeviceInfoBySn(String url, GetDeviceInfoBySnReq request) throws CloudException, IOException, URISyntaxException {
        String DEFAULT_CUSTOM_PATH = "eap";
        if (request.getCustomPath() == null) {
            request.setCustomPath("eap");
        }
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + request.getCustomPathWithSuffix(), "getDeviceInfoBySn", request, GetDeviceInfoBySnResp.class);
    }

    @Override
    public SendEmailResp sendEmail(String url, SendEmailReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "sendEmail", req, SendEmailResp.class);
    }

    @Override
    public SendEmailResp sendEmailWithAttachment(String url, SendEmailReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "sendEmailWithAttachment", req, SendEmailResp.class);
    }

    @Override
    public AccountInfoV2 getAccountInfoByEmail(String url, String cloudUserName) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getAccountInfo", new GetAccountInfoByUsernameReq(cloudUserName), AccountInfoV2.class);
    }

    @Override
    public AccountInfoV2 getAccountInfoByCloudUserName(String url, String cloudUserName) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getAccountInfo", new GetAccountInfoByUsernameReq(cloudUserName), AccountInfoV2.class);
    }

    @Override
    public CheckDeviceTokenResp checkDeviceToken(String url, String serviceId, String deviceToken) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "checkDeviceToken", new CheckDeviceTokenReq(serviceId, deviceToken), CheckDeviceTokenResp.class);
    }

    @Override
    public CheckFwUpdateStatusResp checkFwUpdateStatus(String url, List<String> deviceList) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "checkFwUpdateStatus", CheckFwUpdateStatusReq.of(deviceList), CheckFwUpdateStatusResp.class);
    }

    @Override
    public GetDeviceInfoForBizCloudResp batchGetDeviceInfoForBizCloud(String url, List<String> deviceIdList, boolean emailNeeded, String prodLineCategory, String isNewDomain) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceInfoForBizCloud", new GetDeviceInfoForBizCloudReq(deviceIdList, emailNeeded, prodLineCategory, isNewDomain), GetDeviceInfoForBizCloudResp.class);
    }

    @Override
    public void sendDisableMFAEmail(String url, SendDisableMFAEmailReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "sendDisableMFAEmail", req, JsonNode.class);
    }

    @Override
    public LoginInfoV2 login(String url, LoginReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "login", req, LoginInfoV2.class);
    }

    @Override
    public LoginInfoV2 checkMFACodeAndLogin(String url, CheckMFACodeLoginReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "checkMFACodeAndLogin", req, LoginInfoV2.class);
    }

    @Override
    public GetMFAFeatureStatusResp getMFAFeatureStatus(String url, GetMFAFeatureStatusReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getMFAFeatureStatus", req, GetMFAFeatureStatusResp.class);
    }

    @Override
    public GetTOTPUrlResp getTOTPUrl(String url, GetTOTPUrlReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getTOTPUrl", req, GetTOTPUrlResp.class);
    }

    @Override
    public void enableMFA(String url, EnableMFAReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "enableMFA", req, JsonNode.class);
    }

    @Override
    public void disableMFA(String url, DisableMFAReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "disableMFA", req, JsonNode.class);
    }

    @Override
    public void addMfaType(String url, AddMfaTypeReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "addMFAType", req, JsonNode.class);
    }

    @Override
    public void delMfaType(String url, DelMfaTypeReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "delMFAType", req, JsonNode.class);
    }

    @Override
    public CheckPasswordResp checkPassword(String url, CheckPasswordReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "checkPassword", req, CheckPasswordResp.class);
    }

    @Override
    public void updateTopicSubscription(String url, UpdateTopicSubscriptionReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "updateTopicSubscription", req, JsonNode.class);
    }

    @Override
    public Map<String, DecoFeatureInfo> getDeviceFeatureInfoForDeco(String url, List<String> deviceIdList) throws CloudException, IOException, URISyntaxException {
        if (null == deviceIdList) {
            deviceIdList = Collections.emptyList();
        }
        HttpPost request = HttpRequestUtil.buildPostReq(url, V2_INTERNAL_API_PREFIX);
        WrapPlatformCloudRequestPayload requestPayload = new WrapPlatformCloudRequestPayload("getDeviceFeatureInfo", new GetDeviceFeatureInfoReq(deviceIdList));
        JsonNode result = this.platformCloudV2Api.request((HttpEntityEnclosingRequestBase)request, requestPayload, JsonNode.class).get("featureInfo");
        HashMap<String, DecoFeatureInfo> resultMap = new HashMap<String, DecoFeatureInfo>();
        Iterator iterator = result.fields();
        while (iterator.hasNext()) {
            Map.Entry deviceFeatureInfo = (Map.Entry)iterator.next();
            JsonNode data = ((JsonNode)deviceFeatureInfo.getValue()).get("data");
            DecoFeatureInfo decoFeatureInfo = new DecoFeatureInfo();
            if (data != null) {
                decoFeatureInfo = (DecoFeatureInfo)this.objectMapper.readValue(data.toString(), DecoFeatureInfo.class);
                decoFeatureInfo.setGroupName(new String(Base64.getDecoder().decode(decoFeatureInfo.getGroupName()), StandardCharsets.UTF_8));
            }
            resultMap.put((String)deviceFeatureInfo.getKey(), decoFeatureInfo);
        }
        return resultMap;
    }

    @Override
    public List<EAPFwInfo> batchGetEAPIntlFwList(String url, List<EAPIntlFwQuery> queryList) throws CloudException, IOException, URISyntaxException {
        String DEFAULT_CUSTOM_PATH = "eap";
        GetEAPIntlFwListReq request = new GetEAPIntlFwListReq();
        request.setCustomPath("eap");
        ArrayList<EAPFwInfo> fwInfoList = new ArrayList<EAPFwInfo>();
        int querySize = queryList.size();
        int index = 0;
        while (index < querySize) {
            int nextIndex = Math.min(index + 20, querySize);
            request.setQueryList(queryList.subList(index, nextIndex));
            fwInfoList.addAll(PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + request.getCustomPathWithSuffix(), "batchGetIntlFwList", request, GetEAPIntlFwListResp.class).getFwList());
            index = nextIndex;
        }
        return fwInfoList;
    }

    @Override
    public EAPDeviceInfo getEAPDeviceInfo(String url, GetEAPDeviceInfoReq req) throws CloudException, IOException, URISyntaxException {
        req.setCustomPath("eap");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "getDeviceInfo", req, EAPDeviceInfo.class);
    }

    @Override
    public void abandonDeviceUserRole(String url, AbandonDeviceUserRoleReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("eap");
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "abandonDeviceUserRole", req, JsonNode.class);
    }

    @Override
    public GetDeviceListByPageResp getDeviceListByPage(String url, GetDeviceListByPageReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("eap");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "getDeviceListByPage", req, GetDeviceListByPageResp.class);
    }

    @Override
    public void unbindDevice(String url, UnbindDeviceReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("eap");
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "unbindDevice", req, JsonNode.class);
    }

    @Override
    public CheckDeviceTokenWithIdResp checkDeviceTokenWithId(String url, CheckDeviceTokenWithIdReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("eap");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "checkDeviceTokenWithId", req, CheckDeviceTokenWithIdResp.class);
    }

    @Override
    public void updateAccountInfo(String url, UpdateAccountInfoReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "updateAccountInfo", req, JsonNode.class);
    }

    @Override
    public AuthTokenResp authToken(String url, AuthTokenReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "authToken", req, AuthTokenResp.class);
    }

    @Override
    public MergeThirdAuthAccountWithoutNotifyDeviceResp mergeThirdAuthAccountWithoutNotifyDevice(String url, MergeThirdAuthAccountWithoutNotifyDeviceReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("account");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "mergeThirdAuthAccountWithoutNotifyDevice", req, MergeThirdAuthAccountWithoutNotifyDeviceResp.class);
    }

    @Override
    public RegisterThirdAuthAccountResp registerThirdAuthAccount(String url, RegisterThirdAuthAccountReq req) throws CloudException, IOException, URISyntaxException {
        req.setCustomPath("account");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "registerThirdAuthAccount", req, RegisterThirdAuthAccountResp.class);
    }

    @Override
    public void purgeThirdAuthAccount(String url, PurgeThirdAuthAccountReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("account");
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "purgeThirdAuthAccount", req, JsonNode.class);
    }

    @Override
    public BatchGetDeviceInfoByMacResp batchGetDeviceInfoByMac(String url, BatchGetDeviceInfoByMacReq req) throws URISyntaxException, IOException, CloudException {
        req.setCustomPath("eap");
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "batchGetDeviceInfoByMac", req, BatchGetDeviceInfoByMacResp.class);
    }

    @Override
    public RequestUrlResp requestUrl(String url, RequestUrlReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "requestUrl", req, RequestUrlResp.class);
    }

    @Override
    public LoginInfoV2 captchaLoginInternal(String url, LoginReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "captchaLogin", req, LoginInfoV2.class);
    }

    @Override
    public SubscribeDeviceEventsResp subscribeDeviceEvents(String url, SubscribeDeviceEventsReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX + req.getCustomPathWithSuffix(), "subscribeDeviceEvents", req, SubscribeDeviceEventsResp.class);
    }

    @Override
    public void pushDeviceMsg(String url, PushDeviceMsgReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "pushDeviceMsg", req, JsonNode.class);
    }

    @Override
    public void pushForAppsByTerminalId(String url, PushForAppsByTerminalIdReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "pushForAppsByTerminalId", req, JsonNode.class);
    }

    @Override
    public CheckShareBlacklistResp checkShareBlacklist(String url, CheckShareBlacklistReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "checkShareBlacklist", req, CheckShareBlacklistResp.class);
    }

    @Override
    public GetDeviceShareInfoByShareIdResp getDeviceShareInfoByShareId(String url, GetDeviceShareInfoByShareIdReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getDeviceShareInfoByShareId", req, GetDeviceShareInfoByShareIdResp.class);
    }

    @Override
    public GetDeviceShareInfoByPageResp getDeviceShareInfoByPage(String url, GetDeviceShareInfoByPageReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getDeviceShareInfoByPage", req, GetDeviceShareInfoByPageResp.class);
    }

    @Override
    public void subscribeMsgForBizCloud(String url, SubscribeMsgForBizCloudReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "subscribeMsgForBizCloud", req, JsonNode.class);
    }

    @Override
    public void unsubscribeDevicesForBizCloud(String url, UnsubscribeDevicesForBizCloudReq req) throws URISyntaxException, IOException, CloudException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "unsubscribeDevicesForBizCloud", req, JsonNode.class);
    }

    @Override
    public GetMsgResp getMsg(String url, GetMsgReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getMsg", req, GetMsgResp.class);
    }

    @Override
    public BatchGetDeviceRegionCodeResp batchGetDeviceRegionCode(String url, BatchGetDeviceRegionCodeReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceRegionCode", req, BatchGetDeviceRegionCodeResp.class);
    }

    @Override
    public BatchGetAccountRegionCodeByIdResp batchGetAccountRegionCodeById(String url, BatchGetAccountRegionCodeByIdReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountRegionCodeById", req, BatchGetAccountRegionCodeByIdResp.class);
    }

    @Override
    public BatchGetAccountRegionCodeByCloudUserNameResp batchGetCloudUserNameRegionCodeById(String url, BatchGetAccountRegionCodeByCloudUserNameReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountRegionCodeByCloudUserName", req, BatchGetAccountRegionCodeByCloudUserNameResp.class);
    }

    @Override
    public BatchGetServiceRegion2ServiceUrlResp batchGetServiceRegion2ServiceUrlCache(String url, BatchGetServiceRegion2ServiceUrlReq req) throws CloudException, IOException, URISyntaxException {
        LinkedList<String> serviceIdList = new LinkedList<String>();
        LinkedList<ServiceInfo> serviceList = new LinkedList<ServiceInfo>();
        req.getServiceIdList().forEach(serviceId -> {
            ServiceInfo serviceInfo = (ServiceInfo)this.serviceInfoMap.getIfPresent(serviceId);
            if (serviceInfo != null && serviceInfo.getExpireTimestamp() > System.currentTimeMillis()) {
                serviceList.add(serviceInfo);
            } else {
                this.serviceInfoMap.invalidate(serviceId);
                serviceIdList.add((String)serviceId);
            }
        });
        if (!CollectionUtil.isEmpty(serviceIdList)) {
            BatchGetServiceRegion2ServiceUrlReq req1 = new BatchGetServiceRegion2ServiceUrlReq();
            req1.setServiceIdList(serviceIdList);
            BatchGetServiceRegion2ServiceUrlResp resp = this.batchGetServiceRegion2ServiceUrl(url, req1);
            resp.getServiceList().forEach(serviceInfo -> this.serviceInfoMap.put((Object)serviceInfo.getServiceId(), serviceInfo));
            serviceList.addAll(resp.getServiceList());
        }
        return BatchGetServiceRegion2ServiceUrlResp.builder().serviceList(serviceList).build();
    }

    @Override
    public BatchGetServiceRegion2ServiceUrlResp batchGetServiceRegion2ServiceUrl(String url, BatchGetServiceRegion2ServiceUrlReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetServiceRegion2ServiceUrl", req, BatchGetServiceRegion2ServiceUrlResp.class);
    }

    @Override
    public GetDeviceBasicInfoResp getDeviceBasicInfo(String url, GetDeviceBasicInfoReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getDeviceBasicInfo", req, GetDeviceBasicInfoResp.class);
    }

    @Override
    public BatchGetDeviceInfoByQRCodeResp batchGetDeviceInfoByQRCode(String url, BatchGetDeviceInfoByQRCodeReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceInfoByQRCode", req, BatchGetDeviceInfoByQRCodeResp.class);
    }

    @Override
    public BatchGetDeviceStorageRegionInfoRsp batchGetDeviceStorageRegionInfo(String url, BatchGetDeviceStorageRegionInfoReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceStorageRegionInfo", req, BatchGetDeviceStorageRegionInfoRsp.class);
    }

    @Override
    public GetIpLocationResp getIpLocation(String url, GetIpLocationReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_TOOL_API_PREFIX, "getIpLocation", req, GetIpLocationResp.class);
    }

    @Override
    public BatchGetAccountStorageRegionByCloudUserNameResp batchGetAccountStorageRegionByCloudUserName(String url, BatchGetAccountStorageRegionByCloudUserNameReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountStorageRegionByCloudUserName", req, BatchGetAccountStorageRegionByCloudUserNameResp.class);
    }

    @Override
    public BatchGetAccountStorageRegionByIdResp batchGetAccountStorageRegionById(String url, BatchGetAccountStorageRegionByIdReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountStorageRegionById", req, BatchGetAccountStorageRegionByIdResp.class);
    }

    @Override
    public BatchGetDeviceStorageRegionInfoByMacRsp batchGetDeviceStorageRegionInfoByMac(String url, BatchGetDeviceStorageRegionInfoByMacReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceStorageRegionInfoByMac", req, BatchGetDeviceStorageRegionInfoByMacRsp.class);
    }

    @Override
    public BatchGetDeviceStorageRegionInfoRsp batchGetDeviceStorageRegionInfo(String url, BatchGetDeviceStorageRegionInfoReq req, Brand brand) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceStorageRegionInfo", brand, req, BatchGetDeviceStorageRegionInfoRsp.class);
    }

    @Override
    public BatchGetDeviceStorageRegionInfoByMacRsp batchGetDeviceStorageRegionInfoByMac(String url, BatchGetDeviceStorageRegionInfoByMacReq req, Brand brand) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetDeviceStorageRegionInfoByMac", brand, req, BatchGetDeviceStorageRegionInfoByMacRsp.class);
    }

    @Override
    public BatchGetAccountStorageRegionByCloudUserNameResp batchGetAccountStorageRegionByCloudUserName(String url, BatchGetAccountStorageRegionByCloudUserNameReq req, Brand brand) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountStorageRegionByCloudUserName", brand, req, BatchGetAccountStorageRegionByCloudUserNameResp.class);
    }

    @Override
    public BatchGetAccountStorageRegionByIdResp batchGetAccountStorageRegionById(String url, BatchGetAccountStorageRegionByIdReq req, Brand brand) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetAccountStorageRegionById", brand, req, BatchGetAccountStorageRegionByIdResp.class);
    }

    @Override
    public BatchGetSecureFwListResp batchGetSecureFwList(String url, BatchGetSecureFwListReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "batchGetSecureFwList", req, BatchGetSecureFwListResp.class);
    }

    @Override
    public ValidateDeviceByQRCodeResp validateDeviceByQRCode(String url, ValidateDeviceByQRCodeReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "validateDeviceByQRCode", req, ValidateDeviceByQRCodeResp.class);
    }

    @Override
    public BindDeviceForBindCodeResp bindDeviceForBindCode(String url, BindDeviceForBindCodeReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "bindDeviceForBindCode", req, BindDeviceForBindCodeResp.class);
    }

    @Override
    public BindDeviceResp bindDevice(String url, BindDeviceReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "bindDevice", req, BindDeviceResp.class);
    }

    @Override
    public VerifyBindCodeResp verifyBindCode(String url, VerifyBindCodeReq req) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "verifyBindCode", req, VerifyBindCodeResp.class);
    }

    @Override
    public GetDeviceProxySecretByDeviceIdResp getDeviceProxySecretByDeviceId(String url, GetDeviceProxySecretByDeviceIdReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "getDeviceProxySecretByDeviceId", req, GetDeviceProxySecretByDeviceIdResp.class);
    }

    @Override
    public RegisterRetailDeviceListResp registerRetailDeviceList(String url, RegisterRetailDeviceListReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "registerRetailDeviceList", req, RegisterRetailDeviceListResp.class);
    }

    @Override
    public UnregisterRetailDeviceListResp unregisterRetailDeviceList(String url, UnregisterRetailDeviceListReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_API_PREFIX, "unregisterRetailDeviceList", req, UnregisterRetailDeviceListResp.class);
    }

    @Override
    public void createSubscriptions(String url, CreateSubscriptionsReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "createSubscriptions", req, JsonNode.class);
    }

    @Override
    public void subscribeEmailNotification(String url, SubscribeMsgReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "subscribeEmailNotification", req, JsonNode.class);
    }

    @Override
    public void unsubscribeEmailNotification(String url, UnsubscribeMsgReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "unsubscribeEmailNotification", req, JsonNode.class);
    }

    @Override
    public void updateEmailSetting(String url, UpdateEmailSettingReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "updateEmailSetting", req, JsonNode.class);
    }

    @Override
    public GetSubscriptionsResp getEmailSubscriptions(String url, GetSubscriptionsReq req) throws CloudException, IOException, URISyntaxException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "getEmailSubscriptions", req, GetSubscriptionsResp.class);
    }

    @Override
    public void deleteSubscriptions(String url, DeleteSubscriptionsReq req) throws CloudException, IOException, URISyntaxException {
        PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, V2_INTERNAL_EMAIL_NOTIFICATION, "deleteSubscriptions", req, JsonNode.class);
    }

    @Override
    public GetIpRegionCodeResp getIpRegionCode(String url) throws URISyntaxException, IOException, CloudException {
        return PlatformCloudV2ApiUtil.tryRequest(this.platformCloudV2Api, url, "/api/v2/internal/account/", "getIpRegionCode", this.objectMapper.createObjectNode(), GetIpRegionCodeResp.class);
    }
}

