/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.entity.requestwithtoken;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LaunchDeviceShareReq {
    @PII(strategy=PIIMaskStrategy.HASH)
    private String token;
    private List<ShareInfo> shareList;

    public static LaunchDeviceShareReqBuilder builder() {
        return new LaunchDeviceShareReqBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public List<ShareInfo> getShareList() {
        return this.shareList;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setShareList(List<ShareInfo> shareList) {
        this.shareList = shareList;
    }

    public LaunchDeviceShareReq() {
    }

    public LaunchDeviceShareReq(String token, List<ShareInfo> shareList) {
        this.token = token;
        this.shareList = shareList;
    }

    public static class LaunchDeviceShareReqBuilder {
        private String token;
        private List<ShareInfo> shareList;

        LaunchDeviceShareReqBuilder() {
        }

        public LaunchDeviceShareReqBuilder token(String token) {
            this.token = token;
            return this;
        }

        public LaunchDeviceShareReqBuilder shareList(List<ShareInfo> shareList) {
            this.shareList = shareList;
            return this;
        }

        public LaunchDeviceShareReq build() {
            return new LaunchDeviceShareReq(this.token, this.shareList);
        }

        public String toString() {
            return "LaunchDeviceShareReq.LaunchDeviceShareReqBuilder(token=" + this.token + ", shareList=" + this.shareList + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ShareInfo {
        @PII(strategy=PIIMaskStrategy.ENCRYPT)
        private String deviceId;
        @PII(strategy=PIIMaskStrategy.ENCRYPT)
        private String subDeviceId;
        @PII(strategy=PIIMaskStrategy.HASH)
        private String sharerUserName;
        private Integer shareExpires;
        private String appCategory;

        public static ShareInfoBuilder builder() {
            return new ShareInfoBuilder();
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getSubDeviceId() {
            return this.subDeviceId;
        }

        public String getSharerUserName() {
            return this.sharerUserName;
        }

        public Integer getShareExpires() {
            return this.shareExpires;
        }

        public String getAppCategory() {
            return this.appCategory;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public void setSubDeviceId(String subDeviceId) {
            this.subDeviceId = subDeviceId;
        }

        public void setSharerUserName(String sharerUserName) {
            this.sharerUserName = sharerUserName;
        }

        public void setShareExpires(Integer shareExpires) {
            this.shareExpires = shareExpires;
        }

        public void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        public ShareInfo(String deviceId, String subDeviceId, String sharerUserName, Integer shareExpires, String appCategory) {
            this.deviceId = deviceId;
            this.subDeviceId = subDeviceId;
            this.sharerUserName = sharerUserName;
            this.shareExpires = shareExpires;
            this.appCategory = appCategory;
        }

        public ShareInfo() {
        }

        public static class ShareInfoBuilder {
            private String deviceId;
            private String subDeviceId;
            private String sharerUserName;
            private Integer shareExpires;
            private String appCategory;

            ShareInfoBuilder() {
            }

            public ShareInfoBuilder deviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public ShareInfoBuilder subDeviceId(String subDeviceId) {
                this.subDeviceId = subDeviceId;
                return this;
            }

            public ShareInfoBuilder sharerUserName(String sharerUserName) {
                this.sharerUserName = sharerUserName;
                return this;
            }

            public ShareInfoBuilder shareExpires(Integer shareExpires) {
                this.shareExpires = shareExpires;
                return this;
            }

            public ShareInfoBuilder appCategory(String appCategory) {
                this.appCategory = appCategory;
                return this;
            }

            public ShareInfo build() {
                return new ShareInfo(this.deviceId, this.subDeviceId, this.sharerUserName, this.shareExpires, this.appCategory);
            }

            public String toString() {
                return "LaunchDeviceShareReq.ShareInfo.ShareInfoBuilder(deviceId=" + this.deviceId + ", subDeviceId=" + this.subDeviceId + ", sharerUserName=" + this.sharerUserName + ", shareExpires=" + this.shareExpires + ", appCategory=" + this.appCategory + ")";
            }
        }
    }
}

