/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.entity.request;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import java.util.List;

public class SendEmailReq {
    private String fromAddress;
    private String nickname;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String toAddress;
    private String subject;
    private String content;
    private List<Attachment> attachment;

    SendEmailReq(String fromAddress, String nickname, String toAddress, String subject, String content, List<Attachment> attachment) {
        this.fromAddress = fromAddress;
        this.nickname = nickname;
        this.toAddress = toAddress;
        this.subject = subject;
        this.content = content;
        this.attachment = attachment;
    }

    public static SendEmailReqBuilder builder() {
        return new SendEmailReqBuilder();
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAttachment(List<Attachment> attachment) {
        this.attachment = attachment;
    }

    public static class SendEmailReqBuilder {
        private String fromAddress;
        private String nickname;
        private String toAddress;
        private String subject;
        private String content;
        private List<Attachment> attachment;

        SendEmailReqBuilder() {
        }

        public SendEmailReqBuilder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public SendEmailReqBuilder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public SendEmailReqBuilder toAddress(String toAddress) {
            this.toAddress = toAddress;
            return this;
        }

        public SendEmailReqBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public SendEmailReqBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SendEmailReqBuilder attachment(List<Attachment> attachment) {
            this.attachment = attachment;
            return this;
        }

        public SendEmailReq build() {
            return new SendEmailReq(this.fromAddress, this.nickname, this.toAddress, this.subject, this.content, this.attachment);
        }

        public String toString() {
            return "SendEmailReq.SendEmailReqBuilder(fromAddress=" + this.fromAddress + ", nickname=" + this.nickname + ", toAddress=" + this.toAddress + ", subject=" + this.subject + ", content=" + this.content + ", attachment=" + this.attachment + ")";
        }
    }

    public static class Attachment {
        @PII(strategy=PIIMaskStrategy.MASK)
        private String data;
        private String name;

        public static AttachmentBuilder builder() {
            return new AttachmentBuilder();
        }

        public String getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Attachment(String data, String name) {
            this.data = data;
            this.name = name;
        }

        public Attachment() {
        }

        public static class AttachmentBuilder {
            private String data;
            private String name;

            AttachmentBuilder() {
            }

            public AttachmentBuilder data(String data) {
                this.data = data;
                return this;
            }

            public AttachmentBuilder name(String name) {
                this.name = name;
                return this;
            }

            public Attachment build() {
                return new Attachment(this.data, this.name);
            }

            public String toString() {
                return "SendEmailReq.Attachment.AttachmentBuilder(data=" + this.data + ", name=" + this.name + ")";
            }
        }
    }
}

