/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.entity.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EnableMFAReq {
    @PII(strategy=PIIMaskStrategy.HASH)
    private String cloudUserName;
    @PII(strategy=PIIMaskStrategy.MASK)
    private String cloudPassword;
    private String appType;
    private String appVersion;
    private List<Integer> enabledMFATypes;
    private String code;
    private Boolean terminalBindEnabled;
    private TerminalBindParams terminalBindParams;

    public static EnableMFAReqBuilder builder() {
        return new EnableMFAReqBuilder();
    }

    public String getCloudUserName() {
        return this.cloudUserName;
    }

    public String getCloudPassword() {
        return this.cloudPassword;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public List<Integer> getEnabledMFATypes() {
        return this.enabledMFATypes;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getTerminalBindEnabled() {
        return this.terminalBindEnabled;
    }

    public TerminalBindParams getTerminalBindParams() {
        return this.terminalBindParams;
    }

    public void setCloudUserName(String cloudUserName) {
        this.cloudUserName = cloudUserName;
    }

    public void setCloudPassword(String cloudPassword) {
        this.cloudPassword = cloudPassword;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setEnabledMFATypes(List<Integer> enabledMFATypes) {
        this.enabledMFATypes = enabledMFATypes;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTerminalBindEnabled(Boolean terminalBindEnabled) {
        this.terminalBindEnabled = terminalBindEnabled;
    }

    public void setTerminalBindParams(TerminalBindParams terminalBindParams) {
        this.terminalBindParams = terminalBindParams;
    }

    public EnableMFAReq() {
    }

    public EnableMFAReq(String cloudUserName, String cloudPassword, String appType, String appVersion, List<Integer> enabledMFATypes, String code, Boolean terminalBindEnabled, TerminalBindParams terminalBindParams) {
        this.cloudUserName = cloudUserName;
        this.cloudPassword = cloudPassword;
        this.appType = appType;
        this.appVersion = appVersion;
        this.enabledMFATypes = enabledMFATypes;
        this.code = code;
        this.terminalBindEnabled = terminalBindEnabled;
        this.terminalBindParams = terminalBindParams;
    }

    public static class EnableMFAReqBuilder {
        private String cloudUserName;
        private String cloudPassword;
        private String appType;
        private String appVersion;
        private List<Integer> enabledMFATypes;
        private String code;
        private Boolean terminalBindEnabled;
        private TerminalBindParams terminalBindParams;

        EnableMFAReqBuilder() {
        }

        public EnableMFAReqBuilder cloudUserName(String cloudUserName) {
            this.cloudUserName = cloudUserName;
            return this;
        }

        public EnableMFAReqBuilder cloudPassword(String cloudPassword) {
            this.cloudPassword = cloudPassword;
            return this;
        }

        public EnableMFAReqBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public EnableMFAReqBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public EnableMFAReqBuilder enabledMFATypes(List<Integer> enabledMFATypes) {
            this.enabledMFATypes = enabledMFATypes;
            return this;
        }

        public EnableMFAReqBuilder code(String code) {
            this.code = code;
            return this;
        }

        public EnableMFAReqBuilder terminalBindEnabled(Boolean terminalBindEnabled) {
            this.terminalBindEnabled = terminalBindEnabled;
            return this;
        }

        public EnableMFAReqBuilder terminalBindParams(TerminalBindParams terminalBindParams) {
            this.terminalBindParams = terminalBindParams;
            return this;
        }

        public EnableMFAReq build() {
            return new EnableMFAReq(this.cloudUserName, this.cloudPassword, this.appType, this.appVersion, this.enabledMFATypes, this.code, this.terminalBindEnabled, this.terminalBindParams);
        }

        public String toString() {
            return "EnableMFAReq.EnableMFAReqBuilder(cloudUserName=" + this.cloudUserName + ", cloudPassword=" + this.cloudPassword + ", appType=" + this.appType + ", appVersion=" + this.appVersion + ", enabledMFATypes=" + this.enabledMFATypes + ", code=" + this.code + ", terminalBindEnabled=" + this.terminalBindEnabled + ", terminalBindParams=" + this.terminalBindParams + ")";
        }
    }

    public static class TerminalBindParams {
        private String terminalUUID;
        private String terminalName;
        private String terminalMeta;
        private List<String> trustedTerminalList;

        TerminalBindParams(String terminalUUID, String terminalName, String terminalMeta, List<String> trustedTerminalList) {
            this.terminalUUID = terminalUUID;
            this.terminalName = terminalName;
            this.terminalMeta = terminalMeta;
            this.trustedTerminalList = trustedTerminalList;
        }

        public static TerminalBindParamsBuilder builder() {
            return new TerminalBindParamsBuilder();
        }

        public String getTerminalUUID() {
            return this.terminalUUID;
        }

        public String getTerminalName() {
            return this.terminalName;
        }

        public String getTerminalMeta() {
            return this.terminalMeta;
        }

        public List<String> getTrustedTerminalList() {
            return this.trustedTerminalList;
        }

        public void setTerminalUUID(String terminalUUID) {
            this.terminalUUID = terminalUUID;
        }

        public void setTerminalName(String terminalName) {
            this.terminalName = terminalName;
        }

        public void setTerminalMeta(String terminalMeta) {
            this.terminalMeta = terminalMeta;
        }

        public void setTrustedTerminalList(List<String> trustedTerminalList) {
            this.trustedTerminalList = trustedTerminalList;
        }

        public static class TerminalBindParamsBuilder {
            private String terminalUUID;
            private String terminalName;
            private String terminalMeta;
            private List<String> trustedTerminalList;

            TerminalBindParamsBuilder() {
            }

            public TerminalBindParamsBuilder terminalUUID(String terminalUUID) {
                this.terminalUUID = terminalUUID;
                return this;
            }

            public TerminalBindParamsBuilder terminalName(String terminalName) {
                this.terminalName = terminalName;
                return this;
            }

            public TerminalBindParamsBuilder terminalMeta(String terminalMeta) {
                this.terminalMeta = terminalMeta;
                return this;
            }

            public TerminalBindParamsBuilder trustedTerminalList(List<String> trustedTerminalList) {
                this.trustedTerminalList = trustedTerminalList;
                return this;
            }

            public TerminalBindParams build() {
                return new TerminalBindParams(this.terminalUUID, this.terminalName, this.terminalMeta, this.trustedTerminalList);
            }

            public String toString() {
                return "EnableMFAReq.TerminalBindParams.TerminalBindParamsBuilder(terminalUUID=" + this.terminalUUID + ", terminalName=" + this.terminalName + ", terminalMeta=" + this.terminalMeta + ", trustedTerminalList=" + this.trustedTerminalList + ")";
            }
        }
    }
}

