/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2.entity.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;

public class DisableMFAReq {
    @PII(strategy=PIIMaskStrategy.HASH)
    private String cloudUserName;
    @PII(strategy=PIIMaskStrategy.MASK)
    private String cloudPassword;
    private String appType;
    @JsonProperty(value="MFAType")
    private Integer mfaType;
    @JsonProperty(value="MFAParams")
    private MFAParams params;

    public static DisableMFAReqBuilder builder() {
        return new DisableMFAReqBuilder();
    }

    public String getCloudUserName() {
        return this.cloudUserName;
    }

    public String getCloudPassword() {
        return this.cloudPassword;
    }

    public String getAppType() {
        return this.appType;
    }

    public Integer getMfaType() {
        return this.mfaType;
    }

    public MFAParams getParams() {
        return this.params;
    }

    public void setCloudUserName(String cloudUserName) {
        this.cloudUserName = cloudUserName;
    }

    public void setCloudPassword(String cloudPassword) {
        this.cloudPassword = cloudPassword;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public void setMfaType(Integer mfaType) {
        this.mfaType = mfaType;
    }

    public void setParams(MFAParams params) {
        this.params = params;
    }

    public DisableMFAReq() {
    }

    public DisableMFAReq(String cloudUserName, String cloudPassword, String appType, Integer mfaType, MFAParams params) {
        this.cloudUserName = cloudUserName;
        this.cloudPassword = cloudPassword;
        this.appType = appType;
        this.mfaType = mfaType;
        this.params = params;
    }

    public static class DisableMFAReqBuilder {
        private String cloudUserName;
        private String cloudPassword;
        private String appType;
        private Integer mfaType;
        private MFAParams params;

        DisableMFAReqBuilder() {
        }

        public DisableMFAReqBuilder cloudUserName(String cloudUserName) {
            this.cloudUserName = cloudUserName;
            return this;
        }

        public DisableMFAReqBuilder cloudPassword(String cloudPassword) {
            this.cloudPassword = cloudPassword;
            return this;
        }

        public DisableMFAReqBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public DisableMFAReqBuilder mfaType(Integer mfaType) {
            this.mfaType = mfaType;
            return this;
        }

        public DisableMFAReqBuilder params(MFAParams params) {
            this.params = params;
            return this;
        }

        public DisableMFAReq build() {
            return new DisableMFAReq(this.cloudUserName, this.cloudPassword, this.appType, this.mfaType, this.params);
        }

        public String toString() {
            return "DisableMFAReq.DisableMFAReqBuilder(cloudUserName=" + this.cloudUserName + ", cloudPassword=" + this.cloudPassword + ", appType=" + this.appType + ", mfaType=" + this.mfaType + ", params=" + this.params + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MFAParams {
        private String terminalUUID;
        private String code;

        public static MFAParams constructTerminalUUIDParam(String terminalUUID) {
            MFAParams params = new MFAParams();
            params.setTerminalUUID(terminalUUID);
            return params;
        }

        public static MFAParams constructCodeParam(String code) {
            MFAParams params = new MFAParams();
            params.setTerminalUUID(code);
            return params;
        }

        public String getTerminalUUID() {
            return this.terminalUUID;
        }

        public String getCode() {
            return this.code;
        }

        public void setTerminalUUID(String terminalUUID) {
            this.terminalUUID = terminalUUID;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }
}

