/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2;

import com.tplink.nbu.common.cloudv2.PlatformCloudV2Api;
import com.tplink.nbu.common.cloudv2.constant.Brand;
import com.tplink.nbu.common.cloudv2.entity.WrapPlatformCloudRequestPayload;
import com.tplink.nbu.common.exception.CloudException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformCloudV2ApiUtil {
    private static final Logger log = LoggerFactory.getLogger(PlatformCloudV2ApiUtil.class);

    private PlatformCloudV2ApiUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static HttpPost constructSpecificRequest(String url, String path, Brand brand) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url).setPath(path);
        if (brand != null) {
            uriBuilder.addParameter("brand", brand.getBrandStr());
        }
        URI uri = uriBuilder.build();
        log.trace("uri : {}", (Object)uri);
        return new HttpPost(uri);
    }

    public static <T> T tryRequest(PlatformCloudV2Api v2Api, String appServerUrl, String path, String methodName, Object req, Class<T> responseCl) throws URISyntaxException, IOException, CloudException {
        return v2Api.request((HttpEntityEnclosingRequestBase)PlatformCloudV2ApiUtil.constructSpecificRequest(appServerUrl, path, null), new WrapPlatformCloudRequestPayload(methodName, req), responseCl);
    }

    public static <T> T tryRequest(PlatformCloudV2Api v2Api, String appServerUrl, String path, String methodName, Brand brand, Object req, Class<T> responseCl) throws URISyntaxException, IOException, CloudException {
        return v2Api.request((HttpEntityEnclosingRequestBase)PlatformCloudV2ApiUtil.constructSpecificRequest(appServerUrl, path, brand), new WrapPlatformCloudRequestPayload(methodName, req), responseCl);
    }
}

