/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloudv2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.nbu.common.cloudv2.DeserializeCallback;
import com.tplink.nbu.common.cloudv2.PlatformCloudV2Api;
import com.tplink.nbu.common.cloudv2.entity.PlatformCloudRequestPayload;
import com.tplink.nbu.common.cloudv2.entity.PlatformCloudResponsePayload;
import com.tplink.nbu.common.cloudv2.security.AuthenticateManage;
import com.tplink.nbu.common.cloudv2.security.AuthenticateManageImpl;
import com.tplink.nbu.common.cloudv2.security.AuthenticatedRequest;
import com.tplink.nbu.common.cloudv2.security.PlatformCloudKeyConfig;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.global.CustomObjectMapper;
import com.tplink.nbu.common.global.PIIStrategyMap;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.httpclient.handler.PIILogHandler;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.httpclient.request.async.AsyncHttpClient;
import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.SyncResponseHandler;
import com.tplink.nbu.common.httpclient.response.sync.impl.SimpleSyncResponseHandlerImpl;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.nbu.common.pii.utils.PIIStrategyUtil;
import com.tplink.nbu.common.utils.JacksonUtil;
import com.tplink.nbu.common.utils.ReflectUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformCloudV2ApiImpl
implements PlatformCloudV2Api {
    private static final Logger log = LoggerFactory.getLogger(PlatformCloudV2ApiImpl.class);
    private static ObjectMapper objectMapper = new CustomObjectMapper();
    private HttpClientMgmt httpClientMgmt;
    private AuthenticateManage authenticateManage;
    private RequestConfig.Builder requestConfigBuilder;
    private final PIILogHandler defaultLogHandler = pii -> {
        if (PIIStrategyUtil.isInitialized()) {
            return PIIJacksonUtil.parseToStr((Object)pii);
        }
        return PIIJacksonUtil.maskPIIStr((String)this.parseToStr(pii), PIIStrategyMap.DEFAULT_V2_INTERNAL_STRATEGY_MAP);
    };
    private HttpRequestHandler defaultRequestHandler = new HttpRequestHandler(){

        @Override
        public HttpUriRequest protocol(HttpUriRequest request) {
            return request;
        }

        @Override
        public String url(String oldUrl) {
            return oldUrl;
        }
    };

    public PlatformCloudV2ApiImpl(HttpClientMgmt httpClientMgmt, AuthenticateManage authenticateManage) {
        this.httpClientMgmt = httpClientMgmt;
        this.authenticateManage = authenticateManage;
    }

    public PlatformCloudV2ApiImpl(HttpClientMgmt httpClientMgmt, PlatformCloudKeyConfig keyConfig) {
        this(httpClientMgmt, new AuthenticateManageImpl(keyConfig));
    }

    @Override
    public void requestAsync(HttpEntityEnclosingRequestBase request, String payload, FutureCallback<HttpResponse> callback) throws IOException {
        this.logRequest(request, true);
        request.setEntity((HttpEntity)new StringEntity(payload, Charsets.UTF_8));
        this.setRequestConfig(request);
        AuthenticatedRequest basicRequestInfo = this.constructBasicInfo(request, payload);
        this.authenticateManage.configRequest((HttpRequest)request, basicRequestInfo);
        AsyncHttpClient async = this.httpClientMgmt.async();
        async.execute(this.defaultRequestHandler.protocol((HttpUriRequest)request), callback);
    }

    @Override
    public void request(HttpEntityEnclosingRequestBase request, String payload, SyncResponseHandler handler) throws IOException {
        this.logRequest(request, false);
        request.setEntity((HttpEntity)new StringEntity(payload, Charsets.UTF_8));
        this.setRequestConfig(request);
        AuthenticatedRequest basicRequestInfo = this.constructBasicInfo(request, payload);
        this.authenticateManage.configRequest((HttpRequest)request, basicRequestInfo);
        SyncHttpClient sync = this.httpClientMgmt.sync();
        sync.execute(this.defaultRequestHandler.protocol((HttpUriRequest)request), handler);
    }

    @Override
    public <T> void requestAsync(HttpEntityEnclosingRequestBase request, PlatformCloudRequestPayload payload, DeserializeCallback<T> callback) throws IOException {
        String strPayload = this.parseToStr(payload.getParams());
        try {
            URI uri = this.constructWithMethod(request.getURI(), payload.getMethod());
            request.setURI(uri);
            this.requestAsync(request, strPayload, new WrapFutureCallback<T>(callback, this.defaultLogHandler.logPII(payload.getParams())));
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
        }
    }

    @Override
    public <T> T request(HttpEntityEnclosingRequestBase request, PlatformCloudRequestPayload payload, Class<T> cl) throws IOException, CloudException {
        try {
            URI uri = this.constructWithMethod(request.getURI(), payload.getMethod());
            request.setURI(uri);
            String strPayload = this.parseToStr(payload.getParams());
            SimpleSyncResponseHandlerImpl simpleSyncResponseHandler = new SimpleSyncResponseHandlerImpl();
            this.request(request, strPayload, simpleSyncResponseHandler);
            String reqLogStr = this.defaultLogHandler.logPII(payload.getParams());
            this.logFail(simpleSyncResponseHandler, reqLogStr);
            PlatformCloudV2ApiImpl.checkHttpStatus(simpleSyncResponseHandler.getStatusCode(), reqLogStr);
            String content = simpleSyncResponseHandler.getContent();
            return PlatformCloudV2ApiImpl.analyzeResponse(reqLogStr, content, cl);
        }
        catch (URISyntaxException e) {
            this.errorInUri(e);
            return null;
        }
    }

    private void logFail(SimpleSyncResponseHandlerImpl syncResponseHandler, String reqLogStr) {
        if (syncResponseHandler.getStatusCode() != 200) {
            log.warn("Error in response, statusCode = {}, response headers = {}, response body = {}, reqLogStr={}", new Object[]{syncResponseHandler.getStatusCode(), syncResponseHandler.getHeaders(), syncResponseHandler.getContent(), reqLogStr});
        }
    }

    @Override
    public void setBeforeRequest(HttpRequestHandler requestHandler) {
        this.defaultRequestHandler = requestHandler;
    }

    @Override
    public void setTimeout(int connectTimeoutMs, int poolTimeoutMs, int httpTimeoutMs) {
        this.requestConfigBuilder = RequestConfig.custom();
        if (httpTimeoutMs > 0) {
            this.requestConfigBuilder.setSocketTimeout(httpTimeoutMs);
        }
        if (connectTimeoutMs > 0) {
            this.requestConfigBuilder.setConnectTimeout(connectTimeoutMs);
        }
        if (poolTimeoutMs > 0) {
            this.requestConfigBuilder.setConnectionRequestTimeout(poolTimeoutMs);
        }
    }

    private void setRequestConfig(HttpEntityEnclosingRequestBase request) {
        if (this.requestConfigBuilder != null) {
            request.setConfig(this.requestConfigBuilder.build());
        }
    }

    private void logRequest(HttpEntityEnclosingRequestBase request, boolean async) {
        log.debug("platform cloud v2 request : path({}), async({})", (Object)request.getURI().toString(), (Object)async);
    }

    private String parseToStr(Object payload) {
        return JacksonUtil.parseToStr((Object)payload);
    }

    private AuthenticatedRequest constructBasicInfo(HttpEntityEnclosingRequestBase request, String payload) {
        return AuthenticatedRequest.builder().path(request.getURI().getPath()).payload(payload).build();
    }

    private static <T> T analyzeResponse(String req, String response, Class<T> cl) throws IOException, CloudException {
        log.debug("get response : {}", (Object)response);
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(PlatformCloudResponsePayload.class, new Class[]{cl});
        PlatformCloudResponsePayload value = (PlatformCloudResponsePayload)objectMapper.readValue(response, javaType);
        Integer errorCode = value.getErrorCode();
        if (errorCode != 0) {
            throw new CloudException(200, req, errorCode, value.getMsg());
        }
        return value.getResult();
    }

    private static void checkHttpStatus(int statusCode, String req) throws CloudException {
        if (statusCode != 200) {
            throw new CloudException(statusCode, req);
        }
    }

    private URI constructWithMethod(URI uri, String method) throws URISyntaxException {
        String requestUri = new URIBuilder(uri.toString()).setPath(uri.getPath() + method).build().toString();
        return new URIBuilder(this.defaultRequestHandler.url(requestUri)).build();
    }

    private void errorInUri(URISyntaxException e) {
        log.error("error in construct uri", (Throwable)e);
        throw new IllegalArgumentException("error in construct uri");
    }

    class WrapFutureCallback<T>
    implements FutureCallback<HttpResponse> {
        private DeserializeCallback<T> callback;
        private String reqPayload;

        WrapFutureCallback(DeserializeCallback<T> callback, String reqPayload) {
            this.callback = callback;
            this.reqPayload = reqPayload;
        }

        public void completed(HttpResponse result) {
            log.debug("async request completed : {}", (Object)this.reqPayload);
            try {
                PlatformCloudV2ApiImpl.checkHttpStatus(result.getStatusLine().getStatusCode(), this.reqPayload);
                InputStream inputStream = result.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                String data = br.lines().collect(Collectors.joining("\n"));
                this.callback.completed(PlatformCloudV2ApiImpl.analyzeResponse(this.reqPayload, data, ReflectUtil.getGenericType(this.callback)));
            }
            catch (Exception e) {
                this.callback.failed(e);
            }
        }

        public void failed(Exception ex) {
            this.callback.failed(ex);
        }

        public void cancelled() {
            this.callback.cancelled();
        }
    }
}

