/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.monitor.impl;

import com.tplink.nbu.common.cloud.monitor.RegionUrlMonitor;
import com.tplink.nbu.common.cloud.monitor.TpCloudUrlDO;
import com.tplink.nbu.common.httpclient.request.HttpRequestBuilder;
import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.impl.SimpleSyncResponseHandlerImpl;
import com.tplink.nbu.common.utils.CollectionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RegionUrlMonitorImpl
implements RegionUrlMonitor {
    private static final Logger log = LoggerFactory.getLogger(RegionUrlMonitorImpl.class);
    private SyncHttpClient syncHttpClient;
    private List<TpCloudUrlDO> tpCloudUrlDOs;
    private final Map<String, URI> internalUrlMap;
    private final Map<String, URI> projectHostMap;
    private final Set<String> unreachableInternalUrlSet;
    private MonitorThread monitorThread;

    public RegionUrlMonitorImpl(SyncHttpClient syncHttpClient, List<TpCloudUrlDO> tpCloudUrlDOs) {
        log.warn("RegionUrlMonitor is Deprecated, it will be removed in future.");
        this.syncHttpClient = syncHttpClient;
        this.tpCloudUrlDOs = tpCloudUrlDOs == null ? new ArrayList() : tpCloudUrlDOs;
        this.internalUrlMap = new HashMap<String, URI>();
        this.projectHostMap = new HashMap<String, URI>();
        this.unreachableInternalUrlSet = new HashSet<String>();
        this.init();
    }

    private void init() {
        log.trace("Init RegionUrlMonitor");
        try {
            for (TpCloudUrlDO tpCloudUrlDO : this.tpCloudUrlDOs) {
                for (String projectHostname : tpCloudUrlDO.getProjectHostnames()) {
                    List<String> serverUrls = tpCloudUrlDO.getServerUrls();
                    if (CollectionUtil.isEmpty(serverUrls)) continue;
                    this.projectHostMap.put(projectHostname, this.getURIByUrl(serverUrls.get(0)));
                }
                for (String serverUrl : tpCloudUrlDO.getServerUrls()) {
                    URI internalURI = this.getURIByUrl(tpCloudUrlDO.getInternalServerUrl());
                    this.internalUrlMap.put(this.getURIByUrl(serverUrl).getHost(), internalURI);
                }
            }
        }
        catch (URISyntaxException e) {
            log.error(e.toString(), (Throwable)e);
        }
        this.monitorThread = new MonitorThread();
        this.monitorThread.start();
    }

    @Override
    public void destroy() {
        if (null != this.monitorThread) {
            this.monitorThread.interrupt();
        }
    }

    private boolean isReachable(String url) {
        if (url == null || url.equals("")) {
            return false;
        }
        HttpUriRequest request = HttpRequestBuilder.create(url).get().connectTimeoutMs(500).socketTimeoutMs(500).build();
        SimpleSyncResponseHandlerImpl responseHandler = new SimpleSyncResponseHandlerImpl();
        try {
            this.syncHttpClient.execute(request, responseHandler);
        }
        catch (Exception e) {
            log.debug("Check {} failed ({})", (Object)url, (Object)e.toString());
            return false;
        }
        int statusCode = responseHandler.getStatusCode();
        if (200 != statusCode) {
            log.warn("Check {} failed, status code is {}", (Object)url, (Object)String.valueOf(statusCode));
            return false;
        }
        return true;
    }

    private URI getURIByUrl(String url) throws URISyntaxException {
        URIBuilder tmp = new URIBuilder(url);
        return new URIBuilder().setScheme(tmp.getScheme()).setHost(tmp.getHost()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnreachableUrl(String url) {
        for (Map.Entry<String, URI> entry : this.internalUrlMap.entrySet()) {
            String originUrl = entry.getValue().toString();
            if (!url.contains(originUrl)) continue;
            Set<String> set = this.unreachableInternalUrlSet;
            synchronized (set) {
                if (!this.unreachableInternalUrlSet.contains(originUrl)) {
                    log.warn("Add {} -> {} into 'unreachableInternalUrlSet'", (Object)url, (Object)originUrl);
                    this.unreachableInternalUrlSet.add(originUrl);
                    this.unreachableInternalUrlSet.notifyAll();
                }
            }
            return;
        }
    }

    @Override
    public String getInternalUrl(String url) {
        try {
            URI internalUri;
            URIBuilder uriBuilder = new URIBuilder(url);
            String host = uriBuilder.getHost();
            if (this.internalUrlMap.containsKey(host) && !this.unreachableInternalUrlSet.contains((internalUri = this.internalUrlMap.get(host)).toString())) {
                log.trace("Get {} -> {}", (Object)host, (Object)internalUri);
                return uriBuilder.setScheme(internalUri.getScheme()).setHost(internalUri.getHost()).build().toString();
            }
        }
        catch (URISyntaxException e) {
            log.error("Invalid url {}", (Object)url, (Object)e);
            return url;
        }
        return url;
    }

    @Override
    public String getInternalUrl(String url, String projectHostname) {
        if (projectHostname == null) {
            return this.getInternalUrl(url);
        }
        if (this.projectHostMap.containsKey(projectHostname)) {
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                URI serverUri = this.projectHostMap.get(projectHostname);
                URI internalUri = this.internalUrlMap.get(serverUri.getHost());
                if (null != internalUri && !this.unreachableInternalUrlSet.contains(internalUri.toString())) {
                    log.trace("Get project {} -> {}", (Object)projectHostname, (Object)internalUri);
                    return uriBuilder.setScheme(internalUri.getScheme()).setHost(internalUri.getHost()).build().toString();
                }
                return uriBuilder.setScheme(serverUri.getScheme()).setHost(serverUri.getHost()).build().toString();
            }
            catch (URISyntaxException e) {
                log.error("Invalid url {}", (Object)url, (Object)e);
            }
        }
        log.warn("Cannot find host {}. Use default url {}.", (Object)projectHostname, (Object)url);
        return this.getInternalUrl(url);
    }

    class MonitorThread
    extends Thread {
        LinkedList<String> urlCheckQueue = new LinkedList();
        final int POLL_FOR_STOP_INTERVAL_MS = 5000;
        final int SLEPP_INTERVAL_MS = 60000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            log.trace("MonitorThread {} started", (Object)this.getName());
            try {
                block6: while (true) {
                    MonitorThread.sleep(60000L);
                    this.urlCheckQueue.clear();
                    Object object = RegionUrlMonitorImpl.this.unreachableInternalUrlSet;
                    synchronized (object) {
                        if (0 == RegionUrlMonitorImpl.this.unreachableInternalUrlSet.size()) {
                            RegionUrlMonitorImpl.this.unreachableInternalUrlSet.wait(5000L);
                        }
                        for (String url : RegionUrlMonitorImpl.this.unreachableInternalUrlSet) {
                            this.urlCheckQueue.add(url);
                        }
                    }
                    object = this.urlCheckQueue.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        String url = (String)object.next();
                        if (!RegionUrlMonitorImpl.this.isReachable(url)) continue;
                        log.warn("Remove {} form 'unreachableInternalUrlSet'", (Object)url);
                        Set set = RegionUrlMonitorImpl.this.unreachableInternalUrlSet;
                        synchronized (set) {
                            RegionUrlMonitorImpl.this.unreachableInternalUrlSet.remove(url);
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                log.warn("MonitorThread {} is interrupted", (Object)this.getName());
                log.error("MonitorThread {} stopped", (Object)this.getName());
                return;
            }
        }
    }
}

