/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class Device {
    public static final int FLAG_REGION_UPDATED = 1;
    private String deviceId;
    private String devPk;
    private String devPkId;
    private String deviceType;
    private String oemId;
    private String hwVer;
    private String hwId;
    private int status = -1;
    private String alias;
    private String deviceMac;
    private String deviceModel;
    private String fwVer;
    private String fwId;
    private int fwVerNum = -1;
    private String appServerUrl;
    private String deviceName;
    private int role = -1;
    private boolean sameRegion;
    private Integer regionFlag = 0;
    private String deviceRegion;

    public boolean isOnline() {
        return 1 == this.status;
    }

    public boolean isAdmin() {
        return 0 == this.role;
    }

    public String uniqueKey() {
        return Device.uniqueKey(this.hwId, this.oemId);
    }

    public static String uniqueKey(String hwId, String oemId) {
        return hwId.concat(oemId);
    }

    public static int parseFwVer(String fwVer) {
        if (null == fwVer) {
            return -1;
        }
        String[] versions = (fwVer = fwVer.replaceAll("%20", " ")).split(" |\\.", 4);
        if (versions.length < 3) {
            return -1;
        }
        int master = Integer.parseInt(versions[0]);
        int slave = Integer.parseInt(versions[1]);
        int revision = Integer.parseInt(versions[2]);
        return master * 1000000 + slave * 1000 + revision;
    }

    public static String parseFwVerNum(int fwVerNum) {
        String revision = String.valueOf(fwVerNum % 1000);
        String slave = String.valueOf((fwVerNum /= 1000) % 1000);
        String master = String.valueOf(fwVerNum /= 1000);
        return master + "." + slave + "." + revision;
    }

    public boolean regionUpdated() {
        return this.regionFlag == 1;
    }

    public boolean canSync() {
        return !this.regionUpdated() && !this.isSameRegion();
    }

    public JSONObject toJson() {
        Field[] fields;
        JSONObject jsonObj = new JSONObject();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String name = field.getName();
            String upperName = name.substring(0, 1).toUpperCase().concat(name.substring(1));
            try {
                Method m = this.getClass().getMethod("get" + upperName, new Class[0]);
                jsonObj.put(name, m.invoke((Object)this, new Object[0]));
            }
            catch (Exception e) {
                try {
                    Method m = this.getClass().getMethod("is" + upperName, new Class[0]);
                    jsonObj.put(name, m.invoke((Object)this, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return jsonObj;
    }

    public static Device toObj(JSONObject jsonObj) {
        Method[] methods;
        Device device = new Device();
        for (Method method : methods = device.getClass().getMethods()) {
            String paramName;
            String name = method.getName();
            if (!name.startsWith("set") || !jsonObj.has(paramName = name.substring(3, 4).toLowerCase().concat(name.substring(4)))) continue;
            try {
                method.invoke((Object)device, jsonObj.get(paramName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return device;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDevPk() {
        return this.devPk;
    }

    public String getDevPkId() {
        return this.devPkId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getOemId() {
        return this.oemId;
    }

    public String getHwVer() {
        return this.hwVer;
    }

    public String getHwId() {
        return this.hwId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getFwVer() {
        return this.fwVer;
    }

    public String getFwId() {
        return this.fwId;
    }

    public int getFwVerNum() {
        return this.fwVerNum;
    }

    public String getAppServerUrl() {
        return this.appServerUrl;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getRole() {
        return this.role;
    }

    public boolean isSameRegion() {
        return this.sameRegion;
    }

    public Integer getRegionFlag() {
        return this.regionFlag;
    }

    public String getDeviceRegion() {
        return this.deviceRegion;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setDevPk(String devPk) {
        this.devPk = devPk;
    }

    public void setDevPkId(String devPkId) {
        this.devPkId = devPkId;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setOemId(String oemId) {
        this.oemId = oemId;
    }

    public void setHwVer(String hwVer) {
        this.hwVer = hwVer;
    }

    public void setHwId(String hwId) {
        this.hwId = hwId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public void setFwVer(String fwVer) {
        this.fwVer = fwVer;
    }

    public void setFwId(String fwId) {
        this.fwId = fwId;
    }

    public void setFwVerNum(int fwVerNum) {
        this.fwVerNum = fwVerNum;
    }

    public void setAppServerUrl(String appServerUrl) {
        this.appServerUrl = appServerUrl;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public void setSameRegion(boolean sameRegion) {
        this.sameRegion = sameRegion;
    }

    public void setRegionFlag(Integer regionFlag) {
        this.regionFlag = regionFlag;
    }

    public void setDeviceRegion(String deviceRegion) {
        this.deviceRegion = deviceRegion;
    }

    public String toString() {
        return "Device(deviceId=" + this.getDeviceId() + ", devPk=" + this.getDevPk() + ", devPkId=" + this.getDevPkId() + ", deviceType=" + this.getDeviceType() + ", oemId=" + this.getOemId() + ", hwVer=" + this.getHwVer() + ", hwId=" + this.getHwId() + ", status=" + this.getStatus() + ", alias=" + this.getAlias() + ", deviceMac=" + this.getDeviceMac() + ", deviceModel=" + this.getDeviceModel() + ", fwVer=" + this.getFwVer() + ", fwId=" + this.getFwId() + ", fwVerNum=" + this.getFwVerNum() + ", appServerUrl=" + this.getAppServerUrl() + ", deviceName=" + this.getDeviceName() + ", role=" + this.getRole() + ", sameRegion=" + this.isSameRegion() + ", regionFlag=" + this.getRegionFlag() + ", deviceRegion=" + this.getDeviceRegion() + ")";
    }
}

