/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.entity;

import com.tplink.nbu.common.cloud.api.utils.ResponseParseUtil;
import com.tplink.nbu.common.cloud.entity.AppServerAsyncResponseHandler;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.utils.HttpResponseUtil;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerCommonCallback
implements FutureCallback<HttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(AppServerCommonCallback.class);
    private final String reqJson;
    private final Long reqId;
    private AppServerAsyncResponseHandler handler;

    public void completed(HttpResponse result) {
        int statusCode = HttpResponseUtil.getStatusCode(result);
        String content = HttpResponseUtil.getContent(result);
        JSONObject res = null;
        try {
            res = ResponseParseUtil.parseCloudRes(statusCode, content, this.reqJson);
        }
        catch (CloudException | JSONException e) {
            this.handler.handleException((Exception)e);
        }
        this.handler.releaseRequest(this.reqId);
        this.handler.handleResult(res);
    }

    public void failed(Exception e) {
        this.handler.releaseRequest(this.reqId);
        this.handler.handleException(e);
    }

    public void cancelled() {
        CloudException e = new CloudException(500, this.reqJson);
        this.handler.releaseRequest(this.reqId);
        this.handler.handleException(e);
    }

    public String getReqJson() {
        return this.reqJson;
    }

    public Long getReqId() {
        return this.reqId;
    }

    public AppServerAsyncResponseHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AppServerAsyncResponseHandler handler) {
        this.handler = handler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppServerCommonCallback)) {
            return false;
        }
        AppServerCommonCallback other = (AppServerCommonCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reqJson = this.getReqJson();
        String other$reqJson = other.getReqJson();
        if (this$reqJson == null ? other$reqJson != null : !this$reqJson.equals(other$reqJson)) {
            return false;
        }
        Long this$reqId = this.getReqId();
        Long other$reqId = other.getReqId();
        if (this$reqId == null ? other$reqId != null : !((Object)this$reqId).equals(other$reqId)) {
            return false;
        }
        AppServerAsyncResponseHandler this$handler = this.getHandler();
        AppServerAsyncResponseHandler other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppServerCommonCallback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reqJson = this.getReqJson();
        result = result * 59 + ($reqJson == null ? 43 : $reqJson.hashCode());
        Long $reqId = this.getReqId();
        result = result * 59 + ($reqId == null ? 43 : ((Object)$reqId).hashCode());
        AppServerAsyncResponseHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        return result;
    }

    public String toString() {
        return "AppServerCommonCallback(reqJson=" + this.getReqJson() + ", reqId=" + this.getReqId() + ", handler=" + this.getHandler() + ")";
    }

    public AppServerCommonCallback(String reqJson, Long reqId, AppServerAsyncResponseHandler handler) {
        this.reqJson = reqJson;
        this.reqId = reqId;
        this.handler = handler;
    }
}

