/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.utils;

import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.utils.JSONUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParseUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseParseUtil.class);
    public static final int ERROR_CODE_OK = 0;
    private static final String ERROR_CODE = "error_code";
    private static final String RESULT = "result";
    private static final String MSG = "msg";
    private static final String RESPONSE_DATA = "responseData";

    public static JSONObject parseCloudRes(int statusCode, String content, String reqStr) throws CloudException, JSONException {
        if (200 != statusCode) {
            throw new CloudException(statusCode, reqStr);
        }
        JSONObject res = JSONUtil.convertToJson((String)content);
        log.debug("request is {} | response is {}", (Object)reqStr, (Object)res);
        if (!res.has(ERROR_CODE)) {
            throw new JSONParamMissException(res, ERROR_CODE);
        }
        int errorCode = res.getInt(ERROR_CODE);
        if (0 != errorCode) {
            throw new CloudException(statusCode, reqStr, errorCode, res.optString(MSG));
        }
        return res.optJSONObject(RESULT);
    }

    public static JSONObject parsePassthroughRes(int statusCode, String content, String reqJson) throws CloudException, JSONException {
        JSONObject result = ResponseParseUtil.parseCloudRes(statusCode, content, reqJson);
        return ResponseParseUtil.getPassthroughRes(result);
    }

    public static JSONObject getPassthroughRes(JSONObject result) throws JSONParamMissException {
        if (null == result || !result.has(RESPONSE_DATA)) {
            throw new JSONParamMissException(result, RESPONSE_DATA);
        }
        return result.getJSONObject(RESPONSE_DATA);
    }
}

