/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.impl;

import com.tplink.nbu.common.cloud.api.OAuthServerApi;
import com.tplink.nbu.common.cloud.api.impl.AppServerCommon;
import com.tplink.nbu.common.cloud.entity.AuthCodeRes;
import com.tplink.nbu.common.cloud.entity.OAuthClientInfo;
import com.tplink.nbu.common.cloud.entity.RevokeRes;
import com.tplink.nbu.common.cloud.monitor.RegionUrlMonitor;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.utils.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OAuthServerApiImpl
implements OAuthServerApi {
    private static final String GET_VALID_CLIENT_LIST_PATH = "/oauth2/api/getValidClientList";
    private static final String GET_AUTH_CODE_PATH = "/oauth2/api/getAuthCode";
    private static final String REVOKE_AUTH_PATH = "/oauth2/api/revoke";
    private static final String TOKEN = "token";
    private static final String CLIENT_ID_INTERNAL = "clientIdInternal";
    private static final String AUTH_CODE = "authCode";
    private static final String ERROR_CODE = "error_code";
    private static final String CLIENT_LIST = "clientList";
    private static final String CREATE_AT = "createdAt";
    private static final String SCOPE = "scope";
    private static final String[] CLIENT_INFO_PARAMS = new String[]{"createdAt", "scope", "clientIdInternal"};
    private final AppServerCommon appServerCommon;

    public OAuthServerApiImpl(HttpClientMgmt httpClientMgmt, RegionUrlMonitor regionUrlMonitor) {
        this.appServerCommon = new AppServerCommon(httpClientMgmt, regionUrlMonitor);
    }

    @Override
    public void setBeforeRequest(HttpRequestHandler handler) {
        this.appServerCommon.setBeforeRequest(handler);
    }

    @Override
    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.appServerCommon.setSocketTimeoutMs(socketTimeoutMs);
    }

    @Override
    public List<OAuthClientInfo> getValidClientList(String url, String token) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetValidClientList(token);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(GET_VALID_CLIENT_LIST_PATH), req);
        if (!res.has(CLIENT_LIST)) {
            throw new JSONParamMissException(res, CLIENT_LIST);
        }
        JSONArray clientList = res.getJSONArray(CLIENT_LIST);
        ArrayList<OAuthClientInfo> oAuthClientInfos = new ArrayList<OAuthClientInfo>();
        for (Object obj : clientList) {
            JSONObject client = (JSONObject)obj;
            JSONUtil.validateParams((JSONObject)client, (String[])CLIENT_INFO_PARAMS, (String[])new String[0]);
            oAuthClientInfos.add(new OAuthClientInfo(client.getLong(CREATE_AT), client.getString(SCOPE), client.getString(CLIENT_ID_INTERNAL)));
        }
        return oAuthClientInfos;
    }

    @Override
    public AuthCodeRes getAuthCodeByToken(String url, String token, String clientIdInternal) throws JSONException, CloudException, IOException {
        JSONObject req = this.buildAuthTokenParams(token, clientIdInternal);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(GET_AUTH_CODE_PATH), req);
        if (!res.has(AUTH_CODE)) {
            throw new JSONParamMissException(res, AUTH_CODE);
        }
        return new AuthCodeRes(res.getString(AUTH_CODE));
    }

    @Override
    public RevokeRes revokeToken(String url, String token, String clientIdInternal) throws JSONException, CloudException, IOException {
        JSONObject req = this.buildAuthTokenParams(token, clientIdInternal);
        this.appServerCommon.sendToAppServer(url.concat(REVOKE_AUTH_PATH), req);
        return new RevokeRes(0);
    }

    private JSONObject buildGetValidClientList(String token) {
        JSONObject req = new JSONObject();
        req.put(TOKEN, (Object)token);
        return req;
    }

    private JSONObject buildAuthTokenParams(String token, String clientIdInternal) {
        JSONObject req = new JSONObject();
        req.put(TOKEN, (Object)token);
        req.put(CLIENT_ID_INTERNAL, (Object)clientIdInternal);
        return req;
    }
}

