/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.impl;

import com.tplink.nbu.common.cloud.api.AppServerInternalApi;
import com.tplink.nbu.common.cloud.api.impl.AppServerBase;
import com.tplink.nbu.common.cloud.api.impl.AppServerCommon;
import com.tplink.nbu.common.cloud.entity.AccountInfo;
import com.tplink.nbu.common.cloud.entity.AccountTokenRes;
import com.tplink.nbu.common.cloud.entity.AppServerAsyncResponseHandler;
import com.tplink.nbu.common.cloud.entity.CheckDevTokenRes;
import com.tplink.nbu.common.cloud.entity.Device;
import com.tplink.nbu.common.cloud.entity.DeviceBasicInfo;
import com.tplink.nbu.common.cloud.entity.DeviceBindStatInfo;
import com.tplink.nbu.common.cloud.entity.DeviceFirstOnboardTime;
import com.tplink.nbu.common.cloud.entity.DeviceTokenRegionInfo;
import com.tplink.nbu.common.cloud.entity.DeviceUserInfoRes;
import com.tplink.nbu.common.cloud.entity.DeviceUserRoleRes;
import com.tplink.nbu.common.cloud.entity.PushDeviceMsgReq;
import com.tplink.nbu.common.cloud.entity.PushingInfo;
import com.tplink.nbu.common.cloud.entity.SubAccountEvtInfo;
import com.tplink.nbu.common.cloud.monitor.RegionUrlMonitor;
import com.tplink.nbu.common.cloud.monitor.impl.DefaultRegionUrlMonitor;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.exception.JSONParseException;
import com.tplink.nbu.common.exception.WeakPasswordException;
import com.tplink.nbu.common.global.PIIStrategyMap;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.httpclient.handler.PIILogHandler;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.nbu.common.pii.utils.PIIStrategyUtil;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.nbu.common.utils.JSONUtil;
import com.tplink.nbu.common.utils.JacksonUtil;
import com.tplink.nbu.common.utils.PasswordUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.http.nio.reactor.IOReactorException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerInternalApiImpl
extends AppServerBase
implements AppServerInternalApi {
    private static final Logger log = LoggerFactory.getLogger(AppServerInternalApiImpl.class);
    private static final String INTERNAL = "/internal";
    private static final String IOT = "/iot";
    private static final String ACCOUNT = "/account";
    private static final String ACCOUNT_ID = "accountId";
    private static final String EMAIL = "email";
    private static final String MOBILE = "mobile";
    private static final String VERIFY_URL = "verifyUrl";
    private static final String REGION = "region";
    private static final String USER_LIST = "userList";
    private static final String HW_ID = "hwId";
    private static final String OEM_ID = "oemId";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String FW_VERSION = "fwVersion";
    private static final String FIRST_ONBOARD_TIME = "firstOnboardTime";
    public static final String NICKNAME = "nickname";
    public static final String COUNTRY_CODE = "countryCode";
    private final String[] ACCOUNT_INFO_PARAMS = new String[]{"accountId", "email"};
    private final AppServerCommon appServerCommon;

    public AppServerInternalApiImpl(HttpClientMgmt httpClientMgmt, RegionUrlMonitor regionUrlMonitor) {
        this.appServerCommon = new AppServerCommon(httpClientMgmt, regionUrlMonitor);
        PIILogHandler piiLogHandler = pii -> PIIJacksonUtil.maskPIIStr((String)pii.toString(), PIIStrategyUtil.isInitialized() ? PIIStrategyMap.V1_INTERNAL_STRATEGY_MAP : PIIStrategyMap.DEFAULT_STRATEGY_MAP);
        this.appServerCommon.setPIILogHandler(piiLogHandler);
    }

    public AppServerInternalApiImpl(HttpClientMgmt httpClientMgmt) {
        this(httpClientMgmt, new DefaultRegionUrlMonitor());
    }

    @Override
    public AccountInfo getAccountInfoByToken(String url, String token) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetAccountInfoPayload(token);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), token, req);
        this.appServerCommon.checkResultIsNull(result);
        JSONUtil.validateParams((JSONObject)result, (String[])this.ACCOUNT_INFO_PARAMS, (String[])new String[0]);
        return new AccountInfo(result.optString(EMAIL, null), result.optString(MOBILE, null), result.getString(ACCOUNT_ID), result.optString(NICKNAME, null), result.optString(COUNTRY_CODE, null));
    }

    @Override
    public void verifyToken(String url, String token) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildVerifyTokenPayload(token);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), token, req);
    }

    @Override
    public List<DeviceUserInfoRes> getDeviceUserInfo(String url, String deviceToken, String serviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceUserInfoPayload(deviceToken, serviceId);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(res);
        if (!res.has(USER_LIST)) {
            throw new JSONParamMissException(res, USER_LIST);
        }
        JSONArray userList = res.getJSONArray(USER_LIST);
        String jsonStr = JacksonUtil.parseToStr((Object)userList);
        List deviceUserInfoRes = JacksonUtil.convertToList((String)jsonStr, DeviceUserInfoRes.class);
        if (null == deviceUserInfoRes) {
            throw new JSONParseException(jsonStr);
        }
        return deviceUserInfoRes;
    }

    @Override
    public CheckDevTokenRes checkDeviceToken(String url, String deviceToken, String serviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildCheckDeviceTokenPayload(deviceToken, serviceId);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        String resJsonStr = JacksonUtil.parseToStr((Object)res);
        CheckDevTokenRes checkDevTokenRes = (CheckDevTokenRes)JacksonUtil.convertTo((String)resJsonStr, CheckDevTokenRes.class);
        if (null == checkDevTokenRes) {
            throw new JSONParseException(resJsonStr);
        }
        return checkDevTokenRes;
    }

    @Override
    public DeviceTokenRegionInfo checkDeviceTokenWithId(String url, String deviceToken, String deviceId, String serviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildCheckDeviceTokenWithIdPayload(deviceToken, deviceId, serviceId);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        String appServerUrl = url;
        String region = "unknown";
        if (null != res) {
            if (!res.has(VERIFY_URL)) {
                throw new JSONParamMissException(res, VERIFY_URL);
            }
            appServerUrl = res.getString(VERIFY_URL);
            region = res.has(REGION) ? res.getString(REGION) : region;
        }
        DeviceTokenRegionInfo deviceTokenRegionInfo = new DeviceTokenRegionInfo();
        deviceTokenRegionInfo.setRegion(region);
        deviceTokenRegionInfo.setVerifyUrl(appServerUrl);
        return deviceTokenRegionInfo;
    }

    @Override
    public List<SubAccountEvtInfo> subscribeAccountEvents(String url, List<SubAccountEvtInfo> subscriptions) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildSubscribeAccountEventsPayload(subscriptions);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        JSONArray subscribeEvents = result.optJSONArray("subscribeEvents");
        if (null == subscribeEvents) {
            throw new JSONParamMissException(result, "subscribeEvents");
        }
        return JacksonUtil.convertToList((String)subscribeEvents.toString(), SubAccountEvtInfo.class);
    }

    @Override
    public List<SubAccountEvtInfo> getSubscriptions(String url, List<String> accountIds) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetSubscriptionsPayload(accountIds);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        JSONArray subscribeEvents = result.optJSONArray("subscribeEvents");
        if (null == subscribeEvents) {
            throw new JSONParamMissException(result, "subscribeEvents");
        }
        return JacksonUtil.convertToList((String)subscribeEvents.toString(), SubAccountEvtInfo.class);
    }

    @Override
    public void pushForApps(String url, List<String> cloudUserNames, List<String> appTypes, JSONObject iosMessage, JSONObject androidMessage) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildPushForAppsPayload(cloudUserNames, appTypes, iosMessage, androidMessage);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
    }

    @Override
    public DeviceBasicInfo getDeviceBasicInfo(String url, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceBasicInfo(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        if (!result.has(HW_ID)) {
            throw new JSONParamMissException(result, HW_ID);
        }
        return new DeviceBasicInfo(result.getString(HW_ID), result.optString(OEM_ID), result.getString(DEVICE_TYPE), result.optString(FW_VERSION));
    }

    @Override
    public DeviceFirstOnboardTime getDeviceFirstOnboardTime(String url, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceFirstOnboardTime(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        if (!result.has(FIRST_ONBOARD_TIME)) {
            throw new JSONParamMissException(result, FIRST_ONBOARD_TIME);
        }
        return new DeviceFirstOnboardTime(result.getString(FIRST_ONBOARD_TIME));
    }

    @Override
    public List<DeviceUserInfoRes> getDeviceUserInfoByDeviceId(String url, String deviceId, String ip) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceUserInfoByDeviceIdPayload(deviceId, ip);
        JSONObject res = this.appServerCommon.sendToAppServer(url.concat(INTERNAL).concat(IOT), req);
        this.appServerCommon.checkResultIsNull(res);
        if (!res.has(USER_LIST)) {
            throw new JSONParamMissException(res, USER_LIST);
        }
        JSONArray userList = res.getJSONArray(USER_LIST);
        String jsonStr = userList.toString();
        List deviceUserInfoRes = JacksonUtil.convertToList((String)jsonStr, DeviceUserInfoRes.class);
        if (null == deviceUserInfoRes) {
            throw new JSONParseException(jsonStr);
        }
        return deviceUserInfoRes;
    }

    @Override
    public void getDeviceUserInfoByDeviceIdAsync(String url, String deviceId, String ip, int soTimeoutMs, Long reqId, AppServerAsyncResponseHandler responseHandler) throws IOException {
        JSONObject req = this.buildGetDeviceUserInfoByDeviceIdPayload(deviceId, ip);
        this.appServerCommon.sendToAppServerAsync(url.concat(INTERNAL).concat(IOT), null, req, soTimeoutMs, reqId, responseHandler, null);
    }

    @Override
    public void register(String url, String email, String username, String password) throws CloudException, JSONException, IOException, WeakPasswordException {
        if (PasswordUtil.isWeakPassword((String)password)) {
            throw new WeakPasswordException();
        }
        JSONObject req = this.buildRegisterPayload(email, username, password);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
    }

    @Override
    public void sendEmail(String url, String fromAddress, String nickname, String toAddress, String subject, String content) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildSendEmailPayload(fromAddress, nickname, toAddress, subject, content);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL).concat(ACCOUNT), req);
    }

    @Override
    public void pushForAppsByAccountId(String url, PushingInfo pushingInfo) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildPushForAppsByAccountIdPayload(pushingInfo);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
    }

    @Override
    public void checkBindStatus(String url, String token, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildCheckBindStatusPayload(deviceId);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), token, req);
    }

    @Override
    public DeviceUserRoleRes getDevUserRoleByAccountId(String url, String accountId, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDevUserRoleByAccountId(accountId, deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        String jsonStr = JacksonUtil.parseToStr((Object)result);
        DeviceUserRoleRes response = (DeviceUserRoleRes)JacksonUtil.convertTo((String)jsonStr, DeviceUserRoleRes.class);
        if (null == response) {
            throw new JSONParseException(jsonStr);
        }
        return response;
    }

    @Override
    public AccountTokenRes getAccountToken(String url, String token) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetAccountToken(token);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        String jsonStr = JacksonUtil.parseToStr((Object)result);
        AccountTokenRes response = (AccountTokenRes)JacksonUtil.convertTo((String)jsonStr, AccountTokenRes.class);
        if (null == response) {
            throw new JSONParseException(jsonStr);
        }
        return response;
    }

    @Override
    public Device getDeviceInfo(String url, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceInfoPayload(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(result);
        JSONUtil.validateParams((JSONObject)result, (String[])this.devValidateParams, (String[])new String[]{"isSameRegion", "role", "fwId"});
        Device deviceInfo = this.convertToDevice(result, false);
        deviceInfo.setRegionFlag(1);
        return deviceInfo;
    }

    @Override
    @Deprecated
    public void sendNotification(String url, long ttl, int retryTimes, String deviceId, String msgId, String msgType, long timestamp, Map<String, String> data, String content, String title, Map<String, Object> misc) throws JSONException, CloudException, IOException {
        PushDeviceMsgReq req = PushDeviceMsgReq.builder().ttl(ttl).retryTimes(retryTimes).deviceId(deviceId).msgId(msgId).msgType(msgType).timestamp(timestamp).data(data).content(content).title(title).misc(misc).build();
        this.pushDeviceMsg(url, req);
    }

    @Override
    public DeviceBindStatInfo getDeviceBindStatInfo(String url, String deviceId) throws JSONException, CloudException, IOException {
        JSONObject req = this.buildGetDeviceBindStatInfo(deviceId);
        JSONObject resp = this.appServerCommon.sendToAppServer(url.concat(INTERNAL), req);
        this.appServerCommon.checkResultIsNull(resp);
        return (DeviceBindStatInfo)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)resp), DeviceBindStatInfo.class);
    }

    @Override
    @Deprecated
    public void pushDeviceMsg(String url, long ttl, int retryTimes, String deviceId, String msgId, String msgType, long timestamp, Map<String, String> data, String content, String title) throws JSONException, CloudException, IOException {
        PushDeviceMsgReq req = PushDeviceMsgReq.builder().ttl(ttl).retryTimes(retryTimes).deviceId(deviceId).msgId(msgId).msgType(msgType).timestamp(timestamp).data(data).content(content).title(title).build();
        this.pushDeviceMsg(url, req);
    }

    @Override
    public void pushDeviceMsg(String url, PushDeviceMsgReq req) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildPushDeviceMsg(req);
        this.appServerCommon.sendToAppServer(url.concat(INTERNAL), request);
    }

    @Override
    public void pushDeviceMsgAsync(String url, PushDeviceMsgReq req, int socketTimeoutMs, AppServerAsyncResponseHandler responseHandler) throws IOReactorException {
        JSONObject request = this.buildPushDeviceMsg(req);
        this.appServerCommon.sendToAppServerAsync(url.concat(INTERNAL), null, request, socketTimeoutMs, responseHandler);
    }

    private JSONObject buildGetDeviceBindStatInfo(String deviceId) {
        return new JSONObject().put("method", (Object)"getDeviceBindStatInfo").put("params", (Object)new JSONObject().put("deviceId", (Object)deviceId));
    }

    private JSONObject buildGetDeviceInfoPayload(String deviceId) {
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        JSONObject requestObject = new JSONObject();
        requestObject.put("method", (Object)"getDeviceInfo");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetAccountToken(String token) {
        JSONObject payload = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("token", (Object)token);
        payload.put("method", (Object)"getAccountToken");
        payload.put("params", (Object)params);
        return payload;
    }

    private JSONObject buildGetDevUserRoleByAccountId(String accountId, String deviceId) {
        JSONObject payload = new JSONObject();
        JSONObject params = new JSONObject();
        params.put(ACCOUNT_ID, (Object)accountId);
        params.put("deviceId", (Object)deviceId);
        payload.put("method", (Object)"getDevUserRoleByAccountId");
        payload.put("params", (Object)params);
        return payload;
    }

    private JSONObject buildCheckBindStatusPayload(String deviceId) {
        JSONObject payload = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        payload.put("method", (Object)"checkBindStatus");
        payload.put("params", (Object)params);
        return payload;
    }

    private JSONObject buildGetDeviceUserInfoByDeviceIdPayload(String deviceId, String ip) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        params.put("ip", (Object)ip);
        requestObject.put("method", (Object)"getDeviceUserInfoByDeviceId");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetAccountInfoPayload(String token) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("token", (Object)token);
        requestObject.put("method", (Object)"getAccountInfoByToken");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildVerifyTokenPayload(String token) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        assert (null != token);
        params.put("token", (Object)token);
        requestObject.put("method", (Object)"verifyToken");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceUserInfoPayload(String deviceToken, String serviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceToken", (Object)deviceToken);
        params.put("serviceId", (Object)serviceId);
        requestObject.put("method", (Object)"getDeviceUserInfo");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildCheckDeviceTokenPayload(String deviceToken, String serviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceToken", (Object)deviceToken);
        params.put("serviceId", (Object)serviceId);
        requestObject.put("method", (Object)"checkDeviceToken");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildCheckDeviceTokenWithIdPayload(String deviceToken, String deviceId, String serviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceToken", (Object)deviceToken);
        params.put("serviceId", (Object)serviceId);
        params.put("deviceId", (Object)deviceId);
        requestObject.put("method", (Object)"checkDeviceTokenWithId");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildSubscribeAccountEventsPayload(List<SubAccountEvtInfo> subscriptions) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("subscriptions", (Object)new JSONArray(JacksonUtil.parseToStr(subscriptions)));
        requestObject.put("method", (Object)"subscribeAccountEvents");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetSubscriptionsPayload(List<String> accountIds) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("accountIds", (Object)new JSONArray(JacksonUtil.parseToStr(accountIds)));
        requestObject.put("method", (Object)"getSubscriptions");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildPushForAppsPayload(List<String> cloudUserNames, List<String> appTypes, JSONObject iosMessage, JSONObject androidMessage) {
        if (iosMessage == null && androidMessage == null) {
            throw new NullPointerException("iosMessage and androidMessage cannot both be null.");
        }
        JSONObject payload = new JSONObject();
        if (iosMessage != null) {
            payload.put("ios", (Object)iosMessage);
        }
        if (androidMessage != null) {
            payload.put("android", (Object)androidMessage);
        }
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("cloudUserNames", cloudUserNames);
        params.put("appTypes", appTypes);
        params.put("payload", (Object)payload);
        requestObject.put("method", (Object)"pushForApps");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceBasicInfo(String deviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        requestObject.put("method", (Object)"getDeviceBasicInfo");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceFirstOnboardTime(String deviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        requestObject.put("method", (Object)"getDeviceFirstOnboardTime");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildRegisterPayload(String email, String username, String password) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put(EMAIL, (Object)email);
        params.put("username", (Object)username);
        params.put("password", (Object)password);
        params.put("regTime", (Object)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        requestObject.put("method", (Object)"register");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildSendEmailPayload(String fromAddress, String nickname, String toAddress, String subject, String content) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("fromAddress", (Object)fromAddress);
        params.put(NICKNAME, (Object)nickname);
        params.put("toAddress", (Object)toAddress);
        params.put("subject", (Object)subject);
        params.put("content", (Object)content);
        requestObject.put("method", (Object)"sendEmail");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildPushForAppsByAccountIdPayload(PushingInfo pushingInfo) {
        JSONObject iosMessage = pushingInfo.getIosMessage();
        JSONObject androidMessage = pushingInfo.getAndroidMessage();
        JSONObject androidNotification = pushingInfo.getAndroidNotification();
        if (iosMessage == null && androidMessage == null) {
            throw new NullPointerException("iosMessage and androidMessage cannot both be null.");
        }
        JSONObject payload = new JSONObject();
        if (iosMessage != null) {
            payload.put("ios", (Object)iosMessage);
        }
        if (androidMessage != null) {
            payload.put("android", (Object)androidMessage);
        }
        if (androidNotification != null) {
            payload.put("androidNotification", (Object)androidNotification);
        }
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("accountIds", pushingInfo.getAccountIds());
        params.put("appTypes", pushingInfo.getAppTypes());
        params.put("payload", (Object)payload);
        params.put("timeToLive", pushingInfo.getTimeToLive());
        params.put("retryLimit", pushingInfo.getRetryLimit());
        requestObject.put("method", (Object)"pushForAppsByAccountId");
        requestObject.put("params", (Object)params);
        return requestObject;
    }

    private JSONObject buildPushDeviceMsg(PushDeviceMsgReq req) {
        JSONObject payload = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("timeToLive", (Object)req.getTtl());
        params.put("retryLimit", (Object)req.getRetryTimes());
        params.put("deviceId", (Object)req.getDeviceId());
        params.put("msgId", (Object)req.getMsgId());
        params.put("msgType", (Object)req.getMsgType());
        params.put("time", (Object)req.getTimestamp());
        params.put("msgSubType", (Object)req.getMsgSubType());
        params.put("needPush", (Object)req.getNeedPush());
        if (null != req.getData()) {
            JSONObject jsonData = new JSONObject();
            req.getData().forEach((arg_0, arg_1) -> ((JSONObject)jsonData).put(arg_0, arg_1));
            params.put("data", (Object)jsonData);
        }
        params.put("content", (Object)req.getContent());
        params.put("title", (Object)req.getTitle());
        if (!CollectionUtil.isEmpty(req.getAccountIds())) {
            params.put("accountIds", (Object)new JSONArray(req.getAccountIds()));
        }
        if (null != req.getMisc()) {
            JSONObject jsonMisc = new JSONObject();
            req.getMisc().forEach((arg_0, arg_1) -> ((JSONObject)jsonMisc).put(arg_0, arg_1));
            params.put("misc", (Object)jsonMisc);
        }
        if (!CollectionUtil.isEmpty(req.getAppTypes())) {
            params.put("appTypes", (Object)new JSONArray(req.getAppTypes()));
        }
        if (!CollectionUtil.isEmpty(req.getAuthorizedAccounts())) {
            params.put("authorizedAccounts", (Object)new JSONArray(req.getAuthorizedAccounts()));
        }
        payload.put("method", (Object)"pushDeviceMsg");
        payload.put("params", (Object)params);
        return payload;
    }

    @Override
    public void setBeforeRequest(HttpRequestHandler handler) {
        this.appServerCommon.setBeforeRequest(handler);
    }

    @Override
    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.appServerCommon.setSocketTimeoutMs(socketTimeoutMs);
    }
}

