/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.impl;

import com.tplink.nbu.common.cloud.api.utils.ResponseParseUtil;
import com.tplink.nbu.common.cloud.entity.AppServerAsyncResponseHandler;
import com.tplink.nbu.common.cloud.entity.AppServerCommonCallback;
import com.tplink.nbu.common.cloud.monitor.RegionUrlMonitor;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.global.PIIStrategyMap;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.httpclient.handler.PIILogHandler;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.httpclient.request.HttpRequestBuilder;
import com.tplink.nbu.common.httpclient.request.async.AsyncHttpClient;
import com.tplink.nbu.common.httpclient.request.sync.SyncHttpClient;
import com.tplink.nbu.common.httpclient.response.sync.impl.SimpleSyncResponseHandlerImpl;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.nbu.common.utils.HttpResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.reactor.IOReactorException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerCommon {
    private static final Logger log = LoggerFactory.getLogger(AppServerCommon.class);
    private static final String RESULT = "result";
    private PIILogHandler defaultLogHandler = pii -> PIIJacksonUtil.maskPIIStr((String)pii.toString(), PIIStrategyMap.DEFAULT_STRATEGY_MAP);
    private HttpRequestHandler defaultRequestHandler = new HttpRequestHandler(){

        @Override
        public HttpUriRequest protocol(HttpUriRequest request) {
            return request;
        }

        @Override
        public String url(String oldUrl) {
            return oldUrl;
        }
    };
    private final HttpClientMgmt httpClientMgmt;
    private final RegionUrlMonitor regionUrlMonitor;
    private int defaultSocketTimeoutMs;

    public AppServerCommon(HttpClientMgmt httpClientMgmt, RegionUrlMonitor regionUrlMonitor) {
        this.httpClientMgmt = httpClientMgmt;
        this.regionUrlMonitor = regionUrlMonitor;
        this.defaultSocketTimeoutMs = 5000;
    }

    public void setBeforeRequest(HttpRequestHandler requestHandler) {
        this.defaultRequestHandler = requestHandler;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.defaultSocketTimeoutMs = socketTimeoutMs;
    }

    protected void setPIILogHandler(PIILogHandler logHandler) {
        this.defaultLogHandler = logHandler;
    }

    public void checkResultIsNull(JSONObject res) throws JSONParamMissException {
        if (null == res) {
            throw new JSONParamMissException(res, RESULT);
        }
    }

    protected JSONObject sendToAppServer(String url, JSONObject reqJson) throws IOException, CloudException, JSONException {
        return this.sendToAppServer(url, null, reqJson, this.defaultSocketTimeoutMs);
    }

    protected JSONObject sendToAppServer(String url, JSONObject reqJson, HttpRequestHandler requestHandler) throws IOException, CloudException, JSONException {
        return this.sendToAppServer(url, null, reqJson, this.defaultSocketTimeoutMs, requestHandler);
    }

    protected JSONObject sendToAppServer(String url, String token, JSONObject reqJson) throws IOException, CloudException, JSONException {
        return this.sendToAppServer(url, token, reqJson, this.defaultSocketTimeoutMs);
    }

    protected JSONObject sendToAppServer(String url, String token, JSONObject reqJson, HttpRequestHandler requestHandler) throws IOException, CloudException, JSONException {
        return this.sendToAppServer(url, token, reqJson, this.defaultSocketTimeoutMs, requestHandler);
    }

    protected JSONObject sendToAppServer(String url, String token, JSONObject reqJson, int soTimeoutMs) throws IOException, CloudException, JSONException {
        return this.sendToAppServer(url, token, reqJson, soTimeoutMs, null);
    }

    protected JSONObject sendToAppServer(String url, String token, JSONObject reqJson, int soTimeoutMs, HttpRequestHandler requestHandler) throws IOException, CloudException, JSONException {
        if (requestHandler == null) {
            requestHandler = this.defaultRequestHandler;
        }
        url = this.regionUrlMonitor.getInternalUrl(url);
        url = requestHandler.url(url);
        log.debug("url is {} | token is {} | soTimeoutMs is {}", new Object[]{url, token, soTimeoutMs});
        SyncHttpClient httpClient = this.httpClientMgmt.sync();
        HttpRequestBuilder httpRequestBuilder = null != token ? HttpRequestBuilder.create(url).addQueryParam("token", token) : HttpRequestBuilder.create(url);
        HttpUriRequest request = httpRequestBuilder.post().socketTimeoutMs(soTimeoutMs).setRequestParamsJson(reqJson).build();
        request = requestHandler.protocol(request);
        ResponseHandler responseHandler = new ResponseHandler();
        try {
            httpClient.execute(request, responseHandler);
        }
        catch (IOException e) {
            if (HttpResponseUtil.isConnTimeout(e)) {
                this.regionUrlMonitor.addUnreachableUrl(url);
            }
            throw e;
        }
        return responseHandler.getJsonResult(reqJson);
    }

    protected void sendToAppServerAsync(String url, String token, JSONObject reqJson, int soTimeoutMs, final AppServerAsyncResponseHandler responseHandler) throws IOReactorException {
        this.sendToAppServerAsync(url, token, reqJson, soTimeoutMs, new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                int statusCode = HttpResponseUtil.getStatusCode(httpResponse);
                String content = HttpResponseUtil.getContent(httpResponse);
                JSONObject res = null;
                try {
                    res = ResponseParseUtil.parseCloudRes(statusCode, content, null);
                    responseHandler.handleResult(res);
                }
                catch (CloudException | JSONException e) {
                    responseHandler.handleException((Exception)e);
                }
            }

            public void failed(Exception e) {
                responseHandler.handleException(e);
            }

            public void cancelled() {
                CloudException e = new CloudException(500, null);
                responseHandler.handleException(e);
            }
        }, null);
    }

    protected void sendToAppServerAsync(String url, String token, JSONObject reqJson, int soTimeoutMs, FutureCallback<HttpResponse> callback) throws IOReactorException {
        this.sendToAppServerAsync(url, token, reqJson, soTimeoutMs, callback, null);
    }

    protected void sendToAppServerAsync(String url, String token, JSONObject reqJson, int soTimeoutMs, FutureCallback<HttpResponse> callback, HttpRequestHandler requestHandler) throws IOReactorException {
        if (requestHandler == null) {
            requestHandler = this.defaultRequestHandler;
        }
        url = this.regionUrlMonitor.getInternalUrl(url);
        url = requestHandler.url(url);
        AsyncHttpClient httpClient = this.httpClientMgmt.async();
        HttpRequestBuilder httpRequestBuilder = null != token ? HttpRequestBuilder.create(url).addQueryParam("token", token) : HttpRequestBuilder.create(url);
        HttpUriRequest request = httpRequestBuilder.post().socketTimeoutMs(soTimeoutMs).setRequestParamsJson(reqJson).build();
        request = requestHandler.protocol(request);
        httpClient.execute(request, callback);
    }

    protected void sendToAppServerAsync(String url, String token, JSONObject reqJson, int soTimeoutMs, Long reqId, AppServerAsyncResponseHandler responseHandler, HttpRequestHandler requestHandler) throws IOReactorException {
        requestHandler = requestHandler == null ? this.defaultRequestHandler : requestHandler;
        url = this.regionUrlMonitor.getInternalUrl(url);
        url = requestHandler.url(url);
        AsyncHttpClient httpClient = this.httpClientMgmt.async();
        HttpRequestBuilder httpRequestBuilder = null != token ? HttpRequestBuilder.create(url).addQueryParam("token", token) : HttpRequestBuilder.create(url);
        HttpUriRequest request = httpRequestBuilder.post().socketTimeoutMs(soTimeoutMs).setRequestParamsJson(reqJson).build();
        request = requestHandler.protocol(request);
        AppServerCommonCallback callback = new AppServerCommonCallback(this.defaultLogHandler.logPII(reqJson), reqId, responseHandler);
        httpClient.execute(request, callback);
    }

    protected class ResponseHandler
    extends SimpleSyncResponseHandlerImpl {
        protected ResponseHandler() {
        }

        public JSONObject getJsonResult(JSONObject reqJson) throws CloudException, JSONException {
            return ResponseParseUtil.parseCloudRes(this.getStatusCode(), this.getContent(), AppServerCommon.this.defaultLogHandler.logPII(reqJson));
        }
    }
}

