/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.impl;

import com.tplink.nbu.common.cloud.entity.Device;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONObject;

public class AppServerBase {
    protected static final String DEVICE_PARAM_DEVICE_ID = "deviceId";
    protected static final String DEVICE_PARAM_DEV_PK = "devPk";
    protected static final String DEVICE_PARAM_DEV_PK_ID = "devPkId";
    protected static final String DEVICE_PARAM_APP_SERVER_URL = "appServerUrl";
    protected static final String DEVICE_PARAM_ALIAS = "alias";
    protected static final String DEVICE_PARAM_DEVICE_MAC = "deviceMac";
    protected static final String DEVICE_PARAM_DEVICE_TYPE = "deviceType";
    protected static final String DEVICE_PARAM_DEVICE_NAME = "deviceName";
    protected static final String DEVICE_PARAM_DEVICE_MODEL = "deviceModel";
    protected static final String DEVICE_PARAM_DEVICE_HW_VER = "deviceHwVer";
    protected static final String DEVICE_PARAM_STATUS = "status";
    protected static final String DEVICE_PARAM_FW_VER = "fwVer";
    protected static final String DEVICE_PARAM_FW_ID = "fwId";
    protected static final String DEVICE_PARAM_ROLE = "role";
    protected static final String DEVICE_PARAM_HW_ID = "hwId";
    protected static final String DEVICE_PARAM_OEM_ID = "oemId";
    protected static final String DEVICE_PARAM_SAME_REGION = "isSameRegion";
    protected static final String DEVICE_PARAM_DEVICE_REGION = "deviceRegion";
    protected final String[] devValidateParams = new String[]{"deviceId", "deviceType", "deviceName", "status", "deviceMac", "deviceModel", "deviceHwVer", "fwVer", "appServerUrl", "role", "isSameRegion", "oemId", "hwId", "fwId"};

    protected Device convertToDevice(JSONObject device, Boolean overrideSameRegion) {
        Device devModel = new Device();
        devModel.setAlias(StringEscapeUtils.unescapeJava((String)device.optString(DEVICE_PARAM_ALIAS, null)));
        devModel.setAppServerUrl(device.getString(DEVICE_PARAM_APP_SERVER_URL));
        devModel.setDeviceId(device.getString(DEVICE_PARAM_DEVICE_ID));
        devModel.setDeviceMac(device.getString(DEVICE_PARAM_DEVICE_MAC));
        devModel.setDeviceModel(device.getString(DEVICE_PARAM_DEVICE_MODEL));
        devModel.setDeviceType(device.getString(DEVICE_PARAM_DEVICE_TYPE));
        devModel.setFwVer(device.getString(DEVICE_PARAM_FW_VER));
        devModel.setFwId(device.optString(DEVICE_PARAM_FW_ID, null));
        devModel.setFwVerNum(Device.parseFwVer(device.getString(DEVICE_PARAM_FW_VER)));
        devModel.setOemId(device.getString(DEVICE_PARAM_OEM_ID));
        devModel.setRole(device.optInt(DEVICE_PARAM_ROLE, 0));
        devModel.setStatus(device.getInt(DEVICE_PARAM_STATUS));
        devModel.setHwVer(device.getString(DEVICE_PARAM_DEVICE_HW_VER));
        devModel.setDeviceRegion(device.optString(DEVICE_PARAM_DEVICE_REGION, null));
        devModel.setDevPk(device.optString(DEVICE_PARAM_DEV_PK, null));
        devModel.setDevPkId(device.optString(DEVICE_PARAM_DEV_PK_ID, null));
        if (overrideSameRegion == null) {
            devModel.setSameRegion(device.getBoolean(DEVICE_PARAM_SAME_REGION));
        } else {
            devModel.setSameRegion(overrideSameRegion);
        }
        devModel.setDeviceName(device.getString(DEVICE_PARAM_DEVICE_NAME));
        devModel.setHwId(device.getString(DEVICE_PARAM_HW_ID));
        return devModel;
    }
}

