/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.nbu.common.cloud.api.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.nbu.common.cloud.api.AppServerApi;
import com.tplink.nbu.common.cloud.api.impl.AppServerBase;
import com.tplink.nbu.common.cloud.api.impl.AppServerCommon;
import com.tplink.nbu.common.cloud.api.utils.ResponseParseUtil;
import com.tplink.nbu.common.cloud.entity.AccountInfoV2;
import com.tplink.nbu.common.cloud.entity.CloudAccountStatus;
import com.tplink.nbu.common.cloud.entity.DecoFeatureInfo;
import com.tplink.nbu.common.cloud.entity.Device;
import com.tplink.nbu.common.cloud.entity.FwInfo;
import com.tplink.nbu.common.cloud.entity.FwQueryParams;
import com.tplink.nbu.common.cloud.entity.GetDeviceOwnerInfoResp;
import com.tplink.nbu.common.cloud.entity.GetDeviceShareListByPageResp;
import com.tplink.nbu.common.cloud.entity.GetDeviceUserInfoResp;
import com.tplink.nbu.common.cloud.entity.HandleDeviceShareDetailInfo;
import com.tplink.nbu.common.cloud.entity.HandleDeviceShareDetailRespInfo;
import com.tplink.nbu.common.cloud.entity.LaunchDeviceShareDetailInfo;
import com.tplink.nbu.common.cloud.entity.LaunchDeviceShareRespInfo;
import com.tplink.nbu.common.cloud.entity.LoginInfo;
import com.tplink.nbu.common.cloud.entity.LoginInfoV1;
import com.tplink.nbu.common.cloud.entity.LoginV1Req;
import com.tplink.nbu.common.cloud.entity.RefreshTokenResp;
import com.tplink.nbu.common.cloud.entity.RepeaterFeatureInfo;
import com.tplink.nbu.common.cloud.entity.ServiceUrlInfo;
import com.tplink.nbu.common.cloud.entity.SubscribeMsgType;
import com.tplink.nbu.common.cloud.entity.UnbindDeviceListResult;
import com.tplink.nbu.common.cloud.entity.UserNumberLimitInfo;
import com.tplink.nbu.common.cloud.monitor.RegionUrlMonitor;
import com.tplink.nbu.common.cloud.monitor.impl.DefaultRegionUrlMonitor;
import com.tplink.nbu.common.exception.CloudException;
import com.tplink.nbu.common.exception.JSONException;
import com.tplink.nbu.common.exception.JSONParamMissException;
import com.tplink.nbu.common.exception.WeakPasswordException;
import com.tplink.nbu.common.global.PIIStrategyMap;
import com.tplink.nbu.common.httpclient.handler.HttpRequestHandler;
import com.tplink.nbu.common.httpclient.handler.PIILogHandler;
import com.tplink.nbu.common.httpclient.mgmt.HttpClientMgmt;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.nbu.common.pii.utils.PIIStrategyUtil;
import com.tplink.nbu.common.utils.JSONUtil;
import com.tplink.nbu.common.utils.JacksonUtil;
import com.tplink.nbu.common.utils.PasswordUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.reactor.IOReactorException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerApiImpl
extends AppServerBase
implements AppServerApi {
    private static final Logger log = LoggerFactory.getLogger(AppServerApiImpl.class);
    private final AppServerCommon appServerCommon;
    private static final String REQUEST_METHOD = "method";
    private static final String REQUEST_PARAMS = "params";
    private static final int DEVICE_LIST_PAGE_LIMIT = 20;
    private static final String TOTAL_NUMBER_BY_PAGE = "totalNum";
    private static final String ACCOUNT_PATH = "/api/v1/account";
    private static final String DT_PATH = "/dt";
    private static final String USER_LIST = "userList";
    private static final String ACCOUNT_ID = "accountId";
    private static final String REDIRECT_URL = "redirectUrl";
    private static final String DEVICE_LIST = "deviceList";
    private static final String FEATURE_INFO = "featureInfo";
    private static final String FEATURE_DATA = "data";
    private static final String FEATURE_INFO_GROUP_ID = "group_id";
    private static final String FEATURE_INFO_GROUP_KEY = "group_key";
    private static final String FEATURE_INFO_GROUP_NAME = "group_name";
    private static final String FEATURE_INFO_LOCATION = "location";
    private static final String FEATURE_INFO_MASTER_DEVICE_ID = "master_device_id";
    private static final String FEATURE_INFO_DEVICE_COLOR = "device_color";
    private static final String FEATURE_INFO_RE_LIST = "re_list";
    private static final String FEATURE_INFO_ROLE = "role";
    private static final String FEATURE_INFO_ROLE_MASTER = "master";
    private static final String LOGIN_TOKEN = "token";
    private static final String LOGIN_EMAIL = "email";
    private static final String LOGIN_ACCOUNT_ID = "accountId";
    private static final String FIELD_FW_LIST = "fwList";
    private final String[] decoFeatureParams = new String[]{"group_id", "group_key", "group_name", "location", "master_device_id", "role"};
    private final String[] loginParams = new String[]{"token", "email", "accountId"};
    private final RegionUrlMonitor regionUrlMonitor;

    public AppServerApiImpl(HttpClientMgmt httpClientMgmt, RegionUrlMonitor regionUrlMonitor) {
        this.regionUrlMonitor = regionUrlMonitor;
        this.appServerCommon = new AppServerCommon(httpClientMgmt, regionUrlMonitor);
        PIILogHandler piiLogHandler = pii -> PIIJacksonUtil.maskPIIStr((String)pii.toString(), PIIStrategyUtil.isInitialized() ? PIIStrategyMap.V1_STRATEGY_MAP : PIIStrategyMap.DEFAULT_STRATEGY_MAP);
        this.appServerCommon.setPIILogHandler(piiLogHandler);
    }

    public AppServerApiImpl(HttpClientMgmt httpClientMgmt) {
        this(httpClientMgmt, new DefaultRegionUrlMonitor());
    }

    @Override
    public List<Device> getDeviceList(String url, String token, String deviceType, boolean handleRole) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceListPayload(deviceType);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, req);
        return this.parseDeviceListResult(result, handleRole);
    }

    @Override
    public List<Device> getDeviceListByPage(String url, String token, List<String> deviceTypes, boolean handleRole) throws CloudException, JSONException, IOException {
        JSONObject req = new JSONObject();
        req.put(REQUEST_METHOD, (Object)"getDeviceListByPage");
        JSONObject params = new JSONObject();
        if (null != deviceTypes) {
            params.put("deviceTypeList", deviceTypes);
        }
        params.put("limit", 20);
        params.put("index", 0);
        req.put(REQUEST_PARAMS, (Object)params);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, req);
        if (!result.has(TOTAL_NUMBER_BY_PAGE)) {
            throw new JSONParamMissException(result, TOTAL_NUMBER_BY_PAGE);
        }
        int totalNum = result.getInt(TOTAL_NUMBER_BY_PAGE);
        ArrayList<Device> deviceList = new ArrayList<Device>(this.parseDeviceListResult(result, handleRole));
        for (int index = 20; index < totalNum; index += 20) {
            params.put("index", index);
            req.put(REQUEST_PARAMS, (Object)params);
            JSONObject pageResult = this.appServerCommon.sendToAppServer(url, token, req);
            deviceList.addAll(this.parseDeviceListResult(pageResult, handleRole));
        }
        return deviceList;
    }

    private List<Device> parseDeviceListResult(JSONObject result, boolean handleRole) throws JSONParamMissException {
        this.appServerCommon.checkResultIsNull(result);
        if (!result.has(DEVICE_LIST)) {
            throw new JSONParamMissException(result, DEVICE_LIST);
        }
        JSONArray deviceArray = result.getJSONArray(DEVICE_LIST);
        ArrayList<Device> deviceList = new ArrayList<Device>();
        for (int deviceIndex = 0; deviceIndex < deviceArray.length(); ++deviceIndex) {
            JSONObject device = deviceArray.getJSONObject(deviceIndex);
            try {
                JSONUtil.validateParams((JSONObject)device, (String[])this.devValidateParams, (String[])new String[0]);
            }
            catch (JSONParamMissException e) {
                log.warn("{}", (Object)e.toString());
                continue;
            }
            Device devModel = this.convertToDevice(device, null);
            if (handleRole && !devModel.isAdmin()) continue;
            deviceList.add(devModel);
        }
        return deviceList;
    }

    @Override
    public Device getDeviceInfo(String url, String token, String deviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceInfoPayload(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, req);
        this.appServerCommon.checkResultIsNull(result);
        JSONUtil.validateParams((JSONObject)result, (String[])this.devValidateParams, (String[])new String[]{"isSameRegion"});
        Device deviceInfo = this.convertToDevice(result, false);
        deviceInfo.setRegionFlag(1);
        return deviceInfo;
    }

    @Override
    public Map<String, DecoFeatureInfo> getDeviceFeatureInfoForDeco(String url, String token, String email, JSONArray deviceIdList) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceFeatureInfoPayload(email, deviceIdList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, req);
        this.appServerCommon.checkResultIsNull(result);
        if (!result.has(FEATURE_INFO)) {
            throw new JSONParamMissException(result, FEATURE_INFO);
        }
        HashMap<String, DecoFeatureInfo> deviceFeatureInfos = new HashMap<String, DecoFeatureInfo>();
        JSONObject responseData = result.getJSONObject(FEATURE_INFO);
        for (String deviceId : responseData.keySet()) {
            List tmpList;
            JSONObject info = responseData.getJSONObject(deviceId);
            if (!info.has(FEATURE_DATA)) {
                log.debug("Device feature info has no 'data' ({})", (Object)info.toString());
                continue;
            }
            info = info.getJSONObject(FEATURE_DATA);
            JSONUtil.validateParams((JSONObject)info, (String[])this.decoFeatureParams, (String[])new String[0]);
            String groupId = info.getString(FEATURE_INFO_GROUP_ID);
            String groupKey = info.getString(FEATURE_INFO_GROUP_KEY);
            String groupName = info.getString(FEATURE_INFO_GROUP_NAME);
            String location = info.getString(FEATURE_INFO_LOCATION);
            String masterDeviceId = info.getString(FEATURE_INFO_MASTER_DEVICE_ID);
            String deviceColor = info.optString(FEATURE_INFO_DEVICE_COLOR, null);
            int role = info.getString(FEATURE_INFO_ROLE).equals(FEATURE_INFO_ROLE_MASTER) ? 1 : 0;
            JSONArray reList = info.optJSONArray(FEATURE_INFO_RE_LIST);
            try {
                groupName = new String(Base64.getDecoder().decode(groupName), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("Base64 decode fail and skip it. ({})", (Object)info.toString());
                continue;
            }
            List<RepeaterFeatureInfo> reDeviceIdList = new ArrayList<RepeaterFeatureInfo>();
            if (null != reList && null != (tmpList = JacksonUtil.convertToList((String)reList.toString(), RepeaterFeatureInfo.class))) {
                reDeviceIdList = tmpList.stream().map(item -> {
                    String mac = item.getMac();
                    item.setMac(mac != null ? mac.replaceAll("-", "") : null);
                    return item;
                }).collect(Collectors.toList());
            }
            DecoFeatureInfo decoFeatureInfo = new DecoFeatureInfo(groupId, groupKey, groupName, location, masterDeviceId, deviceColor, role, reDeviceIdList);
            deviceFeatureInfos.put(deviceId, decoFeatureInfo);
        }
        return deviceFeatureInfos;
    }

    @Override
    public JSONObject passthrough(String url, String token, String deviceId, JSONObject requestData, int soTimeoutMs) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildPassthroughPayload(deviceId, requestData);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, req, soTimeoutMs);
        return ResponseParseUtil.getPassthroughRes(result);
    }

    @Override
    public LoginInfo login(String url, String username, String password) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildLoginPayload(username, password);
        JSONObject result = this.appServerCommon.sendToAppServer(url, req);
        this.appServerCommon.checkResultIsNull(result);
        JSONUtil.validateParams((JSONObject)result, (String[])this.loginParams, (String[])new String[0]);
        return (LoginInfo)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), LoginInfo.class);
    }

    @Override
    public LoginInfoV1 loginV1(String url, LoginV1Req req) throws JSONException, IOException, CloudException {
        JSONObject request = this.buildLoginPayload(req);
        JSONObject result = this.appServerCommon.sendToAppServer(url + ACCOUNT_PATH, request);
        this.appServerCommon.checkResultIsNull(result);
        return (LoginInfoV1)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), LoginInfoV1.class);
    }

    @Override
    public List<String> getDeviceUserInfo(String url, String deviceToken, String deviceId, String serviceId) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetDeviceUserInfoPayload(deviceToken, deviceId, serviceId);
        JSONObject res = this.appServerCommon.sendToAppServer(url, req);
        this.appServerCommon.checkResultIsNull(res);
        if (!res.has(USER_LIST)) {
            if (!res.has(REDIRECT_URL)) {
                throw new JSONParamMissException(res, REDIRECT_URL);
            }
            String realServerUrl = res.getString(REDIRECT_URL);
            if (!(res = this.appServerCommon.sendToAppServer(realServerUrl.concat(DT_PATH), req)).has(USER_LIST)) {
                throw new JSONParamMissException(res, USER_LIST);
            }
        }
        JSONArray userList = res.getJSONArray(USER_LIST);
        ArrayList<String> accountIds = new ArrayList<String>();
        for (Object obj : userList) {
            JSONObject jsonObj = (JSONObject)obj;
            String accountId = jsonObj.optString("accountId");
            if ("".equals(accountId)) {
                log.warn("{} is missing {}. Skip it.", (Object)jsonObj.toString(), (Object)"accountId");
                continue;
            }
            accountIds.add(accountId);
        }
        return accountIds;
    }

    @Override
    public List<String> getDeviceUserInfo(String url, String deviceToken, String deviceId, String serviceId, String projectHostname) throws CloudException, JSONException, IOException {
        url = this.regionUrlMonitor.getInternalUrl(url.concat(DT_PATH), projectHostname);
        return this.getDeviceUserInfo(url, deviceToken, deviceId, serviceId);
    }

    @Override
    public List<FwInfo> getIntlFwList(String url, String token, FwQueryParams params) throws CloudException, JSONException, IOException {
        JSONObject request = this.buildGetIntlFwList(params);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        if (!result.has(FIELD_FW_LIST)) {
            throw new JSONParamMissException(result, FIELD_FW_LIST);
        }
        JSONArray array = result.getJSONArray(FIELD_FW_LIST);
        return JacksonUtil.convertToList((String)array.toString(), FwInfo.class);
    }

    @Override
    public void unbindDeviceWithFeatureInfo(String url, String token, String deviceId, String cloudUserName) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildUnbindDeviceWithFeatureInfo(deviceId, cloudUserName);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public void passthroughAsync(String url, String token, String deviceId, JSONObject requestData, int soTimeoutMs, FutureCallback<HttpResponse> callback) throws IOReactorException {
        JSONObject req = this.buildPassthroughPayload(deviceId, requestData);
        this.appServerCommon.sendToAppServerAsync(url, token, req, soTimeoutMs, callback);
    }

    @Override
    public void resendRegEmail(String url, String email, String locale) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildResendRegEmailPayload(email, locale);
        this.appServerCommon.sendToAppServer(url, req);
    }

    @Override
    public void logout(String url, String token, String cloudUserName) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildLogoutPayload(cloudUserName);
        this.appServerCommon.sendToAppServer(url, token, req);
    }

    @Override
    public void getResetPasswordEmail(String url, String email, String locale) throws CloudException, JSONException, IOException {
        JSONObject req = this.buildGetResetPasswordEmailPayload(email, locale);
        this.appServerCommon.sendToAppServer(url, req);
    }

    @Override
    public UnbindDeviceListResult unbindDeviceListWithFeatureInfo(String url, String token, String cloudUserName, List<String> deviceIdList) throws JSONException, CloudException, IOException {
        if (deviceIdList == null || deviceIdList.isEmpty()) {
            log.debug("empty deviceIdList");
            return UnbindDeviceListResult.empty();
        }
        JSONObject request = this.buildUnbindDeviceListWithFeatureInfo(cloudUserName, deviceIdList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        return (UnbindDeviceListResult)JacksonUtil.convertTo((String)result.toString(), UnbindDeviceListResult.class);
    }

    @Override
    public List<SubscribeMsgType> getSubscribeMsgType(String url, String token, String appType, String deviceToken) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetSubscribeMsgTypePayload(appType, deviceToken);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        List subscribeMsgTypeStrList = JacksonUtil.convertToList((String)result.getJSONArray("subscribeMsgType").toString(), String.class);
        return subscribeMsgTypeStrList.stream().map(subscribeMsgTypeStr -> {
            String[] subscribeMsgTypeArray = subscribeMsgTypeStr.split(":");
            return new SubscribeMsgType(subscribeMsgTypeArray[0], subscribeMsgTypeArray[1]);
        }).collect(Collectors.toList());
    }

    @Override
    public void register(String url, String email, String nickname, String cloudPassword, String countryCode, String productLine, Map<String, Boolean> topicSubscription, String locale) throws JSONException, CloudException, IOException, WeakPasswordException {
        if (PasswordUtil.isWeakPassword((String)cloudPassword)) {
            throw new WeakPasswordException();
        }
        JSONObject request = this.buildRegisterPayload(email, nickname, cloudPassword, countryCode, productLine, topicSubscription, locale);
        this.appServerCommon.sendToAppServer(url, request);
    }

    @Override
    public void modifyCloudPassword(String url, String token, String cloudUserName, String oldCloudPassword, String newCloudPassword, String locale) throws JSONException, CloudException, IOException, WeakPasswordException {
        if (PasswordUtil.isWeakPassword((String)newCloudPassword)) {
            throw new WeakPasswordException();
        }
        JSONObject request = this.buildModifyCloudPasswordPayload(cloudUserName, oldCloudPassword, newCloudPassword, locale);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public RefreshTokenResp refreshToken(String url, String refreshToken, String appType, String terminalUUID) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildRefreshTokenPayload(refreshToken, appType, terminalUUID);
        JSONObject result = this.appServerCommon.sendToAppServer(url, request);
        return (RefreshTokenResp)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), RefreshTokenResp.class);
    }

    @Override
    public AccountInfoV2 getAccountInfoV2(String url, String token, String cloudUserName) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetAccountInfoPayload(cloudUserName);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        return (AccountInfoV2)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), AccountInfoV2.class);
    }

    @Override
    public void updateAccountInfo(String url, String token, String cloudUserName, String nickname, String countryCode) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildUpdateAccountInfoReq(cloudUserName, nickname, countryCode);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public Map<String, Boolean> getTopicSubscription(String url, String token, String email, String productLine) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetTopicSubscriptionPayload(email, productLine);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        Object subscription = result.get("topicSubscription");
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(JacksonUtil.parseToStr((Object)subscription), (TypeReference)new TypeReference<Map<String, Boolean>>(){});
    }

    @Override
    public void updateTopicSubscription(String url, String token, String email, String productLine, Map<String, Boolean> topicSubscription) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildUpdateTopicSubscriptionPayload(email, productLine, topicSubscription);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public ServiceUrlInfo getAppServiceUrl(String url, String token, List<String> serviceIds) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetAppServiceUrlPayload(serviceIds);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        return (ServiceUrlInfo)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), ServiceUrlInfo.class);
    }

    private JSONObject buildGetAppServiceUrlPayload(List<String> serviceIds) {
        return new JSONObject().put(REQUEST_METHOD, (Object)"getAppServiceUrl").put(REQUEST_PARAMS, (Object)new JSONObject().put("serviceIds", serviceIds));
    }

    @Override
    public List<LaunchDeviceShareRespInfo> launchTapoDeviceShare(String url, String token, List<LaunchDeviceShareDetailInfo> launchShareDetailList) throws JSONException, CloudException, IOException {
        if (launchShareDetailList == null || launchShareDetailList.isEmpty()) {
            log.debug("empty launchShareDetailList");
            return Collections.emptyList();
        }
        JSONObject request = this.buildLaunchDeviceSharePayload(launchShareDetailList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        List launchDeviceShareRespInfos = JacksonUtil.convertToList((String)result.getJSONArray("launchList").toString(), LaunchDeviceShareRespInfo.class);
        return launchDeviceShareRespInfos;
    }

    @Override
    public List<HandleDeviceShareDetailRespInfo> handleTapoDeviceShare(String url, String token, List<HandleDeviceShareDetailInfo> handleShareDetailList) throws JSONException, CloudException, IOException {
        if (handleShareDetailList == null || handleShareDetailList.isEmpty()) {
            log.debug("empty handleShareDetailList");
            return Collections.emptyList();
        }
        JSONObject request = this.buildHandleDeviceSharePayload(handleShareDetailList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        List handleDeviceShareDetailRespInfos = JacksonUtil.convertToList((String)result.getJSONArray("handleList").toString(), HandleDeviceShareDetailRespInfo.class);
        return handleDeviceShareDetailRespInfos;
    }

    @Override
    public GetDeviceShareListByPageResp getTapoDeviceShareListByPage(String url, String token, List<String> deviceTypeList, String shareRole, String shareStatus, Integer index, Integer limit, Boolean needExpiredInfo, Boolean needCheckBlackList) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetDeviceSharePayload(deviceTypeList, shareRole, shareStatus, index, limit, needExpiredInfo, needCheckBlackList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        GetDeviceShareListByPageResp getDeviceShareListByPageResp = (GetDeviceShareListByPageResp)JacksonUtil.convertTo((String)result.toString(), GetDeviceShareListByPageResp.class);
        return getDeviceShareListByPageResp;
    }

    @Override
    public GetDeviceUserInfoResp getDeviceUserInfo(String url, String userToken, String deviceId) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetDeviceUserInfoByDeviceIdPayload(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url, userToken, request);
        this.appServerCommon.checkResultIsNull(result);
        GetDeviceUserInfoResp getDeviceUserInfoResp = (GetDeviceUserInfoResp)JacksonUtil.convertTo((String)result.toString(), GetDeviceUserInfoResp.class);
        return getDeviceUserInfoResp;
    }

    @Override
    public GetDeviceOwnerInfoResp getDeviceOwnerInfo(String url, String userToken, String deviceId) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildGetDeviceOwnerInfoByDeviceIdPayload(deviceId);
        JSONObject result = this.appServerCommon.sendToAppServer(url, userToken, request);
        this.appServerCommon.checkResultIsNull(result);
        GetDeviceOwnerInfoResp getDeviceOwnerInfoResp = (GetDeviceOwnerInfoResp)JacksonUtil.convertTo((String)result.toString(), GetDeviceOwnerInfoResp.class);
        return getDeviceOwnerInfoResp;
    }

    @Override
    public void removeDeviceUser(String url, String token, String deviceId, String ownerAccount, String userAccount) throws JSONException, CloudException, IOException {
        JSONObject request = this.buildRemoveDeviceUserPayload(deviceId, ownerAccount, userAccount);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public void removeDeviceUsers(String url, String token, String deviceId, String ownerAccount, List<String> userAccountList) throws JSONException, CloudException, IOException {
        if (userAccountList == null || userAccountList.isEmpty()) {
            log.debug("empty userAccountList");
            return;
        }
        JSONObject request = this.buildRemoveDeviceUsersPayload(deviceId, ownerAccount, userAccountList);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public void abandonDeviceUserRole(String url, String token, List<String> deviceIdList, String userAccount) throws JSONException, CloudException, IOException {
        if (deviceIdList == null || deviceIdList.isEmpty()) {
            log.debug("empty deviceIdList");
            return;
        }
        JSONObject request = this.buildAbandonDeviceUserRolePayload(deviceIdList, userAccount);
        this.appServerCommon.sendToAppServer(url, token, request);
    }

    @Override
    public List<UserNumberLimitInfo> batchGetDeviceUserNumberLimit(String url, String token, List<String> deviceTypeList) throws JSONException, CloudException, IOException {
        if (deviceTypeList == null || deviceTypeList.isEmpty()) {
            log.debug("empty deviceTypeList");
            return Collections.emptyList();
        }
        JSONObject request = this.buildBatchGetDeviceUserNumberLimitPayload(deviceTypeList);
        JSONObject result = this.appServerCommon.sendToAppServer(url, token, request);
        this.appServerCommon.checkResultIsNull(result);
        List userNumberLimitInfos = JacksonUtil.convertToList((String)result.getJSONArray("userNumberLimitList").toString(), UserNumberLimitInfo.class);
        return userNumberLimitInfos;
    }

    @Override
    public CloudAccountStatus getCloudAccountStatus(String url, String cloudUserName) throws JSONException, CloudException, IOException {
        JSONObject req = this.buiGetCloudAccountStatusPayload(cloudUserName);
        JSONObject result = this.appServerCommon.sendToAppServer(url, req);
        this.appServerCommon.checkResultIsNull(result);
        return (CloudAccountStatus)JacksonUtil.convertTo((String)JacksonUtil.parseToStr((Object)result), CloudAccountStatus.class);
    }

    private JSONObject buildUpdateTopicSubscriptionPayload(String email, String productLine, Map<String, Boolean> topicSubscription) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"updateTopicSubscription");
        JSONObject params = new JSONObject();
        params.put(LOGIN_EMAIL, (Object)email).put("productLine", (Object)productLine).put("topicSubscription", topicSubscription);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildGetTopicSubscriptionPayload(String email, String productLine) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"getTopicSubscription");
        JSONObject params = new JSONObject();
        params.put(LOGIN_EMAIL, (Object)email).put("productLine", (Object)productLine);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildUpdateAccountInfoReq(String cloudUserName, String nickname, String countryCode) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"updateAccountInfo");
        JSONObject params = new JSONObject();
        params.put("cloudUserName", (Object)cloudUserName).putOpt("nickname", (Object)nickname).putOpt("countryCode", (Object)countryCode);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildGetAccountInfoPayload(String cloudUserName) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"getAccountInfo");
        JSONObject params = new JSONObject();
        params.put("cloudUserName", (Object)cloudUserName);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildRegisterPayload(String email, String nickname, String cloudPassword, String countryCode, String productLine, Map<String, Boolean> topicSubscription, String locale) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"register");
        JSONObject params = new JSONObject();
        params.putOpt(LOGIN_EMAIL, (Object)email).putOpt("nickname", (Object)nickname).putOpt("cloudPassword", (Object)cloudPassword).putOpt("countryCode", (Object)countryCode).putOpt("productLine", (Object)productLine).putOpt("topicSubscription", topicSubscription).putOpt("locale", (Object)locale);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildModifyCloudPasswordPayload(String cloudUserName, String oldCloudPassword, String newCloudPassword, String locale) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"modifyCloudPassword");
        JSONObject params = new JSONObject();
        params.put("cloudUserName", (Object)cloudUserName).put("oldCloudPassword", (Object)oldCloudPassword).put("newCloudPassword", (Object)newCloudPassword).putOpt("locale", (Object)locale);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildRefreshTokenPayload(String refreshToken, String appType, String terminalUUID) {
        JSONObject payload = new JSONObject().put(REQUEST_METHOD, (Object)"refreshToken");
        JSONObject params = new JSONObject();
        params.put("refreshToken", (Object)refreshToken);
        params.put("appType", (Object)appType);
        params.put("terminalUUID", (Object)terminalUUID);
        return payload.put(REQUEST_PARAMS, (Object)params);
    }

    private JSONObject buildGetSubscribeMsgTypePayload(String appType, String deviceToken) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("appType", (Object)appType);
        params.put("deviceToken", (Object)deviceToken);
        requestObject.put(REQUEST_METHOD, (Object)"getSubscribeMsgType");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildUnbindDeviceListWithFeatureInfo(String cloudUserName, List<String> deviceIdList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceIdList", deviceIdList);
        params.put("cloudUserName", (Object)cloudUserName);
        requestObject.put(REQUEST_METHOD, (Object)"unbindDeviceListWithFeatureInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceListPayload(String deviceType) {
        JSONObject requestObject = new JSONObject();
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceList");
        if (null != deviceType) {
            JSONObject params = new JSONObject();
            params.put("deviceType", (Object)deviceType);
            requestObject.put(REQUEST_PARAMS, (Object)params);
        }
        return requestObject;
    }

    private JSONObject buildGetDeviceInfoPayload(String deviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceFeatureInfoPayload(String email, JSONArray deviceIdList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceIdList", (Object)deviceIdList);
        params.put("cloudUserName", (Object)email);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceFeatureInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildPassthroughPayload(String deviceId, JSONObject requestData) {
        JSONObject requestObject = new JSONObject();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("deviceId", deviceId);
        paramsMap.put("requestData", (String)requestData);
        requestObject.put(REQUEST_METHOD, (Object)"passthrough");
        requestObject.put(REQUEST_PARAMS, paramsMap);
        return requestObject;
    }

    private JSONObject buildLoginPayload(String username, String password) {
        JSONObject requestObject = new JSONObject();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("cloudUserName", username);
        paramsMap.put("cloudPassword", password);
        paramsMap.put("appType", "nbu.cloud");
        paramsMap.put("terminalUUID", "tplinknbu");
        requestObject.put(REQUEST_METHOD, (Object)"login");
        requestObject.put(REQUEST_PARAMS, paramsMap);
        return requestObject;
    }

    private JSONObject buildLoginPayload(LoginV1Req req) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject((Object)req);
        requestObject.put(REQUEST_METHOD, (Object)"login");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceUserInfoPayload(String deviceToken, String deviceId, String serviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceToken", (Object)deviceToken);
        params.put("deviceId", (Object)deviceId);
        params.put("serviceId", (Object)serviceId);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceUserInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetIntlFwList(FwQueryParams queryParams) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject(JacksonUtil.parseToStr((Object)queryParams));
        requestObject.put(REQUEST_METHOD, (Object)"getIntlFwList");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildUnbindDeviceWithFeatureInfo(String deviceId, String cloudUserName) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        params.put("cloudUserName", (Object)cloudUserName);
        requestObject.put(REQUEST_METHOD, (Object)"unbindDeviceWithFeatureInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildResendRegEmailPayload(String email, String locale) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put(LOGIN_EMAIL, (Object)email);
        if (StringUtils.isNotBlank((CharSequence)locale)) {
            params.put("locale", (Object)locale);
        }
        requestObject.put(REQUEST_METHOD, (Object)"resendRegEmail");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildLogoutPayload(String cloudUserName) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("cloudUserName", (Object)cloudUserName);
        requestObject.put(REQUEST_METHOD, (Object)"logout");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetResetPasswordEmailPayload(String email, String locale) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put(LOGIN_EMAIL, (Object)email);
        if (StringUtils.isNotBlank((CharSequence)locale)) {
            params.put("locale", (Object)locale);
        }
        requestObject.put(REQUEST_METHOD, (Object)"getResetPasswordEmail");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildLaunchDeviceSharePayload(List<LaunchDeviceShareDetailInfo> launchShareDetailList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("shareList", launchShareDetailList);
        requestObject.put(REQUEST_METHOD, (Object)"launchDeviceShare");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildHandleDeviceSharePayload(List<HandleDeviceShareDetailInfo> handleShareDetailList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("shareList", handleShareDetailList);
        requestObject.put(REQUEST_METHOD, (Object)"handleDeviceShare");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceSharePayload(List<String> deviceTypeList, String shareRole, String shareStatus, Integer index, Integer limit, Boolean needExpiredInfo, Boolean needCheckBlackList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        if (deviceTypeList != null && !deviceTypeList.isEmpty()) {
            params.put("deviceTypeList", deviceTypeList);
        }
        if (StringUtils.isNotBlank((CharSequence)shareStatus)) {
            params.put("shareStatus", (Object)shareStatus);
        }
        if (needExpiredInfo != null) {
            params.put("needExpiredInfo", (Object)needExpiredInfo);
        }
        if (needCheckBlackList != null) {
            params.put("needCheckBlackList", (Object)needCheckBlackList);
        }
        params.put("shareRole", (Object)shareRole);
        params.put("index", (Object)index);
        params.put("limit", (Object)limit);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceShareListByPage");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceUserInfoByDeviceIdPayload(String deviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceUserInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildGetDeviceOwnerInfoByDeviceIdPayload(String deviceId) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        requestObject.put(REQUEST_METHOD, (Object)"getDeviceOwnerInfo");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildRemoveDeviceUserPayload(String deviceId, String ownerAccount, String userAccount) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        params.put("ownerAccount", (Object)ownerAccount);
        params.put("userAccount", (Object)userAccount);
        requestObject.put(REQUEST_METHOD, (Object)"removeDeviceUser");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildRemoveDeviceUsersPayload(String deviceId, String ownerAccount, List<String> userAccountList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceId", (Object)deviceId);
        params.put("ownerAccount", (Object)ownerAccount);
        params.put("userAccountList", userAccountList);
        requestObject.put(REQUEST_METHOD, (Object)"removeDeviceUsers");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildAbandonDeviceUserRolePayload(List<String> deviceIdList, String userAccount) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceIdList", deviceIdList);
        params.put("userAccount", (Object)userAccount);
        requestObject.put(REQUEST_METHOD, (Object)"abandonDeviceUserRole");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buildBatchGetDeviceUserNumberLimitPayload(List<String> deviceTypeList) {
        JSONObject requestObject = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("deviceTypeList", deviceTypeList);
        requestObject.put(REQUEST_METHOD, (Object)"batchGetDeviceUserNumberLimit");
        requestObject.put(REQUEST_PARAMS, (Object)params);
        return requestObject;
    }

    private JSONObject buiGetCloudAccountStatusPayload(String cloudUserName) {
        JSONObject requestObject = new JSONObject();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("cloudUserName", cloudUserName);
        requestObject.put(REQUEST_METHOD, (Object)"getCloudAccountStatus");
        requestObject.put(REQUEST_PARAMS, paramsMap);
        return requestObject;
    }

    @Override
    public void setBeforeRequest(HttpRequestHandler handler) {
        this.appServerCommon.setBeforeRequest(handler);
    }

    @Override
    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.appServerCommon.setSocketTimeoutMs(socketTimeoutMs);
    }
}

