/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.lock.mem.lock;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StopWatch;

public class HashLock<T> {
    private static final Logger log = LoggerFactory.getLogger(HashLock.class);
    private final Map<T, ReentrantLock> lockMap = new ConcurrentReferenceHashMap();
    private final Map<T, ReentrantReadWriteLock> readWriteLockMap = new ConcurrentReferenceHashMap();

    public int getLockNum() {
        return this.lockMap.size();
    }

    public ReentrantLock getLock(T lockKey) {
        StopWatch stopWatch = null;
        if (log.isTraceEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        ReentrantLock reentrantLock = this.lockMap.computeIfAbsent(lockKey, k -> new ReentrantLock());
        if (log.isTraceEnabled() && stopWatch != null) {
            stopWatch.stop();
            log.trace("[lockService]getLock use {} ms", (Object)stopWatch.getTotalTimeMillis());
        }
        return reentrantLock;
    }

    public ReentrantReadWriteLock getReadWriteLock(T lockKey) {
        StopWatch stopWatch = null;
        if (log.isTraceEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.readWriteLockMap.computeIfAbsent(lockKey, k -> new ReentrantReadWriteLock());
        if (log.isTraceEnabled() && stopWatch != null) {
            stopWatch.stop();
            log.trace("[lockService]getReadWriteLock use {} ms", (Object)stopWatch.getTotalTimeMillis());
        }
        return reentrantReadWriteLock;
    }
}

