/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.health.core.c.a;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.wifi.WifiHealthDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.insight.api.internal.dto.healthv2.ClientHealthGridDTO;
import com.tplink.smb.omada.insight.api.internal.dto.healthv2.DeviceHealthGridDTO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeScoreItemVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeScoreListVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.AccessCapacityInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.BaseClientInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.BaseDeviceInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.ChannelInterInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.ChannelUtilInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.ClientAccessTimeInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.RssiInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.WifiClientInfoVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.wifi.WifiHealthDetailVO;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class i {
    private i() {
    }

    public static TimeScoreListVO a(List<WifiHealthDTO> wifiHealthDTOList, List<Long> timeList) {
        Map<Long, WifiHealthDTO> wifiHealthDTOMap = Optional.ofNullable(wifiHealthDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        List<TimeScoreItemVO> voList = timeList.stream().map(time -> {
            WifiHealthDTO scoreDTO = (WifiHealthDTO)wifiHealthDTOMap.get(time);
            if (Objects.isNull(scoreDTO)) {
                return TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time);
            }
            return TimeScoreItemVO.createMillSecondVO((Integer)scoreDTO.getScore(), (Long)scoreDTO.getTimestamp());
        }).toList();
        return new TimeScoreListVO(voList);
    }

    public static WifiHealthDetailVO b(List<WifiHealthDTO> wifiHealthDTOList, List<Long> timeList) {
        WifiHealthDetailVO wifiHealthDetailVO = new WifiHealthDetailVO();
        Map<Long, WifiHealthDTO> wifiHealthDTOMap = Optional.ofNullable(wifiHealthDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        ArrayList accessTimeScoreList = new ArrayList();
        ArrayList channelUtilScoreList = new ArrayList();
        ArrayList channelInterferenceScoreList = new ArrayList();
        ArrayList accessCapacityScoreList = new ArrayList();
        ArrayList rssiScoreList = new ArrayList();
        timeList.stream().forEach(time -> {
            WifiHealthDTO healthDTO = (WifiHealthDTO)wifiHealthDTOMap.get(time);
            accessTimeScoreList.add(TimeScoreItemVO.createMillSecondVO((Integer)(Objects.nonNull(healthDTO) ? healthDTO.getAccessTimeScore() : -1), (Long)time));
            channelUtilScoreList.add(TimeScoreItemVO.createMillSecondVO((Integer)(Objects.nonNull(healthDTO) ? healthDTO.getChannelUtilScore() : -1), (Long)time));
            channelInterferenceScoreList.add(TimeScoreItemVO.createMillSecondVO((Integer)(Objects.nonNull(healthDTO) ? healthDTO.getInterUtilScore() : -1), (Long)time));
            accessCapacityScoreList.add(TimeScoreItemVO.createMillSecondVO((Integer)(Objects.nonNull(healthDTO) ? healthDTO.getAccessCapacityScore() : -1), (Long)time));
            rssiScoreList.add(TimeScoreItemVO.createMillSecondVO((Integer)(Objects.nonNull(healthDTO) ? healthDTO.getRssiScore() : -1), (Long)time));
        });
        int lastOneIndex = timeList.size() - 1;
        WifiHealthDTO lastOne = wifiHealthDTOMap.get(timeList.get(lastOneIndex));
        Integer wifiHealthScore = -1;
        if (Objects.nonNull(lastOne)) {
            wifiHealthScore = lastOne.getScore();
        }
        wifiHealthDetailVO.setWifiHealthScore(wifiHealthScore);
        WifiHealthDetailVO.SubSingleHealthInfoDetailVO accessTimeScoreDetail = new WifiHealthDetailVO.SubSingleHealthInfoDetailVO(((TimeScoreItemVO)accessTimeScoreList.get(lastOneIndex)).getScore(), accessTimeScoreList);
        wifiHealthDetailVO.setAccessTimeScoreDetail(accessTimeScoreDetail);
        WifiHealthDetailVO.SubSingleHealthInfoDetailVO channelUseRatioScoreDetail = new WifiHealthDetailVO.SubSingleHealthInfoDetailVO(((TimeScoreItemVO)channelUtilScoreList.get(lastOneIndex)).getScore(), channelUtilScoreList);
        wifiHealthDetailVO.setChannelUtilScoreDetail(channelUseRatioScoreDetail);
        WifiHealthDetailVO.SubSingleHealthInfoDetailVO channelInterferenceScoreDetail = new WifiHealthDetailVO.SubSingleHealthInfoDetailVO(((TimeScoreItemVO)channelInterferenceScoreList.get(lastOneIndex)).getScore(), channelInterferenceScoreList);
        wifiHealthDetailVO.setChannelInterUtilDetail(channelInterferenceScoreDetail);
        WifiHealthDetailVO.SubSingleHealthInfoDetailVO wirelessAccessCapacityScoreDetail = new WifiHealthDetailVO.SubSingleHealthInfoDetailVO(((TimeScoreItemVO)accessCapacityScoreList.get(lastOneIndex)).getScore(), accessCapacityScoreList);
        boolean supportCapacity = accessCapacityScoreList.stream().map(TimeScoreItemVO::getScore).anyMatch(score -> score != null && score != -1);
        wirelessAccessCapacityScoreDetail.setSupport(Boolean.valueOf(supportCapacity));
        wifiHealthDetailVO.setAccessCapacityScoreDetail(wirelessAccessCapacityScoreDetail);
        WifiHealthDetailVO.SubSingleHealthInfoDetailVO rssiScoreDetail = new WifiHealthDetailVO.SubSingleHealthInfoDetailVO(((TimeScoreItemVO)rssiScoreList.get(lastOneIndex)).getScore(), rssiScoreList);
        wifiHealthDetailVO.setRssiScoreDetail(rssiScoreDetail);
        return wifiHealthDetailVO;
    }

    public static WifiClientInfoVO c(List<DeviceHealthGridDTO> deviceGridDTOList, List<ClientHealthGridDTO> clientGridDTOList) {
        if (CollectionUtils.isEmpty(deviceGridDTOList) && CollectionUtils.isEmpty(clientGridDTOList)) {
            return null;
        }
        WifiClientInfoVO wifiClientInfoVO = new WifiClientInfoVO();
        int deviceSize = CollectionUtils.size(deviceGridDTOList);
        ArrayList channelInterInfoVOList = new ArrayList(deviceSize);
        ArrayList channelUtilInfoVOList = new ArrayList(deviceSize);
        ArrayList accessCapacityInfoVOList = new ArrayList(deviceSize);
        Optional.ofNullable(deviceGridDTOList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(gridDTO -> {
            channelInterInfoVOList.add(i.a(gridDTO));
            channelUtilInfoVOList.add(i.b(gridDTO));
            accessCapacityInfoVOList.add(i.c(gridDTO));
        });
        wifiClientInfoVO.setChannelInterfList(channelInterInfoVOList);
        wifiClientInfoVO.setChannelUtilList(channelUtilInfoVOList);
        wifiClientInfoVO.setAccessCapacityList(accessCapacityInfoVOList);
        int clientSize = CollectionUtils.size(clientGridDTOList);
        ArrayList accessTimeInfoVOList = new ArrayList(clientSize);
        ArrayList rssiInfoVOList = new ArrayList(clientSize);
        Optional.ofNullable(clientGridDTOList).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(clientHealthDTO -> {
            accessTimeInfoVOList.add(i.a(clientHealthDTO));
            rssiInfoVOList.add(i.b(clientHealthDTO));
        });
        wifiClientInfoVO.setAccessTimeList(accessTimeInfoVOList);
        wifiClientInfoVO.setRssiList(rssiInfoVOList);
        return wifiClientInfoVO;
    }

    public static List<DeviceHealthGridDTO> a(List<ApHealthScoreDTO> scoreDTOList) {
        return Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().map(scoreDTO -> i.a(scoreDTO)).filter(Objects::nonNull).toList();
    }

    private static DeviceHealthGridDTO a(ApHealthScoreDTO scoreDTO) {
        if (Objects.isNull(scoreDTO)) {
            return null;
        }
        return DeviceHealthGridDTO.builder().name(scoreDTO.getName()).mac(scoreDTO.getMac()).omadaId(scoreDTO.getOmadacId()).siteId(scoreDTO.getSiteId()).model(scoreDTO.getModel()).modelVersion(scoreDTO.getModelVersion()).ip(scoreDTO.getIp()).channelInter2g(scoreDTO.getInter2gUtil()).channelInter5g(scoreDTO.getInter5gUtil()).channelInter6g(scoreDTO.getInter6gUtil()).channelInterf(i.a(scoreDTO.getInter2gUtil(), scoreDTO.getInter5gUtil(), scoreDTO.getInter6gUtil())).channelUtil2g(scoreDTO.getChannel2gUtil()).channelUtil6g(scoreDTO.getInter6gUtil()).channelUtil5g(scoreDTO.getChannel5gUtil()).channelUtil(i.a(scoreDTO.getChannel2gUtil(), scoreDTO.getChannel5gUtil(), scoreDTO.getChannel6gUtil())).connectionClientCount(scoreDTO.getConnectCount()).build();
    }

    private static ChannelInterInfoVO a(DeviceHealthGridDTO gridDTO) {
        ChannelInterInfoVO channelInterInfoVO = new ChannelInterInfoVO();
        i.a((BaseDeviceInfoVO)channelInterInfoVO, gridDTO);
        channelInterInfoVO.setChannelInterf(gridDTO.getChannelInterf());
        return channelInterInfoVO;
    }

    private static ChannelUtilInfoVO b(DeviceHealthGridDTO gridDTO) {
        ChannelUtilInfoVO channelInterInfoVO = new ChannelUtilInfoVO();
        i.a((BaseDeviceInfoVO)channelInterInfoVO, gridDTO);
        channelInterInfoVO.setChannelUtil(gridDTO.getChannelUtil());
        return channelInterInfoVO;
    }

    private static AccessCapacityInfoVO c(DeviceHealthGridDTO gridDTO) {
        AccessCapacityInfoVO accessCapacityInfoVO = new AccessCapacityInfoVO();
        i.a((BaseDeviceInfoVO)accessCapacityInfoVO, gridDTO);
        accessCapacityInfoVO.setConnectionClientCount(gridDTO.getConnectionClientCount());
        return accessCapacityInfoVO;
    }

    private static ClientAccessTimeInfoVO a(ClientHealthGridDTO clientHealthDTO) {
        ClientAccessTimeInfoVO accessTimeInfoVO = new ClientAccessTimeInfoVO();
        i.a((BaseClientInfoVO)accessTimeInfoVO, clientHealthDTO);
        Integer associationTime = clientHealthDTO.getAssociationTime();
        accessTimeInfoVO.setAssociationTime(associationTime);
        accessTimeInfoVO.setTotalTime(associationTime);
        return accessTimeInfoVO;
    }

    private static RssiInfoVO b(ClientHealthGridDTO clientHealthDTO) {
        RssiInfoVO rssiInfoVO = new RssiInfoVO();
        i.a((BaseClientInfoVO)rssiInfoVO, clientHealthDTO);
        Integer rssi = clientHealthDTO.getRssi();
        rssiInfoVO.setRssi(rssi);
        rssiInfoVO.setSsid(clientHealthDTO.getSsid());
        rssiInfoVO.setConnectDeviceName(clientHealthDTO.getDeviceName());
        rssiInfoVO.setConnectDeviceMac(clientHealthDTO.getDeviceMac());
        return rssiInfoVO;
    }

    private static void a(BaseDeviceInfoVO baseDeviceInfoVO, DeviceHealthGridDTO gridDTO) {
        baseDeviceInfoVO.setIp(gridDTO.getIp());
        baseDeviceInfoVO.setDeviceName(gridDTO.getName());
        baseDeviceInfoVO.setMac(gridDTO.getMac());
        baseDeviceInfoVO.setModel(gridDTO.getModel());
        baseDeviceInfoVO.setModelVersion(gridDTO.getModelVersion());
        baseDeviceInfoVO.setDeviceType(StringUtils.isBlank((String)gridDTO.getDeviceType()) ? DeviceTypeEnum.a.b() : gridDTO.getDeviceType());
    }

    private static void a(BaseClientInfoVO baseClientInfoVO, ClientHealthGridDTO clientHealthDTO) {
        baseClientInfoVO.setIp(clientHealthDTO.getIp());
        baseClientInfoVO.setClientName(clientHealthDTO.getName());
        baseClientInfoVO.setMac(clientHealthDTO.getMac());
        baseClientInfoVO.setDeviceType(StringUtils.isBlank((String)clientHealthDTO.getDeviceType()) ? DeviceTypeEnum.a.b() : clientHealthDTO.getDeviceType());
    }

    public static Integer a(Integer channel2g, Integer channel5g, Integer channel6g) {
        int mixCondition = i.b(channel2g, channel5g, channel6g);
        switch (mixCondition) {
            case 1: {
                return channel2g;
            }
            case 2: {
                return channel5g;
            }
            case 4: {
                return channel6g;
            }
            case 3: {
                return Math.round(0.3f * (float)channel2g.intValue() + 0.7f * (float)channel5g.intValue());
            }
            case 6: {
                return Math.round(0.6f * (float)channel5g.intValue() + 0.4f * (float)channel6g.intValue());
            }
            case 5: {
                return Math.round(0.3f * (float)channel2g.intValue() + 0.7f * (float)channel6g.intValue());
            }
            case 7: {
                return Math.round(0.2f * (float)channel2g.intValue() + 0.5f * (float)channel5g.intValue() + 0.3f * (float)channel6g.intValue());
            }
        }
        return null;
    }

    private static boolean a(Integer scoreVal) {
        return scoreVal != null && scoreVal >= 0;
    }

    private static int b(Integer channel2g, Integer channel5g, Integer channel6g) {
        Integer channel2gCondition = i.a(channel2g) ? 1 : 0;
        Integer channel5gCondition = i.a(channel5g) ? 2 : 0;
        Integer channel6gCondition = i.a(channel6g) ? 4 : 0;
        return channel2gCondition | channel5gCondition | channel6gCondition;
    }
}

