/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.health.core.c.a;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthScoreDTO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.OswHealthDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeValueItemVO;
import com.tplink.smb.omada.insight.health.core.c.a.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class g {
    private g() {
    }

    public static OswHealthDetailVO a(List<OswHealthScoreDTO> scoreDTOList, List<Long> timeList) {
        if (CollectionUtils.isEmpty(timeList)) {
            return null;
        }
        Map<Long, OswHealthScoreDTO> oswHealthScoreMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        int timeSize = timeList.size();
        ArrayList<TimeValueItemVO> cpuUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> memUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> temperatureList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> packetLossList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> errorFrameList = new ArrayList<TimeValueItemVO>(timeSize);
        for (Long time : timeList) {
            OswHealthScoreDTO scoreDTO = oswHealthScoreMap.get(time);
            if (Objects.isNull(scoreDTO)) {
                cpuUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                memUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                temperatureList.add(TimeValueItemVO.createNullValueVO((Long)time));
                packetLossList.add(TimeValueItemVO.createNullValueVO((Long)time));
                errorFrameList.add(TimeValueItemVO.createNullValueVO((Long)time));
                continue;
            }
            cpuUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getCpuUtil(), (Long)time));
            memUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getMemUtil(), (Long)time));
            temperatureList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getTemperature(), (Long)time));
            packetLossList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getPortPktsLoss(), (Long)time));
            errorFrameList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getErrorFrameUtil(), (Long)time));
        }
        OswHealthDetailVO oswHealthDetailVO = new OswHealthDetailVO();
        Long lastTime = timeList.get(timeSize - 1);
        OswHealthScoreDTO lastOne = oswHealthScoreMap.get(lastTime);
        oswHealthDetailVO.setScore(e.a(lastOne, () -> lastOne.getScore()));
        g.a(lastOne);
        oswHealthDetailVO.setCpu(e.a(cpuUtilList, e.b(lastOne, () -> lastOne.getCpuUtilScore())));
        oswHealthDetailVO.setMemory(e.a(memUtilList, e.b(lastOne, () -> lastOne.getMemUtilScore())));
        oswHealthDetailVO.setTemperature(e.a(temperatureList, e.b(lastOne, () -> lastOne.getTemperatureScore())));
        oswHealthDetailVO.setPacketLoss(e.a(packetLossList, e.b(lastOne, () -> lastOne.getPortPktsLossScore())));
        oswHealthDetailVO.setErrorFrame(e.a(errorFrameList, e.b(lastOne, () -> lastOne.getErrorFrameUtilScore())));
        oswHealthDetailVO.getTemperature().setSupport(Boolean.valueOf(oswHealthScoreMap.values().stream().anyMatch(dto -> dto.getTemperature() != null && !Objects.equals(dto.getTemperatureScore(), -1))));
        return oswHealthDetailVO;
    }

    private static void a(OswHealthScoreDTO lastOne) {
        if (e.a(lastOne, BaseHealthScoreDTO::getScore, -1) && e.a(lastOne.getCpuUtilScore()) && e.a(lastOne.getMemUtilScore()) && e.a(lastOne.getTemperatureScore()) && e.a(lastOne.getPortPktsLossScore()) && e.a(lastOne.getErrorFrameUtilScore())) {
            lastOne.setCpuUtilScore(Integer.valueOf(-1));
            lastOne.setMemUtilScore(Integer.valueOf(-1));
            lastOne.setTemperatureScore(Integer.valueOf(-1));
            lastOne.setPortPktsLossScore(Integer.valueOf(-1));
            lastOne.setErrorFrameUtilScore(Integer.valueOf(-1));
        }
    }
}

