/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.health.core.c.a;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.OsgHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.WanHealthLevelDTO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.OsgHealthDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeValueItemVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.ChannelSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.health.core.c.a.e;
import com.tplink.smb.omada.insight.health.core.port.ap.RadioIdDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class f {
    private f() {
    }

    public static OsgHealthDetailVO a(List<OsgHealthScoreDTO> scoreDTOList, List<WanHealthLevelDTO> wanHealthLevelDTOList, List<Long> timeList, RadioIdDTO radioIdDTO) {
        if (CollectionUtils.isEmpty(timeList)) {
            return null;
        }
        Map<Long, OsgHealthScoreDTO> osgHealthScoreMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        Map<Long, WanHealthLevelDTO> wanHealthScoreMap = Optional.ofNullable(wanHealthLevelDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(WanHealthLevelDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        int size = CollectionUtils.size(timeList);
        ArrayList<TimeValueItemVO> cpuUtilList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> memUtilList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> temperatureList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> wanLatencyList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> channel2gUtilList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> channel5gUtilList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> channel6gUtilList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> txRetryList = new ArrayList<TimeValueItemVO>(size);
        ArrayList<TimeValueItemVO> txDropList = new ArrayList<TimeValueItemVO>(size);
        for (Long time : timeList) {
            OsgHealthScoreDTO scoreDTO = osgHealthScoreMap.get(time);
            if (Objects.isNull(scoreDTO)) {
                cpuUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                memUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                temperatureList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel2gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel5gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel6gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                txRetryList.add(TimeValueItemVO.createNullValueVO((Long)time));
                txDropList.add(TimeValueItemVO.createNullValueVO((Long)time));
            } else {
                cpuUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getCpuUtil(), (Long)time));
                memUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getMemUtil(), (Long)time));
                temperatureList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getTemperature(), (Long)time));
                channel2gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getChannel2gUtil(), (Long)time));
                channel5gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getChannel5gUtil(), (Long)time));
                channel6gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                Integer txRetry = e.a(scoreDTO.getTxRetryRate2g(), scoreDTO.getTxRetryRate5g(), scoreDTO.getTxRetryRate5g2(), null);
                Integer txDrop = e.a(scoreDTO.getTxDropRate2g(), scoreDTO.getTxDropRate5g(), scoreDTO.getTxDropRate5g2(), null);
                txRetryList.add(TimeValueItemVO.createMillSecondVO((Integer)txRetry, (Long)time));
                txDropList.add(TimeValueItemVO.createMillSecondVO((Integer)txDrop, (Long)time));
            }
            WanHealthLevelDTO wanHealthLevelDTO = wanHealthScoreMap.get(time);
            if (Objects.nonNull(wanHealthLevelDTO)) {
                wanLatencyList.add(TimeValueItemVO.createMillSecondVO((Integer)wanHealthLevelDTO.getLatency(), (Long)time));
                continue;
            }
            wanLatencyList.add(TimeValueItemVO.createNullValueVO((Long)time));
        }
        OsgHealthDetailVO osgHealthDetailVO = new OsgHealthDetailVO();
        Long lastTime = timeList.get(size - 1);
        OsgHealthScoreDTO lastOsgOne = osgHealthScoreMap.get(lastTime);
        osgHealthDetailVO.setScore(e.a(lastOsgOne, () -> lastOsgOne.getScore()));
        WanHealthLevelDTO lastWanOne = wanHealthScoreMap.get(lastTime);
        f.a(lastOsgOne);
        osgHealthDetailVO.setCpu(e.a(cpuUtilList, e.b(lastOsgOne, () -> lastOsgOne.getCpuUtilScore())));
        osgHealthDetailVO.setMemory(e.a(memUtilList, e.b(lastOsgOne, () -> lastOsgOne.getMemUtilScore())));
        osgHealthDetailVO.setTemperature(e.a(temperatureList, e.b(lastOsgOne, () -> lastOsgOne.getTemperatureScore())));
        ChannelSubHealthInfoDetailVO channelUtil = e.a(channel2gUtilList, channel5gUtilList, channel6gUtilList, e.b(lastOsgOne, () -> lastOsgOne.getChannelUtilScore()), RadioIdDTO.allSupportInstance());
        channelUtil.setSupport(Boolean.valueOf(false));
        osgHealthDetailVO.setChannelUtil(channelUtil);
        if (radioIdDTO.supportWireless()) {
            ChannelSubHealthInfoDetailVO supportedChannelUtil = e.a(channel2gUtilList, channel5gUtilList, channel6gUtilList, e.b(lastOsgOne, () -> lastOsgOne.getChannelUtilScore()), radioIdDTO);
            osgHealthDetailVO.setSupportedChannelUtil(supportedChannelUtil);
            supportedChannelUtil.setSupport(Boolean.valueOf(true));
        }
        osgHealthDetailVO.setTransmission(e.a(txRetryList, txDropList, e.b(lastOsgOne, () -> lastOsgOne.getTxQualityScore())));
        osgHealthDetailVO.setWanLatency(e.a(wanLatencyList, e.a(lastWanOne, () -> lastWanOne.getScore())));
        osgHealthDetailVO.getTemperature().setSupport(Boolean.valueOf(osgHealthScoreMap.values().stream().anyMatch(dto -> dto.getTemperature() != null && !Objects.equals(dto.getTemperatureScore(), -1))));
        return osgHealthDetailVO;
    }

    private static void a(OsgHealthScoreDTO lastOsgOne) {
        if (e.a(lastOsgOne, BaseHealthScoreDTO::getScore, -1) && e.a(lastOsgOne.getCpuUtilScore()) && e.a(lastOsgOne.getMemUtilScore()) && e.a(lastOsgOne.getTemperatureScore()) && e.a(lastOsgOne.getChannelUtilScore()) && e.a(lastOsgOne.getTxQualityScore())) {
            lastOsgOne.setCpuUtilScore(Integer.valueOf(-1));
            lastOsgOne.setMemUtilScore(Integer.valueOf(-1));
            lastOsgOne.setTemperatureScore(Integer.valueOf(-1));
            lastOsgOne.setChannelUtilScore(Integer.valueOf(-1));
            lastOsgOne.setTxQualityScore(Integer.valueOf(-1));
        }
    }
}

