/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.health.core.c.a;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeScoreItemVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeValueItemVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.ChannelSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.CommonSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.TransmissionSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.health.core.port.a.a;
import com.tplink.smb.omada.insight.health.core.port.ap.RadioIdDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class e {
    private e() {
    }

    public static CommonSubHealthInfoDetailVO a(List<TimeValueItemVO> timeValueList, Integer score) {
        Integer averageNum = e.a(timeValueList);
        CommonSubHealthInfoDetailVO subHealthInfoDetailVO = new CommonSubHealthInfoDetailVO(score, averageNum, timeValueList);
        return subHealthInfoDetailVO;
    }

    public static ChannelSubHealthInfoDetailVO a(List<TimeValueItemVO> channel2gList, List<TimeValueItemVO> channel5gList, List<TimeValueItemVO> channel6gList, Integer channelScore, RadioIdDTO radioIdDTO) {
        if (radioIdDTO == null) {
            return null;
        }
        Integer average2g = radioIdDTO.isSupport2g() ? e.a(channel2gList) : null;
        Integer average5g = radioIdDTO.isSupport5g() ? e.a(channel5gList) : null;
        Integer average6g = radioIdDTO.isSupport6g() ? e.a(channel6gList) : null;
        channel2gList = radioIdDTO.isSupport2g() ? channel2gList : null;
        channel5gList = radioIdDTO.isSupport5g() ? channel5gList : null;
        channel6gList = radioIdDTO.isSupport6g() ? channel6gList : null;
        ChannelSubHealthInfoDetailVO detailVO = new ChannelSubHealthInfoDetailVO(average2g, average5g, average6g, channel2gList, channel5gList, channel6gList);
        detailVO.setSummaryScore(channelScore);
        return detailVO;
    }

    public static TransmissionSubHealthInfoDetailVO a(List<TimeValueItemVO> txRetryList, List<TimeValueItemVO> txDropList, Integer score) {
        Integer txRetryAverageNum = e.a(txRetryList);
        Integer txDropAverageNum = e.a(txDropList);
        TransmissionSubHealthInfoDetailVO transmissionSubHealthInfoDetailVO = new TransmissionSubHealthInfoDetailVO(txRetryAverageNum, txDropAverageNum, txRetryList, txDropList);
        transmissionSubHealthInfoDetailVO.setSummaryScore(score);
        return transmissionSubHealthInfoDetailVO;
    }

    public static List<TimeScoreItemVO> a(List<? extends BaseHealthScoreDTO> scoreDTOList, List<Long> timeList) {
        if (CollectionUtils.isEmpty(timeList)) {
            return Collections.emptyList();
        }
        Map<Long, BaseHealthScoreDTO> healthScoreDTOMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        return timeList.stream().map(time -> {
            BaseHealthScoreDTO healthScoreDTO = (BaseHealthScoreDTO)healthScoreDTOMap.get(time);
            TimeScoreItemVO timeScoreItemVO = TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time);
            if (Objects.nonNull(healthScoreDTO)) {
                timeScoreItemVO = TimeScoreItemVO.createMillSecondVO((Integer)healthScoreDTO.getScore(), (Long)healthScoreDTO.getTimestamp());
            }
            return timeScoreItemVO;
        }).toList();
    }

    public static List<TimeScoreItemVO> a(List<? extends BaseHealthScoreDTO> scoreDTOList, Long end) {
        if (CollectionUtils.isEmpty(scoreDTOList)) {
            return e.a(end);
        }
        Map<Long, BaseHealthScoreDTO> healthScoreDTOMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        long lastValidFormatTime = end / 600L * 600L;
        BaseHealthScoreDTO lastOne = healthScoreDTOMap.get(lastValidFormatTime);
        BaseHealthScoreDTO lastSecondOne = healthScoreDTOMap.get(lastValidFormatTime - 600L);
        BaseHealthScoreDTO lastThirdOne = healthScoreDTOMap.get(lastValidFormatTime - 1200L);
        lastValidFormatTime = Objects.nonNull(lastOne) ? lastOne.getTimestamp() : (Objects.nonNull(lastSecondOne) ? lastSecondOne.getTimestamp() : (Objects.nonNull(lastThirdOne) ? lastThirdOne.getTimestamp() : (lastValidFormatTime -= 1200L)));
        ArrayList<Long> timePoints = new ArrayList<Long>();
        for (long current = lastValidFormatTime - 86400L + 600L; current <= lastValidFormatTime; current += 600L) {
            timePoints.add(current);
        }
        List<TimeScoreItemVO> timeScoreItemVOList = timePoints.stream().map(time -> {
            BaseHealthScoreDTO healthScoreDTO = (BaseHealthScoreDTO)healthScoreDTOMap.get(time);
            return Objects.nonNull(healthScoreDTO) ? TimeScoreItemVO.createMillSecondVO((Integer)healthScoreDTO.getScore(), (Long)healthScoreDTO.getTimestamp()) : TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time);
        }).collect(Collectors.toList());
        return timeScoreItemVOList;
    }

    public static Integer a(List<TimeValueItemVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List<TimeValueItemVO> validList = list.stream().filter(timeValue -> Objects.nonNull(timeValue) && Objects.nonNull(timeValue.getPastNum())).toList();
        if (CollectionUtils.isEmpty(validList)) {
            return null;
        }
        int sum = validList.stream().mapToInt(TimeValueItemVO::getPastNum).sum();
        int count = validList.size();
        return Math.round((float)sum / (float)count);
    }

    public static Integer a(Integer channel2g, Integer channel5g, Integer channel5g2, Integer channel6g) {
        int mixCondition = e.b(channel2g, channel5g, channel5g2, channel6g);
        switch (mixCondition) {
            case 1: {
                return channel2g;
            }
            case 2: {
                return e.a(channel5g, channel5g2);
            }
            case 4: {
                return channel6g;
            }
            case 3: {
                Integer channel5gScore1 = e.a(channel5g, channel5g2);
                return Math.round(0.3f * (float)channel2g.intValue() + 0.7f * (float)(Objects.isNull(channel5gScore1) ? 0 : channel5gScore1));
            }
            case 6: {
                Integer channel5gScore2 = e.a(channel5g, channel5g2);
                return Math.round(0.6f * (float)(Objects.isNull(channel5gScore2) ? 0 : channel5gScore2) + 0.4f * (float)channel6g.intValue());
            }
            case 5: {
                return Math.round(0.3f * (float)channel2g.intValue() + 0.7f * (float)channel6g.intValue());
            }
            case 7: {
                Integer channel5gScore3 = e.a(channel5g, channel5g2);
                return Math.round(0.2f * (float)channel2g.intValue() + 0.5f * (float)(Objects.isNull(channel5gScore3) ? 0 : channel5gScore3) + 0.3f * (float)channel6g.intValue());
            }
        }
        return null;
    }

    public static <T> Integer a(T dto, Supplier<Integer> scoreSupplier) {
        return dto != null && scoreSupplier != null ? Optional.ofNullable(scoreSupplier.get()).orElse(-1) : -1;
    }

    public static <T> Integer b(T dto, Supplier<Integer> scoreSupplier) {
        Integer score = e.a(dto, scoreSupplier);
        return score == 0 ? -1 : score;
    }

    public static <T, R> boolean a(T data, Function<T, R> function, R expectedVal) {
        return Objects.nonNull(data) && Objects.equals(function.apply(data), expectedVal);
    }

    public static boolean a(Integer val) {
        return Objects.isNull(val) || Objects.equals(val, 0);
    }

    private static List<TimeScoreItemVO> a(Long end) {
        Long start = end - 86400L;
        List<Long> timeList = a.b(start, end, 600);
        if (CollectionUtils.isEmpty(timeList)) {
            return Collections.emptyList();
        }
        List<TimeScoreItemVO> timeScoreItemVOList = timeList.stream().map(time -> TimeScoreItemVO.createMillSecondVO((Integer)-1, (Long)time)).collect(Collectors.toList());
        return timeScoreItemVOList;
    }

    private static boolean b(Integer scoreVal) {
        return scoreVal != null && scoreVal >= 0;
    }

    private static int b(Integer channel2g, Integer channel5g, Integer channel5g2, Integer channel6g) {
        Integer channel2gCondition = e.b(channel2g) ? 1 : 0;
        Integer channel5gCondition = e.b(channel5g) || e.b(channel5g2) ? 2 : 0;
        Integer channel6gCondition = e.b(channel6g) ? 4 : 0;
        return channel2gCondition | channel5gCondition | channel6gCondition;
    }

    private static Integer a(Integer channel5g, Integer channel5g2) {
        boolean isValid5g = e.b(channel5g);
        boolean isValid5g2 = e.b(channel5g2);
        if (isValid5g && isValid5g2) {
            return Math.round(0.5f * (float)channel5g.intValue() + 0.5f * (float)channel5g2.intValue());
        }
        if (isValid5g2) {
            return channel5g2;
        }
        if (isValid5g) {
            return channel5g;
        }
        return null;
    }
}

