/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.health.core.c.a;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthScoreDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApHealthScoreDTO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.ApHealthDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.TimeValueItemVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.ChannelSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.CommonSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.api.web.healthv2.vo.sub.TransmissionSubHealthInfoDetailVO;
import com.tplink.smb.omada.insight.health.core.c.a.e;
import com.tplink.smb.omada.insight.health.core.port.ap.RadioIdDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class c {
    private c() {
    }

    public static ApHealthDetailVO a(List<ApHealthScoreDTO> scoreDTOList, List<Long> timeList, RadioIdDTO radioIdDTO) {
        if (CollectionUtils.isEmpty(timeList)) {
            return null;
        }
        Map<Long, ApHealthScoreDTO> apHealthScoreMap = Optional.ofNullable(scoreDTOList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseHealthScoreDTO::getTimestamp, vo -> vo, (existing, replacement) -> replacement));
        int timeSize = timeList.size();
        ArrayList<TimeValueItemVO> channel2gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> channel5gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> channel6gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> inter2gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> inter5gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> inter6gUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> cpuUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> memUtilList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> txRetryList = new ArrayList<TimeValueItemVO>(timeSize);
        ArrayList<TimeValueItemVO> txDropList = new ArrayList<TimeValueItemVO>(timeSize);
        for (Long time : timeList) {
            ApHealthScoreDTO scoreDTO = apHealthScoreMap.get(time);
            if (Objects.isNull(scoreDTO)) {
                cpuUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                memUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel2gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel5gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                channel6gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                inter2gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                inter5gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                inter6gUtilList.add(TimeValueItemVO.createNullValueVO((Long)time));
                txRetryList.add(TimeValueItemVO.createNullValueVO((Long)time));
                txDropList.add(TimeValueItemVO.createNullValueVO((Long)time));
                continue;
            }
            cpuUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getCpuUtil(), (Long)time));
            memUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getMemUtil(), (Long)time));
            channel2gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getChannel2gUtil(), (Long)time));
            channel5gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getChannel5gUtil(), (Long)time));
            channel6gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getChannel6gUtil(), (Long)time));
            inter2gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getInter2gUtil(), (Long)time));
            inter5gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getInter5gUtil(), (Long)time));
            inter6gUtilList.add(TimeValueItemVO.createMillSecondVO((Integer)scoreDTO.getInter6gUtil(), (Long)time));
            Integer txRetry = e.a(scoreDTO.getTxRetryRate2g(), scoreDTO.getTxRetryRate5g(), scoreDTO.getTxRetryRate5g2(), scoreDTO.getTxRetryRate6g());
            Integer txDrop = e.a(scoreDTO.getTxDropRate2g(), scoreDTO.getTxDropRate5g(), scoreDTO.getTxDropRate5g2(), scoreDTO.getTxDropRate6g());
            txRetryList.add(TimeValueItemVO.createMillSecondVO((Integer)txRetry, (Long)time));
            txDropList.add(TimeValueItemVO.createMillSecondVO((Integer)txDrop, (Long)time));
        }
        ApHealthDetailVO apHealthDetailVO = new ApHealthDetailVO();
        Long lastTime = timeList.get(timeSize - 1);
        ApHealthScoreDTO lastOne = apHealthScoreMap.get(lastTime);
        apHealthDetailVO.setScore(e.a(lastOne, () -> lastOne.getScore()));
        c.a(lastOne);
        RadioIdDTO allSupport = RadioIdDTO.allSupportInstance();
        ChannelSubHealthInfoDetailVO channelUtilDetailVO = e.a(channel2gUtilList, channel5gUtilList, channel6gUtilList, e.b(lastOne, () -> lastOne.getChannelUtilScore()), allSupport);
        channelUtilDetailVO.setSupport(Boolean.valueOf(false));
        apHealthDetailVO.setChannelUtil(channelUtilDetailVO);
        ChannelSubHealthInfoDetailVO supportedChannelUtilDetailVO = e.a(channel2gUtilList, channel5gUtilList, channel6gUtilList, e.b(lastOne, () -> lastOne.getChannelUtilScore()), radioIdDTO);
        apHealthDetailVO.setSupportedChannelUtil(supportedChannelUtilDetailVO);
        ChannelSubHealthInfoDetailVO interUtilDetailVO = e.a(inter2gUtilList, inter5gUtilList, inter6gUtilList, e.b(lastOne, () -> lastOne.getInterUtilScore()), allSupport);
        interUtilDetailVO.setSupport(Boolean.valueOf(false));
        apHealthDetailVO.setChannelInterf(interUtilDetailVO);
        ChannelSubHealthInfoDetailVO supportedInterUtilDetailVO = e.a(inter2gUtilList, inter5gUtilList, inter6gUtilList, e.b(lastOne, () -> lastOne.getInterUtilScore()), radioIdDTO);
        apHealthDetailVO.setSupportedChannelInterf(supportedInterUtilDetailVO);
        CommonSubHealthInfoDetailVO cpuUtilDetailVO = e.a(cpuUtilList, e.b(lastOne, () -> lastOne.getCpuUtilScore()));
        apHealthDetailVO.setCpu(cpuUtilDetailVO);
        CommonSubHealthInfoDetailVO memUtilDetailVO = e.a(memUtilList, e.b(lastOne, () -> lastOne.getMemUtilScore()));
        apHealthDetailVO.setMemory(memUtilDetailVO);
        TransmissionSubHealthInfoDetailVO subHealthInfoDetailVO = e.a(txRetryList, txDropList, e.b(lastOne, () -> lastOne.getTransmissionQualityScore()));
        apHealthDetailVO.setTransmission(subHealthInfoDetailVO);
        boolean supportInterUtil = apHealthScoreMap.values().stream().map(ApHealthScoreDTO::getInterUtilScore).anyMatch(score -> score != null && !Objects.equals(score, -1));
        apHealthDetailVO.getSupportedChannelInterf().setSupport(Boolean.valueOf(supportInterUtil));
        return apHealthDetailVO;
    }

    private static void a(ApHealthScoreDTO lastOne) {
        if (e.a(lastOne, BaseHealthScoreDTO::getScore, -1) && e.a(lastOne.getChannelUtilScore()) && e.a(lastOne.getInterUtilScore()) && e.a(lastOne.getCpuUtilScore()) && e.a(lastOne.getMemUtilScore()) && e.a(lastOne.getTransmissionQualityScore())) {
            lastOne.setChannelUtilScore(Integer.valueOf(-1));
            lastOne.setInterUtilScore(Integer.valueOf(-1));
            lastOne.setCpuUtilScore(Integer.valueOf(-1));
            lastOne.setMemUtilScore(Integer.valueOf(-1));
            lastOne.setTransmissionQualityScore(Integer.valueOf(-1));
        }
    }
}

