/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.schedule;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduleTrigger;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.component.schedule.api.triggers.TimestampTrigger;
import com.tplink.smb.omada.client.common.domain.a.j;
import com.tplink.smb.omada.client.common.domain.model.shared.SchedulerCustomProperties;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.lock.b.b;
import com.tplink.smb.omada.portal.domain.model.c.a;
import com.tplink.smb.omada.portal.domain.model.c.g;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.common.spring.b
public class c
implements ScheduledEventHandler {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(c.class);
    public static final long a = TimeUnit.SECONDS.toMillis(30L);
    public static final String b = "auth.timeout";
    @Autowired
    private ScheduleCenter d;
    @Autowired
    private g e;
    @Autowired
    private LockService f;
    @Autowired
    private SchedulerCustomProperties g;
    @Autowired
    private a h;
    @Autowired
    private j i;
    @Autowired
    @Qualifier(value="authTimeoutExecutor")
    private ExecutorService j;

    @PostConstruct
    public void a() {
        com.tplink.smb.omada.common.concurrent.thread.a.a(() -> {
            long currentTimeMillis = System.currentTimeMillis();
            long delayMs = TimeUnit.SECONDS.toMillis(60 + new Random().nextInt(60));
            int shardingSize = this.g.getShardingSizeOf("client_auth_timeout");
            List existingTasks = this.d.findTasksByTaskName("client_auth_timeout");
            if (CollectionUtils.isEmpty((Collection)existingTasks)) {
                this.d.saveTask(ScheduleTask.builder().withIdentity("client_auth_timeout").withEnableSharding(Integer.valueOf(shardingSize)).withTimestampTrigger(Long.valueOf(currentTimeMillis + delayMs)).build());
            } else {
                for (ScheduleTask task : existingTasks) {
                    Long nextTriggerTime;
                    if (!(task.getScheduleTrigger() instanceof TimestampTrigger) || (nextTriggerTime = ((TimestampTrigger)task.getScheduleTrigger()).getTimestamp()) != null && nextTriggerTime >= currentTimeMillis) continue;
                    task.setScheduleTrigger((ScheduleTrigger)TimestampTrigger.by((Long)(currentTimeMillis + a)));
                    this.d.saveTask(task);
                }
            }
            this.d.registerEventHandler("client_auth_timeout", (ScheduledEventHandler)this, this.j);
            this.d.addSystemTimeChangedListener(() -> {
                c.debug("System time changed, update {} task.", (Object)"client_auth_timeout");
                this.d.updateTimestamp(TaskKey.of((String)"client_auth_timeout"), Long.valueOf(System.currentTimeMillis() + a));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ScheduledEvent scheduledEvent) {
        int shardingSize = scheduledEvent.getShardingParam().getShardingSize();
        int shardingIndex = scheduledEvent.getShardingParam().getShardingIndex();
        try {
            this.a(shardingSize, shardingIndex);
        }
        finally {
            long currentTimeMillis = System.currentTimeMillis();
            this.d.saveTask(ScheduleTask.builder().withIdentity("client_auth_timeout").withEnableSharding(Integer.valueOf(this.g.getShardingSizeOf("client_auth_timeout"))).withTimestampTrigger(Long.valueOf(currentTimeMillis + a)).build());
        }
    }

    private void a(int shardingSize, int shardingIndex) {
        Set<r> omadacIds = this.h.b(shardingIndex);
        c.debug("Running Task<{}>: omadacIds<{}>, shardSize<{}>, shardIndex<{}>", new Object[]{"client_auth_timeout", omadacIds, shardingSize, shardingIndex});
        if (CollectionUtils.isEmpty(omadacIds)) {
            return;
        }
        for (r omadacId : omadacIds) {
            if (this.i.a(omadacId)) {
                c.debug("OmadacId={} is restoring", (Object)omadacId);
                return;
            }
            this.a(omadacId, () -> {
                try {
                    long start = System.nanoTime();
                    c.trace("Check TimeoutAuthRecords of omadac: {}", (Object)omadacId);
                    this.e.a(omadacId);
                    c.trace("Check TimeoutAuthRecords of omadac: {} finished in {} ms", (Object)omadacId, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
                catch (Exception e2) {
                    c.warn("Check TimeoutAuthRecords of omadac: {} with exception", (Object)omadacId, (Object)e2);
                }
                return true;
            }, () -> {
                c.info("Skipping check TimeoutAuthRecords of omadac: {}. tryLock failed", (Object)omadacId);
                return false;
            });
        }
    }

    private void a(@Nonnull r omadacId, @Nonnull Supplier<Object> onSynchronized, @Nonnull Supplier<Object> onLockFailed) {
        this.f.doWithTryLock(com.tplink.smb.omada.lock.b.b.a((String)"portal", (String)b), (Object)com.tplink.smb.omada.lock.b.b.a((String[])new String[]{"omadac.id", omadacId.a()}), onSynchronized, onLockFailed);
    }
}

