/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.schedule;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.client.common.domain.model.shared.SchedulerCustomProperties;
import com.tplink.smb.omada.client.common.port.c.a;
import com.tplink.smb.omada.portal.port.radius.task.RadiusAccountingScheduleProperties;
import com.tplink.smb.omada.portal.port.schedule.j;
import com.tplink.smb.omada.portal.port.schedule.k;
import com.tplink.smb.omada.portal.port.schedule.l;
import com.tplink.smb.omada.portal.port.schedule.m;
import com.tplink.smb.omada.portal.port.schedule.n;
import com.tplink.smb.omada.portal.port.schedule.o;
import com.tplink.smb.omada.portal.port.schedule.p;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class PortalScheduleExecutorConfiguration {
    @Autowired
    private SchedulerCustomProperties a;
    @Autowired
    private RadiusAccountingScheduleProperties b;
    @Autowired
    private com.tplink.smb.omada.portal.port.c.a c;
    @Autowired
    private a d;

    @Bean(value={"authTimeoutExecutor"})
    @ConditionalOnMissingBean(name={"authTimeoutExecutor"})
    public ExecutorService authTimeoutExecutor() {
        int shardingSize = this.a.getShardingSizeOf("client_auth_timeout");
        String executorName = "auth-timeout-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, shardingSize, 120000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new j(this));
        return this.d.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"facebookPeriodVerifyExecutor"})
    @ConditionalOnMissingBean(name={"facebookPeriodVerifyExecutor"})
    public ExecutorService facebookPeriodVerifyExecutor() {
        int shardingSize = this.a.getShardingSizeOf("client_auth_timeout");
        String executorName = "facebook-period-verify-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, shardingSize, 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new k(this));
        return this.d.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"facebookV2PeriodVerifyExecutor"})
    @ConditionalOnMissingBean(name={"facebookV2PeriodVerifyExecutor"})
    public ExecutorService facebookV2PeriodVerifyExecutor() {
        int shardingSize = this.a.getShardingSizeOf("client_auth_timeout");
        String executorName = "facebook-v2-period-verify-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, shardingSize, 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new l(this));
        return this.d.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"voucherClearExecutor"})
    @ConditionalOnMissingBean(name={"voucherClearExecutor"})
    public ExecutorService voucherClearExecutor() {
        int shardingSize = this.a.getShardingSizeOf("client_voucher_period_verify");
        String executorName = "expired-voucher-clear-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, shardingSize, 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new m(this));
        return this.d.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"radiusAccountingExecutor"})
    @ConditionalOnMissingBean(name={"radiusAccountingExecutor"})
    public ExecutorService radiusAccountingExecutor() {
        int corePoolSize = this.b.getCorePoolSize();
        int maximumPoolSize = this.b.getMaximumPoolSize();
        int queueCapacity = this.b.getQueueCapacity();
        int keepAliveTime = this.b.getKeepAliveTime();
        String threadPoolName = "client-radius-accounting-schedule-powercontrol-pool";
        ThreadPoolExecutor radiusAccountingExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new ThreadFactoryBuilder().setNameFormat(threadPoolName + "-%d").build(), new n(this));
        return this.d.a((ExecutorService)radiusAccountingExecutor, threadPoolName);
    }

    @Bean(value={"portalFileTimeoutExecutor"})
    @ConditionalOnMissingBean(name={"portalFileTimeoutExecutor"})
    public ExecutorService portalFileTimeoutExecutor() {
        String executorName = "portal-file-timeout-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new o(this));
        return this.d.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"localuserDailyLimitUpdateExecutor"})
    @ConditionalOnMissingBean(name={"localuserDailyLimitUpdateExecutor"})
    public ExecutorService localuserDailyLimitUpdateExecutor() {
        String executorName = "localuser-daily-limit-update-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(3000), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new p(this));
        return this.d.a((ExecutorService)executor, executorName);
    }
}

