/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.radius.acct;

import com.tplink.smb.omada.client.common.domain.a.i;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.gridquery.d;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.system.b;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.QueryRadiusProfileDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.RadiusProfileDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.embed.RadiusAcctServerDTO;
import com.tplink.smb.omada.portal.domain.model.c.f;
import com.tplink.smb.omada.portal.domain.model.c.q;
import com.tplink.smb.omada.portal.domain.model.h.O;
import com.tplink.smb.omada.portal.domain.model.h.Q;
import com.tplink.smb.omada.portal.domain.model.h.U;
import com.tplink.smb.omada.portal.domain.model.h.f.e;
import com.tplink.smb.omada.portal.domain.model.h.r;
import com.tplink.smb.omada.portal.domain.model.shared.p;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.VendorSpecificAttribute;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

@Component
public class c
implements com.tplink.smb.omada.portal.port.radius.acct.b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private com.tplink.smb.omada.client.common.domain.a.c b;
    @Autowired
    private f c;
    @Autowired
    private Q d;
    @Autowired
    private e e;
    @Autowired
    private com.tplink.smb.omada.portal.port.c.b f;
    @Autowired
    private com.tplink.smb.omada.portal.port.radius.d.c g;
    @Autowired
    private i h;
    private final NioEventLoopGroup i = new NioEventLoopGroup();
    private static final int j = 30000;
    private static final int k = 50000;
    private final Random l = new Random();

    @PreDestroy
    public void a() {
        if (this.i != null) {
            this.i.shutdownGracefully();
            a.info("shutdown nioEventLoopGroup when bean RadiusAcctService closed");
        }
    }

    public c() {
        a.info("init nioEventLoopGroup");
    }

    @Override
    public OperationResponse<q> a(com.tplink.smb.omada.portal.port.radius.a.a acctRequest) {
        OperationResponse<q> ops = new OperationResponse<q>(com.tplink.smb.omada.common.g.b.b, null);
        RadiusProfileDTO radiusProfile = acctRequest.n();
        if (CollectionUtils.isEmpty((Collection)radiusProfile.getAcctServer()) || !Boolean.TRUE.equals(radiusProfile.getRadiusAccountingEnable())) {
            return ops;
        }
        for (RadiusAcctServerDTO acctServerDTO : radiusProfile.getAcctServer()) {
            com.tplink.smb.omada.portal.port.radius.d.a rc = new com.tplink.smb.omada.portal.port.radius.d.a(this.g, acctServerDTO.getAccountingServerIp(), acctServerDTO.getAccountingServerPwd());
            rc.setAcctPort(acctServerDTO.getAccountingServerPort());
            acctRequest.b(acctServerDTO.getAccountingServerIp());
            ops = this.a(rc, acctRequest);
            if (!ops.success()) continue;
            break;
        }
        return ops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResponse<q> a(RadiusClient rc, com.tplink.smb.omada.portal.port.radius.a.a acctRequest) {
        AccountingRequest ar2 = this.b(acctRequest);
        if (ar2 == null) {
            a.warn("Failed to build Accounting-Request(Start).");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.b, null);
        }
        try {
            RadiusPacket response = rc.account(ar2);
            if (response.getPacketType() == 5) {
                a.debug("Radius server has handled accounting request.");
                OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)acctRequest.d());
                return operationResponse;
            }
            a.warn("Unexpected response packet type of Accounting-Request is {}.", (Object)response.getPacketType());
        }
        catch (com.tplink.smb.omada.portal.port.radius.c.a e2) {
            a.warn("Accounting start error.");
        }
        catch (RadiusException e3) {
            a.warn("Radius protocol error.");
            a.debug(e3.toString(), (Throwable)e3);
        }
        catch (SocketTimeoutException e4) {
            a.warn("Connect Radius timeout.");
            a.debug(e4.toString(), (Throwable)e4);
        }
        catch (IOException e5) {
            a.warn("IOException occurs when connecting Radius server.");
            a.debug(e5.toString(), (Throwable)e5);
        }
        finally {
            rc.close();
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.b, null);
    }

    private AccountingRequest b(com.tplink.smb.omada.portal.port.radius.a.a acctRequest) {
        long acctDelayTime;
        int acctStatusType;
        if (acctRequest.o() == null) {
            a.error("Portal setting had no valid RADIUS accounting setting.");
            return null;
        }
        q clientInfo = acctRequest.d();
        q.a accountingPhase = q.a.a(clientInfo.k());
        if (!q.a.a(accountingPhase)) {
            a.error("Unexpected Accounting-Status-Type");
            return null;
        }
        long now = W.a();
        switch (accountingPhase) {
            case b: {
                acctStatusType = 1;
                if (clientInfo.g() == 0L) {
                    clientInfo.c(now);
                }
                acctDelayTime = now - clientInfo.g();
                break;
            }
            case d: {
                acctStatusType = 2;
                if (clientInfo.j() == 0L) {
                    clientInfo.f(now);
                }
                acctDelayTime = now - clientInfo.j();
                break;
            }
            case c: {
                acctStatusType = 3;
                long lastSeen = this.b.c(acctRequest.b(), acctRequest.c(), acctRequest.e());
                acctDelayTime = now - lastSeen / 1000L;
                break;
            }
            default: {
                a.error("Unexpected Accounting-Status-Type");
                return null;
            }
        }
        AccountingRequest ar2 = new AccountingRequest(clientInfo.a(), acctStatusType);
        ar2.addAttribute("Acct-Session-Id", clientInfo.c());
        ar2.addAttribute("Event-Timestamp", String.valueOf(now));
        if (acctDelayTime > 0L) {
            ar2.addAttribute("Acct-Delay-Time", String.valueOf(acctDelayTime));
        }
        if (accountingPhase != q.a.b) {
            long downloadTotal = acctRequest.f();
            long uploadTotal = acctRequest.g();
            ar2.addAttribute("Acct-Session-Time", String.valueOf(acctRequest.h()));
            ar2.addAttribute("Acct-Input-Octets", String.valueOf(uploadTotal % 0x100000000L));
            ar2.addAttribute("Acct-Output-Octets", String.valueOf(downloadTotal % 0x100000000L));
            long acctInputGigas = uploadTotal >> 32;
            long acctOutputGigas = downloadTotal >> 32;
            if (acctInputGigas > 0L || acctOutputGigas > 0L) {
                ar2.addAttribute("Acct-Input-Gigawords", String.valueOf(acctInputGigas));
                ar2.addAttribute("Acct-Output-Gigawords", String.valueOf(acctOutputGigas));
            }
        }
        ar2.addAttribute("NAS-Port-Type", "Wireless-802.11");
        ar2.addAttribute("NAS-Port", "1");
        ar2.addAttribute("NAS-Port-Id", "00000001");
        String framedIp = this.a(acctRequest, accountingPhase);
        ar2.addAttribute("Framed-IP-Address", framedIp);
        ar2.addAttribute("NAS-IP-Address", this.a(acctRequest.o()));
        ar2.addAttribute("NAS-Identifier", acctRequest.i());
        Integer macFormat = this.h.a(acctRequest.b());
        if (!T.a((String)acctRequest.j())) {
            ar2.addAttribute("Called-Station-Id", com.tplink.smb.omada.client.common.domain.a.i.a((String)acctRequest.j(), (Integer)macFormat) + ":" + acctRequest.l());
        } else {
            ar2.addAttribute("Called-Station-Id", com.tplink.smb.omada.client.common.domain.a.i.a((String)acctRequest.k(), (Integer)macFormat) + ":" + acctRequest.m());
        }
        ar2.addAttribute("Calling-Station-Id", com.tplink.smb.omada.client.common.domain.a.i.a((String)acctRequest.e(), (Integer)macFormat));
        if (accountingPhase.equals((Object)q.a.d)) {
            Integer cause = clientInfo.r();
            if (cause == null || cause <= 0) {
                cause = clientInfo.q() != null && now >= TimeUnit.MILLISECONDS.toSeconds(clientInfo.q()) ? Integer.valueOf(com.tplink.smb.omada.portal.port.radius.b.a.c.a()) : Integer.valueOf(com.tplink.smb.omada.portal.port.radius.b.a.a.a());
            }
            ar2.addAttribute("Acct-Terminate-Cause", cause.toString());
        }
        VendorSpecificAttribute va = new VendorSpecificAttribute(11863);
        va.addSubAttribute("TPLink-Omada", acctRequest.b().a());
        ar2.addAttribute((RadiusAttribute)va);
        return ar2;
    }

    private String a(com.tplink.smb.omada.portal.port.radius.a.a acctRequest, q.a accountingPhase) {
        String framedIp = this.b.e(acctRequest.b(), acctRequest.c(), acctRequest.e());
        if (framedIp == null || T.c((String)framedIp) || framedIp.equals("0.0.0.0")) {
            q clientInfo = acctRequest.d();
            a.debug("Can't find current IP of the guest({}), so use the IP which the guest used to authenticate.", (Object)acctRequest.e());
            framedIp = clientInfo.d();
        }
        if (framedIp == null) {
            if (!accountingPhase.equals((Object)q.a.d)) {
                a.warn("Client({})'s IP can't be gotten at this moment, will send accounting request again later.", (Object)acctRequest.e());
                throw new com.tplink.smb.omada.portal.port.radius.c.a();
            }
            framedIp = "0.0.0.0";
        }
        return framedIp;
    }

    private void a(com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        q clientInfo = authRecord.L();
        if (clientInfo.k().intValue() == q.a.b.a()) {
            clientInfo.b(clientInfo.l() + 1);
            a.info("{} Send Start catch exception, add retry times {}", (Object)authRecord.q(), (Object)clientInfo.l());
            if (clientInfo.l() >= 10) {
                a.warn("{} Channel exception, retry times reached limit {} when sending Accounting-Request START", (Object)authRecord.q(), (Object)10);
                clientInfo.a(q.a.c.a());
                clientInfo.b(0);
            }
        } else if (clientInfo.k().intValue() == q.a.c.a()) {
            clientInfo.b(clientInfo.l() + 1);
            if (clientInfo.l() >= 10) {
                a.warn("{} Channel exception, retry times reached limit {} when sending Accounting-Request INTERIM_UPDATE", (Object)authRecord.q(), (Object)10);
                clientInfo.d(W.a());
                long lastSeen = this.b.c(authRecord.o(), authRecord.p(), authRecord.q());
                clientInfo.e(lastSeen / 1000L);
                clientInfo.b(0);
            }
        } else if (clientInfo.k().intValue() == q.a.d.a()) {
            clientInfo.b(clientInfo.l() + 1);
            a.info("{} Send Stop catch exception, add retry times {}", (Object)authRecord.q(), (Object)clientInfo.l());
            if (clientInfo.l() >= 10) {
                a.warn("{} Channel exception, retry times reached limit {} when sending Accounting-Request STOP", (Object)authRecord.q(), (Object)10);
                clientInfo.a(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(List<com.tplink.smb.omada.portal.port.radius.a.b> batchAcctRequests) {
        List<String> authRecordIds = Collections.synchronizedList(batchAcctRequests.stream().map(com.tplink.smb.omada.portal.port.radius.a.b::c).map(com.tplink.smb.omada.portal.domain.model.c.b::n).map(com.tplink.smb.omada.portal.domain.model.c.e::a).distinct().collect(Collectors.toList()));
        try {
            for (int count = 0; count < 4; ++count) {
                ArrayList<ChannelFuture> closeFutures = new ArrayList<ChannelFuture>();
                try {
                    for (com.tplink.smb.omada.portal.port.radius.a.b batchAcctRequest : batchAcctRequests) {
                        RadiusProfileDTO radiusProfile;
                        com.tplink.smb.omada.portal.domain.model.c.b authRecord = batchAcctRequest.c();
                        if (!authRecordIds.contains(authRecord.n().a()) || CollectionUtils.isEmpty((Collection)(radiusProfile = batchAcctRequest.b()).getAcctServer()) || radiusProfile.getAcctServer().size() <= count || radiusProfile.getAcctServer().get(count) == null) continue;
                        Channel udpChannel = this.a(authRecord, authRecordIds);
                        if (udpChannel == null) {
                            a.warn("{} Radius Accounting bind channel failed, skip this accounting", (Object)authRecord.q());
                            continue;
                        }
                        InetSocketAddress remoteAddress = new InetSocketAddress(((RadiusAcctServerDTO)radiusProfile.getAcctServer().get(count)).getAccountingServerIp(), (int)((RadiusAcctServerDTO)radiusProfile.getAcctServer().get(count)).getAccountingServerPort());
                        com.tplink.smb.omada.portal.port.radius.a.a acctRequest = com.tplink.smb.omada.portal.port.radius.a.a.a(authRecord, batchAcctRequest.d(), radiusProfile);
                        acctRequest.b(((RadiusAcctServerDTO)radiusProfile.getAcctServer().get(count)).getAccountingServerIp());
                        AccountingRequest ar2 = this.b(acctRequest);
                        authRecord.a(acctRequest.d());
                        byte[] requestData = this.a(ar2, ((RadiusAcctServerDTO)radiusProfile.getAcctServer().get(count)).getAccountingServerPwd());
                        if (ar2 == null || requestData.length == 0) continue;
                        DatagramPacket packet = new DatagramPacket(Unpooled.copiedBuffer((byte[])requestData), remoteAddress);
                        a.info("{} write and flush radius packet, phase: {}, acctId: {} ", new Object[]{authRecord.q(), acctRequest.d().k(), acctRequest.d().c()});
                        udpChannel.writeAndFlush((Object)packet);
                        this.f.a(ar2.getPacketTypeName(), ((ByteBuf)packet.content()).readableBytes());
                        closeFutures.add(udpChannel.closeFuture());
                    }
                    continue;
                }
                catch (Exception e2) {
                    a.error(e2.toString(), (Throwable)e2);
                }
                finally {
                    for (ChannelFuture future : closeFutures) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException | ExecutionException e3) {
                            a.warn(e3.toString(), (Throwable)e3);
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        }
        catch (Exception e4) {
            a.warn(e4.toString(), (Throwable)e4);
        }
    }

    private Channel a(com.tplink.smb.omada.portal.domain.model.c.b authRecord, List<String> authRecordIds) {
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)this.i);
            bootstrap.channel(NioDatagramChannel.class);
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            bootstrap.handler((ChannelHandler)new a(authRecord, authRecordIds));
            int port = this.l.nextInt(20000) + 30000;
            int retryTimes = 0;
            while (com.tplink.smb.omada.common.util.U.a((int)port)) {
                if (++retryTimes >= 10) {
                    return null;
                }
                port = this.l.nextInt(20000) + 30000;
            }
            ChannelFuture sync = bootstrap.bind(port).sync();
            return sync.channel();
        }
        catch (InterruptedException e2) {
            a.warn("AuthRecord {} Radius accounting bind channel failed with exception {}", new Object[]{authRecord.q(), e2.getMessage(), e2});
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e3) {
            a.error(e3.getMessage(), (Throwable)e3);
            return null;
        }
    }

    private byte[] a(AccountingRequest ar2, String acctServerPwd) {
        byte[] byArray;
        if (ar2 == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ar2.encodeRequestPacket((OutputStream)bos, acctServerPwd);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                a.warn(e2.toString(), (Throwable)e2);
                return new byte[0];
            }
        }
        bos.close();
        return byArray;
    }

    @Override
    public String a(String serverIp) {
        String localIp = v.a((String)serverIp, (List)com.tplink.smb.omada.common.util.system.b.b());
        if (T.c((String)localIp)) {
            List ipList = com.tplink.smb.omada.common.util.system.b.a((b.a)b.a.a, null);
            localIp = ipList.size() > 0 ? (String)ipList.get(0) : "0.0.0.0";
            a.debug("Can't find a correct local IP based on remote IP, so uses the first available IP({}).", (Object)localIp);
        }
        return localIp;
    }

    @Override
    public void a(String omadacId, String siteId, String wlanId, String ssidId) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecordList;
        a.debug("Stops RADIUS accounting when SSID is removed or relation between RADIUS portal and SSID is removed.");
        if (T.a((String)ssidId)) {
            return;
        }
        long count = this.c.a(omadacId, siteId, wlanId, ssidId);
        a.debug("Count of filtered authrecords is {}.", (Object)count);
        if (count <= 0L) {
            return;
        }
        int pageSize = 1000;
        int pageNum = (int)(count + (long)pageSize - 1L) / pageSize;
        for (int i2 = 0; i2 < pageNum && !CollectionUtils.isEmpty(authRecordList = this.c.a(new d(i2, pageSize), omadacId, siteId, wlanId, ssidId)); ++i2) {
            this.b(authRecordList);
        }
        a.debug("StopAccounting is finished when SSID is removed or relation between RADIUS portal and SSID is removed.");
    }

    @Override
    public void a(String omadacId, String siteId, String wlanId) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecordList;
        a.debug("Stops RADIUS accounting when Wlan group is removed.");
        if (T.a((String)wlanId)) {
            return;
        }
        long count = this.c.a(omadacId, siteId, wlanId);
        a.debug("Count of filtered authrecords is {}.", (Object)count);
        if (count <= 0L) {
            return;
        }
        int pageSize = 1000;
        int pageNum = (int)(count + (long)pageSize - 1L) / pageSize;
        for (int i2 = 0; i2 < pageNum && !CollectionUtils.isEmpty(authRecordList = this.c.a(new d(i2, pageSize), omadacId, siteId, wlanId)); ++i2) {
            this.b(authRecordList);
        }
        a.debug("StopAccounting is finished when Wlan group is removed.");
    }

    @Override
    public void a(String omadacId, String siteId, List<Integer> vids) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecordList;
        a.debug("Stops RADIUS accounting when LanNetwork is removed or relation between RADIUS portal and LanNetwork is removed.");
        if (CollectionUtils.isEmpty(vids)) {
            return;
        }
        long count = this.c.a(omadacId, siteId, vids);
        a.debug("Count of filtered authrecords is {}.", (Object)count);
        if (count <= 0L) {
            return;
        }
        int pageSize = 1000;
        int pageNum = (int)(count + (long)pageSize - 1L) / pageSize;
        for (int i2 = 0; i2 < pageNum && !CollectionUtils.isEmpty(authRecordList = this.c.a(new d(i2, pageSize), omadacId, siteId, vids)); ++i2) {
            this.b(authRecordList);
        }
        a.debug("StopAccounting is finished when LanNetwork is removed or relation between RADIUS portal and LanNetwork is removed.");
    }

    private void b(List<com.tplink.smb.omada.portal.domain.model.c.b> authRecordList) {
        long now = W.a();
        ArrayList<com.tplink.smb.omada.portal.port.radius.a.b> batchAcctRequests = new ArrayList<com.tplink.smb.omada.portal.port.radius.a.b>();
        Iterator<com.tplink.smb.omada.portal.domain.model.c.b> authRecordIt = authRecordList.iterator();
        while (authRecordIt.hasNext()) {
            com.tplink.smb.omada.portal.domain.model.c.b authRecord = authRecordIt.next();
            q radiusClientInfo = authRecord.L();
            if (radiusClientInfo == null || radiusClientInfo.k() == 0) {
                a.info("{} radiusClientInfo == null || radiusClientInfo.getAcctPhase() == 0", (Object)authRecord.q());
                authRecordIt.remove();
                continue;
            }
            Optional<O> portal = this.d.b(authRecord.o(), authRecord.p(), authRecord.r(), x.a).map(basePortal -> (O)basePortal);
            if (!portal.isPresent()) {
                a.info("{} !portal.isPresent()", (Object)authRecord.q());
                authRecordIt.remove();
                continue;
            }
            r portalRadius = p.a(portal.get());
            if (portalRadius == null || T.a((String)portalRadius.b())) {
                a.info("{} portalRadius == null || StringUtils.isNull(portalRadius.getRadiusProfileId()", (Object)authRecord.q());
                authRecordIt.remove();
                continue;
            }
            OperationResponse<RadiusProfileDTO> optRes = this.e.a(QueryRadiusProfileDTO.builder().omadacId(authRecord.o().a()).siteId(authRecord.p().a()).id(portalRadius.b()).build());
            if (!optRes.success() || optRes.getResult() == null || Boolean.TRUE.equals(((RadiusProfileDTO)optRes.getResult()).getDomainEnable())) {
                a.info("{} optRes.success() || Boolean.TRUE.equals(optRes.getResult().getDomainEnable()", (Object)authRecord.q());
                authRecordIt.remove();
                continue;
            }
            if (!Boolean.TRUE.equals(((RadiusProfileDTO)optRes.getResult()).getRadiusAccountingEnable())) {
                a.info("{} optRes.getResult() == null || !Boolean.TRUE.equals(optRes.getResult().getRadiusAccountingEnable()", (Object)authRecord.q());
                authRecordIt.remove();
                continue;
            }
            if (radiusClientInfo.k().intValue() != q.a.d.a()) {
                radiusClientInfo.a(q.a.d.a());
            }
            if (!authRecord.F().booleanValue() && radiusClientInfo.j() == 0L) {
                radiusClientInfo.f(now);
            }
            batchAcctRequests.add(com.tplink.smb.omada.portal.port.radius.a.b.a().a(authRecord).a((RadiusProfileDTO)optRes.getResult()).a(portalRadius.d()).a());
        }
        a.info("send stop message of {}", batchAcctRequests);
        this.a(batchAcctRequests);
        this.c.a(authRecordList, now);
    }

    @Override
    public void a(String omadacId, String siteId) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords;
        a.debug("Stops RADIUS accounting when site is deleted.");
        long count = this.c.a(omadacId, siteId);
        if (count == 0L) {
            return;
        }
        int pageSize = 1000;
        int pageNum = (int)(count + (long)pageSize - 1L) / pageSize;
        for (int i2 = 0; i2 < pageNum && !CollectionUtils.isEmpty(authRecords = this.c.a(new d(i2, pageSize), omadacId, siteId)); ++i2) {
            this.b(authRecords);
        }
        a.info("StopAccounting is finished when site is deleted.");
    }

    @Override
    public void a(com.tplink.smb.omada.client.common.domain.model.shared.r omadacId, z siteId, U portalId) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords;
        a.debug("Stops RADIUS accounting when portal:{} is deleted.", (Object)portalId);
        long count = this.c.a(omadacId, siteId, portalId);
        if (count == 0L) {
            return;
        }
        int pageSize = 1000;
        int pageNum = (int)(count + (long)pageSize - 1L) / pageSize;
        for (int i2 = 0; i2 < pageNum && !CollectionUtils.isEmpty(authRecords = this.c.a(new d(i2, pageSize), omadacId, siteId, portalId)); ++i2) {
            this.b(authRecords);
        }
        a.info("StopAccounting is finished when portal {} is deleted, stopped {} accounting.", (Object)portalId, (Object)count);
    }

    @Override
    public void a(com.tplink.smb.omada.client.common.domain.model.shared.r omadacId, z siteId, String clientMac) {
        a.info("handle radius stop event {}", (Object)clientMac);
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords = this.c.c(omadacId, siteId, clientMac);
        if (CollectionUtils.isEmpty(authRecords)) {
            a.info("authRecords of {} is empty", (Object)clientMac);
            return;
        }
        a.info("{} {}, stop accounting on client {} timed out", new Object[]{omadacId.a(), siteId.a(), clientMac});
        this.b(authRecords);
    }

    @Override
    public void b(com.tplink.smb.omada.client.common.domain.model.shared.r omadacId, z siteId, String clientMac) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords = this.c.g(omadacId, siteId, clientMac);
        if (CollectionUtils.isEmpty(authRecords)) {
            return;
        }
        a.info("{} {}, restart accounting on client {} connected", new Object[]{omadacId.a(), siteId.a(), clientMac});
        ArrayList<com.tplink.smb.omada.portal.port.radius.a.b> batchAcctRequests = new ArrayList<com.tplink.smb.omada.portal.port.radius.a.b>();
        Iterator<com.tplink.smb.omada.portal.domain.model.c.b> authRecordIt = authRecords.iterator();
        while (authRecordIt.hasNext()) {
            com.tplink.smb.omada.portal.domain.model.c.b authRecord = authRecordIt.next();
            q radiusClientInfo = authRecord.L();
            if (radiusClientInfo == null) {
                authRecordIt.remove();
                continue;
            }
            Optional<O> portal = this.d.b(authRecord.o(), authRecord.p(), authRecord.r(), x.a).map(basePortal -> (O)basePortal);
            if (!portal.isPresent()) {
                authRecordIt.remove();
                continue;
            }
            r portalRadius = p.a(portal.get());
            if (portalRadius == null || T.a((String)portalRadius.b())) {
                authRecordIt.remove();
                continue;
            }
            OperationResponse<RadiusProfileDTO> optRes = this.e.a(QueryRadiusProfileDTO.builder().omadacId(authRecord.o().a()).siteId(authRecord.p().a()).id(portalRadius.b()).build());
            if (!optRes.success() || optRes.getResult() == null || Boolean.TRUE.equals(((RadiusProfileDTO)optRes.getResult()).getDomainEnable())) {
                authRecordIt.remove();
                continue;
            }
            if (!Boolean.TRUE.equals(((RadiusProfileDTO)optRes.getResult()).getRadiusAccountingEnable())) {
                authRecordIt.remove();
                continue;
            }
            radiusClientInfo.a(q.a.b.a());
            radiusClientInfo.c(W.a());
            radiusClientInfo.f(0L);
            radiusClientInfo.a(true);
            radiusClientInfo.b(UUID.randomUUID().toString().replace("-", ""));
            batchAcctRequests.add(com.tplink.smb.omada.portal.port.radius.a.b.a().a(authRecord).a((RadiusProfileDTO)optRes.getResult()).a(portalRadius.d()).a());
        }
        this.a(batchAcctRequests);
        this.c.b(authRecords);
    }

    public class a
    extends ChannelInitializer<NioDatagramChannel> {
        private static final int b = 3;
        private com.tplink.smb.omada.portal.domain.model.c.b c;
        private List<String> d;

        a(com.tplink.smb.omada.portal.domain.model.c.b authRecord, List<String> authRecordIds) {
            this.c = authRecord;
            this.d = authRecordIds;
        }

        protected void a(NioDatagramChannel ch) throws Exception {
            a.debug("Thread name is {}", (Object)Thread.currentThread().getName());
            ChannelPipeline cp = ch.pipeline();
            int readTimeout = Optional.ofNullable(this.c.L()).map(q::s).orElse(3);
            cp.addLast(new ChannelHandler[]{new ReadTimeoutHandler(readTimeout)});
            cp.addLast(new ChannelHandler[]{new b(this.c, this.d)});
        }

        protected /* synthetic */ void initChannel(Channel channel) throws Exception {
            this.a((NioDatagramChannel)channel);
        }
    }

    public class b
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private final com.tplink.smb.omada.portal.domain.model.c.b b;
        private final List<String> c;

        b(com.tplink.smb.omada.portal.domain.model.c.b authRecord, List<String> authRecordIds) {
            this.b = authRecord;
            this.c = authRecordIds;
        }

        protected void a(ChannelHandlerContext ctx, DatagramPacket msg) {
            int size = ((ByteBuf)msg.content()).readableBytes();
            c.this.f.a("Accounting-Response", size);
            this.c.remove(this.b.n().a());
            a.debug("Accounting-Reply is received. mac: {}, acctId {}", (Object)this.b.q(), Optional.ofNullable(this.b.L()).map(q::c).orElse(null));
            q clientInfo = this.b.L();
            if (clientInfo.k().intValue() == q.a.b.a()) {
                a.info("acct phase is {}", (Object)clientInfo.k());
                clientInfo.a(q.a.c.a());
                clientInfo.b(0);
            } else if (clientInfo.k().intValue() == q.a.c.a()) {
                clientInfo.d(W.a());
                clientInfo.e(c.this.b.c(this.b.o(), this.b.p(), this.b.q()) / 1000L);
                clientInfo.b(0);
            } else if (clientInfo.k().intValue() == q.a.d.a()) {
                clientInfo.b(0);
                clientInfo.a(false);
            }
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            q clientInfo = this.b.L();
            a.info("Mac {}, acctId {}, Channel exception when sending Accounting-Request during {}:{}", new Object[]{this.b.q(), Optional.ofNullable(this.b.L()).map(q::c).orElse(null), q.a.a(clientInfo.k()), cause});
            c.this.a(this.b);
            ctx.close();
        }

        protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            this.a(channelHandlerContext, (DatagramPacket)object);
        }
    }
}

