/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.google;

import com.tplink.smb.omada.common.omadac.config.c;
import com.tplink.smb.omada.portal.port.google.GoogleOAuthBO;
import com.tplink.smb.omada.portal.port.google.GoogleResponseBO;
import com.tplink.smb.omada.portal.port.google.InnerErrCode;
import jakarta.annotation.Nonnull;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    @Qualifier(value="restTemplate")
    private RestTemplate b;
    @Autowired
    private com.tplink.smb.omada.portal.port.c.a c;
    private static final String d = Optional.ofNullable(com.tplink.smb.omada.common.omadac.config.c.a((String)"omada.properties")).map(configuration -> Optional.ofNullable(configuration.a("portal.google.endpoint")).orElse("https://oauth2.googleapis.com/token")).orElse("https://oauth2.googleapis.com/token");
    private static final String e = "authorization_code";

    public GoogleResponseBO<GoogleOAuthBO> a(@Nonnull String clientSecret, @Nonnull String clientId, @Nonnull String authCode, @Nonnull String redirectUrl) {
        try {
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.put((Object)"code", Collections.singletonList(authCode));
            body.put((Object)"client_id", Collections.singletonList(clientId));
            body.put((Object)"client_secret", Collections.singletonList(clientSecret));
            body.put((Object)"redirect_uri", Collections.singletonList(redirectUrl));
            body.put((Object)"grant_type", Collections.singletonList(e));
            ResponseEntity<GoogleOAuthBO> response = this.a(d, (MultiValueMap<String, String>)body, GoogleOAuthBO.class);
            if (response.getStatusCode() != HttpStatus.OK) {
                a.warn("Check auth failed. http status: [{}]", (Object)response.getStatusCodeValue());
                return new GoogleResponseBO<GoogleOAuthBO>(InnerErrCode.b);
            }
            return GoogleResponseBO.ok((GoogleOAuthBO)response.getBody());
        }
        catch (RestClientException e2) {
            return this.a(e2);
        }
    }

    private <R> ResponseEntity<R> a(String uri, MultiValueMap<String, String> reqObj, Class<R> rClass) {
        try {
            URI url = this.a(uri);
            RequestEntity requestEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)url).header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).header("Accept", new String[]{"application/json"})).body(reqObj);
            a.debug("Making POST request by form: {}", (Object)requestEntity);
            ResponseEntity responseEntity = this.b.exchange(requestEntity, rClass);
            this.c.a(false);
            return responseEntity;
        }
        catch (Exception e2) {
            this.c.a(true);
            throw e2;
        }
    }

    private URI a(String uri) {
        URI url = URI.create(uri);
        return url;
    }

    private <T> GoogleResponseBO<T> a(RestClientException e2) {
        Throwable cause = e2.getCause();
        if (cause == null) {
            cause = e2;
        }
        if (cause instanceof ConnectTimeoutException) {
            a.warn("Connect timeout.", cause);
            return new GoogleResponseBO(InnerErrCode.c);
        }
        if (cause instanceof SocketTimeoutException) {
            a.warn("Socket timeout.", cause);
            return new GoogleResponseBO(InnerErrCode.c);
        }
        if (cause instanceof UnknownHostException) {
            a.warn("Unknown host.", cause);
            return new GoogleResponseBO(InnerErrCode.e);
        }
        a.warn(cause.getMessage(), cause);
        return new GoogleResponseBO(InnerErrCode.d);
    }
}

