/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.port.device;

import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.proxy.EcspV1DeviceServerProxy;
import com.tplink.smb.ecsp.proxy.EcspV2DeviceServerProxy;
import com.tplink.smb.omada.client.common.domain.a.g;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.device.manage.message.body.manage.AuthorizationBody;
import com.tplink.smb.omada.device.manage.message.body.manage.authentication.BaseAuthedUser;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceImageOutlineDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.e;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.k;
import com.tplink.smb.omada.portal.domain.model.b.i;
import com.tplink.smb.omada.portal.domain.model.i.b.f;
import com.tplink.smb.omada.portal.port.device.a;
import com.tplink.smb.omada.portal.port.device.config.b;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
implements i {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(c.class);
    public static final long a = 10000L;
    public static final long b = 30000L;
    private EcspV1DeviceServerProxy d;
    private EcspV2DeviceServerProxy e;
    private ExecutorService f;
    private com.tplink.smb.omada.manager.device.api.internal.device.b g;
    private g h;

    @Override
    public CompletableFuture<Integer> a(com.tplink.smb.omada.portal.domain.model.c.b authRecord, String deviceMac, DeviceTypeEnum deviceType) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.f.execute(() -> {
            AuthorizationBody authBody;
            String ecspVersion;
            com.tplink.smb.omada.manager.device.api.internal.device.dto.f response = this.g.a(com.tplink.smb.omada.manager.device.api.internal.device.dto.e.a().a(authRecord.o().a()).b(deviceMac).b());
            if (response == null || !response.b() || response.c() == null || (ecspVersion = response.c().getEcspVersion()) == null) {
                c.warn("Failed to send Authorization to device: {}, Omadac:{}, Failed to get ecsp version.", (Object)deviceMac, (Object)authRecord.o());
                future.complete(1);
                return;
            }
            if (deviceType == DeviceTypeEnum.a) {
                authBody = com.tplink.smb.omada.portal.port.device.a.a(authRecord);
            } else if (deviceType == DeviceTypeEnum.b) {
                authBody = com.tplink.smb.omada.portal.port.device.a.b(authRecord);
            } else {
                c.warn("Send AuthedUser: Unknown deviceType: {}", (Object)deviceType);
                future.complete(1);
                return;
            }
            this.a(authBody, deviceMac, ecspVersion, future);
        });
        return future;
    }

    @Override
    public CompletableFuture<Integer> a(com.tplink.smb.omada.portal.domain.model.c.b authRecord, String deviceMac, DeviceTypeEnum deviceType, long deviceEndTime) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.f.execute(() -> {
            AuthorizationBody authBody;
            String ecspVersion;
            com.tplink.smb.omada.manager.device.api.internal.device.dto.f response = this.g.a(com.tplink.smb.omada.manager.device.api.internal.device.dto.e.a().a(authRecord.o().a()).b(deviceMac).b());
            if (response == null || !response.b() || response.c() == null || (ecspVersion = response.c().getEcspVersion()) == null) {
                c.warn("Failed to send Authorization to device: {}, Omadac:{}, Failed to get ecsp version.", (Object)deviceMac, (Object)authRecord.o());
                future.complete(1);
                return;
            }
            if (deviceType == DeviceTypeEnum.a) {
                authBody = com.tplink.smb.omada.portal.port.device.a.a(authRecord);
            } else if (deviceType == DeviceTypeEnum.b) {
                authBody = com.tplink.smb.omada.portal.port.device.a.b(authRecord);
            } else {
                c.warn("Send AuthedUser: Unknown deviceType: {}", (Object)deviceType);
                future.complete(1);
                return;
            }
            List authedUsers = authBody.getAuthedUsers();
            if (CollectionUtils.isEmpty((Collection)authedUsers)) {
                c.warn("AuthedUsers in sendAuthedUserAsyncWithTime is empty, authRecord: {}", (Object)authRecord);
                return;
            }
            BaseAuthedUser authedUser = (BaseAuthedUser)authedUsers.get(0);
            authedUser.setEndTime(Long.valueOf(deviceEndTime / 1000L));
            if (authedUser instanceof com.tplink.smb.omada.portal.port.device.config.a) {
                ArrayList<com.tplink.smb.omada.portal.port.device.config.a> apAuthedUsers = new ArrayList<com.tplink.smb.omada.portal.port.device.config.a>();
                apAuthedUsers.add((com.tplink.smb.omada.portal.port.device.config.a)authedUser);
                authBody.setAuthedUsers(apAuthedUsers);
            } else {
                ArrayList<b> osgAuthedUsers = new ArrayList<b>();
                osgAuthedUsers.add((b)authedUser);
                authBody.setAuthedUsers(osgAuthedUsers);
            }
            this.a(authBody, deviceMac, ecspVersion, future);
        });
        return future;
    }

    @Override
    public CompletableFuture<Integer> a(AuthorizationBody body, String deviceMac, DeviceTypeEnum deviceType, String ecspVersion) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.f.execute(() -> this.a(body, deviceMac, ecspVersion, future));
        return future;
    }

    @Override
    public boolean b(AuthorizationBody body, String deviceMac, DeviceTypeEnum deviceType, String ecspVersion) {
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)ecspVersion);
        if (deviceType == DeviceTypeEnum.b && firstVersion.getVersion() >= EcspFirstVersionEnum.V2.getVersion()) {
            return this.a(body, deviceMac, ecspVersion);
        }
        this.a(body, deviceMac, deviceType, ecspVersion);
        return true;
    }

    @Override
    public CompletableFuture<Integer> a(@Nonnull com.tplink.smb.omada.portal.domain.model.h.T portalEntranceQuery, @Nonnull com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        String deviceMac = portalEntranceQuery.b();
        DeviceTypeEnum deviceType = portalEntranceQuery.a();
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.f.execute(() -> {
            AuthorizationBody authBody;
            String ecspVersion;
            com.tplink.smb.omada.manager.device.api.internal.device.dto.f response = this.g.a(com.tplink.smb.omada.manager.device.api.internal.device.dto.e.a().a(authRecord.o().a()).b(deviceMac).b());
            if (response == null || !response.b() || response.c() == null || (ecspVersion = response.c().getEcspVersion()) == null) {
                c.warn("Failed to send Authorization to device: {}, Omadac:{}, Failed to get ecsp version.", (Object)deviceMac, (Object)authRecord.o());
                future.complete(1);
                return;
            }
            if (deviceType == DeviceTypeEnum.a) {
                authBody = com.tplink.smb.omada.portal.port.device.a.a(authRecord);
            } else if (deviceType == DeviceTypeEnum.b) {
                authBody = com.tplink.smb.omada.portal.port.device.a.b(portalEntranceQuery.d(), portalEntranceQuery.j(), authRecord);
            } else {
                c.warn("Send AuthedUser: Unknown deviceType: {}", (Object)deviceType);
                future.complete(1);
                return;
            }
            this.a(authBody, deviceMac, ecspVersion, future);
        });
        return future;
    }

    @Override
    public CompletableFuture<Integer> a(String ssidName, Integer rid, f pskDetail, String apMac) {
        if (ssidName == null || pskDetail == null || T.a((String)apMac)) {
            return null;
        }
        String omadacId = pskDetail.b().a();
        AuthorizationBody authBody = com.tplink.smb.omada.portal.port.device.a.b(ssidName, rid, pskDetail);
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.f.execute(() -> {
            String ecspVersion;
            com.tplink.smb.omada.manager.device.api.internal.device.dto.f response = this.g.a(com.tplink.smb.omada.manager.device.api.internal.device.dto.e.a().a(omadacId).b(apMac).b());
            if (response == null || !response.b() || response.c() == null || (ecspVersion = response.c().getEcspVersion()) == null) {
                c.warn("Failed to send ppsk Authorization to device: {}, Omadac:{}, Failed to get ecsp version.", (Object)apMac, (Object)omadacId);
                future.complete(1);
                return;
            }
            this.e.sendPortalAuth(apMac, ecspVersion, (MessageBody)authBody, null, 10000L).subscribe(transResult -> {
                c.debug("ECSP v2 send ppsk PortalAuth by device-gateway returned {}", transResult);
                future.complete(transResult.getErrCode());
            });
        });
        return future;
    }

    @Override
    public void a(String omadacId, String ssidName, Integer rid, String clientMac, Set<String> apMacSet) {
        if (ssidName == null || clientMac == null || CollectionUtils.isEmpty(apMacSet)) {
            return;
        }
        AuthorizationBody authBody = com.tplink.smb.omada.portal.port.device.a.a(ssidName, rid, clientMac);
        com.tplink.smb.omada.manager.device.api.internal.a.a.b deviceImageListRes = this.g.a(new k(omadacId, apMacSet.stream().toList()));
        if (!deviceImageListRes.a()) {
            c.warn("Failed to send ppsk Unauth to device: {}, Omadac:{}, Failed to get ecsp version.", apMacSet, (Object)omadacId);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)deviceImageListRes.e()))) {
            return;
        }
        Map<String, String> macEcspVerMap = ((List)deviceImageListRes.e()).stream().collect(Collectors.toMap(DeviceImageOutlineDTO::getMac, DeviceImageOutlineDTO::getEcspVersion));
        for (String apMac : apMacSet) {
            CompletableFuture future = new CompletableFuture();
            this.f.execute(() -> {
                String ecspVersion = (String)macEcspVerMap.get(apMac);
                if (ecspVersion == null) {
                    future.complete(1);
                    return;
                }
                EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)EcspVersion.fitFatEcspVer((String)ecspVersion));
                switch (firstVersion) {
                    case V1: {
                        c.warn("V1 device should not sendPpskUnauthUserAsync, omadac:{}, apMac:{}", (Object)omadacId, (Object)apMac);
                        future.complete(1);
                        break;
                    }
                    case V2: 
                    case V3: {
                        this.e.sendPortalAuth(apMac, ecspVersion, (MessageBody)authBody, null, 10000L).subscribe(transResult -> {
                            c.debug("ECSP v2 send sendPpskUnauthUserAsync by device-gateway returned {}", transResult);
                            future.complete(transResult.getErrCode());
                        });
                        break;
                    }
                    default: {
                        c.error("Failed to send sendPpskUnauthUserAsync to device: {}, Unsupported ecsp version:{}.", (Object)apMac, (Object)ecspVersion);
                        future.complete(1);
                    }
                }
            });
        }
    }

    private void a(AuthorizationBody body, String deviceMac, @Nonnull String ecspVersion, CompletableFuture<Integer> future) {
        if (CollectionUtils.isEmpty((Collection)body.getAuthedUsers())) {
            c.info("Skip sending empty AuthedUsers to device:{}, ecspVer:{}, AuthorizationBody:{}.", new Object[]{deviceMac, ecspVersion, body});
            return;
        }
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)EcspVersion.fitFatEcspVer((String)ecspVersion));
        switch (firstVersion) {
            case V1: {
                this.d.sendPortalAuth(deviceMac, ecspVersion, (MessageBody)body, 10000L).subscribe(transResult -> {
                    c.debug("ECSP v1 sendPortalAuth by device-gateway returned {}", transResult);
                    future.complete(transResult.getErrCode());
                });
                break;
            }
            case V2: 
            case V3: {
                this.e.sendPortalAuth(deviceMac, ecspVersion, (MessageBody)body, null, 10000L).subscribe(transResult -> {
                    c.debug("ECSP v2 sendPortalAuth by device-gateway returned {}", transResult);
                    future.complete(transResult.getErrCode());
                });
                break;
            }
            default: {
                c.error("Failed to send Authorization to device: {}, Unsupported ecsp version:{}.", (Object)deviceMac, (Object)ecspVersion);
                future.complete(1);
            }
        }
    }

    private boolean a(AuthorizationBody body, String deviceMac, @Nonnull String ecspVersion) {
        TransResult result;
        int seqId = this.h.a();
        try {
            result = (TransResult)this.e.sendPortalAuth(deviceMac, ecspVersion, (MessageBody)body, Integer.valueOf(seqId), 30000L).blockingGet();
        }
        catch (Exception e2) {
            c.debug("Exception occured when send portal auth");
            return false;
        }
        c.debug("sendAuthorizationSync result is {}", (Object)result.isOK());
        return result.isOK();
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService) {
        this.g = deviceInternalApiService;
    }

    @Autowired
    @Qualifier(value="portalDeviceManageWorkGroup")
    public void a(ExecutorService portalDeviceManageWorkGroup) {
        this.f = portalDeviceManageWorkGroup;
    }

    @Autowired
    @Lazy
    public void a(EcspV1DeviceServerProxy ecspV1DeviceServerProxy) {
        this.d = ecspV1DeviceServerProxy;
    }

    @Autowired
    @Lazy
    public void a(EcspV2DeviceServerProxy ecspV2DeviceServerProxy) {
        this.e = ecspV2DeviceServerProxy;
    }

    @Autowired
    public void a(@Lazy g nextSequenceIdService) {
        this.h = nextSequenceIdService;
    }
}

