/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.domain.service.traffic;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.client.common.api.internal.dto.ClientImageBriefDTO;
import com.tplink.smb.omada.client.common.domain.a.c;
import com.tplink.smb.omada.client.common.domain.a.j;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.y;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.judgement.a.e;
import com.tplink.smb.omada.lock.b.b;
import com.tplink.smb.omada.portal.domain.service.traffic.AuthRecordTrafficTaskProperties;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(a.class);
    public static final String a = "traffic.task";
    @Autowired
    private com.tplink.smb.omada.portal.port.cache.c.a c;
    @Autowired
    private y d;
    @Autowired
    private LockService e;
    @Autowired
    private j f;
    @Autowired
    private c g;
    @Autowired
    private com.tplink.smb.omada.portal.domain.model.c.a h;
    @Autowired
    private e i;
    @Autowired
    private com.tplink.smb.omada.client.common.domain.model.b.a.a j;
    @Autowired
    private AuthRecordTrafficTaskProperties k;

    public void a(int shardingIndex) {
        if (!this.i.a("portal:authed_clients:traffic")) {
            return;
        }
        if (Boolean.TRUE.equals(this.k.getEnableSiteAllocation())) {
            Map partitionSiteIdMap = this.j.a(shardingIndex);
            if (CollectionUtils.isEmpty((Map)partitionSiteIdMap)) {
                return;
            }
            Set<r> recordExistOmadacIds = this.h.a(partitionSiteIdMap.keySet());
            if (CollectionUtils.isEmpty(recordExistOmadacIds)) {
                return;
            }
            for (Map.Entry entry : partitionSiteIdMap.entrySet()) {
                String omadacId = (String)entry.getKey();
                Set siteIds = (Set)entry.getValue();
                if (!recordExistOmadacIds.contains(new r(omadacId))) {
                    b.debug("AuthRecords not exist in OmadacId={}", (Object)omadacId);
                    continue;
                }
                if (this.f.a(new r(omadacId))) {
                    b.debug("OmadacId={} is restoring", (Object)omadacId);
                    continue;
                }
                this.a(omadacId, siteIds);
            }
        } else {
            Set<r> omadacIds = this.h.b(shardingIndex);
            if (CollectionUtils.isEmpty(omadacIds)) {
                return;
            }
            for (r omadacId : omadacIds) {
                if (this.f.a(omadacId)) {
                    b.debug("OmadacId={} is restoring", (Object)omadacId);
                    continue;
                }
                Set siteIds = this.d.a(omadacId);
                this.a(omadacId.a(), siteIds);
            }
        }
    }

    private void a(String omadacId, Set<String> siteIds) {
        for (String siteId : siteIds) {
            this.a(omadacId, siteId, () -> {
                try {
                    long start = System.nanoTime();
                    b.debug("Check AuthRecordTraffics of omadac: {}, siteid:{}, timestamp:{}", new Object[]{omadacId, siteId, System.currentTimeMillis()});
                    this.a(new r(omadacId), new z(siteId));
                    b.debug("Check AuthRecordTraffics of omadac: {}, siteid:{} finished in {} ms", new Object[]{omadacId, siteId, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                }
                catch (Exception e2) {
                    b.warn("Check AuthRecordTraffics of omadac: {} with exception", (Object)omadacId, (Object)e2);
                }
                return true;
            }, () -> {
                b.warn("Skipping check AuthRecordTraffics of omadac: {}. tryLock failed", (Object)omadacId);
                return false;
            });
        }
    }

    private void a(r omadacId, z siteId) {
        Set<String> jobMap = this.c.a(omadacId, siteId, Double.MIN_VALUE, (double)System.currentTimeMillis());
        for (String clientMac : jobMap) {
            Optional clientImageBriefOptional = this.g.f(omadacId, siteId, clientMac);
            if (!clientImageBriefOptional.isPresent()) {
                b.warn("client {} in [omadacId:{}, siteId:{}] is already disconnected, delete this job", new Object[]{clientMac, omadacId, siteId});
                this.c.a(omadacId, siteId, clientMac);
                continue;
            }
            ClientImageBriefDTO clientImageBrief = (ClientImageBriefDTO)clientImageBriefOptional.get();
            if (!Boolean.TRUE.equals(clientImageBrief.getAuthed())) {
                b.warn("client {} in [omadacId:{}, siteId:{}] is already unauthed, delete this job", new Object[]{clientMac, omadacId, siteId});
                this.c.a(omadacId, siteId, clientMac);
                continue;
            }
            DomainEventBusHolder.getPublisher().publishSync((DomainEvent)new com.tplink.smb.omada.client.common.domain.model.a.d.c(clientImageBrief));
        }
        b.debug("AuthRecordTrafficTask executed on [omadacId:{},timestamp:{}], handled {} authed clients", new Object[]{omadacId, System.currentTimeMillis(), jobMap.size()});
    }

    private void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull Supplier<Object> onSynchronized, @Nonnull Supplier<Object> onLockFailed) {
        this.e.doWithTryLock(com.tplink.smb.omada.lock.b.b.a((String)"portal", (String)a), (Object)com.tplink.smb.omada.lock.b.b.a((String[])new String[]{"omadac.id", omadacId, "site.id", siteId}), onSynchronized, onLockFailed);
    }
}

