/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.domain.service.ldap;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.internal.site.authentication.dto.LdapProfileDTO;
import com.tplink.smb.omada.portal.domain.service.ldap.LdapSslSocketFactory;
import java.util.HashMap;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.InvalidSearchFilterException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.ServiceUnavailableException;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.AuthenticationErrorCallback;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapEntryIdentification;
import org.springframework.ldap.core.LdapEntryIdentificationContextMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.support.LdapUtils;

public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    private static final String b = "LDAP Authentication failed. Error message";
    private static b c = new b();

    public static b a() {
        return c;
    }

    private b() {
    }

    public com.tplink.smb.omada.common.g.b a(String username, String password, LdapProfileDTO ldapProfile) {
        return this.d(username, password, ldapProfile);
    }

    public com.tplink.smb.omada.common.g.b b(String username, String password, LdapProfileDTO ldapProfile) {
        return this.e(username, password, ldapProfile);
    }

    public com.tplink.smb.omada.common.g.b c(String username, String password, LdapProfileDTO ldapProfile) {
        return this.f(username, password, ldapProfile);
    }

    private com.tplink.smb.omada.common.g.b d(String username, String password, LdapProfileDTO ldapProfile) {
        String url = (ldapProfile.isSslCon() ? "ldaps://" : "ldap://") + ldapProfile.getServer() + ":" + ldapProfile.getDstPort();
        String baseDn = ldapProfile.getBaseDn();
        String filter = ldapProfile.getCn() + "=" + username;
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(url);
        contextSource.setPooled(true);
        HashMap<String, String> config = new HashMap<String, String>(3);
        if (ldapProfile.isSslCon()) {
            config.put("java.naming.security.protocol", "ssl");
            config.put("java.naming.ldap.factory.socket", LdapSslSocketFactory.class.getName());
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", Boolean.TRUE.toString());
        }
        config.put("java.naming.ldap.attributes.binary", "objectGUID");
        contextSource.setBaseEnvironmentProperties(config);
        contextSource.afterPropertiesSet();
        LdapTemplate anonConnection = new LdapTemplate((ContextSource)contextSource);
        try {
            boolean isAuthed = this.a(baseDn, filter, password, anonConnection, ldapProfile.getOmadacId(), ldapProfile.getSiteId());
            return isAuthed ? com.tplink.smb.omada.common.g.b.a : com.tplink.smb.omada.common.g.b.Lr;
        }
        catch (Exception e2) {
            a.warn(b, (Throwable)e2);
            if (e2 instanceof CommunicationException || e2 instanceof ServiceUnavailableException) {
                return com.tplink.smb.omada.common.g.b.Lq;
            }
            if (e2 instanceof NameNotFoundException || e2 instanceof InvalidSearchFilterException) {
                return com.tplink.smb.omada.common.g.b.Lq;
            }
            return com.tplink.smb.omada.common.g.b.Is;
        }
    }

    private com.tplink.smb.omada.common.g.b e(String username, String password, LdapProfileDTO ldapProfile) {
        String url = (ldapProfile.isSslCon() ? "ldaps://" : "ldap://") + ldapProfile.getServer() + ":" + ldapProfile.getDstPort();
        String groupDn = ldapProfile.getGroupDn();
        String baseDn = ldapProfile.getBaseDn();
        String filter = T.a((String)ldapProfile.getFilter()) ? "objectClass=*" : ldapProfile.getFilter();
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(url);
        contextSource.setPooled(true);
        HashMap<String, String> config = new HashMap<String, String>(3);
        if (ldapProfile.isSslCon()) {
            config.put("java.naming.security.protocol", "ssl");
            config.put("java.naming.ldap.factory.socket", LdapSslSocketFactory.class.getName());
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", Boolean.TRUE.toString());
        }
        config.put("java.naming.ldap.attributes.binary", "objectGUID");
        contextSource.setBaseEnvironmentProperties(config);
        contextSource.setAnonymousReadOnly(true);
        contextSource.afterPropertiesSet();
        LdapTemplate anonConnection = new LdapTemplate((ContextSource)contextSource);
        try {
            if (!T.a((String)groupDn)) {
                boolean isAuthed = this.a(baseDn, groupDn, ldapProfile.getCn(), filter, username, password, anonConnection, ldapProfile.getOmadacId(), ldapProfile.getSiteId());
                return isAuthed ? com.tplink.smb.omada.common.g.b.a : com.tplink.smb.omada.common.g.b.Lr;
            }
            String authFilter = "(&(" + filter + ")(" + ldapProfile.getCn() + "=" + username + "))";
            boolean isAuthed = this.a(baseDn, authFilter, password, anonConnection, ldapProfile.getOmadacId(), ldapProfile.getSiteId());
            return isAuthed ? com.tplink.smb.omada.common.g.b.a : com.tplink.smb.omada.common.g.b.Lr;
        }
        catch (Exception e2) {
            a.warn(b, (Throwable)e2);
            if (e2 instanceof CommunicationException || e2 instanceof ServiceUnavailableException || e2 instanceof NameNotFoundException || e2 instanceof InvalidSearchFilterException) {
                return com.tplink.smb.omada.common.g.b.Lq;
            }
            return com.tplink.smb.omada.common.g.b.Is;
        }
    }

    private com.tplink.smb.omada.common.g.b f(String username, String password, LdapProfileDTO ldapProfile) {
        String url = (ldapProfile.isSslCon() ? "ldaps://" : "ldap://") + ldapProfile.getServer() + ":" + ldapProfile.getDstPort();
        String groupDn = ldapProfile.getGroupDn();
        String baseDn = ldapProfile.getBaseDn();
        if (T.a((String)ldapProfile.getRegularDn()) || T.a((String)ldapProfile.getRegularPassword())) {
            return com.tplink.smb.omada.common.g.b.Lq;
        }
        String filter = T.a((String)ldapProfile.getFilter()) ? "objectClass=*" : ldapProfile.getFilter();
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(url);
        contextSource.setPooled(true);
        HashMap<String, String> config = new HashMap<String, String>(3);
        if (ldapProfile.isSslCon()) {
            config.put("java.naming.security.protocol", "ssl");
            config.put("java.naming.ldap.factory.socket", LdapSslSocketFactory.class.getName());
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", Boolean.TRUE.toString());
        }
        config.put("java.naming.ldap.attributes.binary", "objectGUID");
        config.put("java.naming.security.principal", ldapProfile.getRegularDn());
        config.put("java.naming.security.credentials", ldapProfile.getRegularPassword());
        contextSource.setBaseEnvironmentProperties(config);
        contextSource.afterPropertiesSet();
        LdapTemplate anonConnection = new LdapTemplate((ContextSource)contextSource);
        try {
            if (!T.a((String)groupDn)) {
                boolean isAuthed = this.a(baseDn, groupDn, ldapProfile.getCn(), filter, username, password, anonConnection, ldapProfile.getOmadacId(), ldapProfile.getSiteId());
                return isAuthed ? com.tplink.smb.omada.common.g.b.a : com.tplink.smb.omada.common.g.b.Lr;
            }
            String authFilter = "(&(" + filter + ")(" + ldapProfile.getCn() + "=" + username + "))";
            boolean isAuthed = this.a(baseDn, authFilter, password, anonConnection, ldapProfile.getOmadacId(), ldapProfile.getSiteId());
            return isAuthed ? com.tplink.smb.omada.common.g.b.a : com.tplink.smb.omada.common.g.b.Lr;
        }
        catch (Exception e2) {
            a.warn(b, (Throwable)e2);
            if (e2 instanceof CommunicationException || e2 instanceof ServiceUnavailableException || e2 instanceof NameNotFoundException || e2 instanceof InvalidSearchFilterException) {
                return com.tplink.smb.omada.common.g.b.Lq;
            }
            return com.tplink.smb.omada.common.g.b.Is;
        }
    }

    private String a(String baseDn, String cn, String addFilter, String username) {
        String andItem1 = "(&(objectClass=posixGroup)(memberUid=" + username + "))";
        String andItem2 = "(&(objectCategory=group)(member=" + cn + "=" + username + "," + baseDn + "))";
        String orItem = "(|" + andItem1 + andItem2 + ")";
        String andItem = "(&(objectClass=posixGroup)(uniqueMember=" + cn + "=" + username + "," + baseDn + "))";
        String groupFilter = "(|" + orItem + andItem + ")";
        return "(&(" + addFilter + ")" + groupFilter + ")";
    }

    private boolean a(String baseDn, String groupDn, String cn, String addFilter, String username, String password, LdapTemplate ldapTemplate, String omadacId, String siteId) {
        SearchControls searchControls = this.b();
        a callback = new a();
        b errorCallback = new b();
        String rdnFilter = "(&(" + addFilter + ")(" + cn + "=" + username + "))";
        List rdnResult = ldapTemplate.search((Name)LdapUtils.newLdapName((String)baseDn), rdnFilter, searchControls, (ContextMapper)new LdapEntryIdentificationContextMapper());
        if (rdnResult.isEmpty()) {
            a.info("OmadacId: {}, siteId:{}. Can't find user in baseDn: {}", new Object[]{omadacId, siteId, baseDn});
            return false;
        }
        if (rdnResult.size() > 1) {
            String msg = "base:'" + baseDn + "'; filter:'" + rdnFilter + "'.";
            throw new IncorrectResultSizeDataAccessException(msg, 1, rdnResult.size());
        }
        LdapEntryIdentification entryIdentification = (LdapEntryIdentification)rdnResult.get(0);
        String groupFilter = this.a(baseDn, cn, addFilter, username);
        List groupResult = ldapTemplate.search((Name)LdapUtils.newLdapName((String)groupDn), groupFilter, searchControls, (ContextMapper)new LdapEntryIdentificationContextMapper());
        if (groupResult.isEmpty()) {
            a.info("OmadacId: {}, siteId:{}. Can't find user in groupDn: {}", new Object[]{omadacId, siteId, groupDn});
            return false;
        }
        if (groupResult.size() > 1) {
            String msg = "base:'" + baseDn + "'; filter:'" + groupFilter + "'.";
            throw new IncorrectResultSizeDataAccessException(msg, 1, groupResult.size());
        }
        try {
            DirContext ctx = ldapTemplate.getContextSource().getContext(entryIdentification.getAbsoluteName().toString(), password);
            this.a(ctx1 -> {
                callback.executeWithContext(ctx1, entryIdentification);
                return null;
            }, ctx);
            return true;
        }
        catch (Exception e2) {
            a.info("OmadacId: {}, siteId:{}.Authentication failed for entry with DN '" + entryIdentification.getAbsoluteName() + "'", new Object[]{omadacId, siteId, e2});
            errorCallback.execute(e2);
            return false;
        }
    }

    private boolean a(String baseDn, String filter, String password, LdapTemplate ldapTemplate, String omadacId, String siteId) {
        LdapName base = LdapUtils.newLdapName((String)baseDn);
        SearchControls searchControls = this.b();
        a callback = new a();
        b errorCallback = new b();
        List result = ldapTemplate.search((Name)base, filter, searchControls, (ContextMapper)new LdapEntryIdentificationContextMapper());
        if (result.isEmpty()) {
            a.info("OmadacId: {}, siteId:{}. Can't find user in baseDn: {}", new Object[]{omadacId, siteId, baseDn});
            return false;
        }
        if (result.size() > 1) {
            String msg = "base: '" + base + "'; filter: '" + filter + "'.";
            throw new IncorrectResultSizeDataAccessException(msg, 1, result.size());
        }
        LdapEntryIdentification entryIdentification = (LdapEntryIdentification)result.get(0);
        try {
            DirContext ctx = ldapTemplate.getContextSource().getContext(entryIdentification.getAbsoluteName().toString(), password);
            this.a(ctx1 -> {
                callback.executeWithContext(ctx1, entryIdentification);
                return null;
            }, ctx);
            return true;
        }
        catch (Exception e2) {
            a.info("OmadacId: {}, siteId:{}.Authentication failed for entry with DN '" + entryIdentification.getAbsoluteName() + "'", new Object[]{omadacId, siteId, e2});
            errorCallback.execute(e2);
            return false;
        }
    }

    private <T> void a(ContextExecutor<T> ce, DirContext ctx) {
        try {
            ce.executeWithContext(ctx);
        }
        catch (NamingException e2) {
            throw LdapUtils.convertLdapException((NamingException)e2);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private SearchControls b() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setTimeLimit(0);
        controls.setCountLimit(0L);
        controls.setReturningObjFlag(true);
        controls.setReturningAttributes(new String[0]);
        return controls;
    }

    private static final class a
    implements AuthenticatedLdapEntryContextCallback,
    AuthenticatedLdapEntryContextMapper<Object> {
        private a() {
        }

        public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
        }

        public Object mapWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
            return null;
        }
    }

    private static final class b
    implements AuthenticationErrorCallback {
        private b() {
        }

        public void execute(Exception e2) {
        }
    }
}

