/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.domain.service.auth;

import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.client.common.api.internal.dto.ClientImageBriefDTO;
import com.tplink.smb.omada.client.common.api.internal.dto.ClientTrafficDTO;
import com.tplink.smb.omada.client.common.constant.j;
import com.tplink.smb.omada.client.common.domain.a.e;
import com.tplink.smb.omada.client.common.domain.model.a.d.f;
import com.tplink.smb.omada.client.common.domain.model.shared.ClientInformDebugProperties;
import com.tplink.smb.omada.client.common.domain.model.shared.d;
import com.tplink.smb.omada.client.common.domain.model.shared.o;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.t;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.lock.a.c;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.portal.domain.model.c.q;
import com.tplink.smb.omada.portal.domain.model.g.g;
import com.tplink.smb.omada.portal.domain.model.voucher.m;
import com.tplink.smb.omada.portal.domain.model.voucher.x;
import com.tplink.smb.omada.portal.domain.service.auth.l;
import com.tplink.smb.omada.portal.domain.service.auth.w;
import com.tplink.smb.omada.portal.port.radius.b.a;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class E {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(E.class);
    private com.tplink.smb.omada.portal.domain.model.c.f b;
    private w c;
    private l d;
    private t e;
    private com.tplink.smb.omada.portal.port.cache.c.a f;
    private d g;
    private e h;
    private x i;
    private g j;
    private c k;
    @Autowired
    private ClientInformDebugProperties l;
    @Autowired
    private com.tplink.smb.omada.judgement.a.e m;
    private static final Long n = 0x100000L;

    public void a(ClientImageBriefDTO clientImage, boolean cancelAuthEnable) {
        List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords;
        if (!this.m.a(clientImage.getOmadacId().a(), "portal:authed_clients:traffic")) {
            return;
        }
        if (!clientImage.getAuthed().booleanValue()) {
            return;
        }
        r omadacId = clientImage.getOmadacId();
        z siteId = clientImage.getSiteId();
        long start = System.nanoTime();
        if (clientImage.isWireless()) {
            authRecords = this.c.a(omadacId, siteId, clientImage.getMac(), clientImage.getIp(), clientImage.getSsid(), clientImage.getWlanId(), this.e.a(omadacId, siteId).orElse(null), start);
            this.l.clientInformHandleInTimeRangeLogging(start, "taskGetAllAuthRecordsOfWirelessClient", new String[]{"clientMac", clientImage.getMac()});
        } else {
            authRecords = this.c.a(omadacId, siteId, clientImage.getMac(), clientImage.getVid(), start);
            this.l.clientInformHandleInTimeRangeLogging(start, "taskGetValidWiredAuthRecords", new String[]{"clientMac", clientImage.getMac()});
        }
        if (CollectionUtils.isEmpty(authRecords)) {
            this.f.a(omadacId, siteId, clientImage.getMac());
            return;
        }
        ArrayList<com.tplink.smb.omada.portal.domain.model.c.b> needCancelAuthList = new ArrayList<com.tplink.smb.omada.portal.domain.model.c.b>(authRecords.size());
        HashMap<String, Long> hotspotVoucherTrafficMap = new HashMap<String, Long>(authRecords.size());
        HashMap<String, Long> hotspotLocalUserTrafficMap = new HashMap<String, Long>(authRecords.size());
        boolean voucherOrLocalUserAuth = false;
        for (com.tplink.smb.omada.portal.domain.model.c.b authRecord : authRecords) {
            if (Objects.equals((Object)authRecord.E(), (Object)com.tplink.smb.omada.portal.domain.model.shared.b.d) || Objects.equals((Object)authRecord.E(), (Object)com.tplink.smb.omada.portal.domain.model.shared.b.f)) {
                voucherOrLocalUserAuth = true;
            }
            if (clientImage.getIp() != null && !clientImage.getIp().equals(authRecord.Y())) {
                authRecord.m(clientImage.getIp()).i(v.b((String)clientImage.getIp()));
            }
            long trafficIncrement = this.a(authRecord, clientImage.getTraffic().getAuthedDownload(authRecord.n().a()), clientImage.getTraffic().getAuthedUpload(authRecord.n().a()));
            if (this.a(authRecord)) {
                hotspotVoucherTrafficMap.put(authRecord.G().b(), trafficIncrement);
            } else if (this.b(authRecord)) {
                hotspotLocalUserTrafficMap.put(authRecord.J().a(), trafficIncrement);
            }
            this.a(authRecord, clientImage);
            authRecord.f(clientImage.getTraffic().getAuthedDownload(authRecord.n().a()));
            authRecord.g(clientImage.getTraffic().getAuthedUpload(authRecord.n().a()));
            authRecord.h(TimeUnit.MILLISECONDS.toSeconds(clientImage.getLastSeen() - authRecord.C()));
            if (authRecord.X() < 0L) {
                authRecord.h(0L);
            }
            if (this.c(authRecord)) {
                needCancelAuthList.add(authRecord);
            }
            if (this.d(authRecord)) {
                needCancelAuthList.add(authRecord);
            }
            if (authRecord.s() == null) {
                authRecord.a(clientImage.getName());
            }
            if (authRecord.Y() == null && clientImage.getIp() != null) {
                authRecord.m(clientImage.getIp());
                authRecord.i(v.b((String)authRecord.Y()));
            }
            if (authRecord.E() != com.tplink.smb.omada.portal.domain.model.shared.b.j || !clientImage.isWireless()) continue;
            authRecord.a(clientImage.getRadioId());
        }
        this.l.clientInformHandleInTimeRangeLogging(start, "taskGetTrafficIncrement", new String[]{"clientMac", clientImage.getMac()});
        if (!needCancelAuthList.isEmpty() && cancelAuthEnable) {
            com.tplink.smb.omada.portal.domain.model.c.b authRecordDO = (com.tplink.smb.omada.portal.domain.model.c.b)needCancelAuthList.get(0);
            com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
                if (!this.d.a(authRecordDO, false, start).a()) {
                    a.warn("invalid auth record failed, send message to device failed, record id {}", (Object)authRecordDO.n());
                }
            });
        }
        this.b.c(authRecords);
        this.l.clientInformHandleInTimeRangeLogging(start, "taskUpdateAuthRecordTraffic", new String[]{"clientMac", clientImage.getMac()});
        this.c(hotspotVoucherTrafficMap, omadacId, siteId);
        this.d(hotspotLocalUserTrafficMap, omadacId, siteId);
        this.l.clientInformHandleInTimeRangeLogging(start, "taskNotifyVoucherAndLocalUserTrafficUpdate", new String[]{"clientMac", clientImage.getMac()});
        if (!voucherOrLocalUserAuth) {
            this.f.a(omadacId, siteId, clientImage.getMac(), System.currentTimeMillis() + clientImage.getTraffic().getRecordInterval());
        }
        this.l.clientInformHandleInTimeRangeLogging(start, "taskSaveAuthRecordTrafficTask", new String[]{"clientMac", clientImage.getMac()});
        if (authRecords.stream().anyMatch(com.tplink.smb.omada.portal.domain.model.c.b::a)) {
            this.g.b(omadacId, siteId);
        }
        this.l.clientInformHandleInTimeRangeLogging(start, "taskEnd", new String[]{"clientMac", clientImage.getMac()});
    }

    public void a(List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords, @Nonnull ClientImageBriefDTO clientImage, Map<z, Map<String, Map<String, Set<String>>>> sitePortalAuthsMap, boolean clientHistoryEnabled) {
        if (!this.m.a("portal:authed_clients:traffic")) {
            return;
        }
        r omadacId = clientImage.getOmadacId();
        z siteId = clientImage.getSiteId();
        if (CollectionUtils.isEmpty(authRecords)) {
            return;
        }
        HashMap<String, Long> hotspotVoucherTrafficMap = new HashMap<String, Long>(authRecords.size());
        HashMap<String, Long> hotspotLocalUserTrafficMap = new HashMap<String, Long>(authRecords.size());
        for (com.tplink.smb.omada.portal.domain.model.c.b authRecord : authRecords) {
            this.a(authRecord, sitePortalAuthsMap, clientHistoryEnabled);
            authRecord.a(false);
            long trafficIncrement = this.a(authRecord, clientImage.getTraffic().getAuthedDownload(authRecord.n().a()), clientImage.getTraffic().getAuthedUpload(authRecord.n().a()));
            if (this.a(authRecord)) {
                hotspotVoucherTrafficMap.put(authRecord.G().b(), trafficIncrement);
            } else if (this.b(authRecord)) {
                hotspotLocalUserTrafficMap.put(authRecord.J().a(), trafficIncrement);
            }
            this.a(authRecord, clientImage);
            authRecord.f(clientImage.getTraffic().getAuthedDownload(authRecord.n().a()));
            authRecord.g(clientImage.getTraffic().getAuthedUpload(authRecord.n().a()));
            authRecord.h(TimeUnit.MILLISECONDS.toSeconds(clientImage.getLastSeen() - authRecord.C()));
            if (authRecord.X() < 0L) {
                authRecord.h(0L);
            }
            if (authRecord.s() == null) {
                authRecord.a(clientImage.getName());
            }
            if (authRecord.Y() == null && clientImage.getIp() != null) {
                authRecord.m(clientImage.getIp());
                authRecord.i(v.b((String)authRecord.Y()));
            }
            if (authRecord.E() == com.tplink.smb.omada.portal.domain.model.shared.b.j && clientImage.isWireless()) {
                authRecord.a(clientImage.getRadioId());
            }
            authRecord.b(System.currentTimeMillis());
        }
        this.b.a(authRecords);
        this.b(hotspotVoucherTrafficMap, omadacId, siteId);
        this.a(hotspotLocalUserTrafficMap, omadacId, siteId);
    }

    public void a(r omadacId, z siteId, List<com.tplink.smb.omada.portal.domain.model.c.b> authRecords, o notifiedClient, boolean clientHistoryEnabled) {
        if (!this.m.a("portal:authed_clients:traffic")) {
            return;
        }
        if (CollectionUtils.isEmpty(authRecords)) {
            return;
        }
        HashMap<String, Long> hotspotVoucherTrafficMap = new HashMap<String, Long>(authRecords.size());
        HashMap<String, Long> hotspotLocalUserTrafficMap = new HashMap<String, Long>(authRecords.size());
        for (com.tplink.smb.omada.portal.domain.model.c.b authRecord : authRecords) {
            this.a(authRecord, null, clientHistoryEnabled);
            authRecord.a(false);
            long trafficIncrement = notifiedClient.f() + notifiedClient.g();
            if (this.a(authRecord)) {
                hotspotVoucherTrafficMap.put(authRecord.G().b(), trafficIncrement);
            } else if (this.b(authRecord)) {
                hotspotLocalUserTrafficMap.put(authRecord.J().a(), trafficIncrement);
            }
            authRecord.c(notifiedClient.g());
            authRecord.d(notifiedClient.f());
            authRecord.e(notifiedClient.h());
            authRecord.f(authRecord.V() + notifiedClient.g());
            authRecord.g(authRecord.W() + notifiedClient.f());
            authRecord.h(TimeUnit.MILLISECONDS.toSeconds(notifiedClient.l() - authRecord.C()));
            if (authRecord.X() < 0L) {
                authRecord.h(0L);
            }
            authRecord.b(System.currentTimeMillis());
        }
        this.b.a(authRecords);
        this.b(hotspotVoucherTrafficMap, omadacId, siteId);
        this.a(hotspotLocalUserTrafficMap, omadacId, siteId);
    }

    private void a(com.tplink.smb.omada.portal.domain.model.c.b record, @Nullable Map<z, Map<String, Map<String, Set<String>>>> sitePortalAuthsMap, boolean clientHistoryEnabled) {
        r omadacId = record.o();
        Optional<com.tplink.smb.omada.portal.domain.model.c.b> oldOptional = this.b.b(omadacId, record.n());
        if (sitePortalAuthsMap != null) {
            Map portalAuthsMap = sitePortalAuthsMap.computeIfAbsent(record.p(), map -> new HashMap());
            Map authMap = portalAuthsMap.computeIfAbsent(record.r().b(), map -> new HashMap());
            Set authRecordSet = authMap.computeIfAbsent(record.q(), set -> new HashSet());
            authRecordSet.add(record.n().a());
        }
        if (oldOptional.isPresent() && Boolean.TRUE.equals(oldOptional.get().F()) && clientHistoryEnabled) {
            HashMap<String, String> mac2Name = new HashMap<String, String>(2);
            mac2Name.put(record.q(), record.s());
            if (record.t() != null) {
                this.h.a(OmadaLogDTO.build((String)omadacId.a(), (String)record.p().a(), (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.W_C_PRT_EXP, mac2Name, (String[])new String[]{record.q(), record.x()}), OmadaLogKeyEnumDTO.W_C_PRT_EXP, true);
            } else if (record.u() != null) {
                this.h.a(OmadaLogDTO.build((String)omadacId.a(), (String)record.p().a(), (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.L_C_AUTH_EXP, mac2Name, (String[])new String[]{record.q(), record.Q()}), OmadaLogKeyEnumDTO.L_C_AUTH_EXP, true);
            }
        }
    }

    private void a(Map<String, Long> hotspotLocalUserTrafficMap, r omadacId, z siteId) {
        if (CollectionUtils.isEmpty(hotspotLocalUserTrafficMap)) {
            return;
        }
        this.k.b(omadacId.a(), siteId.a(), () -> {
            hotspotLocalUserTrafficMap.forEach((username, traffic) -> {
                com.tplink.smb.omada.portal.domain.model.g.d localUserDO = this.j.a(omadacId, siteId, (String)username);
                if (localUserDO == null) {
                    a.warn("Cannot find local user {} in site {} in omadac {}", new Object[]{com.tplink.smb.omada.common.util.e.a.c((String)username), siteId, omadacId});
                    return;
                }
                localUserDO.e(localUserDO.v() == null ? traffic : localUserDO.v() + traffic);
                if (!Boolean.FALSE.equals(localUserDO.u()) && localUserDO.t() <= localUserDO.v() / n) {
                    localUserDO.e(false);
                    localUserDO.a(false);
                }
                this.j.a(localUserDO);
            });
            return true;
        }, () -> {
            a.info("updateLocalUserStatusOnNotified Operation failed because other operations are being performed on omadacId {} and site {}.", (Object)omadacId, (Object)siteId);
            return false;
        });
    }

    private void b(Map<String, Long> hotspotVoucherTrafficMap, r omadacId, z siteId) {
        if (CollectionUtils.isEmpty(hotspotVoucherTrafficMap)) {
            return;
        }
        this.k.b(omadacId.a(), siteId.a(), () -> {
            hotspotVoucherTrafficMap.forEach((code, traffic) -> {
                m voucherDO = this.i.a(omadacId, siteId, (String)code);
                if (voucherDO == null) {
                    a.debug("Cannot find voucher {} in site {} in omadac {}", new Object[]{code, siteId, omadacId});
                    return;
                }
                voucherDO.l(voucherDO.J() == null ? traffic : voucherDO.J() + traffic);
                if (!Boolean.FALSE.equals(voucherDO.I()) && voucherDO.E() <= voucherDO.J() / n) {
                    long count;
                    voucherDO.e(false);
                    voucherDO.l(voucherDO.E() * n);
                    if (Objects.equals(com.tplink.smb.omada.client.common.constant.j.a.e, voucherDO.F())) {
                        voucherDO.k(System.currentTimeMillis());
                    }
                    if (Objects.equals(0, voucherDO.k()) && voucherDO.m() >= voucherDO.l() && (count = this.b.d(omadacId, siteId, (String)code, true)) == 0L) {
                        voucherDO.k(System.currentTimeMillis());
                    }
                }
                this.i.a(voucherDO);
            });
            return true;
        }, () -> {
            a.info("updateVoucherStatusOnNotified Operation failed because other operations are being performed on omadacId {} and site {}.", (Object)omadacId, (Object)siteId);
            return false;
        });
    }

    private void a(com.tplink.smb.omada.portal.domain.model.c.b authRecord, ClientImageBriefDTO clientImage) {
        ClientTrafficDTO traffic = clientImage.getTraffic();
        long downLoadIncrement = traffic.getAuthedDownload(authRecord.n().a()) - authRecord.V();
        long upLoadIncrement = traffic.getAuthedUpload(authRecord.n().a()) - authRecord.W();
        authRecord.c(Optional.ofNullable(authRecord.S()).orElse(0L) + downLoadIncrement);
        authRecord.d(Optional.ofNullable(authRecord.T()).orElse(0L) + upLoadIncrement);
        long firstSeen = clientImage.getLastSeen() - TimeUnit.SECONDS.toMillis(clientImage.getDuration());
        if (firstSeen < authRecord.C()) {
            long duration = clientImage.getLastSeen() > authRecord.C() ? clientImage.getLastSeen() - authRecord.C() : 0L;
            authRecord.e(TimeUnit.MILLISECONDS.toSeconds(duration));
        } else {
            authRecord.e(clientImage.getDuration());
        }
    }

    private void c(Map<String, Long> voucherTrafficMap, r omadacId, z siteId) {
        if (CollectionUtils.isEmpty(voucherTrafficMap)) {
            return;
        }
        DomainEventBusHolder.getPublisher().publish((DomainEvent)new f(omadacId, siteId, voucherTrafficMap, Integer.valueOf(com.tplink.smb.omada.portal.domain.model.shared.b.d.x)));
    }

    private void d(Map<String, Long> usernameTrafficMap, r omadacId, z siteId) {
        if (CollectionUtils.isEmpty(usernameTrafficMap)) {
            return;
        }
        DomainEventBusHolder.getPublisher().publish((DomainEvent)new f(omadacId, siteId, usernameTrafficMap, Integer.valueOf(com.tplink.smb.omada.portal.domain.model.shared.b.f.x)));
    }

    private long a(com.tplink.smb.omada.portal.domain.model.c.b dbAuthRecord, long authedDownCache, long authedUpCache) {
        long result = authedDownCache - dbAuthRecord.V() + authedUpCache - dbAuthRecord.W();
        return result <= 0L ? 0L : result;
    }

    private boolean a(com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        com.tplink.smb.omada.portal.domain.model.c.v voucher = authRecord.G();
        return Objects.equals((Object)com.tplink.smb.omada.portal.domain.model.shared.b.d, (Object)authRecord.E()) && voucher != null && Boolean.TRUE.equals(voucher.g()) && voucher.h() != null;
    }

    private boolean b(com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        com.tplink.smb.omada.portal.domain.model.c.o localUser = authRecord.J();
        return Objects.equals((Object)com.tplink.smb.omada.portal.domain.model.shared.b.f, (Object)authRecord.E()) && localUser != null && Boolean.TRUE.equals(localUser.f()) && localUser.g() != null;
    }

    private boolean c(com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        if (!Objects.equals((Object)com.tplink.smb.omada.portal.domain.model.shared.b.c, (Object)authRecord.E()) && !Objects.equals((Object)com.tplink.smb.omada.portal.domain.model.shared.b.i, (Object)authRecord.E())) {
            return false;
        }
        q radiusUser = authRecord.L();
        if (radiusUser == null || radiusUser.n() == null || radiusUser.o() == null) {
            return false;
        }
        if (radiusUser.n() > 0L && authRecord.V() >= radiusUser.n() || radiusUser.o() > 0L && authRecord.W() >= radiusUser.o()) {
            if (radiusUser.r() == null || radiusUser.r() <= 0) {
                radiusUser.c(com.tplink.smb.omada.portal.port.radius.b.a.e.a());
            }
            return true;
        }
        long totalTrafficLimit = Optional.ofNullable(radiusUser.p()).orElse(0L);
        if (totalTrafficLimit > 0L && authRecord.V() + authRecord.W() >= totalTrafficLimit) {
            if (radiusUser.r() == null || radiusUser.r() <= 0) {
                radiusUser.c(com.tplink.smb.omada.portal.port.radius.b.a.e.a());
            }
            return true;
        }
        return false;
    }

    private boolean d(com.tplink.smb.omada.portal.domain.model.c.b authRecord) {
        if (authRecord.E() != com.tplink.smb.omada.portal.domain.model.shared.b.e) {
            return false;
        }
        if (authRecord.M() == null || !authRecord.M().a()) {
            return false;
        }
        return authRecord.V() + authRecord.W() >= authRecord.M().b();
    }

    @Autowired
    public void a(com.tplink.smb.omada.portal.domain.model.c.f authRecordRepository) {
        this.b = authRecordRepository;
    }

    @Autowired
    public void a(w queryDeviceAuthedClientService) {
        this.c = queryDeviceAuthedClientService;
    }

    @Autowired
    public void a(l invalidAuthRecordService) {
        this.d = invalidAuthRecordService;
    }

    @Autowired
    public void a(t osgMacMemCache) {
        this.e = osgMacMemCache;
    }

    @Autowired
    public void a(com.tplink.smb.omada.portal.port.cache.c.a authRecordTrafficTaskCache) {
        this.f = authRecordTrafficTaskCache;
    }

    @Autowired
    public void a(d busySiteCache) {
        this.g = busySiteCache;
    }

    @Autowired
    public void a(e clientLogService) {
        this.h = clientLogService;
    }

    @Autowired
    public void a(x voucherRepository) {
        this.i = voucherRepository;
    }

    @Autowired
    public void a(g localUserRepository) {
        this.j = localUserRepository;
    }

    @Autowired
    public void a(c siteLockFactory) {
        this.k = siteLockFactory;
    }
}

