/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.storage.api.util;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class SnowflakeIdWorker {
    private final long twepoch = new Date(121, 1, 1).getTime();
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static SnowflakeIdWorker idWorker = new SnowflakeIdWorker(SnowflakeIdWorker.getWorkId(), SnowflakeIdWorker.getDataCenterId());

    private SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenterId can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostAddress);
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return sums % 32;
        }
        catch (UnknownHostException e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
    }

    private static Long getDataCenterId() {
        int sums = 0;
        try {
            int[] ints;
            for (int i : ints = StringUtils.toCodePoints((CharSequence)Inet4Address.getLocalHost().getHostName())) {
                sums += i;
            }
        }
        catch (UnknownHostException e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
        return sums % 32;
    }

    public static synchronized Long generateId() {
        return idWorker.nextId();
    }
}

