/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper mapper;

    private JsonUtils() {
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void setMapper(ObjectMapper mapper) {
        JsonUtils.mapper = mapper;
    }

    public static <T> T readFile(File file, Class<T> tClass) throws Exception {
        try {
            return (T)mapper.readValue(file, tClass);
        }
        catch (IOException e) {
            log.warn("Parse json message exception .", (Throwable)e);
            throw e;
        }
    }

    public static <T> T readInputStream(InputStream inputStream, Class<T> tClass) throws Exception {
        try {
            return (T)mapper.readValue(inputStream, tClass);
        }
        catch (IOException e) {
            log.warn("Parse json message exception .", (Throwable)e);
            throw e;
        }
    }

    public static String bean2Json(Object object) throws Exception {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.warn("fail to transfer bean to Json", (Throwable)e);
            throw e;
        }
    }

    public static byte[] bean2Bytes(Object object) throws Exception {
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            log.warn("fail to transfer bean to bytes", (Throwable)e);
            throw e;
        }
    }

    public static <T> T json2bean(String json, Class<T> clazz) throws Exception {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            log.debug("Parse json message exception .", (Throwable)e);
            throw e;
        }
    }

    public static <T> T json2bean(String json, TypeReference<T> tTypeReference) throws Exception {
        try {
            return (T)mapper.readValue(json, tTypeReference);
        }
        catch (IOException e) {
            log.debug("Parse json message exception .", (Throwable)e);
            throw e;
        }
    }

    public static <T> T json2bean(String json, JavaType javaType) throws Exception {
        try {
            return (T)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            log.debug("Parse json message exception .", (Throwable)e);
            throw e;
        }
    }

    public static <T> T map2Bean(Map map, Class<T> tClass) {
        return (T)mapper.convertValue((Object)map, tClass);
    }

    public static <T> List<T> json2list(String json, Class<T> tClass) throws Exception {
        JavaType type = JsonUtils.getCollectionType(List.class, tClass);
        try {
            return (List)mapper.readValue(json, type);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to list .", (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Object> json2Map(String json) throws Exception {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to map .", (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Object> json2MapWithoutLog(String json) throws Exception {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)mapper.readValue(json, (TypeReference)typeRef);
    }

    public static boolean hasKey(JSONObject jsonObject, String key) {
        return !jsonObject.isNull(key);
    }

    public static boolean hasKeys(JSONObject jsonObject, String ... keys) {
        if (keys == null || keys.length < 1) {
            return false;
        }
        for (String key : keys) {
            if (!jsonObject.isNull(key)) continue;
            return false;
        }
        return true;
    }

    public static JSONObject fromObject(Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Map) {
            return new JSONObject((Map)origin);
        }
        if (origin instanceof String) {
            return new JSONObject((String)origin);
        }
        if (origin instanceof JSONObject) {
            return new JSONObject(((JSONObject)origin).toMap());
        }
        return new JSONObject(origin);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{elementClasses});
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, (JsonSerializer)new JsonSerializer<JSONObject>(){

            public void serialize(JSONObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addSerializer(JSONArray.class, (JsonSerializer)new JsonSerializer<JSONArray>(){

            public void serialize(JSONArray value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new JsonDeserializer<JSONObject>(){

            public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_OBJECT) {
                    Map map = (Map)p.readValueAs(Map.class);
                    return new JSONObject(map);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
        });
        module.addDeserializer(JSONArray.class, (JsonDeserializer)new JsonDeserializer<JSONArray>(){

            public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_ARRAY) {
                    List list = (List)p.readValueAs(List.class);
                    return new JSONArray((Collection)list);
                }
                return (JSONArray)ctxt.handleUnexpectedToken(JSONArray.class, p);
            }
        });
        mapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS}).build();
        mapper.registerModule((Module)module);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

