/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class GenerateBssidUtils {
    public static HashMap<String, String> generateAllScanBssidMap(List<String> scanApMacList, int radioId) {
        HashMap<String, String> allScanApBssidMap = new HashMap<String, String>();
        for (String apMac : scanApMacList) {
            ArrayList<Object> bssids = new ArrayList<Object>();
            List<Object> extraBssidList = new ArrayList();
            switch (radioId) {
                case 0: {
                    extraBssidList = GenerateBssidUtils.generate2gBssidList(apMac);
                    break;
                }
                case 1: {
                    extraBssidList = GenerateBssidUtils.generate5g1BssidList(apMac);
                    break;
                }
                case 3: {
                    extraBssidList = GenerateBssidUtils.generate6gBssidList(apMac, false);
                    break;
                }
            }
            System.out.println("generateAllScanBssidMap-apMac:" + apMac + " bssid:" + extraBssidList.toString());
            bssids.addAll(extraBssidList);
            if (CollectionUtils.isEmpty(bssids)) continue;
            for (String string : bssids) {
                if (string == null || Objects.equals(string, apMac)) continue;
                allScanApBssidMap.put(string, apMac);
            }
        }
        System.out.println("generateAllScanBssidMap-allScanApBssidMap:" + allScanApBssidMap.toString());
        return allScanApBssidMap;
    }

    public static List<String> generate2gBssidList(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        for (int index = 0; index < 8; ++index) {
            if (index == 0) {
                bssidList.add(apMac);
                continue;
            }
            bssidList.add(GenerateBssidUtils.generate2gOr5gBssid(apMac, index));
        }
        return bssidList;
    }

    public static List<String> generate5g1BssidList(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        String startBssid = GenerateBssidUtils.getAddMac(apMac, 1);
        for (int index = 0; index < 9; ++index) {
            if (index == 0) {
                bssidList.add(startBssid);
                continue;
            }
            bssidList.add(GenerateBssidUtils.generate2gOr5gBssid(startBssid, index));
        }
        return bssidList;
    }

    public static List<String> generate5g2BssidList(String apMac) {
        ArrayList<String> bssidList = new ArrayList<String>();
        String startBssid = GenerateBssidUtils.getAddMac(apMac, 2);
        for (int index = 0; index < 9; ++index) {
            if (index == 0) {
                bssidList.add(startBssid);
                continue;
            }
            bssidList.add(GenerateBssidUtils.generate2gOr5gBssid(startBssid, index));
        }
        return bssidList;
    }

    public static String generate2gOr5gBssid(String apMac, int index) {
        String[] macStr = apMac.split("-");
        int bssidNum = Integer.parseInt(macStr[0], 16);
        int tempBssidNum = (bssidNum & 0xFC) + (index << 2) & 0xFC;
        bssidNum = bssidNum & 3 | tempBssidNum | 2;
        macStr[0] = String.format("%02X", bssidNum);
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : macStr) {
            stringBuilder.append(str).append("-");
        }
        return stringBuilder.toString().substring(0, 17);
    }

    public static List<String> generate6gBssidList(String apMac, boolean support5g2) {
        ArrayList<String> bssidList = new ArrayList<String>();
        int num = support5g2 ? 3 : 2;
        String startBssid = GenerateBssidUtils.getAddMac(apMac, num);
        for (int index = 0; index < 10; ++index) {
            bssidList.add(GenerateBssidUtils.generate6gBssid(startBssid, index));
        }
        return bssidList;
    }

    public static String generate6gBssid(String apMac, int index) {
        String[] macStr = apMac.split("-");
        int bssidNum0 = Integer.parseInt(macStr[0], 16);
        int bssidNum5 = Integer.parseInt(macStr[5], 16);
        int tempBssidNum = bssidNum5 & 0xF;
        bssidNum5 &= 0xF0;
        macStr[0] = String.format("%02X", bssidNum0 |= 2);
        macStr[5] = String.format("%02X", bssidNum5 |= (tempBssidNum + index) % 16);
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : macStr) {
            stringBuilder.append(str).append("-");
        }
        return stringBuilder.toString().substring(0, 17);
    }

    public static String getAddLastMac(String apMac, int num) {
        String lastChar = apMac.substring(apMac.length() - 1).toUpperCase(Locale.getDefault());
        apMac = apMac.substring(0, apMac.length() - 1);
        if ("F".equals(lastChar)) {
            lastChar = "0";
        } else {
            int tempChar = Integer.parseInt(lastChar, 16) + num;
            lastChar = Integer.toHexString(tempChar).toUpperCase(Locale.getDefault());
        }
        return apMac + lastChar;
    }

    public static String getAddMac(String apMac, int num) {
        String[] macStr = apMac.split("-");
        String macStrAppend = "";
        for (int i = 0; i < macStr.length; ++i) {
            macStrAppend = macStrAppend + macStr[i];
        }
        String macStrAdd = Long.toHexString(Long.parseLong(macStrAppend, 16) + (long)num).toUpperCase(Locale.getDefault());
        if (macStrAdd.length() < macStrAppend.length()) {
            int delta = macStrAppend.length() - macStrAdd.length();
            macStrAdd = Stream.generate(() -> "0").limit(delta).collect(Collectors.joining()) + macStrAdd;
        }
        macStrAdd = GenerateBssidUtils.formatMac(macStrAdd, "-");
        return macStrAdd;
    }

    public static String formatMac(String mac, String split) {
        String regex = "[0-9a-fA-F]{12}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mac);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("mac format is error");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            char c = mac.charAt(i);
            sb.append(c);
            if ((i & 1) != 1 || i > 9) continue;
            sb.append(split);
        }
        return sb.toString();
    }
}

