/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtils {
    private static final Logger log = LoggerFactory.getLogger(DebugUtils.class);

    private DebugUtils() {
    }

    public static boolean isChannelDeployMsgEnable() {
        return DebugHolder.isChannelDeployMsgEnable();
    }

    public static void setChannelDeployMsgEnable(boolean enable) {
        DebugHolder.setChannelDeployMsgEnable(enable);
    }

    private static class DebugHolder {
        static AtomicBoolean CHANNEL_DEPLOY_MSG_ENABLE = new AtomicBoolean(false);
        static AtomicBoolean HAS_READ_CHANNEL_DEPLOY_MSG_ENABLE = new AtomicBoolean(false);

        private DebugHolder() {
        }

        static boolean isChannelDeployMsgEnable() {
            if (HAS_READ_CHANNEL_DEPLOY_MSG_ENABLE.get()) {
                return CHANNEL_DEPLOY_MSG_ENABLE.get();
            }
            CHANNEL_DEPLOY_MSG_ENABLE.getAndSet(Boolean.parseBoolean(System.getProperty("debug.channel.deploy.msg.enable")));
            HAS_READ_CHANNEL_DEPLOY_MSG_ENABLE.getAndSet(true);
            return CHANNEL_DEPLOY_MSG_ENABLE.get();
        }

        static void setChannelDeployMsgEnable(boolean enable) {
            CHANNEL_DEPLOY_MSG_ENABLE.getAndSet(enable);
        }
    }

    private static class Keys {
        static final String DEBUG_CHANNEL_DEPLOY_MSG_ENABLE = "debug.channel.deploy.msg.enable";

        private Keys() {
        }
    }
}

