/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.utils;

import com.tplink.smb.algorithm.common.AlgAp;
import com.tplink.smb.algorithm.common.BaseAlgAp;
import com.tplink.smb.algorithm.common.ChannelsInfo;
import com.tplink.smb.algorithm.common.Connection;
import com.tplink.smb.algorithm.common.RFPlanningScanResult;
import com.tplink.smb.algorithm.common.RRMHistJamEventSolve;
import com.tplink.smb.algorithm.common.RRMJamEventAndSolve;
import com.tplink.smb.algorithm.common.RRMJamEventInfo;
import com.tplink.smb.algorithm.common.RRMJamEventSolveDetail;
import com.tplink.smb.algorithm.common.RRMJamSolution;
import com.tplink.smb.algorithm.common.RRMRFConfigChange;
import com.tplink.smb.algorithm.common.ScanAlgAp;
import com.tplink.smb.algorithm.common.ScanBss;
import com.tplink.smb.algorithm.common.ScanInfo;
import com.tplink.smb.algorithm.common.ScanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDeployUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonDeployUtils.class);
    private static final int RSSI_MAXIMUMS = 0;
    private static final int RSSI_DEFAULT = -70;
    private static final int NF_MAXIMUMS = -80;
    private static final int CL_MAXIMUMS = 80;
    private static final int CL_MAXIMUMS_RRM = 100;
    private static final int RSSI_DELTA = 5;
    private static final int BAND_BSSID_MAX_CNT = 16;
    private static final int PASTTIMEMS = 0x6DDD00;
    private static final int BUSY_UTILTH_NON2G = 80;
    private static final int BUSY_UTILTH_2G = 80;
    private static final int INTER_UTILTH_NON2G = 50;
    private static final int INTER_UTILTH_2G = 40;
    private static final int SCANFREQ_TH = 2;
    private static final int MAXSCANFREQ = 6;
    private static final int CHCHANGEFREQ_TH = 2;
    private static final int SCAN_PASSIVE_DEFAULT = 0;
    private static final int MAX_SCAN_Number = 256;
    private static final String VIRTUAL_NEIGHBORMAC = "AA-AA-AA-AA-AA-AA";
    private static final int VIRTUAL_RSSI = -109;

    private CommonDeployUtils() {
    }

    public static void copyRFConfig(ArrayList<AlgAp> apList1, ArrayList<AlgAp> apList2) {
        block0: for (int i = 0; i < apList1.size(); ++i) {
            for (int j = 0; j < apList2.size(); ++j) {
                if (!apList1.get(i).getMac().equals(apList2.get(j).getMac())) continue;
                apList1.get(i).setChannel(apList2.get(j).getChannel());
                apList1.get(i).setTxPower(apList2.get(j).getTxPower());
                apList1.get(i).setWidth(apList2.get(j).getWidth());
                apList1.get(i).setMaxTxPower(apList2.get(j).getMaxTxPower());
                continue block0;
            }
        }
    }

    public static RRMJamSolution getRRMJamSolution(ArrayList<AlgAp> apListInput, ArrayList<AlgAp> apListOut, ArrayList<RFPlanningScanResult> origGlobalScan, int RRMEnableMethod, RRMJamEventInfo curJamEvent, int radioId) {
        ArrayList<BaseAlgAp> baseApListOut = CommonDeployUtils.getBaseAlgApList(apListOut);
        RRMJamSolution rrmJamSolution = new RRMJamSolution();
        rrmJamSolution.setOrigGlobalScan(origGlobalScan);
        rrmJamSolution.setApSolution(baseApListOut);
        RRMRFConfigChange rrmrfConfigChange = new RRMRFConfigChange();
        rrmrfConfigChange.init();
        rrmJamSolution.setConfigChangeSolution(rrmrfConfigChange);
        if (null == apListInput || null == apListOut || apListInput.size() != apListOut.size()) {
            return rrmJamSolution;
        }
        if (0 == RRMEnableMethod) {
            String jamApMac = curJamEvent.getApMac();
            CommonDeployUtils.setRRMrfConf(rrmrfConfigChange, apListInput, apListOut, jamApMac);
        }
        ArrayList<RFPlanningScanResult> ansGlobalScanList = CommonDeployUtils.fixOrigGlobalScan(apListInput, apListOut, origGlobalScan, radioId);
        rrmJamSolution.setOrigGlobalScan(ansGlobalScanList);
        return rrmJamSolution;
    }

    public static ArrayList<RFPlanningScanResult> fixOrigGlobalScan(ArrayList<AlgAp> apListInput, ArrayList<AlgAp> apListOut, ArrayList<RFPlanningScanResult> origGlobalScan, int radioId) {
        log.debug("fixOrigGlobalScan print input:");
        log.debug("apListInput: " + (null == apListInput ? "null" : apListInput.toString()));
        log.debug("apListOut: " + (null == apListOut ? "null" : apListOut.toString()));
        log.debug("origGlobalScan: " + (null == origGlobalScan ? "null" : origGlobalScan.toString()));
        log.debug("radioId: " + radioId);
        ArrayList<RFPlanningScanResult> ans = CommonDeployUtils.deepCopyOrigScan(origGlobalScan);
        if (null == apListInput || 0 == apListInput.size() || null == apListOut || 0 == apListOut.size()) {
            return ans;
        }
        for (int i = 0; i < apListInput.size(); ++i) {
            String apMac = apListInput.get(i).getMac();
            int afterTxPower = apListInput.get(i).getTxPower();
            boolean changeFlag = false;
            for (int j = 0; j < apListOut.size(); ++j) {
                if (apMac.equals(apListOut.get(j).getMac()) && apListInput.get(i).getTxPower() != apListOut.get(j).getTxPower()) {
                    afterTxPower = apListOut.get(j).getTxPower();
                    changeFlag = true;
                }
                if (!changeFlag) continue;
                for (int k = 0; k < ans.size(); ++k) {
                    ScanResult ansScanResult = ans.get(k).getScanResults();
                    List<ChannelsInfo> ansChannels = ansScanResult.getChannels();
                    if (null == ansChannels) continue;
                    for (int m = 0; m < ansChannels.size(); ++m) {
                        List<ScanBss> bss = ansChannels.get(m).getBss();
                        if (null == bss) continue;
                        for (int n = 0; n < bss.size(); ++n) {
                            if (!bss.get(n).getMac().equals(apMac)) continue;
                            bss.get(n).setRssi(bss.get(n).getRssi() + afterTxPower - apListInput.get(i).getTxPower());
                        }
                    }
                }
            }
        }
        return ans;
    }

    public static ArrayList<RFPlanningScanResult> deepCopyOrigScan(ArrayList<RFPlanningScanResult> origGlobalScan) {
        ArrayList<RFPlanningScanResult> ans = new ArrayList<RFPlanningScanResult>();
        if (null == origGlobalScan || 0 == origGlobalScan.size()) {
            return ans;
        }
        for (int i = 0; i < origGlobalScan.size(); ++i) {
            RFPlanningScanResult ansRFPlanningScanResult = new RFPlanningScanResult();
            ansRFPlanningScanResult.setId(origGlobalScan.get(i).getId());
            ansRFPlanningScanResult.setSiteId(origGlobalScan.get(i).getSiteId());
            ansRFPlanningScanResult.setOmadacId(origGlobalScan.get(i).getOmadacId());
            ansRFPlanningScanResult.setMac(origGlobalScan.get(i).getMac());
            ansRFPlanningScanResult.setScanResults(CommonDeployUtils.deepCopyScanResults(origGlobalScan.get(i).getScanResults()));
            ansRFPlanningScanResult.setRadioId(origGlobalScan.get(i).getRadioId());
            ans.add(ansRFPlanningScanResult);
        }
        return ans;
    }

    public static ScanResult deepCopyScanResults(ScanResult origScanResults) {
        ScanResult ans = new ScanResult();
        if (null == origScanResults) {
            return ans;
        }
        ScanResult newScanResult = new ScanResult();
        newScanResult.setRadioId(origScanResults.getRadioId());
        newScanResult.setChWidth(origScanResults.getChWidth());
        newScanResult.setTxPower(origScanResults.getTxPower());
        newScanResult.setChannels(CommonDeployUtils.deepCopyChannelsInfo(origScanResults.getChannels()));
        return newScanResult;
    }

    public static List<ChannelsInfo> deepCopyChannelsInfo(List<ChannelsInfo> origChannelsList) {
        ArrayList<ChannelsInfo> ans = new ArrayList<ChannelsInfo>();
        if (null == origChannelsList || 0 == origChannelsList.size()) {
            return ans;
        }
        for (int i = 0; i < origChannelsList.size(); ++i) {
            ChannelsInfo newChannelsInfo = new ChannelsInfo();
            newChannelsInfo.setChannel(origChannelsList.get(i).getChannel());
            newChannelsInfo.setNsFloor(origChannelsList.get(i).getNsFloor());
            newChannelsInfo.setLoadUtil(origChannelsList.get(i).getLoadUtil());
            newChannelsInfo.setBss(CommonDeployUtils.deepCopyScanBss(origChannelsList.get(i).getBss()));
            ans.add(newChannelsInfo);
        }
        return ans;
    }

    public static List<ScanBss> deepCopyScanBss(List<ScanBss> origScanBssList) {
        ArrayList<ScanBss> ans = new ArrayList<ScanBss>();
        if (null == origScanBssList || 0 == origScanBssList.size()) {
            return ans;
        }
        for (int i = 0; i < origScanBssList.size(); ++i) {
            ScanBss newScanBss = new ScanBss();
            newScanBss.setMac(origScanBssList.get(i).getMac());
            newScanBss.setRssi(origScanBssList.get(i).getRssi());
            newScanBss.setTxPower(origScanBssList.get(i).getTxPower());
            newScanBss.setBssidRevertToMac(origScanBssList.get(i).getBssidRevertToMac());
            ans.add(newScanBss);
        }
        return ans;
    }

    public static void setRRMrfConf(RRMRFConfigChange rrmrfConfigChange, ArrayList<AlgAp> apListInput, ArrayList<AlgAp> apListOut, String jamApMac) {
        boolean stopFlag1 = false;
        boolean stopFlag2 = false;
        for (int i = 0; i < apListInput.size(); ++i) {
            String apMac;
            if (null != apListInput.get(i) && jamApMac.equals(apMac = apListInput.get(i).getMac())) {
                rrmrfConfigChange.setPreBandOn(true);
                rrmrfConfigChange.setPreChannel(apListInput.get(i).getChannel());
                rrmrfConfigChange.setPreWidth(apListInput.get(i).getWidth());
                rrmrfConfigChange.setPreTxPower(apListInput.get(i).getTxPower());
                stopFlag1 = true;
            }
            if (null != apListOut.get(i) && jamApMac.equals(apMac = apListOut.get(i).getMac())) {
                rrmrfConfigChange.setAfterBandOn(true);
                rrmrfConfigChange.setAfterChannel(apListOut.get(i).getChannel());
                rrmrfConfigChange.setAfterWidth(apListOut.get(i).getWidth());
                rrmrfConfigChange.setAfterTxPower(apListOut.get(i).getTxPower());
                stopFlag2 = true;
            }
            if (!stopFlag1 || !stopFlag2) continue;
            if (rrmrfConfigChange.getPreChannel() != rrmrfConfigChange.getAfterChannel()) {
                rrmrfConfigChange.setChangeChannel(true);
            }
            if (rrmrfConfigChange.getPreWidth() != rrmrfConfigChange.getAfterWidth()) {
                rrmrfConfigChange.setChangeWidth(true);
            }
            if (rrmrfConfigChange.getPreTxPower() != rrmrfConfigChange.getAfterTxPower()) {
                rrmrfConfigChange.setChangePower(true);
            }
            rrmrfConfigChange.setChangeBandOnOff(false);
            return;
        }
    }

    public static ArrayList<Connection> connectionsRRMCombine(ArrayList<Connection> connections1, ArrayList<Connection> connections2, ArrayList<AlgAp> apMacList, int mode1, int mode2) {
        ArrayList<Connection> connectionsAns = new ArrayList<Connection>();
        if (connections1 == null || connections2 == null || apMacList == null) {
            return connections1;
        }
        connections2 = CommonDeployUtils.standardizationRRMConnection(apMacList, connections2, mode1);
        if (connections1.size() == 0 || connections2.size() == 0) {
            return connections1;
        }
        for (Connection connection : connections1) {
            Connection tmpConnection = new Connection(connection.getCenterApMac(), connection.getNeighborApMac(), connection.getIsEnabled(), connection.getChannel(), connection.getRssi(), connection.getChannelLoad(), connection.getNoiseFloor());
            connectionsAns.add(tmpConnection);
        }
        for (Connection connection : connections2) {
            for (int i = 0; i < connectionsAns.size(); ++i) {
                if (!connection.getCenterApMac().equals(connectionsAns.get(i).getCenterApMac()) || connection.getChannel() != connectionsAns.get(i).getChannel()) continue;
                connectionsAns.get(i).setNoiseFloor(connection.getNoiseFloor());
                connectionsAns.get(i).setChannelLoad(connection.getChannelLoad());
            }
        }
        for (Connection connection : connections2) {
            boolean flagConnMac = false;
            boolean flagApMac = false;
            for (int j = 0; j < apMacList.size(); ++j) {
                if (!connection.getCenterApMac().equals(apMacList.get(j).getMac())) continue;
                flagApMac = true;
                break;
            }
            if (!flagApMac) continue;
            for (int i = 0; i < connectionsAns.size(); ++i) {
                if (!connection.getCenterApMac().equals(connectionsAns.get(i).getCenterApMac()) || !connection.getNeighborApMac().equals(connectionsAns.get(i).getNeighborApMac()) || connection.getNeighborApMac().equals(VIRTUAL_NEIGHBORMAC)) continue;
                connectionsAns.get(i).setRssi(connection.getRssi());
                connectionsAns.get(i).setChannel(connection.getChannel());
                connectionsAns.get(i).setIsEnabled(connection.getIsEnabled());
                connectionsAns.get(i).setChannelLoad(connection.getChannelLoad());
                connectionsAns.get(i).setNoiseFloor(connection.getNoiseFloor());
                flagConnMac = true;
                break;
            }
            if (flagConnMac || !flagApMac || connection.getChannel() < 0) continue;
            connectionsAns.add(connection);
        }
        connectionsAns = CommonDeployUtils.standardizationRRMConnection(apMacList, connectionsAns, mode2);
        return connectionsAns;
    }

    public static ArrayList<AlgAp> deepCopyApList(ArrayList<AlgAp> input) {
        ArrayList<AlgAp> output = new ArrayList<AlgAp>();
        for (int i = 0; i < input.size(); ++i) {
            AlgAp tmp = new AlgAp();
            tmp.setBandFlag(input.get(i).getBandFlag());
            tmp.setStaAccessRssiMap(input.get(i).getStaAccessRssiMap());
            tmp.setAvailableWidthList(input.get(i).getAvailableWidthList());
            tmp.setTrafficList(input.get(i).getTrafficList());
            tmp.setStationLoadList(input.get(i).getStationLoadList());
            tmp.setTxPower(input.get(i).getTxPower());
            tmp.setErrorCode(input.get(i).getErrorCode());
            tmp.setOriginTxPower(input.get(i).getOriginTxPower());
            tmp.setMac(input.get(i).getMac());
            tmp.setWidth(input.get(i).getWidth());
            tmp.setOriginWidth(input.get(i).getOriginWidth());
            tmp.setOriginChannel(input.get(i).getOriginChannel());
            tmp.setOriginBandFlag(input.get(i).getOriginBandFlag());
            tmp.setMinTxPower(input.get(i).getMinTxPower());
            tmp.setMaxTxPower(input.get(i).getMaxTxPower());
            tmp.setChannel(input.get(i).getChannel());
            tmp.setChannelFlagList(input.get(i).getChannelFlagList());
            tmp.setAvailableChannelList(input.get(i).getAvailableChannelList());
            tmp.setCsaSupport(input.get(i).isCsaSupport());
            tmp.setRRMOptBgScan(input.get(i).isRRMOptBgScan());
            tmp.setSupportRRM(input.get(i).isSupportRRM());
            tmp.setCountryCode(input.get(i).getCountryCode());
            tmp.setWirelessModeWidthList(input.get(i).getWirelessModeWidthList());
            tmp.setAiDeploySupport(input.get(i).getAiDeploySupport());
            output.add(tmp);
        }
        return output;
    }

    public static Map<String, ScanResult> convertOrigScan(ArrayList<RFPlanningScanResult> origScan) {
        HashMap<String, ScanResult> scanResultMap = new HashMap<String, ScanResult>();
        if (null == origScan) {
            return scanResultMap;
        }
        for (int i = 0; i < origScan.size(); ++i) {
            RFPlanningScanResult rfPlanningScanResult = origScan.get(i);
            if (null == rfPlanningScanResult || !rfPlanningScanResult.validate()) continue;
            String apMac = rfPlanningScanResult.getMac();
            ScanResult scanResults = rfPlanningScanResult.getScanResults();
            scanResultMap.put(apMac, scanResults);
        }
        return scanResultMap;
    }

    public static ArrayList<BaseAlgAp> getBaseAlgApList(ArrayList<AlgAp> apList) {
        ArrayList<BaseAlgAp> baseAlgAps = new ArrayList<BaseAlgAp>();
        if (null == apList) {
            return baseAlgAps;
        }
        for (int i = 0; i < apList.size(); ++i) {
            AlgAp algAp = apList.get(i);
            BaseAlgAp baseAlgAp = new BaseAlgAp();
            baseAlgAp.setMac(algAp.getMac());
            baseAlgAp.setChannel(algAp.getChannel());
            baseAlgAp.setTxPower(algAp.getTxPower());
            baseAlgAp.setWidth(algAp.getWidth());
            baseAlgAp.setBandFlag(algAp.getBandFlag());
            baseAlgAps.add(baseAlgAp);
        }
        return baseAlgAps;
    }

    public static ArrayList<String> getApMacList(ArrayList<AlgAp> apList) {
        ArrayList<String> apMacList = new ArrayList<String>();
        if (null == apList) {
            return apMacList;
        }
        for (int i = 0; i < apList.size(); ++i) {
            if (null == apList.get(i).getMac()) continue;
            apMacList.add(apList.get(i).getMac());
        }
        return apMacList;
    }

    public static ArrayList<Connection> generateChannelScanResult(ArrayList<String> apMacList, ArrayList<AlgAp> apList, boolean isGlobal, boolean isFillTxPower, Map<String, ScanResult> scanResultMap) {
        HashMap<String, Connection> scanResultsMap = new HashMap<String, Connection>();
        ArrayList<Connection> channelScanResult = new ArrayList<Connection>();
        CommonDeployUtils.getChannelScanResult(apMacList, scanResultMap, scanResultsMap, apList, isGlobal, isFillTxPower);
        for (Map.Entry<String, Connection> entry : scanResultsMap.entrySet()) {
            channelScanResult.add(entry.getValue());
        }
        return channelScanResult;
    }

    private static void getChannelScanResult(ArrayList<String> apMacList, Map<String, ScanResult> scanResultMap, HashMap<String, Connection> scanResultsMap, ArrayList<AlgAp> apList, boolean isGlobal, boolean isFillTxPower) {
        for (int i = 0; i < apMacList.size(); ++i) {
            String apMac = apMacList.get(i);
            ScanResult scanResult = scanResultMap.get(apMac);
            if (null == scanResult || CollectionUtils.isEmpty(scanResult.getChannels())) continue;
            List<ChannelsInfo> autoChannelApChannelsInfo = scanResult.getChannels();
            for (ChannelsInfo channelsInfo : autoChannelApChannelsInfo) {
                if (channelsInfo == null || !channelsInfo.validate()) continue;
                if (CollectionUtils.isEmpty(channelsInfo.getBss()) || channelsInfo.getBss().size() > 256) {
                    Connection autoChannelAp = new Connection();
                    autoChannelAp.setCenterApMac(apMac);
                    autoChannelAp.setNeighborApMac(VIRTUAL_NEIGHBORMAC);
                    autoChannelAp.setChannel(channelsInfo.getChannel());
                    autoChannelAp.setRssi(-109);
                    autoChannelAp.setChannelLoad(channelsInfo.getLoadUtil());
                    autoChannelAp.setIsEnabled(1);
                    if (channelsInfo.getNsFloor() == 0 && channelsInfo.getLoadUtil() == 0 && scanResult.getRadioId() != null && scanResult.getRadioId() < 3 && scanResult.getRadioId() > 0) {
                        log.debug("device 5g nf & loadUtil is 100, change chload is 99, nf is -100, rssi is -30");
                        autoChannelAp.setChannelLoad(99);
                        autoChannelAp.setNoiseFloor(-100);
                        autoChannelAp.setRssi(-30);
                    } else if (channelsInfo.getNsFloor() == 0) {
                        autoChannelAp.setNoiseFloor(-100);
                    } else {
                        autoChannelAp.setNoiseFloor(channelsInfo.getNsFloor());
                    }
                    String key = apMac + ":" + VIRTUAL_NEIGHBORMAC + ":" + channelsInfo.getChannel();
                    scanResultsMap.put(key, autoChannelAp);
                    continue;
                }
                List<ScanBss> scanBsses = channelsInfo.getBss();
                CommonDeployUtils.fillScanResultsMap(scanBsses, scanResultsMap, apMacList.get(i), channelsInfo, apList, isGlobal, isFillTxPower, scanResult.getRadioId() == null ? 0 : scanResult.getRadioId());
            }
        }
    }

    public static void fillScanResultsMap(List<ScanBss> scanBsses, HashMap<String, Connection> scanResultsMap, String apMac, ChannelsInfo channelsInfo, ArrayList<AlgAp> apList, boolean isGlobal, boolean isFillTxPower, int radioId) {
        for (ScanBss scanBss : scanBsses) {
            if (null == scanBss) continue;
            Connection autoChannelAp = new Connection();
            autoChannelAp.setCenterApMac(apMac);
            autoChannelAp.setNeighborApMac(scanBss.getMac());
            autoChannelAp.setChannel(channelsInfo.getChannel());
            if (null != scanBss.getBssidRevertToMac() && scanBss.getBssidRevertToMac().booleanValue() && null != apList && isGlobal) {
                for (int i = 0; i < apList.size(); ++i) {
                    if (!scanBss.getMac().equals(apList.get(i).getMac())) continue;
                    if (scanBss.getTxPower() == null || scanBss.getTxPower() == 0) {
                        autoChannelAp.setRssi(scanBss.getRssi());
                    } else {
                        autoChannelAp.setRssi(scanBss.getRssi() + apList.get(i).getTxPower() - scanBss.getTxPower());
                    }
                    if (!isFillTxPower) break;
                    scanBss.setTxPower(apList.get(i).getTxPower());
                    break;
                }
            }
            autoChannelAp.setRssi(scanBss.getRssi());
            autoChannelAp.setChannelLoad(channelsInfo.getLoadUtil());
            autoChannelAp.setIsEnabled(1);
            if (channelsInfo.getNsFloor() == 0 && channelsInfo.getLoadUtil() == 0 && radioId > 0 && radioId < 3) {
                log.debug("device nf & loadUtil is 100, change chload is 99, nf is -100, rssi is -30");
                autoChannelAp.setChannelLoad(99);
                autoChannelAp.setNoiseFloor(-100);
                autoChannelAp.setRssi(-30);
            } else if (channelsInfo.getNsFloor() == 0) {
                autoChannelAp.setNoiseFloor(-100);
            } else {
                autoChannelAp.setNoiseFloor(channelsInfo.getNsFloor());
            }
            String key = apMac + ":" + scanBss.getMac() + ":" + channelsInfo.getChannel();
            scanResultsMap.put(key, autoChannelAp);
        }
    }

    public static ArrayList<ScanInfo> getNewApScanInfo(ArrayList<ScanAlgAp> scanApList) {
        log.debug("getNewApScanInfo\u2014\u2014input print:");
        log.debug(" ***************************** ");
        log.debug("scanApList: " + (null == scanApList ? "null" : scanApList.toString()));
        log.debug(" ***************************** ");
        ArrayList<ScanInfo> scanInfoList = new ArrayList<ScanInfo>();
        if (null == scanApList || 0 == scanApList.size()) {
            log.debug("getNewApScanInfo\u2014\u2014scanApList is null or empty return in advance");
            return scanInfoList;
        }
        for (int k = 0; k < scanApList.size(); ++k) {
            ScanAlgAp ap = scanApList.get(k);
            ScanInfo scanInfo = new ScanInfo();
            scanInfo.setScan(false);
            if (null == ap || null == ap.getMac()) {
                log.debug("ap is null or ap mac is null not scan");
                log.debug(" ***************************** ");
                log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
                log.debug(" ***************************** ");
                scanInfoList.add(scanInfo);
                continue;
            }
            scanInfo.setMac(ap.getMac());
            if (!ap.isRRMOptBgScan()) {
                log.debug("ap not support rrmScan , all radio not scan");
                log.debug(" ***************************** ");
                log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
                log.debug(" ***************************** ");
                scanInfoList.add(scanInfo);
                continue;
            }
            List<Integer> supportRadioList = ap.getSupportRadioList();
            if (null == supportRadioList || 0 == supportRadioList.size()) {
                log.debug("ap not support radio not scan");
                log.debug(" ***************************** ");
                log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
                log.debug(" ***************************** ");
                scanInfoList.add(scanInfo);
                continue;
            }
            List<Integer> onRadioList = ap.getOnRadioList();
            ArrayList<Integer> scanRadioIdList = new ArrayList<Integer>();
            for (int j = 0; j < supportRadioList.size(); ++j) {
                if (1 != onRadioList.get(j)) continue;
                int radioId = supportRadioList.get(j);
                scanRadioIdList.add(radioId);
            }
            if (scanRadioIdList.size() == 0) {
                log.debug("ap not on radio ,not scan");
                log.debug(" ***************************** ");
                log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
                log.debug(" ***************************** ");
                scanInfoList.add(scanInfo);
                continue;
            }
            ArrayList scanRadioList = new ArrayList();
            ArrayList<Integer> scanInterval = new ArrayList<Integer>();
            ArrayList<Integer> scanMode = new ArrayList<Integer>();
            ArrayList<Integer> scanTimes = new ArrayList<Integer>();
            ArrayList<Integer> scanStayTime = new ArrayList<Integer>();
            scanInfo.setScanChannelList2g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g2(new ArrayList<Integer>());
            scanInfo.setScanChannelList6g(new ArrayList<Integer>());
            for (int i = 0; i < scanRadioIdList.size(); ++i) {
                if (0 == scanRadioIdList.get(i)) {
                    scanInfo.setScanChannelList2g(new ArrayList<Integer>(Collections.singletonList(0)));
                    scanInfo.setScan(true);
                } else if (1 == scanRadioIdList.get(i)) {
                    scanInfo.setScanChannelList5g(new ArrayList<Integer>(Collections.singletonList(0)));
                    scanInfo.setScan(true);
                } else if (2 == scanRadioIdList.get(i)) {
                    scanInfo.setScanChannelList5g2(new ArrayList<Integer>(Collections.singletonList(0)));
                    scanInfo.setScan(true);
                } else if (3 == scanRadioIdList.get(i)) {
                    scanInfo.setScanChannelList6g(new ArrayList<Integer>(Collections.singletonList(0)));
                    scanInfo.setScan(true);
                }
                scanInterval.add(2000);
                scanMode.add(0);
                if (0 == ap.getChipType() || 1 == ap.getChipType() || 3 == ap.getChipType()) {
                    scanTimes.add(3);
                    scanStayTime.add(60);
                    continue;
                }
                if (2 != ap.getChipType()) continue;
                scanTimes.add(2);
                scanStayTime.add(100);
            }
            scanInfo.setBand(scanRadioIdList);
            scanInfo.setScanInterval(scanInterval);
            scanInfo.setScanMode(scanMode);
            scanInfo.setScanTimes(scanTimes);
            scanInfo.setScanStayTime(scanStayTime);
            scanInfo.setRrmFlag(true);
            log.debug("new ap scan param print:");
            log.debug(" ***************************** ");
            log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
            log.debug(" ***************************** ");
            scanInfoList.add(scanInfo);
        }
        return scanInfoList;
    }

    public static ScanInfo getJamScanInfo(RRMHistJamEventSolve rrmHistJamEventSolve, RRMJamEventInfo curJamEvent, ScanAlgAp ap) {
        log.debug("getJamScanInfo input print:");
        log.debug(" ***************************** ");
        log.debug("rrmHistJamEventSolve: " + (null == rrmHistJamEventSolve ? "null" : rrmHistJamEventSolve.toString()));
        log.debug("curJamEvent: " + (null == curJamEvent ? "null" : curJamEvent.toString()));
        log.debug("ap: " + (null == ap ? "null" : ap.toString()));
        log.debug(" ***************************** ");
        ScanInfo scanInfo = new ScanInfo();
        scanInfo.setScan(false);
        if (null == ap) {
            log.debug("getJamScanInfo scanAlgAp is null,return in advance");
            log.debug(" ***************************** ");
            log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
            log.debug(" ***************************** ");
            return scanInfo;
        }
        if (null == curJamEvent) {
            log.debug("getJamScanInfo curJamEvent is null , return in advance");
            log.debug(" ***************************** ");
            log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
            log.debug(" ***************************** ");
            return scanInfo;
        }
        if (!(ap.isRRMOptBgScan() && ap.getIsCsaSupportList().get(curJamEvent.getRadioId()).booleanValue() && ap.isSupportRRM())) {
            log.debug("getJamScanInfo ap not support RRMScan or not support RRM or not support CSA or not match radio, return in advance");
            log.debug(" ***************************** ");
            log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
            log.debug(" ***************************** ");
            return scanInfo;
        }
        if (!curJamEvent.getApMac().equals(ap.getMac())) {
            log.debug("getJamScanInfo ap mac not match jamApMac");
            log.debug(" ***************************** ");
            log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
            log.debug(" ***************************** ");
            return scanInfo;
        }
        int scanFreq = rrmHistJamEventSolve == null ? 0 : rrmHistJamEventSolve.getScanFreq();
        int chChangeFreq = rrmHistJamEventSolve == null ? 0 : rrmHistJamEventSolve.getChannelChangeFreq();
        double pScan = 0.0;
        int jamRadioId = curJamEvent.getRadioId();
        if (6 <= scanFreq) {
            pScan = 0.0;
            log.debug("2h scan freq reach 6 times,set pSan = 0");
        } else {
            pScan = CommonDeployUtils.calPscan(jamRadioId, curJamEvent.getAverageBusyUtil(), curJamEvent.getAverageInterUtil(), scanFreq, chChangeFreq);
        }
        double randomNumber = Math.random();
        log.debug("getJamScanInfo print 2h scan freq, channle channge freq, pscan, randomNumber: ");
        log.debug(" ***************************** ");
        log.debug("scanFreq: " + scanFreq);
        log.debug("chChangeFreq: " + chChangeFreq);
        log.debug("pScan: " + pScan);
        log.debug("randomNumber: " + randomNumber);
        log.debug(" ***************************** ");
        if (pScan >= randomNumber) {
            int chipType = ap.getChipType();
            scanInfo = CommonDeployUtils.setJamScanInfo(jamRadioId, chipType, scanInfo, ap);
            log.debug("getJamScanInfo pScan > random, according to the jamLeval and chipType confirm the scan param");
            log.debug(" ***************************** ");
            log.debug("chipType:" + chipType);
            log.debug(" ***************************** ");
        }
        log.debug("getJamScanInfo the final scan param is: ");
        log.debug(" ***************************** ");
        log.debug("scanInfo: " + (null == scanInfo ? "null" : scanInfo.toString()));
        log.debug(" ***************************** ");
        return scanInfo;
    }

    public static int[] calScanFreq(ArrayList<RRMJamEventAndSolve> apHistJamDetailList, long curTimeStamp, long minTimeStamp, int jamRadioId) {
        int scanFreq = 0;
        int chChangeFreq = 0;
        int[] ans = new int[2];
        for (int i = 0; i < apHistJamDetailList.size(); ++i) {
            RRMRFConfigChange rrmrfConfigChange;
            long timeStamp;
            RRMJamEventAndSolve rrmJamEventAndSolve = apHistJamDetailList.get(i);
            if (null == rrmJamEventAndSolve) continue;
            RRMJamEventInfo rrmJamEventInfo = rrmJamEventAndSolve.getJamEventInfo();
            RRMJamEventSolveDetail rrmJamEventSolveDetail = rrmJamEventAndSolve.getJamEventSolveDetail();
            if (null == rrmJamEventSolveDetail || null == rrmJamEventInfo || jamRadioId != rrmJamEventInfo.getRadioId()) continue;
            long l = timeStamp = rrmJamEventSolveDetail.getTimeStampScan() == null ? 0L : rrmJamEventSolveDetail.getTimeStampScan();
            if (minTimeStamp > timeStamp || curTimeStamp <= timeStamp) continue;
            if (rrmJamEventSolveDetail.isScan()) {
                ++scanFreq;
            }
            if (null == (rrmrfConfigChange = rrmJamEventSolveDetail.getRfConfigChange()) || !rrmrfConfigChange.isChangeChannel()) continue;
            ++chChangeFreq;
        }
        ans[0] = scanFreq;
        ans[1] = chChangeFreq;
        return ans;
    }

    public static ScanInfo setJamScanInfo(int jamRadioId, int chipType, ScanInfo scanInfo, ScanAlgAp ap) {
        scanInfo.setScan(true);
        scanInfo.setBand(new ArrayList<Integer>(Collections.singletonList(jamRadioId)));
        scanInfo.setScanMode(new ArrayList<Integer>(Collections.singletonList(0)));
        scanInfo.setRrmFlag(true);
        scanInfo.setMac(ap.getMac());
        if (0 == jamRadioId) {
            scanInfo.setScanChannelList2g(new ArrayList<Integer>(Collections.singletonList(0)));
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g2(new ArrayList<Integer>());
            scanInfo.setScanChannelList6g(new ArrayList<Integer>());
        } else if (1 == jamRadioId) {
            scanInfo.setScanChannelList2g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g(new ArrayList<Integer>(Collections.singletonList(0)));
            scanInfo.setScanChannelList5g2(new ArrayList<Integer>());
            scanInfo.setScanChannelList6g(new ArrayList<Integer>());
        } else if (2 == jamRadioId) {
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g(new ArrayList<Integer>(Collections.singletonList(0)));
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
        } else if (3 == jamRadioId) {
            scanInfo.setScanChannelList2g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g(new ArrayList<Integer>());
            scanInfo.setScanChannelList5g2(new ArrayList<Integer>());
            scanInfo.setScanChannelList6g(new ArrayList<Integer>(Collections.singletonList(0)));
        }
        if (chipType == 2) {
            scanInfo.setScanTimes(new ArrayList<Integer>(Collections.singletonList(2)));
            scanInfo.setScanInterval(new ArrayList<Integer>(Collections.singletonList(2000)));
            scanInfo.setScanStayTime(new ArrayList<Integer>(Collections.singletonList(100)));
        } else {
            scanInfo.setScanTimes(new ArrayList<Integer>(Collections.singletonList(3)));
            scanInfo.setScanInterval(new ArrayList<Integer>(Collections.singletonList(2000)));
            scanInfo.setScanStayTime(new ArrayList<Integer>(Collections.singletonList(100)));
        }
        return scanInfo;
    }

    public static boolean isValidPscChannel(int channel) {
        return channel % 16 == 5 && channel / 16 >= 2 && channel / 16 <= 14;
    }

    public static double calPscan(int radioId, int avgBusyUtil, int avgInterUtil, int scanFreq, int chChangeFreq) {
        double pScan = 0.0;
        if (0 == radioId) {
            pScan = (double)Math.min(avgBusyUtil, 80) / 80.0 * ((double)Math.min(avgInterUtil, 40) / 40.0) * (2.0 / (double)Math.max(scanFreq, 2)) * (2.0 / (double)Math.max(chChangeFreq, 2));
        } else if (1 <= radioId && 3 >= radioId) {
            pScan = (double)Math.min(avgBusyUtil, 80) / 80.0 * ((double)Math.min(avgInterUtil, 50) / 50.0) * (2.0 / (double)Math.max(scanFreq, 2)) * (2.0 / (double)Math.max(chChangeFreq, 2));
        }
        return pScan;
    }

    public static String generateVirtualAp(String mac) {
        if (mac.contains("_virtualAp")) {
            return mac;
        }
        return mac + "_virtualAp";
    }

    public static ArrayList<Connection> standardizationRRMConnection(ArrayList<AlgAp> apListInput, ArrayList<Connection> connectionList, int mode) {
        int i;
        int tmp;
        int i2;
        int i3;
        if (connectionList == null || apListInput == null || connectionList.isEmpty()) {
            return connectionList;
        }
        Collections.sort(apListInput, new AlgMacComparator());
        Collections.sort(connectionList, new ConMacComparator());
        ArrayList<Connection> connection = new ArrayList<Connection>();
        ArrayList<String> macList = new ArrayList<String>();
        for (i3 = 0; i3 < apListInput.size(); ++i3) {
            if (!apListInput.get(i3).getMac().contains("virtualAp")) continue;
            macList.add(apListInput.get(i3).getMac());
        }
        for (i3 = 0; i3 < connectionList.size(); ++i3) {
            String virtualApMac2;
            if (0 <= connectionList.get(i3).getRssi()) {
                connectionList.get(i3).setRssi(-70);
            }
            if (-80 <= connectionList.get(i3).getNoiseFloor()) {
                connectionList.get(i3).setNoiseFloor(-80);
            }
            if (100 <= connectionList.get(i3).getChannelLoad()) {
                connectionList.get(i3).setChannelLoad(100);
            } else if (0 >= connectionList.get(i3).getChannelLoad()) {
                connectionList.get(i3).setChannelLoad(0);
            }
            if (connectionList.get(i3).getChannel() < 100) continue;
            String virtualApMac1 = CommonDeployUtils.generateVirtualAp(connectionList.get(i3).getCenterApMac());
            if (macList.contains(virtualApMac1)) {
                connectionList.get(i3).setCenterApMac(virtualApMac1);
            }
            if (!macList.contains(virtualApMac2 = CommonDeployUtils.generateVirtualAp(connectionList.get(i3).getNeighborApMac()))) continue;
            connectionList.get(i3).setNeighborApMac(virtualApMac2);
        }
        ArrayList<Integer> connectionCnt = new ArrayList<Integer>();
        ArrayList<Integer> bssidCnt = new ArrayList<Integer>();
        ArrayList<Boolean> inside = new ArrayList<Boolean>();
        connection.add(connectionList.get(0));
        connectionCnt.add(1);
        inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(0).getNeighborApMac()), new AlgMacComparator()) > -1);
        bssidCnt.add(0);
        int apStartIdx = 0;
        for (i2 = 1; i2 < connectionList.size(); ++i2) {
            int j;
            tmp = connection.size();
            if (connectionList.get(i2 - 1).getChannel() != connectionList.get(i2).getChannel() || !connectionList.get(i2 - 1).getCenterApMac().equals(connectionList.get(i2).getCenterApMac())) {
                apStartIdx = tmp;
                connection.add(connectionList.get(i2));
                connectionCnt.add(1);
                bssidCnt.add(0);
                inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1);
                continue;
            }
            boolean repeatedFlag = false;
            boolean insideFlag = false;
            for (j = Math.max(apStartIdx, tmp - 300); j < tmp; ++j) {
                if (!connectionList.get(i2).getNeighborApMac().equals(connection.get(j).getNeighborApMac())) continue;
                connection.get(j).setChannelLoad(connection.get(j).getChannelLoad() + connectionList.get(i2).getChannelLoad());
                connection.get(j).setNoiseFloor(connection.get(j).getNoiseFloor() + connectionList.get(i2).getNoiseFloor());
                connection.get(j).setRssi(connection.get(j).getRssi() + connectionList.get(i2).getRssi());
                connectionCnt.set(j, (Integer)connectionCnt.get(j) + 1);
                repeatedFlag = true;
                break;
            }
            if (Boolean.FALSE.equals(repeatedFlag)) {
                boolean bl = insideFlag = Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1;
                if (Boolean.FALSE.equals(insideFlag)) {
                    for (j = Math.max(apStartIdx, tmp - 300); j < tmp && connection.get(j).getRssi() / (Integer)connectionCnt.get(j) + 5 >= connectionList.get(i2).getRssi(); ++j) {
                        if ((Integer)bssidCnt.get(j) >= 16 || !Boolean.FALSE.equals(inside.get(j)) || connection.get(j).getRssi() / (Integer)connectionCnt.get(j) - 5 > connectionList.get(i2).getRssi() || !connection.get(j).getNeighborApMac().substring(0, 14).equals(connectionList.get(i2).getNeighborApMac().substring(0, 14)) && !connection.get(j).getNeighborApMac().substring(2, 16).equals(connectionList.get(i2).getNeighborApMac().substring(2, 16)) && (!connection.get(j).getNeighborApMac().substring(0, 8).equals(connectionList.get(i2).getNeighborApMac().substring(0, 8)) || !connection.get(j).getNeighborApMac().substring(11, 16).equals(connectionList.get(i2).getNeighborApMac().substring(11, 16)))) continue;
                        connection.get(j).setChannelLoad(connection.get(j).getChannelLoad() + connectionList.get(i2).getChannelLoad());
                        connection.get(j).setNoiseFloor(connection.get(j).getNoiseFloor() + connectionList.get(i2).getNoiseFloor());
                        connection.get(j).setRssi(connection.get(j).getRssi() + connectionList.get(i2).getRssi());
                        connectionCnt.set(j, (Integer)connectionCnt.get(j) + 1);
                        bssidCnt.set(j, (Integer)bssidCnt.get(j) + 1);
                        repeatedFlag = true;
                        break;
                    }
                }
            }
            if (!Boolean.FALSE.equals(repeatedFlag) && !Boolean.TRUE.equals(insideFlag)) continue;
            connection.add(connectionList.get(i2));
            connectionCnt.add(1);
            inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1);
            bssidCnt.add(0);
        }
        for (i2 = 0; i2 < connection.size(); ++i2) {
            tmp = (Integer)connectionCnt.get(i2);
            if (tmp <= 1) continue;
            ((Connection)connection.get(i2)).setChannelLoad(((Connection)connection.get(i2)).getChannelLoad() / tmp);
            connection.get(i2).setNoiseFloor(connection.get(i2).getNoiseFloor() / tmp);
            connection.get(i2).setRssi(connection.get(i2).getRssi() / tmp);
        }
        int tmpSize = connection.size();
        for (i = 0; i < tmpSize; ++i) {
            String tmpTxMac = ((Connection)connection.get(i)).getNeighborApMac();
            String tmpRxMac = ((Connection)connection.get(i)).getCenterApMac();
            int txApIndex = -1;
            int rxApIndex = -1;
            txApIndex = Collections.binarySearch(apListInput, new AlgAp(tmpTxMac), new AlgMacComparator());
            rxApIndex = Collections.binarySearch(apListInput, new AlgAp(tmpRxMac), new AlgMacComparator());
            if (txApIndex <= -1 || rxApIndex <= -1) continue;
            int txApIndexTmp = -1;
            int rxApIndexTmp = -1;
            txApIndexTmp = Collections.binarySearch(connectionList, new Connection(tmpTxMac), new MacComparator());
            if (txApIndexTmp > -1) {
                int startIdx = Math.max(txApIndexTmp - 300, 0);
                int endIdx = Math.min(txApIndexTmp + 300, connectionList.size());
                for (int j = startIdx; j < endIdx; ++j) {
                    if (!Objects.equals(tmpRxMac, connectionList.get(j).getNeighborApMac()) || !Objects.equals(tmpTxMac, connectionList.get(j).getCenterApMac())) continue;
                    rxApIndexTmp = txApIndexTmp + j;
                    break;
                }
            }
            if (txApIndexTmp != -1 && rxApIndexTmp != -1) continue;
            Connection tmpAdd = new Connection();
            tmpAdd.setCenterApMac(tmpTxMac);
            tmpAdd.setNeighborApMac(tmpRxMac);
            int tmpTxPower = apListInput.get(txApIndex).getTxPower();
            int tmpRxPower = apListInput.get(rxApIndex).getTxPower();
            tmpAdd.setRssi(connection.get(i).getRssi() + (tmpRxPower - tmpTxPower));
            tmpAdd.setChannel(connection.get(i).getChannel());
            tmpAdd.setChannelLoad(connection.get(i).getChannelLoad());
            tmpAdd.setNoiseFloor(connection.get(i).getNoiseFloor());
            tmpAdd.setIsEnabled(connection.get(i).getIsEnabled());
            connection.add(tmpAdd);
        }
        for (i = 0; i < apListInput.size(); ++i) {
            if (apListInput.get(i).getBandFlag() == 1) continue;
            for (int j = 0; j < connection.size(); ++j) {
                if (!apListInput.get(i).getMac().equals(connection.get(j).getNeighborApMac()) && !apListInput.get(i).getMac().equals(connection.get(j).getCenterApMac())) continue;
                connection.get(j).setIsEnabled(0);
            }
        }
        if (mode == 0) {
            return connection;
        }
        for (i = 0; i < apListInput.size(); ++i) {
            int deltaPower = apListInput.get(i).getMaxTxPower() - apListInput.get(i).getTxPower();
            if (deltaPower == 0) continue;
            if (mode == 2) {
                deltaPower = -deltaPower;
            }
            for (int j = 0; j < connection.size(); ++j) {
                if (!apListInput.get(i).getMac().equals(connection.get(j).getNeighborApMac())) continue;
                connection.get(j).setRssi(connection.get(j).getRssi() - deltaPower);
            }
        }
        return connection;
    }

    public static ArrayList<Connection> standardizationConnection(ArrayList<AlgAp> apListInput, ArrayList<Connection> connectionList, int mode) {
        int i;
        int tmp;
        int i2;
        int i3;
        if (connectionList == null || apListInput == null || connectionList.isEmpty()) {
            return connectionList;
        }
        Collections.sort(apListInput, new AlgMacComparator());
        Collections.sort(connectionList, new ConMacComparator());
        ArrayList<Connection> connection = new ArrayList<Connection>();
        ArrayList<String> macList = new ArrayList<String>();
        for (i3 = 0; i3 < apListInput.size(); ++i3) {
            if (!apListInput.get(i3).getMac().contains("virtualAp")) continue;
            macList.add(apListInput.get(i3).getMac());
        }
        for (i3 = 0; i3 < connectionList.size(); ++i3) {
            String virtualApMac2;
            if (0 <= connectionList.get(i3).getRssi()) {
                connectionList.get(i3).setRssi(-70);
            }
            if (-80 <= connectionList.get(i3).getNoiseFloor()) {
                connectionList.get(i3).setNoiseFloor(-80);
            }
            if (80 <= connectionList.get(i3).getChannelLoad()) {
                connectionList.get(i3).setChannelLoad(80);
            } else if (0 >= connectionList.get(i3).getChannelLoad()) {
                connectionList.get(i3).setChannelLoad(0);
            }
            if (connectionList.get(i3).getChannel() < 100) continue;
            String virtualApMac1 = CommonDeployUtils.generateVirtualAp(connectionList.get(i3).getCenterApMac());
            if (macList.contains(virtualApMac1)) {
                connectionList.get(i3).setCenterApMac(virtualApMac1);
            }
            if (!macList.contains(virtualApMac2 = CommonDeployUtils.generateVirtualAp(connectionList.get(i3).getNeighborApMac()))) continue;
            connectionList.get(i3).setNeighborApMac(virtualApMac2);
        }
        ArrayList<Integer> connectionCnt = new ArrayList<Integer>();
        ArrayList<Integer> bssidCnt = new ArrayList<Integer>();
        ArrayList<Boolean> inside = new ArrayList<Boolean>();
        connection.add(connectionList.get(0));
        connectionCnt.add(1);
        inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(0).getNeighborApMac()), new AlgMacComparator()) > -1);
        bssidCnt.add(0);
        int apStartIdx = 0;
        for (i2 = 1; i2 < connectionList.size(); ++i2) {
            int j;
            tmp = connection.size();
            if (connectionList.get(i2 - 1).getChannel() != connectionList.get(i2).getChannel() || !connectionList.get(i2 - 1).getCenterApMac().equals(connectionList.get(i2).getCenterApMac())) {
                apStartIdx = tmp;
                connection.add(connectionList.get(i2));
                connectionCnt.add(1);
                bssidCnt.add(0);
                inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1);
                continue;
            }
            boolean repeatedFlag = false;
            boolean insideFlag = false;
            for (j = Math.max(apStartIdx, tmp - 300); j < tmp; ++j) {
                if (!connectionList.get(i2).getNeighborApMac().equals(connection.get(j).getNeighborApMac())) continue;
                connection.get(j).setChannelLoad(connection.get(j).getChannelLoad() + connectionList.get(i2).getChannelLoad());
                connection.get(j).setNoiseFloor(connection.get(j).getNoiseFloor() + connectionList.get(i2).getNoiseFloor());
                connection.get(j).setRssi(connection.get(j).getRssi() + connectionList.get(i2).getRssi());
                connectionCnt.set(j, (Integer)connectionCnt.get(j) + 1);
                repeatedFlag = true;
                break;
            }
            if (Boolean.FALSE.equals(repeatedFlag)) {
                boolean bl = insideFlag = Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1;
                if (Boolean.FALSE.equals(insideFlag)) {
                    for (j = Math.max(apStartIdx, tmp - 300); j < tmp && connection.get(j).getRssi() / (Integer)connectionCnt.get(j) + 5 >= connectionList.get(i2).getRssi(); ++j) {
                        if ((Integer)bssidCnt.get(j) >= 16 || !Boolean.FALSE.equals(inside.get(j)) || connection.get(j).getRssi() / (Integer)connectionCnt.get(j) - 5 > connectionList.get(i2).getRssi() || !connection.get(j).getNeighborApMac().substring(0, 14).equals(connectionList.get(i2).getNeighborApMac().substring(0, 14)) && !connection.get(j).getNeighborApMac().substring(2, 16).equals(connectionList.get(i2).getNeighborApMac().substring(2, 16)) && (!connection.get(j).getNeighborApMac().substring(0, 8).equals(connectionList.get(i2).getNeighborApMac().substring(0, 8)) || !connection.get(j).getNeighborApMac().substring(11, 16).equals(connectionList.get(i2).getNeighborApMac().substring(11, 16)))) continue;
                        connection.get(j).setChannelLoad(connection.get(j).getChannelLoad() + connectionList.get(i2).getChannelLoad());
                        connection.get(j).setNoiseFloor(connection.get(j).getNoiseFloor() + connectionList.get(i2).getNoiseFloor());
                        connection.get(j).setRssi(connection.get(j).getRssi() + connectionList.get(i2).getRssi());
                        connectionCnt.set(j, (Integer)connectionCnt.get(j) + 1);
                        bssidCnt.set(j, (Integer)bssidCnt.get(j) + 1);
                        repeatedFlag = true;
                        break;
                    }
                }
            }
            if (!Boolean.FALSE.equals(repeatedFlag) && !Boolean.TRUE.equals(insideFlag)) continue;
            connection.add(connectionList.get(i2));
            connectionCnt.add(1);
            inside.add(Collections.binarySearch(apListInput, new AlgAp(connectionList.get(i2).getNeighborApMac()), new AlgMacComparator()) > -1);
            bssidCnt.add(0);
        }
        for (i2 = 0; i2 < connection.size(); ++i2) {
            tmp = (Integer)connectionCnt.get(i2);
            if (tmp <= 1) continue;
            ((Connection)connection.get(i2)).setChannelLoad(((Connection)connection.get(i2)).getChannelLoad() / tmp);
            connection.get(i2).setNoiseFloor(connection.get(i2).getNoiseFloor() / tmp);
            connection.get(i2).setRssi(connection.get(i2).getRssi() / tmp);
        }
        int tmpSize = connection.size();
        for (i = 0; i < tmpSize; ++i) {
            String tmpTxMac = ((Connection)connection.get(i)).getNeighborApMac();
            String tmpRxMac = ((Connection)connection.get(i)).getCenterApMac();
            int txApIndex = -1;
            int rxApIndex = -1;
            txApIndex = Collections.binarySearch(apListInput, new AlgAp(tmpTxMac), new AlgMacComparator());
            rxApIndex = Collections.binarySearch(apListInput, new AlgAp(tmpRxMac), new AlgMacComparator());
            if (txApIndex <= -1 || rxApIndex <= -1) continue;
            int txApIndexTmp = -1;
            int rxApIndexTmp = -1;
            txApIndexTmp = Collections.binarySearch(connectionList, new Connection(tmpTxMac), new MacComparator());
            if (txApIndexTmp > -1) {
                int startIdx = Math.max(txApIndexTmp - 300, 0);
                int endIdx = Math.min(txApIndexTmp + 300, connectionList.size());
                for (int j = startIdx; j < endIdx; ++j) {
                    if (!Objects.equals(tmpRxMac, connectionList.get(j).getNeighborApMac()) || !Objects.equals(tmpTxMac, connectionList.get(j).getCenterApMac())) continue;
                    rxApIndexTmp = txApIndexTmp + j;
                    break;
                }
            }
            if (txApIndexTmp != -1 && rxApIndexTmp != -1) continue;
            Connection tmpAdd = new Connection();
            tmpAdd.setCenterApMac(tmpTxMac);
            tmpAdd.setNeighborApMac(tmpRxMac);
            int tmpTxPower = apListInput.get(txApIndex).getTxPower();
            int tmpRxPower = apListInput.get(rxApIndex).getTxPower();
            tmpAdd.setRssi(connection.get(i).getRssi() + (tmpRxPower - tmpTxPower));
            tmpAdd.setChannel(connection.get(i).getChannel());
            tmpAdd.setChannelLoad(connection.get(i).getChannelLoad());
            tmpAdd.setNoiseFloor(connection.get(i).getNoiseFloor());
            tmpAdd.setIsEnabled(connection.get(i).getIsEnabled());
            connection.add(tmpAdd);
        }
        for (i = 0; i < apListInput.size(); ++i) {
            if (apListInput.get(i).getBandFlag() == 1) continue;
            for (int j = 0; j < connection.size(); ++j) {
                if (!apListInput.get(i).getMac().equals(connection.get(j).getNeighborApMac()) && !apListInput.get(i).getMac().equals(connection.get(j).getCenterApMac())) continue;
                connection.get(j).setIsEnabled(0);
            }
        }
        if (mode == 0) {
            return connection;
        }
        for (i = 0; i < apListInput.size(); ++i) {
            int deltaPower = apListInput.get(i).getMaxTxPower() - apListInput.get(i).getTxPower();
            if (deltaPower == 0) continue;
            if (mode == 2) {
                deltaPower = -deltaPower;
            }
            for (int j = 0; j < connection.size(); ++j) {
                if (!apListInput.get(i).getMac().equals(connection.get(j).getNeighborApMac())) continue;
                connection.get(j).setRssi(connection.get(j).getRssi() - deltaPower);
            }
        }
        return connection;
    }

    public static ArrayList<AlgAp> setPower2Max(ArrayList<AlgAp> apListInput) {
        for (int i = 0; i < apListInput.size(); ++i) {
            apListInput.get(i).setTxPower(apListInput.get(i).getMaxTxPower());
        }
        return apListInput;
    }

    public static ArrayList<Connection> deepCopyConnections(ArrayList<Connection> input) {
        ArrayList<Connection> output = new ArrayList<Connection>();
        for (int i = 0; i < input.size(); ++i) {
            Connection tmp = new Connection();
            tmp.setCenterApMac(input.get(i).getCenterApMac());
            tmp.setNeighborApMac(input.get(i).getNeighborApMac());
            tmp.setIsEnabled(input.get(i).getIsEnabled());
            tmp.setChannel(input.get(i).getChannel());
            tmp.setChannelLoad(input.get(i).getChannelLoad());
            tmp.setNoiseFloor(input.get(i).getNoiseFloor());
            tmp.setRssi(input.get(i).getRssi());
            output.add(tmp);
        }
        return output;
    }

    private static class AlgMacComparator
    implements Comparator<Object> {
        private AlgMacComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            AlgAp ap1 = (AlgAp)o1;
            AlgAp ap2 = (AlgAp)o2;
            return ap1.getMac().compareTo(ap2.getMac());
        }

        public String toString() {
            return "CommonDeployUtils.AlgMacComparator()";
        }
    }

    private static class ConMacComparator
    implements Comparator<Object> {
        private ConMacComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Connection ap1 = (Connection)o1;
            Connection ap2 = (Connection)o2;
            if (ap1.getCenterApMac().equals(ap2.getCenterApMac())) {
                if (ap1.getChannel() == ap2.getChannel()) {
                    if (ap1.getRssi() == ap2.getRssi()) {
                        return 0;
                    }
                    return ap1.getRssi() < ap2.getRssi() ? 1 : -1;
                }
                return ap1.getChannel() > ap2.getChannel() ? 1 : -1;
            }
            return ap1.getCenterApMac().compareTo(ap2.getCenterApMac());
        }

        public String toString() {
            return "CommonDeployUtils.ConMacComparator()";
        }
    }

    private static class MacComparator
    implements Comparator<Object> {
        private MacComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Connection ap1 = (Connection)o1;
            Connection ap2 = (Connection)o2;
            return ap1.getCenterApMac().compareTo(ap2.getCenterApMac());
        }

        public String toString() {
            return "CommonDeployUtils.MacComparator()";
        }
    }
}

