/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.log;

import com.tplink.smb.algorithm.common.AlgAp;
import com.tplink.smb.algorithm.common.BaseAlgAp;
import com.tplink.smb.algorithm.common.ChannelDetail;
import com.tplink.smb.algorithm.common.Connection;
import com.tplink.smb.algorithm.common.RFAdvanceSetting;
import com.tplink.smb.algorithm.common.log.DeflaterUtils;
import com.tplink.smb.algorithm.common.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private String logPrefix;
    private String solutionPrefix;
    private Map<String, Integer> macIdxMap;

    public LogUtils() {
    }

    public LogUtils(String logPrefix) {
        this.logPrefix = logPrefix = logPrefix.replace("V2.0", "V2.1");
        this.solutionPrefix = logPrefix + ", Solution:";
    }

    private void initMacMap(ArrayList<AlgAp> apList, ArrayList<BaseAlgAp> solutionPreInput, ArrayList<Connection> connections) {
        this.macIdxMap = new HashMap<String, Integer>();
        int cnt = 0;
        if (apList != null) {
            for (AlgAp algAp : apList) {
                this.macIdxMap.put(algAp.getMac(), cnt++);
            }
        }
        if (solutionPreInput != null) {
            for (BaseAlgAp baseAlgAp : solutionPreInput) {
                this.macIdxMap.put(baseAlgAp.getMac(), cnt++);
            }
        }
        if (connections != null) {
            for (Connection connection : connections) {
                if (!this.macIdxMap.containsKey(connection.getCenterApMac())) {
                    this.macIdxMap.put(connection.getCenterApMac(), cnt++);
                }
                if (this.macIdxMap.containsKey(connection.getNeighborApMac())) continue;
                this.macIdxMap.put(connection.getNeighborApMac(), cnt++);
            }
        }
    }

    private void initRRMMacMap(ArrayList<AlgAp> apList, ArrayList<BaseAlgAp> solutionPreInput, ArrayList<Connection> connectionsGlobal, ArrayList<Connection> connectionsLocal) {
        this.macIdxMap = new HashMap<String, Integer>();
        int cnt = 0;
        if (apList != null) {
            for (AlgAp algAp : apList) {
                this.macIdxMap.put(algAp.getMac(), cnt++);
            }
        }
        if (solutionPreInput != null) {
            for (BaseAlgAp baseAlgAp : solutionPreInput) {
                this.macIdxMap.put(baseAlgAp.getMac(), cnt++);
            }
        }
        if (connectionsGlobal != null) {
            for (Connection connection : connectionsGlobal) {
                if (!this.macIdxMap.containsKey(connection.getCenterApMac())) {
                    this.macIdxMap.put(connection.getCenterApMac(), cnt++);
                }
                if (this.macIdxMap.containsKey(connection.getNeighborApMac())) continue;
                this.macIdxMap.put(connection.getNeighborApMac(), cnt++);
            }
        }
        if (connectionsLocal != null) {
            for (Connection connection : connectionsLocal) {
                if (!this.macIdxMap.containsKey(connection.getCenterApMac())) {
                    this.macIdxMap.put(connection.getCenterApMac(), cnt++);
                }
                if (this.macIdxMap.containsKey(connection.getNeighborApMac())) continue;
                this.macIdxMap.put(connection.getNeighborApMac(), cnt++);
            }
        }
    }

    private String getChFlagListStr(ArrayList<ChannelDetail> channelFlagList) {
        int i;
        if (channelFlagList == null) {
            return "null";
        }
        if (channelFlagList.isEmpty()) {
            return "[]";
        }
        StringBuilder chFlagStr = new StringBuilder();
        chFlagStr.append("[");
        for (i = 0; i < channelFlagList.size() - 1; ++i) {
            chFlagStr.append("[" + channelFlagList.get(i).getChannel().toString() + "," + channelFlagList.get(i).getWidthFlag().toString() + "],");
        }
        chFlagStr.append("[" + channelFlagList.get(i).getChannel().toString() + "," + channelFlagList.get(i).getWidthFlag().toString() + "]]");
        return chFlagStr.toString();
    }

    private String getAlgApStr(AlgAp algAp) {
        return String.format(Locale.ROOT, "[%s,%d,%d,%d,%d,%d,%d,%d,%s,%s,%s,%s,%s,%s]", this.macIdxMap.get(algAp.getMac()), algAp.getBandFlag(), algAp.getChannel(), algAp.getWidth(), algAp.getTxPower(), algAp.getMaxTxPower(), algAp.getMinTxPower(), algAp.getErrorCode(), this.getChFlagListStr(algAp.getChannelFlagList()), algAp.getAvailableWidthList() == null ? "null" : Arrays.deepToString(algAp.getAvailableWidthList().toArray()), algAp.getAvailableChannelList() == null ? "null" : Arrays.deepToString(algAp.getAvailableChannelList().toArray()), algAp.getStationLoadList() == null ? "null" : Arrays.deepToString(algAp.getStationLoadList().toArray()), algAp.getTrafficList() == null ? "null" : Arrays.deepToString(algAp.getTrafficList().toArray()), algAp.getStaAccessRssiMap() == null ? "null" : new JSONObject(algAp.getStaAccessRssiMap()));
    }

    private String getBaseAlgApStr(BaseAlgAp baseAlgAp) {
        return String.format(Locale.ROOT, "[%s,%d,%d,%d,%d]", this.macIdxMap.get(baseAlgAp.getMac()), baseAlgAp.getBandFlag() == null ? -1 : baseAlgAp.getBandFlag(), baseAlgAp.getChannel() == null ? -1 : baseAlgAp.getChannel(), baseAlgAp.getWidth() == null ? -1 : baseAlgAp.getWidth(), baseAlgAp.getTxPower() == null ? -1 : baseAlgAp.getTxPower());
    }

    private String getConStr(Connection connection) {
        return String.format(Locale.ROOT, "[%s,%s,%d,%d,%d,%d,%d]", this.macIdxMap.get(connection.getCenterApMac()), this.macIdxMap.get(connection.getNeighborApMac()), connection.getIsEnabled(), connection.getChannel(), connection.getRssi(), connection.getChannelLoad(), connection.getNoiseFloor());
    }

    private String getApListStr(ArrayList<AlgAp> apList) {
        int i;
        if (apList == null) {
            return "null";
        }
        if (apList.isEmpty()) {
            return "[]";
        }
        StringBuilder apListStr = new StringBuilder();
        apListStr.append("[[\"mac\",\"bandFlag\",\"channel\",\"width\",\"txPower\",\"maxTxPower\",\"minTxPower\",\"errorcode\",\"channelFlagList\",\"widthList\",\"channelList\",\"staLoadList\",\"trafficList\",\"staAccessRssiMap\"],");
        for (i = 0; i < apList.size() - 1; ++i) {
            apListStr.append(this.getAlgApStr(apList.get(i)) + ",");
        }
        apListStr.append(this.getAlgApStr(apList.get(i)) + "]");
        return apListStr.toString();
    }

    private String getBaseApListStr(ArrayList<BaseAlgAp> solutionPreInput) {
        int i;
        if (solutionPreInput == null) {
            return "null";
        }
        if (solutionPreInput.isEmpty()) {
            return "[]";
        }
        StringBuilder apListStr = new StringBuilder();
        apListStr.append("[[\"mac\",\"bandFlag\",\"channel\",\"width\",\"txPower\"],");
        for (i = 0; i < solutionPreInput.size() - 1; ++i) {
            apListStr.append(this.getBaseAlgApStr(solutionPreInput.get(i)) + ",");
        }
        apListStr.append(this.getBaseAlgApStr(solutionPreInput.get(i)) + "]");
        return apListStr.toString();
    }

    private String getConListStr(ArrayList<Connection> connections) {
        int i;
        if (connections == null) {
            return "null";
        }
        if (connections.isEmpty()) {
            return "[]";
        }
        StringBuilder connectStr = new StringBuilder();
        connectStr.append("[[\"centerApMac\",\"neighborApMac\",\"isEnabled\",\"channel\",\"rssi\",\"channelLoad\",\"noiseFloor\"],");
        for (i = 0; i < connections.size() - 1; ++i) {
            connectStr.append(this.getConStr(connections.get(i)) + ",");
        }
        connectStr.append(this.getConStr(connections.get(i)) + "]");
        return connectStr.toString();
    }

    private String strEncryption(String str) {
        int strLen = str.length();
        int[] a = new int[strLen + 2];
        char[] ch = str.toCharArray();
        for (int i = 30; i < strLen; ++i) {
            a[i] = ch[i];
            a[i] = a[i] - 2;
            ch[i] = (char)a[i];
        }
        return new String(ch);
    }

    public void displayInput(ArrayList<AlgAp> apListInput, ArrayList<BaseAlgAp> solutionPreInput, ArrayList<Connection> connectionsListInput, RFAdvanceSetting rfAdvanceSetting) {
        try {
            this.initMacMap(apListInput, solutionPreInput, connectionsListInput);
            String logPrint = String.format(Locale.ROOT, "%s, {\"macIdxMap\":%s,\"AlgAp\":%s,\"BaseAlgAp\":%s,\"rfAdvanceSetting\":%s,\"Connection\":%s}", this.logPrefix, JsonUtils.bean2Json(this.macIdxMap), this.getApListStr(apListInput), this.getBaseApListStr(solutionPreInput), JsonUtils.bean2Json(rfAdvanceSetting), this.getConListStr(connectionsListInput));
            log.debug(logPrint.substring(0, 30) + DeflaterUtils.zipString(logPrint.substring(30)));
        }
        catch (Exception e) {
            String logPrint = String.format(Locale.ROOT, "%s, log wrong", this.logPrefix);
            log.debug(this.strEncryption(logPrint));
        }
    }

    public void displayRRMInput(ArrayList<AlgAp> apListInput, ArrayList<BaseAlgAp> solutionPreInput, ArrayList<Connection> connectionsListGlobal, ArrayList<Connection> connectionsListLocal, RFAdvanceSetting rfAdvanceSetting) {
        try {
            this.initRRMMacMap(apListInput, solutionPreInput, connectionsListGlobal, connectionsListLocal);
            String logPrint = String.format(Locale.ROOT, "%s, {\"macIdxMap\":%s,\"AlgAp\":%s,\"BaseAlgAp\":%s,\"rfAdvanceSetting\":%s,\"ConnectionGlobal\":%s, \"ConnectionLocal\":%s}", this.logPrefix, JsonUtils.bean2Json(this.macIdxMap), this.getApListStr(apListInput), this.getBaseApListStr(solutionPreInput), JsonUtils.bean2Json(rfAdvanceSetting), this.getConListStr(connectionsListGlobal), this.getConListStr(connectionsListLocal));
            log.debug(logPrint.substring(0, 30) + DeflaterUtils.zipString(logPrint.substring(30)));
        }
        catch (Exception e) {
            String logPrint = String.format(Locale.ROOT, "%s, log wrong", this.logPrefix);
            log.debug(this.strEncryption(logPrint));
        }
    }

    public void displaySolution(ArrayList<AlgAp> solution) {
        try {
            String tmp = String.format(Locale.ROOT, "%s, {\"output\":%s}", this.solutionPrefix, this.getApListStr(solution));
            log.debug(tmp.substring(0, 30) + DeflaterUtils.zipString(tmp.substring(30)));
        }
        catch (Exception e) {
            String tmp = String.format(Locale.ROOT, "%s, log wrong", this.solutionPrefix);
            log.debug(this.strEncryption(tmp));
        }
    }

    public String displayInputData(ArrayList<AlgAp> apListInput, ArrayList<BaseAlgAp> solutionPreInput, ArrayList<Connection> connectionsListInput, RFAdvanceSetting rfAdvanceSetting) {
        try {
            this.initMacMap(apListInput, solutionPreInput, connectionsListInput);
            String inputData = String.format(Locale.ROOT, "%s, {\"macIdxMap\":%s,\"AlgAp\":%s,\"BaseAlgAp\":%s,\"rfAdvanceSetting\":%s,\"Connection\":%s}", this.logPrefix, JsonUtils.bean2Json(this.macIdxMap), this.getApListStr(apListInput), this.getBaseApListStr(solutionPreInput), JsonUtils.bean2Json(rfAdvanceSetting), this.getConListStr(connectionsListInput));
            return inputData.substring(0, 30) + DeflaterUtils.zipString(inputData.substring(30));
        }
        catch (Exception e) {
            String inputData = String.format(Locale.ROOT, "%s, log wrong", this.logPrefix);
            return inputData;
        }
    }
}

