/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common.log;

import com.tplink.smb.algorithm.common.AlgAp;
import com.tplink.smb.algorithm.common.BaseAlgAp;
import com.tplink.smb.algorithm.common.ChannelDetail;
import com.tplink.smb.algorithm.common.Connection;
import com.tplink.smb.algorithm.common.RFAdvanceSetting;
import com.tplink.smb.algorithm.common.log.DeflaterUtils;
import com.tplink.smb.algorithm.common.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDecryption {
    private static final Logger log = LoggerFactory.getLogger(LogDecryption.class);
    private static final String ALGAP_STRING = "AlgAp";
    private static final String BASEALGAP_STRING = "BaseAlgAp";
    private static final String CONNECTION_STRING = "Connection";
    private static final String RFADVENCE_STRING = "rfAdvanceSetting";
    private static final String STALOAD_STRING = "stationLoadList";
    private static final String TRAFFIC_STRING = "trafficList";
    private static final String STARSSICNT_STRING = "staAccessRssiMap";
    private static final String THRES2G_STRING = "threshold2g";
    private static final String THRES5G_STRING = "threshold5g";
    private static final String THRES6G_STRING = "threshold6g";
    private static final int[] staAccessRssiKey = new int[]{-90, -88, -83, -78, -73, -68, -63, -58, -53, -48, -43, -38, -33, -30};
    private ArrayList<AlgAp> ap;
    private ArrayList<BaseAlgAp> baseAp;
    private ArrayList<Connection> connection;
    private RFAdvanceSetting rfAdvanceSetting;
    private Map<Integer, String> idxMaxMap;
    private Integer unDecryptionLen = 30;

    public LogDecryption() {
    }

    public LogDecryption(String fileFold) {
        ArrayList<AlgAp> apList = new ArrayList<AlgAp>();
        ArrayList<Connection> connectionList = new ArrayList<Connection>();
        String encoding = "UTF-16";
        String channelString = "channel";
        String channelFlagString = "channelFlagList";
        File file = new File(fileFold + "/encryptionData.log");
        boolean isEncryptionFile = true;
        boolean isCompressionFile = false;
        if (!file.exists()) {
            isEncryptionFile = false;
            file = new File(fileFold + "/decryptionData.log");
            if (!file.exists()) {
                isCompressionFile = true;
                file = new File(fileFold + "/compresionData.log");
                if (!file.exists()) {
                    return;
                }
            }
        }
        InputStreamReader read = null;
        try {
            read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                JSONObject tmp;
                int i;
                if (!lineTxt.contains("RFPlanning-")) continue;
                if (lineTxt.contains("V2.1")) {
                    this.unDecryptionLen = 16;
                } else if (lineTxt.contains("V2.2")) {
                    this.unDecryptionLen = 30;
                }
                if (isEncryptionFile) {
                    lineTxt = this.strDecryption(lineTxt);
                }
                if (isCompressionFile) {
                    this.jsonToInput(lineTxt);
                    continue;
                }
                int index1 = lineTxt.indexOf("{\"AlgAp\":");
                int index2 = lineTxt.length();
                if (index1 == -1) continue;
                JSONObject obj = JsonUtils.fromObject(lineTxt.substring(index1, index2));
                if (lineTxt.contains("Solution:")) continue;
                for (i = 0; i < obj.getJSONArray(ALGAP_STRING).length(); ++i) {
                    tmp = obj.getJSONArray(ALGAP_STRING).getJSONObject(i);
                    AlgAp apDetile = new AlgAp(tmp.getString("mac"));
                    apDetile.setChannel(tmp.getInt(channelString));
                    apDetile.setWidth(tmp.getInt("width"));
                    apDetile.setBandFlag(tmp.getInt("bandFlag"));
                    ArrayList<ChannelDetail> channelFlagList = new ArrayList<ChannelDetail>();
                    if (tmp.has(channelFlagString)) {
                        for (int j = 0; j < tmp.getJSONArray(channelFlagString).length(); ++j) {
                            ChannelDetail channelDetailTmp = new ChannelDetail(tmp.getJSONArray(channelFlagString).getJSONObject(j).getInt(channelString), tmp.getJSONArray(channelFlagString).getJSONObject(j).getInt("widthFlag"));
                            channelFlagList.add(channelDetailTmp);
                        }
                        apDetile.setChannelFlagList(channelFlagList);
                    }
                    ArrayList<Integer> stationLoadList = new ArrayList<Integer>();
                    if (tmp.has(STALOAD_STRING)) {
                        for (int j = 0; j < tmp.getJSONArray(STALOAD_STRING).length(); ++j) {
                            stationLoadList.add(tmp.getJSONArray(STALOAD_STRING).getInt(j));
                        }
                    }
                    apDetile.setStationLoadList(stationLoadList);
                    ArrayList<Long> trafficList = new ArrayList<Long>();
                    if (tmp.has(TRAFFIC_STRING)) {
                        for (int j = 0; j < tmp.getJSONArray(TRAFFIC_STRING).length(); ++j) {
                            trafficList.add(tmp.getJSONArray(TRAFFIC_STRING).getLong(j));
                        }
                    }
                    apDetile.setTrafficList(trafficList);
                    if (tmp.has("minTxPower")) {
                        apDetile.setMinTxPower(tmp.getInt("minTxPower"));
                    } else {
                        apDetile.setMinTxPower(0);
                    }
                    if (tmp.has("maxTxPower")) {
                        apDetile.setMaxTxPower(tmp.getInt("maxTxPower"));
                    } else {
                        apDetile.setMaxTxPower(30);
                    }
                    if (tmp.has("txPower")) {
                        apDetile.setTxPower(tmp.getInt("txPower"));
                    } else {
                        apDetile.setTxPower(apDetile.getMaxTxPower());
                    }
                    TreeMap<Integer, Integer> staAccessRssiMap = new TreeMap<Integer, Integer>();
                    if (tmp.has(STARSSICNT_STRING)) {
                        JSONObject tmpMap = tmp.getJSONObject(STARSSICNT_STRING);
                        for (int key : staAccessRssiKey) {
                            staAccessRssiMap.put(key, tmpMap.getInt(String.valueOf(key)));
                        }
                        apDetile.setStaAccessRssiMap(staAccessRssiMap);
                    }
                    apList.add(apDetile);
                }
                for (i = 0; i < obj.getJSONArray(CONNECTION_STRING).length(); ++i) {
                    tmp = obj.getJSONArray(CONNECTION_STRING).getJSONObject(i);
                    int dataEnabled = 1;
                    if (tmp.has("isEnabled")) {
                        dataEnabled = tmp.getInt("isEnabled");
                    }
                    Connection connectionTmp = new Connection(tmp.getString("centerApMac"), tmp.getString("neighborApMac"), dataEnabled, tmp.getInt(channelString), tmp.getInt("rssi"), tmp.getInt("channelLoad"), tmp.getInt("noiseFloor"));
                    connectionList.add(connectionTmp);
                }
                this.ap = apList;
                this.connection = connectionList;
                if (!obj.has(RFADVENCE_STRING) || obj.get(RFADVENCE_STRING).toString().equals("null")) continue;
                if (obj.getJSONObject(RFADVENCE_STRING).isEmpty()) {
                    this.rfAdvanceSetting = null;
                    continue;
                }
                RFAdvanceSetting rfAdvanceSettingTmp = new RFAdvanceSetting();
                tmp = obj.getJSONObject(RFADVENCE_STRING);
                rfAdvanceSettingTmp.setMinChannelWidth2g(tmp.getInt("minChannelWidth2g"));
                rfAdvanceSettingTmp.setMaxChannelWidth2g(tmp.getInt("maxChannelWidth2g"));
                rfAdvanceSettingTmp.setMinChannelWidth5g(tmp.getInt("minChannelWidth5g"));
                rfAdvanceSettingTmp.setMaxChannelWidth5g(tmp.getInt("maxChannelWidth5g"));
                rfAdvanceSettingTmp.setMinChannelWidth6g(tmp.getInt("minChannelWidth6g"));
                rfAdvanceSettingTmp.setMaxChannelWidth6g(tmp.getInt("maxChannelWidth6g"));
                rfAdvanceSettingTmp.setMinTxPower2g(tmp.getInt("minTxPower2g"));
                rfAdvanceSettingTmp.setMaxTxPower2g(tmp.getInt("maxTxPower2g"));
                rfAdvanceSettingTmp.setMinTxPower5g(tmp.getInt("minTxPower5g"));
                rfAdvanceSettingTmp.setMaxTxPower5g(tmp.getInt("maxTxPower5g"));
                rfAdvanceSettingTmp.setMinTxPower6g(tmp.getInt("minTxPower6g"));
                rfAdvanceSettingTmp.setMaxTxPower6g(tmp.getInt("maxTxPower6g"));
                if (tmp.has(THRES2G_STRING)) {
                    rfAdvanceSettingTmp.setThreshold2g(tmp.getInt(THRES2G_STRING));
                } else {
                    rfAdvanceSettingTmp.setThreshold2g(0);
                }
                if (tmp.has(THRES5G_STRING)) {
                    rfAdvanceSettingTmp.setThreshold5g(tmp.getInt(THRES5G_STRING));
                } else {
                    rfAdvanceSettingTmp.setThreshold5g(0);
                }
                if (tmp.has(THRES6G_STRING)) {
                    rfAdvanceSettingTmp.setThreshold6g(tmp.getInt(THRES6G_STRING));
                } else {
                    rfAdvanceSettingTmp.setThreshold6g(0);
                }
                this.rfAdvanceSetting = rfAdvanceSettingTmp;
            }
            bufferedReader.close();
            read.close();
        }
        catch (Exception e) {
            log.debug("Loading file error.");
            e.printStackTrace();
        }
    }

    private void jsonToHashMap(JSONObject obj) {
        this.idxMaxMap = new HashMap<Integer, String>();
        try {
            Iterator it = obj.keys();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                Integer value = Integer.valueOf(obj.get(key).toString());
                this.idxMaxMap.put(value, key);
            }
        }
        catch (Exception e) {
            log.debug("Parse macIdxMap exception.", (Throwable)e);
        }
    }

    private ArrayList<Integer> jsonToList(JSONArray arr) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i = 0; i < arr.length(); ++i) {
            intList.add(arr.getInt(i));
        }
        return intList;
    }

    private ArrayList<Long> jsonToLongList(JSONArray arr) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (int i = 0; i < arr.length(); ++i) {
            longList.add(arr.getLong(i));
        }
        return longList;
    }

    private ArrayList<ChannelDetail> jsonToChFlagList(JSONArray arr) {
        ArrayList<ChannelDetail> chFlagList = new ArrayList<ChannelDetail>();
        for (int i = 0; i < arr.length(); ++i) {
            chFlagList.add(new ChannelDetail(arr.getJSONArray(i).getInt(0), arr.getJSONArray(i).getInt(1)));
        }
        return chFlagList;
    }

    private ArrayList<AlgAp> jsonToApList(JSONObject obj) {
        ArrayList<AlgAp> algApListTmp = new ArrayList<AlgAp>();
        for (int i = 1; i < obj.getJSONArray(ALGAP_STRING).length(); ++i) {
            JSONArray arrayTmp = obj.getJSONArray(ALGAP_STRING).getJSONArray(i);
            AlgAp algApTmp = new AlgAp();
            algApTmp.setMac(this.idxMaxMap.get(arrayTmp.getInt(0)));
            algApTmp.setBandFlag(arrayTmp.getInt(1));
            algApTmp.setChannel(arrayTmp.getInt(2));
            algApTmp.setWidth(arrayTmp.getInt(3));
            algApTmp.setTxPower(arrayTmp.getInt(4));
            algApTmp.setMaxTxPower(arrayTmp.getInt(5));
            algApTmp.setMinTxPower(arrayTmp.getInt(6));
            algApTmp.setErrorCode(arrayTmp.getInt(7));
            algApTmp.setChannelFlagList(arrayTmp.get(8).toString().equals("null") ? null : this.jsonToChFlagList(arrayTmp.getJSONArray(8)));
            algApTmp.setAvailableWidthList(arrayTmp.get(9).toString().equals("null") ? null : this.jsonToList(arrayTmp.getJSONArray(9)));
            algApTmp.setAvailableChannelList(arrayTmp.get(10).toString().equals("null") ? null : this.jsonToList(arrayTmp.getJSONArray(10)));
            algApTmp.setStationLoadList(arrayTmp.get(11).toString().equals("null") ? null : this.jsonToList(arrayTmp.getJSONArray(11)));
            if (arrayTmp.length() > 12) {
                algApTmp.setTrafficList(arrayTmp.get(12).toString().equals("null") ? null : this.jsonToLongList(arrayTmp.getJSONArray(12)));
            }
            if (arrayTmp.length() > 13) {
                if (arrayTmp.get(13).toString().equals("null")) {
                    algApTmp.setStaAccessRssiMap(null);
                } else {
                    Map tmpJson = arrayTmp.getJSONObject(13).toMap();
                    TreeMap<Integer, Integer> tmp = new TreeMap<Integer, Integer>();
                    for (Map.Entry entry : tmpJson.entrySet()) {
                        Integer keytmp = Integer.valueOf((String)entry.getKey());
                        Integer valuetmp = (Integer)entry.getValue();
                        tmp.put(keytmp, valuetmp);
                    }
                    algApTmp.setStaAccessRssiMap(tmp);
                }
            }
            algApListTmp.add(algApTmp);
        }
        return algApListTmp;
    }

    private ArrayList<BaseAlgAp> jsonToBaseApList(JSONObject obj) {
        ArrayList<BaseAlgAp> algApListTmp = new ArrayList<BaseAlgAp>();
        for (int i = 1; i < obj.getJSONArray(BASEALGAP_STRING).length(); ++i) {
            JSONArray arrayTmp = obj.getJSONArray(BASEALGAP_STRING).getJSONArray(i);
            BaseAlgAp algApTmp = new BaseAlgAp();
            algApTmp.setMac(this.idxMaxMap.get(arrayTmp.getInt(0)));
            algApTmp.setBandFlag(arrayTmp.getInt(1));
            algApTmp.setChannel(arrayTmp.getInt(2));
            algApTmp.setWidth(arrayTmp.getInt(3));
            algApTmp.setTxPower(arrayTmp.getInt(4));
            algApListTmp.add(algApTmp);
        }
        return algApListTmp;
    }

    private ArrayList<Connection> jsonToConList(JSONObject obj) {
        ArrayList<Connection> connectionsTmp = new ArrayList<Connection>();
        for (int i = 1; i < obj.getJSONArray(CONNECTION_STRING).length(); ++i) {
            JSONArray arrayTmp = obj.getJSONArray(CONNECTION_STRING).getJSONArray(i);
            connectionsTmp.add(new Connection(this.idxMaxMap.get(arrayTmp.getInt(0)), this.idxMaxMap.get(arrayTmp.getInt(1)), arrayTmp.getInt(2), arrayTmp.getInt(3), arrayTmp.getInt(4), arrayTmp.getInt(5), arrayTmp.getInt(6)));
        }
        return connectionsTmp;
    }

    private RFAdvanceSetting jsonToRfSetting(JSONObject obj) {
        RFAdvanceSetting rfAdvanceSettingTmp = new RFAdvanceSetting();
        JSONObject objTmp = obj.getJSONObject(RFADVENCE_STRING);
        rfAdvanceSettingTmp.setMinChannelWidth2g(objTmp.getInt("minChannelWidth2g"));
        rfAdvanceSettingTmp.setMaxChannelWidth2g(objTmp.getInt("maxChannelWidth2g"));
        rfAdvanceSettingTmp.setMinChannelWidth5g(objTmp.getInt("minChannelWidth5g"));
        rfAdvanceSettingTmp.setMaxChannelWidth5g(objTmp.getInt("maxChannelWidth5g"));
        rfAdvanceSettingTmp.setMinChannelWidth6g(objTmp.getInt("minChannelWidth6g"));
        rfAdvanceSettingTmp.setMaxChannelWidth6g(objTmp.getInt("maxChannelWidth6g"));
        rfAdvanceSettingTmp.setMinTxPower2g(objTmp.getInt("minTxPower2g"));
        rfAdvanceSettingTmp.setMaxTxPower2g(objTmp.getInt("maxTxPower2g"));
        rfAdvanceSettingTmp.setMinTxPower5g(objTmp.getInt("minTxPower5g"));
        rfAdvanceSettingTmp.setMaxTxPower5g(objTmp.getInt("maxTxPower5g"));
        rfAdvanceSettingTmp.setMinTxPower6g(objTmp.getInt("minTxPower6g"));
        rfAdvanceSettingTmp.setMaxTxPower6g(objTmp.getInt("maxTxPower6g"));
        rfAdvanceSettingTmp.setThreshold2g(objTmp.getInt(THRES2G_STRING));
        rfAdvanceSettingTmp.setThreshold5g(objTmp.getInt(THRES5G_STRING));
        rfAdvanceSettingTmp.setThreshold6g(objTmp.getInt(THRES6G_STRING));
        rfAdvanceSettingTmp.setEnableBandDeploy(objTmp.getBoolean("isEnableBandDeploy"));
        rfAdvanceSettingTmp.setEnableChannelDeploy(objTmp.getBoolean("isEnableChannelDeploy"));
        rfAdvanceSettingTmp.setEnableChannelWidthDeploy(objTmp.getBoolean("isEnableChannelWidthDeploy"));
        rfAdvanceSettingTmp.setEnablePowerDeploy(objTmp.getBoolean("isEnablePowerDeploy"));
        return rfAdvanceSettingTmp;
    }

    private void jsonToInput(String lineTxt) {
        if ((lineTxt = DeflaterUtils.unzipString(lineTxt.substring(lineTxt.indexOf("RFPlanning-") + this.unDecryptionLen, lineTxt.length()))).length() < 100) {
            System.out.println(lineTxt.substring(0, lineTxt.length()));
        } else {
            System.out.println(lineTxt.substring(0, 100));
        }
        int index1 = lineTxt.indexOf("{\"macIdxMap\":");
        int index2 = lineTxt.length();
        if (index1 == -1 || index2 == -1) {
            return;
        }
        JSONObject obj = JsonUtils.fromObject(lineTxt.substring(index1, index2));
        this.jsonToHashMap(obj.getJSONObject("macIdxMap"));
        if (!lineTxt.contains("Solution:")) {
            this.ap = obj.has(ALGAP_STRING) && obj.get(ALGAP_STRING).toString().equals("null") ? null : this.jsonToApList(obj);
        }
        this.baseAp = obj.has(BASEALGAP_STRING) && obj.get(BASEALGAP_STRING).toString().equals("null") ? null : this.jsonToBaseApList(obj);
        this.connection = obj.has(CONNECTION_STRING) && obj.get(CONNECTION_STRING).toString().equals("null") ? null : this.jsonToConList(obj);
        this.rfAdvanceSetting = obj.has(RFADVENCE_STRING) && obj.get(RFADVENCE_STRING).toString().equals("null") ? null : this.jsonToRfSetting(obj);
    }

    public ArrayList<AlgAp> getApList() {
        return this.ap;
    }

    public ArrayList<BaseAlgAp> getBaseApList() {
        return this.baseAp;
    }

    public ArrayList<Connection> getConnectionsListInput() {
        return this.connection;
    }

    public RFAdvanceSetting getRfAdvanceSetting() {
        return this.rfAdvanceSetting;
    }

    private String strDecryption(String str) {
        int strLen = str.length();
        int index = str.indexOf("RFPlanning-");
        int[] a = new int[strLen + 2];
        char[] ch = str.toCharArray();
        for (int i = index + this.unDecryptionLen; i < strLen; ++i) {
            a[i] = ch[i];
            a[i] = a[i] + 2;
            ch[i] = (char)a[i];
        }
        return new String(ch);
    }
}

