/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common;

import com.tplink.smb.algorithm.common.ChannelsInfo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class ScanResult {
    private Integer radioId;
    private Integer chWidth;
    private Integer txPower;
    private List<ChannelsInfo> channels;

    public boolean validate() {
        if (Objects.isNull(this.radioId) || Objects.isNull(this.chWidth)) {
            return false;
        }
        return CollectionUtils.isEmpty(this.channels) || this.channels.get(0).validate();
    }

    public static ScanResultBuilder builder() {
        return new ScanResultBuilder();
    }

    public void setRadioId(Integer radioId) {
        this.radioId = radioId;
    }

    public void setChWidth(Integer chWidth) {
        this.chWidth = chWidth;
    }

    public void setTxPower(Integer txPower) {
        this.txPower = txPower;
    }

    public void setChannels(List<ChannelsInfo> channels) {
        this.channels = channels;
    }

    public Integer getRadioId() {
        return this.radioId;
    }

    public Integer getChWidth() {
        return this.chWidth;
    }

    public Integer getTxPower() {
        return this.txPower;
    }

    public List<ChannelsInfo> getChannels() {
        return this.channels;
    }

    public String toString() {
        return "ScanResult(radioId=" + this.getRadioId() + ", chWidth=" + this.getChWidth() + ", txPower=" + this.getTxPower() + ", channels=" + this.getChannels() + ")";
    }

    public ScanResult() {
    }

    public ScanResult(Integer radioId, Integer chWidth, Integer txPower, List<ChannelsInfo> channels) {
        this.radioId = radioId;
        this.chWidth = chWidth;
        this.txPower = txPower;
        this.channels = channels;
    }

    public static class ScanResultBuilder {
        private Integer radioId;
        private Integer chWidth;
        private Integer txPower;
        private List<ChannelsInfo> channels;

        ScanResultBuilder() {
        }

        public ScanResultBuilder radioId(Integer radioId) {
            this.radioId = radioId;
            return this;
        }

        public ScanResultBuilder chWidth(Integer chWidth) {
            this.chWidth = chWidth;
            return this;
        }

        public ScanResultBuilder txPower(Integer txPower) {
            this.txPower = txPower;
            return this;
        }

        public ScanResultBuilder channels(List<ChannelsInfo> channels) {
            this.channels = channels;
            return this;
        }

        public ScanResult build() {
            return new ScanResult(this.radioId, this.chWidth, this.txPower, this.channels);
        }

        public String toString() {
            return "ScanResult.ScanResultBuilder(radioId=" + this.radioId + ", chWidth=" + this.chWidth + ", txPower=" + this.txPower + ", channels=" + this.channels + ")";
        }
    }
}

