/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.algorithm.common;

import java.util.Objects;

public class ScanBss {
    private String mac;
    private Integer rssi;
    private Integer txPower;
    private Boolean bssidRevertToMac;

    public boolean validate() {
        return !Objects.isNull(this.mac) && !Objects.isNull(this.rssi);
    }

    public static ScanBssBuilder builder() {
        return new ScanBssBuilder();
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setRssi(Integer rssi) {
        this.rssi = rssi;
    }

    public void setTxPower(Integer txPower) {
        this.txPower = txPower;
    }

    public void setBssidRevertToMac(Boolean bssidRevertToMac) {
        this.bssidRevertToMac = bssidRevertToMac;
    }

    public String getMac() {
        return this.mac;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public Integer getTxPower() {
        return this.txPower;
    }

    public Boolean getBssidRevertToMac() {
        return this.bssidRevertToMac;
    }

    public String toString() {
        return "ScanBss(mac=" + this.getMac() + ", rssi=" + this.getRssi() + ", txPower=" + this.getTxPower() + ", bssidRevertToMac=" + this.getBssidRevertToMac() + ")";
    }

    public ScanBss() {
    }

    public ScanBss(String mac, Integer rssi, Integer txPower, Boolean bssidRevertToMac) {
        this.mac = mac;
        this.rssi = rssi;
        this.txPower = txPower;
        this.bssidRevertToMac = bssidRevertToMac;
    }

    public static class ScanBssBuilder {
        private String mac;
        private Integer rssi;
        private Integer txPower;
        private Boolean bssidRevertToMac;

        ScanBssBuilder() {
        }

        public ScanBssBuilder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public ScanBssBuilder rssi(Integer rssi) {
            this.rssi = rssi;
            return this;
        }

        public ScanBssBuilder txPower(Integer txPower) {
            this.txPower = txPower;
            return this;
        }

        public ScanBssBuilder bssidRevertToMac(Boolean bssidRevertToMac) {
            this.bssidRevertToMac = bssidRevertToMac;
            return this;
        }

        public ScanBss build() {
            return new ScanBss(this.mac, this.rssi, this.txPower, this.bssidRevertToMac);
        }

        public String toString() {
            return "ScanBss.ScanBssBuilder(mac=" + this.mac + ", rssi=" + this.rssi + ", txPower=" + this.txPower + ", bssidRevertToMac=" + this.bssidRevertToMac + ")";
        }
    }
}

