/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.local.property;

import com.tplink.smb.device.firmware.upgrade.common.property.FirmwareUpgradeProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="firmware-upgrade")
public class LocalFirmwareUpgradeProperties
extends FirmwareUpgradeProperties {
    public static final String FIRMWARE_UPGRADE_PREFIX = "firmware-upgrade";
    private int maxDownloadingDevices = Integer.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private long longestWaitingTime = 300000L;
    private long deviceNum = 3000L;

    public long getWaitingTime() {
        return (this.getDeviceNum() / 5000L + 1L) * this.getLongestWaitingTime();
    }

    public int getMaxDownloadingDevices() {
        return this.maxDownloadingDevices;
    }

    public long getLongestWaitingTime() {
        return this.longestWaitingTime;
    }

    public long getDeviceNum() {
        return this.deviceNum;
    }

    public void setMaxDownloadingDevices(int maxDownloadingDevices) {
        this.maxDownloadingDevices = maxDownloadingDevices;
    }

    public void setLongestWaitingTime(long longestWaitingTime) {
        this.longestWaitingTime = longestWaitingTime;
    }

    public void setDeviceNum(long deviceNum) {
        this.deviceNum = deviceNum;
    }
}

